/* demo10.c - test simple popup functions.
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "jlib.doc" for more details.
*/

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>


#define MESSAGE "This is an info box.  Info boxes can be great sources of information if they are used correctly."
#define SHORT_MESS "Short messages need less lines."

/* macro to clear the screen checking the mouse if needed */
#define SAFE_CLEAR            \
  if(MOUSE_AVAILABLE){        \
     mouse_hide_pointer();    \
  }                           \
  screen_clear();             \
  if(MOUSE_AVAILABLE){        \
     mouse_show_pointer();    \
  }


int main(void)
{
 /* set up the screen */
 screen_set_video_mode();

 screen_put_pal(15,255,255,255);
 screen_put_pal(35,20,80,80);

 if(MOUSE_AVAILABLE){
    mouse_present(); /* it doesn't actually matter if mouse is there or not */
    mouse_show_pointer();
 }

 if(KEYBOARD_AVAILABLE){
   kb_init();
 }
  
 popup_about(35,15);

 SAFE_CLEAR;
 
 popup_info(MESSAGE,35,15);

 SAFE_CLEAR;
  
 popup_info(SHORT_MESS,35,15);


 if(KEYBOARD_AVAILABLE){
   kb_closedown();
 }

 if(MOUSE_AVAILABLE){
    mouse_closedown();
 }

 /* return to text mode and exit */
 screen_restore_video_mode();

 return(0);
}
