/* demo1.c
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "jlib.doc" for more details.
*/

#include <stdio.h>
#include <stdlib.h>

#include <jlib.h>

/* This demo shows how to load and display image files,  how to fade the
** screen in and out using the library functions, and how to use an offscreen
** buffer.
*/

int main(void)
{
 image *pcx_pic;
 buffer_rec *offscreen;
 unsigned char *pal;
 char filename[] = "demo1.pcx";
 char filename2[] = "demo1.jlb";
 image *jlb_pic;
 
 int i;
 
 /* initialise screen sized buffer */
 offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

 /* check that initialisation was OK */
 if(offscreen == NULL){
    printf("ERROR:could not initialise buffer.\n");
    printf("press any key to exit.\n");
    fgetc(stdin);
    exit(0);
 }

 /* load pcx */
 pcx_pic = image_load_pcx(filename);

 /* check that load was OK */
 if(pcx_pic == NULL){
    printf("ERROR:could not load PCX image file.\n");
    printf("press any key to exit.\n");
    fgetc(stdin);
    exit(0);
 }

 /* set pal to point to the images palette */
 pal = IMG_PALETTE(pcx_pic);

 /* set up the screen */
 screen_set_video_mode();

 screen_blank_pal();


 /* copy the image to the offscreen buffer */
 buff_blit_img_to(offscreen,0,0,pcx_pic,0,0,IMG_WIDTH(pcx_pic),IMG_HEIGHT(pcx_pic));

 /* blit the buffer to the screen and wait for a keypress */
 screen_blit_fs_buffer(offscreen);
 fgetc(stdin);

 /* fade in the palette and wait for a keypress */
 screen_fade_in_pal(pal,40);
 fgetc(stdin);

 /* fade out the palette and wait for a keypress */
 screen_fade_out_pal(pal,40);
 fgetc(stdin);

 screen_blank_pal();
 image_free(pcx_pic);

 /* load jlb */
 jlb_pic = image_load_jlb(filename2);

 /* check that load was OK */
 if(jlb_pic == NULL){
    free(pcx_pic);
    screen_restore_video_mode();
    printf("ERROR:could not load JLib image file.\n");
    printf("press any key to exit.\n");
    fgetc(stdin);
    exit(0);
 }

 /* set pal to point to the images palette */
 pal = IMG_PALETTE(jlb_pic);

 /* copy the image to the offscreen buffer */
 buff_blit_img_to(offscreen,0,0,jlb_pic,0,0,IMG_WIDTH(jlb_pic),IMG_HEIGHT(jlb_pic));

 /* blit the buffer to the screen and wait for a keypress */
 screen_blit_fs_buffer(offscreen);
 fgetc(stdin);

 /* fade in the palette and wait for a keypress */
 screen_fade_in_pal(pal,80);
 fgetc(stdin);

 /* clear the screen and wait for a keypress */
 screen_clear();
 fgetc(stdin);

 /* fill the screen a few times with different colors */
 for(i=0;i<100;i++){
     screen_fill((UBYTE)i);
 }

 image_free(jlb_pic);
 
 /* return to text mode and exit */
 screen_restore_video_mode();
 return(0);
}
