#include    <stdio.h>
#include    <stdlib.h>
#include    <conio.h>
#include    "video.h"
#include    "realdos.h"

struct  VesaForm {
    char    VESASignature[4];
    short   VESAVersion;
    void   *OEMStringPtr;
    char    Capabilities[4];
    void   *VideoModePtr;
    short   TotalMemory;
    char    reserved[236];
};  // INT 10h ( 4F00h service )

struct  ModeInfo {
    short   ModeAttributes;
    char    WinAAttributes, WinBAttributes;
    short   WinGranularity, WinSize;
    short   WinASegment, WinBSegment;
    int     WinFuncPtr;
    short   BytesPerScanLine;
    short   XResolution, YResolution;
    char    XCharSize, YCharSize;
    char    NumberOfPlanes;
    char    BitsPerPixel;
    char    NumberOfBanks;
    char    MemoryModel;
    char    BankSize;
    char    NumberOfImagePages;
    char    res1;
    char    RedMaskSize, RedFieldPosition;
    char    GreenMaskSize, GreenFieldPosition;
    char    BlueMaskSize, BlueFieldPosition;
    char    RsvdMaskSize, RsvdFieldPosition;
    char    DirectColorModeInfo;
    char    res2[216];
};  // INT 10h ( 4F01h service )

#define     RP_SEG(A) ((unsigned)A>>4)      // real mode pointer segment
#define     RP_OFF(A) ((unsigned)A&15)      // real mode pointer offset

static int  BANK_SHIFT = 0;
static int  BANK_WRITE_SWITCH = 0;
static int  BANK_READ_SWITCH = 0;
static int  switch_bank[2] = {0,0};

int     SCREEN_XSIZE, SCREEN_YSIZE;
int     BANK_SIZE = 65536;

void    InitVideo(int videomode)
{
    union       REGS  r;
    struct      SREGS sr;
    segread(&sr);

    if (videomode == 0x13) {
        union   REGS    r;
        r.w.ax = 0x13;
        int386(0x10, &r, &r);

        SCREEN_XSIZE = 320;
        SCREEN_YSIZE = 200;
        BANK_SIZE = 65536;

        return;
    }

    VesaForm   *form;
    ModeInfo   *mode;

    form = (VesaForm*)AllocDosmem(sizeof(VesaForm));
    r.w.ax = 0x4f00;
    sr.es = RP_SEG(form);
    r.x.edi = RP_OFF(form);
    int386xemul(0x10, &r, &r, &sr);
    if(memcmp(form->VESASignature,"VESA",4)!=0) {
        printf("Vesa 1.2 is not installed.");
        exit(-1);
    }

    FreeDosmem(form);

    r.w.ax = 0x4f02;
    r.w.bx = videomode;
    int386(0x10, &r, &r);
    if(r.h.ah==1) {
        UninitVideo();
        printf("Mother fucker!!");
        exit(-1);
    }

    mode = (ModeInfo*)AllocDosmem(sizeof(ModeInfo));
    r.w.ax = 0x4f01;
    r.w.cx = videomode;
    sr.es = RP_SEG(mode);
    r.x.edi = RP_OFF(mode);
    int386xemul(0x10, &r, &r, &sr);

    if((mode->WinAAttributes&3)==3) BANK_READ_SWITCH=0;
    if((mode->WinAAttributes&5)==5) BANK_WRITE_SWITCH=0;
    if((mode->WinBAttributes&3)==3) BANK_READ_SWITCH=1;
    if((mode->WinBAttributes&5)==5) BANK_WRITE_SWITCH=1;

    for(BANK_SHIFT=0; (64>>BANK_SHIFT)!=mode->WinGranularity && BANK_SHIFT<14; BANK_SHIFT++) ;

    BANK_SIZE=mode->WinSize*1024;

    SCREEN_XSIZE = mode->XResolution;
    SCREEN_YSIZE = mode->YResolution;

    FreeDosmem(mode);
}

void    UninitVideo()
{
    union   REGS    r;
    r.w.ax = 3;
    int386(0x10, &r, &r);
}

void    SwitchBank(int bank, int num, int *address);
#pragma aux SwitchBank= \
      " cmp     edx, dword ptr [esi]    "\
      " je      quit                    "\
      " mov     dword ptr [esi], edx    "\
      " mov     eax, 4f05h              "\
      " int     10h                     "\
      " quit :                          "\
       parm [ edx ] [ ebx ] [ esi ]      \
       modify [ eax ];

void    WriteBank(int bank)
{
    SwitchBank(bank<<BANK_SHIFT, BANK_WRITE_SWITCH, switch_bank+BANK_WRITE_SWITCH);
}

void    ReadBank(int bank)
{
    SwitchBank(bank<<BANK_SHIFT, BANK_READ_SWITCH, switch_bank+BANK_READ_SWITCH);
}

int     GetBank()
{
    return switch_bank[BANK_WRITE_SWITCH];
}

void    PutImage(int x, int y, char *image, int xs, int ys)
{
    int     offset = x + y * SCREEN_XSIZE;
    char    bank = offset/BANK_SIZE;
    offset %= BANK_SIZE;
    WriteBank(bank);

    for(int i=0; i<ys; i++, offset+=SCREEN_XSIZE, image+=xs) {
        if (offset >= 65536) {
            bank += offset/65536;
            offset %= 65536;
            WriteBank(bank);
        }

        if (offset+xs > 65536) {
            int     left = 65536 - offset;
            memcpy((char*)0xa0000 + offset, image, left);
            WriteBank(bank+1);
            memcpy((char*)0xa0000, image+left, xs-left);
        } else
            memcpy((char*)0xa0000 + offset, image, xs);
    }
}

void    SetPalette(char *palette)
{
    outp(0x3c8, 0);
    for(int i=0; i<768; i++)
        outp(0x3c9, palette[i]/4);
}
