;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=- UNCHAIN.ASM -- This small program cycles throught the unchained modes   -=
;=- displaying a short message. Press enter to go to the next mode.         -=
;=-                                                                         -=
;=- See the README.TXT file for the Disclaimer and other info               -=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
.MODEL  SMALL
.386
JUMPS
LOCALS
.STACK  100h
.DATA
VGA               EQU       0A000H
ATTRCON_ADDR      EQU       03C0H
MISC_ADDR         EQU       03C2H
VGAENABLE_ADDR    EQU       03C3H
SEQ_ADDR          EQU       03C4H
GRACON_ADDR       EQU       03CEH
CRTC_ADDR         EQU       03D4H
STATUS_ADDR       EQU       03DAH

BUFFER        DW 0

; Width in pixels
MODE_WIDTH    DW ?

; Height in pixels
MODE_HEIGHT   DW ?

; Number of bytes to fill 1 video screen
WIDTH_BYTES   DW ?


; Must be included if you set any unchained mode
include mode13h.inc

; Must be included if you set Chain-4 Mode or Mode X
include modec4.inc

; Must be included if you set Mode B
include modeb.inc

ICON DB  0, 0, 0, 0, 0, 0,15,15,15,15, 0, 0, 0, 0, 0, 0
     DB  0, 0, 0, 0, 0,15,15,15,15,15,15, 0, 0, 0, 0, 0
     DB  0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0
     DB  0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0
     DB  0, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 0
     DB  0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0
     DB  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
     DB  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
     DB  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
     DB  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
     DB  0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0
     DB  0, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 0
     DB  0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0
     DB  0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0
     DB  0, 0, 0, 0, 0,15,15,15,15,15,15, 0, 0, 0, 0, 0
     DB  0, 0, 0, 0, 0, 0,15,15,15,15, 0, 0, 0, 0, 0, 0

MSG1 DB 'Unchain -- Shows a small message in all 4 unchained modes.'
     DB 13,10,'Press any key to go to the next mode.'
     DB 13,10,13,10,'Press any key to continue...','$'

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= End Data Section =-=-=-=-=-=-=-=-=-=-=-=-=-=

.CODE

IODELAY MACRO
   REPT 8
      JMP $+2
   ENDM
ENDM

Start:
   MOV AX,@DATA
   MOV DS,AX

   ; Print out the message
   MOV DX,OFFSET MSG1
   MOV AH,9
   INT 21H

   ; Wait for a keypress
   MOV AH,0
   INT 16H

   CALL SET_CHAIN4

   PUSH 0
   CALL CLEAR_SCREEN
   CALL MESSAGE

   ; Wait for a keypress
   MOV AH,0
   INT 16H

   CALL SET_MODEX

   PUSH 4
   CALL CLEAR_SCREEN
   CALL MESSAGE

   ; Wait for a keypress
   MOV AH,0
   INT 16H

   CALL SET_MODEA

   PUSH 2
   CALL CLEAR_SCREEN
   CALL MESSAGE

   ; Wait for a keypress
   MOV AH,0
   INT 16H

   CALL SET_MODEB

   PUSH 5
   CALL CLEAR_SCREEN
   CALL MESSAGE

   ; Wait for a keypress
   MOV AH,0
   INT 16H

   ; Set the BIOS mode 03h
   MOV AX,0003H
   INT 10H

   ; Exit to DOS
   MOV AX,4C00H
   INT 21H

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

   PUBLIC SETMODE
SETMODE PROC

   ; Send MISC regs
   CALL OUTREGS
   ADD SI,4

   MOV DX,STATUS_ADDR
   MOV AL,[SI].VALUE
   OUT DX,AL
   IODELAY
   ADD SI,4

   ; Send SEQ regs
   MOV CX,5
REG_LOOP:
   CALL OUTREGS
   ADD SI,4
   LOOP REG_LOOP

   ; Clear Protection bits
   MOV AH,0EH
   MOV AL,11H
   AND AH,7FH
   MOV DX,CRTC_ADDR
   OUT DX,AX
   IODELAY

   ; Send CRTC regs
   MOV CX,25
REG_LOOP2:
   CALL OUTREGS
   ADD SI,4
   LOOP REG_LOOP2

   ; Send GRAPHICS regs
   MOV CX,9
REG_LOOP3:
   CALL OUTREGS
   ADD SI,4
   LOOP REG_LOOP3

   MOV DX,STATUS_ADDR
   IN AL,DX
   IODELAY

   ; Send ATTRCON regs
   MOV CX,21
REG_LOOP4:
   CALL OUTREGS
   ADD SI,4
   LOOP REG_LOOP4

   MOV AL,20H
   OUT DX,AL
   IODELAY

   RET
SETMODE ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

   PUBLIC OUTREGS
OUTREGS PROC

   MOV AX,[SI].PORT
   CMP AX,ATTRCON_ADDR
   JE CASE1
   CMP AX,MISC_ADDR
   JE CASE2
   CMP AX,VGAENABLE_ADDR
   JE CASE2
   JMP CASE3

CASE1:
   MOV DX,ATTRCON_ADDR
   IN AX,DX

   MOV AL,[SI].INDEX
   OUT DX,AL
   IODELAY

   MOV AL,[SI].VALUE
   OUT DX,AL
   IODELAY
   JMP CASEOUT

CASE2:
   MOV DX,[SI].PORT
   MOV AL,[SI].VALUE
   OUT DX,AL
   IODELAY
   JMP CASEOUT

CASE3:
   MOV DX,[SI].PORT
   MOV AL,[SI].INDEX
   OUT DX,AL
   IODELAY

   MOV DX,[SI].PORT
   INC DX
   MOV AL,[SI].VALUE
   OUT DX,AL
   IODELAY

CASEOUT:
   RET
OUTREGS ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

; Mode setting functions
include chain4.asm
include modex.asm
include modea.asm
include modeb.asm

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

CLEAR_SCREEN PROC
   PUSH BP
   MOV BP,SP

   mov   dx, 03C4h         ; 03c4h
   mov   al, 2             ; Map Mask Register
   out   dx, al
   inc   dx
   mov   al,00001111B      ; Select all planes to write to
   out   dx, al            ; Doing this to clear all planes at once

   mov   ax,VGA
   mov   es, ax
   MOV DI,BUFFER           ; set es:di = Screen Mem
   mov ah,[BP+4]           ; move the color into ah
   mov al,ah               ; copy the value to al
   mov   cx,WIDTH_BYTES    ; Number of words
   SHR CL,1
   cld
   rep   stosw             ; clear it

   POP BP
   RET 2
CLEAR_SCREEN ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

   PUBLIC PIXEL
PIXEL PROC
   PUSH BP
   MOV BP,SP
   PUSHA           ; Save registers

   MOV AX,VGA      ;    video memory segment number
   MOV ES,AX       ;    place it in es

   MOV DX,03C4H
   MOV AL,2
   OUT DX,AL
   INC DX

   MOV AL,1
   MOV CX,WORD PTR [BP+4]
   AND CX,3
   SHL AL,CL
   OUT DX,AL

   MOV DI,BUFFER

; Calculate the Offset
   mov ax,MODE_WIDTH          ; Mode_width / 4
   SHR AX,2
   mul word ptr [bp+6]        ; (Y * (mode_width / 4))
   mov bx,word ptr [bp+4]     ; (X / 4) + (Y * (mode_width / 4))
   shr bx,2
   add ax,bx
; Done!

   ADD DI,AX
   mov ah,[bp+8]  ;    move the Color into ah
   mov es:[di],ah ;    move the value to the screen

QUIT1:
   POPA           ; Restore registers
   POP BP
   RET 6
PIXEL ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Puts an icon on the screen
; void PutIcon(int X, int Y, char Icon[], int Width, int Height);
   PUBLIC PUTICON
PUTICON PROC
   PUSH BP
   MOV BP,SP
   PUSHA          ; Save registers

   MOV SI,[BP+8]

   MOV BX,[BP+6] ; Move in Y start value
   MOV CX,0 
LOOP1:

   MOV AX,[BP+4] ; Move in X start value
   MOV DX,0 
LOOP2:
      CMP BYTE PTR [SI],0 ; Check to see if the color is 0
      JE OUT1

      PUSH WORD PTR [SI]  ; Push the Color value
      PUSH BX             ; Push the Y value
      PUSH AX             ; Push the X value
      CALL PIXEL

   OUT1:

   INC SI              ; Increment our pointer in the array
   INC AX              ; Increment our X pointer
   INC DX              ; Increment our width counter 
   CMP DX,[BP+10]      ; compare it to the width of the icon
   JB LOOP2            ; and loop.

   INC BX              ; Increment our Y pointer
   INC CX              ; Increment our height counter 
   CMP CX,[BP+12]      ; compare it to the height of the icon
   JB LOOP1            ; and loop

   POPA                ; Restore registers
   POP BP
   RET 10
PUTICON ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

MESSAGE PROC

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 10
   PUSH 10
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 30
   PUSH 10
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 50
   PUSH 10
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 70
   PUSH 10
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 90
   PUSH 10
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 50
   PUSH 30
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 10
   PUSH 50
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 30
   PUSH 50
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 50
   PUSH 50
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 70
   PUSH 50
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 90
   PUSH 50
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 10
   PUSH 100
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 50
   PUSH 100
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 70
   PUSH 100
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 90
   PUSH 100
   CALL PUTICON

   RET
MESSAGE ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

END Start
