;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-                                                                         -=
;=-        Source Code for switching Video Modes without using BIOS         -=
;=-                 November 20, 1997     Version 2.1                       -=
;=-                                                                         -=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-        See the README.TXT file for the Disclaimer and other info        -=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

SET_MODEA PROC

   MOV SI,OFFSET MODE13H
   CALL SETMODE

   ; Turn off Chain4
   MOV DX,SEQ_ADDR
   MOV AL,4
   OUT DX,AL
   INC DX
   IN AL,DX
   AND AL,NOT 08H
   OR AL,04H
   OUT DX,AL

   ; Turn off Odd/Even
   MOV DX,GRACON_ADDR
   MOV AL,5
   OUT DX,AL
   INC DX
   IN AL,DX
   AND AL,NOT 10H
   OUT DX,AL

   ; Turn off Chain
   MOV DX,GRACON_ADDR
   MOV AL,6
   OUT DX,AL
   INC DX
   IN AL,DX
   AND AL,NOT 02H
   OUT DX,AL

   ; Tweak the mode out to 400 scan line by not scanning each line twice
   MOV DX,CRTC_ADDR
   MOV AL,9
   OUT DX,AL
   INC DX
   IN AL,DX
   AND AL,NOT 1FH
   OUT DX,AL

   ; Switch from doubleword mode to byte mode
   MOV DX,CRTC_ADDR
   MOV AL,14h
   OUT DX,AL
   INC DX
   IN AL,DX
   AND AL,NOT 40H
   OUT DX,AL

   MOV DX,CRTC_ADDR
   MOV AL,17h
   OUT DX,AL
   INC DX
   IN AL,DX
   OR AL,40H
   OUT DX,AL

   MOV MODE_WIDTH,320
   MOV MODE_HEIGHT,400
   MOV WIDTH_BYTES,32000

   RET
SET_MODEA ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
