
;ͻ;
; Exception handling routines                                               ;
;ͼ;

Code32 SEGMENT
  ASSUME CS:Code32, DS:Code32, SS:Code32


;Ŀ;
; Exception Handler                                                         ;
;                                                                           ;
; Stack upon entry (each item as a DWORD):                                  ;
; (Top) GS FS ES DS EDI ESI EBP ESP EBX EDX ECX EAX                         ;
;       EIP CS EFLAGS Exception_Number (Bottom)                             ;
;;

dExceptionStack STRUC
  excp_SS       dd ?
  excp_GS       dd ?
  excp_FS       dd ?
  excp_ES       dd ?
  excp_DS       dd ?
  excp_EDI      dd ?
  excp_ESI      dd ?
  excp_EBP      dd ?
  excp_ESP      dd ?
  excp_EBX      dd ?
  excp_EDX      dd ?
  excp_ECX      dd ?
  excp_EAX      dd ?
  excp_EIP      dd ?
  excp_CS       dd ?
  excp_EFLAGS   dd ?
  excp_Number   dd ?
ENDS

ExceptionMSG  LABEL
db 'Exception '
ExceptionNumber db 0
db 'h has occured.$'

Exception_Handler:
  mov ds,m CS:Data32Sel

  mov ebx,[esp.excp_Number]
  mov al,HexTab+ebx
  mov ExceptionNumber,al

  mov edx,o ExceptionMSG
  call PrintString
  jmp Exit32

;  jmp ErrorExit32



;Ŀ;
; Initialization                                                            ;
;;
Init_Exception_Handling:

  cmp pm_EntryType,pm_ENTRY_RAWXMS
  jz @@RAWXMS

;*****************************************************************************;
  ; DPMI exception handling
  @@DPMI:

    xor bl,bl
    mov esi,o DPMI_Handler_Offsets
    @@DPMI_10:
      mov cx,m Code32Sel
      mov edx,[esi]
      mov ax,0203h
      int 31h

      inc bl
      add esi,4
      cmp bl,10h
      jb @@DPMI_10

  ret


;*****************************************************************************;
  ; RAWXMS exception handling
  @@RAWXMS:

  ; Get first 10h interrupt vectors
  mov esi,o IntVectors
  xor bl,bl
  mov ecx,10h
  @@10:
    call m GetPMInt
    mov [esi  ],edx             ; EIP
    mov [esi+4], ax             ; CS
    add esi,8
    inc bl
    loop @@10


  ; Set first 10h interrupt vectors
  mov esi,o RAWXMS_Interrupt_Offsets
  xor bl,bl
  mov ecx,10h
  @@20:
    mov edx,[esi]
    mov ax,m Code32Sel
    call m SetPMInt

    add esi,4
    inc bl
    loop @@20

  ; re-vector GetPMInt and SetPMInt
  mov m GetPMInt,o Excp_Get_pm_Int
  mov m SetPMInt,o Excp_Set_pm_Int

  ret



;Ŀ;
; RAW/XMS interrupt processing                                              ;
;;

; Interrupt vector table  (Offset:Selector as 32 bits each)
IntVectors dq 10h dup (0)

Excp_Get_pm_Int:
  cmp bl,0Fh
  ja RAWXMS_Get_pm_Int

  ; get interrupt
  push ebx
  movzx ebx,bl
  mov edx,d IntVectors+ebx*8
  mov  ax,w IntVectors+ebx*8+4
  pop ebx

  ret


Excp_Set_pm_Int:
  cmp bl,0Fh
  ja RAWXMS_Set_pm_Int

  ; set interrupt
  push ebx
  movzx ebx,bl
  mov d IntVectors+ebx*8  ,edx
  mov w IntVectors+ebx*8+4,ax
  pop ebx

  ret



;Ŀ;
; Tests whether an interrupt was invoked due to an exception or an IRQ      ;
;                                                                           ;
; Stack contains (each item as a DWORD):                                    ;
; (Top) Interrupt_Number Reserved (Bottom)                                  ;
;;
RAWXMS_Test_Exception:

  pushfd
  push eax
  mov al,00001011b    ; OCW3 to read ISR on next read
  out 20h,al          ; write to base I/O address of 8259A
  DELAY
  in al,20h           ; read ISR
  DELAY
  and al,al
  jnz @@IRQ           ; If interrupt was invoked due to an IRQ
                      ; redirect

                      ; else handle exception
  pop eax             ; EFLAGS - already pushed
  push d [esp+16]     ; CS     - 16 for EFLAGS + Reserved
  push d [esp+16]     ; EIP    - 16 for CS + EFLAGS + Reserved
  pushad
  push ds es fs gs ss
  jmp Exception_Handler


@@IRQ:                ; Handle_IRQ  (stack contains EAX, EFLAGS)
  push ebx
  mov ebx,[esp+12]    ; Get Interrupt_Number

  ; modify stack for RETF to interrupt vector
  mov eax,d CS:IntVectors+ebx*8
  mov [esp+12],eax    ; return EIP
  mov eax,d CS:IntVectors+ebx*8+4
  mov [esp+16],eax    ; return CS

  pop ebx eax         ; restore registers
  popfd               ; and flags

  retf                ; issue far return



;Ŀ;
; Exception entry handlers for RAW/XMS exceptions                           ;
;                                                                           ;
; Creates routines labeled RAWXMS_Interrupt_0 through RAWXMS_Interrupt_F    ;
; Creates a table of offsets for the above routines                         ;
;;


@RAWXMS_Create_Interrupt MACRO N
RAWXMS_Interrupt_&N&:
  push eax
  push d &N&
  jmp RAWXMS_Test_Exception
ENDM

I=0
REPT 10h
  @RAWXMS_Create_Interrupt %I
  I=I+1
ENDM

@RAWXMS_Interrupt_Offset MACRO N
  dd o RAWXMS_Interrupt_&N&
ENDM

RAWXMS_Interrupt_Offsets LABEL DWORD
I=0
REPT 10h
  @RAWXMS_Interrupt_Offset %I
  I=I+1
ENDM



;Ŀ;
; Exception entry handlers for DPMI exceptions                              ;
;                                                                           ;
; Creates routines labeled DPMI_Exception_0 through DPMI_Exception_F        ;
; Creates a table of offsets for the above routines                         ;
;                                                                           ;
; [SS:ESP] - Exception Number                                               ;
;;
All_DPMI_Exceptions:
  push d [esp+14h+ 4]     ; 14h = offset of EFLAGS, 4  = Exception_Number
  push d [esp+10h+ 8]     ; 10h = offset of CS    , 8  = 4+EFLAGS
  push d [esp+0Ch+12]     ; 0Ch = offset of EIP   , 12 = 8+CS
  pushad
  push ds es fs gs ss
  jmp Exception_Handler

@Create_DPMI_Exception MACRO N
DPMI_Exception_&N&:
  push d &N&
  jmp All_DPMI_Exceptions
ENDM

I=0
REPT 10h
  @Create_DPMI_Exception %I
  I=I+1
ENDM

@DPMI_Exception_Offset MACRO N
  dd o DPMI_Exception_&N&
ENDM

DPMI_Handler_Offsets LABEL DWORD
I=0
REPT 10h
  @DPMI_Exception_Offset %I
  I=I+1
ENDM


Code32 ENDS
