
;ͻ;
; Demonstrate drawing to an offscreen buffer.                               ;
;                                                                           ;
; Copyright 1995-1997 (c) Maxwell Sayles.  All Rights Reserved.             ;
;ͼ;

  LOCALS
  .386p

INCLUDE ..\xids\xids.inc

CODEBEGIN

pCFB dd 0                       ; pointer to color frame buffer

Start32:
  ; allocate memory for CFB
  @Alloc pCFB,320*200

  WriteLn 'Please wait...'

  ; Draw circle pattern to CFB
  mov edi,pCFB
  xor ecx,ecx
  @@YLoop:
    xor ebx,ebx
    @@XLoop:
      mov eax,ebx
      sub ax,159
      imul ax
      mov esi,eax
      mov eax,ecx
      sub ax,99
      imul ax
      add eax,esi
      mov edx,ebx
      mov esi,ecx
      call IntSqrt
      mov ecx,esi
      mov ebx,edx
      stosb
      inc ebx
      cmp bx,320
      jb @@XLoop
    inc ecx
    cmp cx,200
    jb @@YLoop

  WriteLn 'Done.  Press any key when ready.'

  ; wait for keypress
  xor eax,eax
  int 16h

  ; set 320x200x8bpp
  mov ax,13h
  int 10h

  ; flush CFB
  mov esi,pCFB
  mov edi,000A0000h           ; Video window is linear
  sub edi,m Code32Addr        ; make relative to base of Code32
  mov ecx,320*200/4
  rep movsd                   ; copy

  @Release pCFB

  ; wait for keypress
  xor eax,eax
  int 16h

  ; set 80x50 textmode
  mov ax,03h
  int 10h
  mov ax,1112h
  xor bl,bl
  int 10h

  ; terminate
  jmp Exit32


;Ŀ;
; Integer quare root                                                        ;
;                                                                           ;
; Entry: AX - integer for square root to be calculated from                 ;
; Exit : AL - Square root of Ax                                             ;
; Kiils: EBX, ECX                                                           ;
;;
IntSqrt:
  mov ecx,eax
  xor eax,eax
  mov ebx,1
  jmp @@20
  @@10:
    add ebx,2
    inc eax
    @@20:
    sub ecx,ebx
    jae @@10

  ret


CODEEND
