
;ͻ;
; Demonstrates ISR.                                                         ;
;                                                                           ;
; Copyright 1995-1997 (c) Maxwell Sayles.  All Rights Reserved.             ;
;ͼ;

  LOCALS
  .386p

INCLUDE ..\xids\xids.inc


;*****************************************************************************;
CODEBEGIN

  ; print a '.' using a real mode interrupt from a protected mode IRQ
IRQ0:
  push ax dx ds
  mov ds,m CS:Data32Sel
  mov ah,2
  mov dl,'.'
  int 21h
  mov al,20h
  out 20h,al
  pop ds dx ax

  iretd


  ; increment character in top left of screen
IRQ1:
  push eax ds
  mov ds,m CS:Flat32Sel
  inc b [DS:000B8000h]
  pop ds eax

  db 0EAh                     ; chain to original ISR
OldInt9hOffset  dd ?
OldInt9hSel     dw ?

OldInt8hOffset  dd ?
OldInt8hSel     dw ?


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Start32:

  ; Enable mouse cursor
  xor eax,eax
  int 33h
  mov ax,1
  int 33h

  ; Get original Int 8h
  mov bl,8h
  call m GetPMInt
  mov OldInt8hOffset,edx
  mov OldInt8hSel,ax

  ; Set new Int 8h
  mov ax,m Code32Sel
  mov edx,o IRQ0
  mov bl,8h
  call m SetPMInt

  ; Get original Int 9h
  mov bl,9h
  call m GetPMInt
  mov OldInt9hOffset,edx
  mov OldInt9hSel,ax

  ; Set new Int 9h
  mov ax,m Code32Sel
  mov edx,o IRQ1
  mov bl,9h
  call m SetPMInt

  ; Print 'P'
  mov ah,2
  mov dl,'P'
  int 21h

  ; Readkey from Protected Mode
  mov ax,GS:[41Ah]
  @@1:
    cmp ax,GS:[41Ch]
    je @@1
    mov GS:[41Ch],ax


  ; Print 'R'
  mov ah,2
  mov dl,'R'
  int 21h

  ; Readkey from Real Mode
  xor eax,eax
  rint 16h

  ; Restore protected mode interrupts
  mov bl,8h
  mov ax,OldInt8hSel
  mov edx,OldInt8hOffset
  call m SetPMInt

  mov bl,9h
  mov ax,OldInt9hSel
  mov edx,OldInt9hOffset
  call m SetPMInt

  ; disable mouse cursor
  mov ax,2
  int 33h

  jmp Exit32

CODEEND
