_RVERSIONMAGIC     EQU   '0SER'
comment #
 resource overview
 12 bytes: header
 items*data
 items*directory
#
_RESHDR            STRUC
_rmagic            DD    ? ; magic
_rrsize            DD    ? ; resource file size (except directory)
_ritems            DD    ? ; items in resource file
_RESHDR            ENDS

_RESITEM           STRUC
_rname             DB   22D DUP(?)
_rzero             DB   ? ; string terminator
_rflags            DB   ? ; resource item flags
_rfpos             DD   ? ; position relative to beginning of resource
_rsize             DD   ? ; resource item size
_RESITEM           ENDS

_resdir            DD    ?
_resbase           DD    ?
_reshw             LABEL WORD
_resh              _RESHDR <>
_reshandle         DD    ?

Comment #
!_RES_Init
  Explanation  : initialize resource file
  Expects      : EDX - pointer to filename containing resource
  Returns      : CF = 0 resource opened OK
                  CF = 1 error
  Screwed regs : none
#
_RES_Init          PROC  NEAR
                   PUSH  EAX
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX

                   CLR   EAX
                   MOV   _resbase,EAX

                   CLR   AL
                   XCHG  AL,FileMode ; mode 0, read only
                   PUSH  EAX
                   CALL  FileOpen
                   POP   EBX
                   XCHG  BL,FileMode
                   JC    @@druut
                   MOV   _reshandle,EAX
                   MOV   EBX,EAX

@@testres:         MOV   EAX,_resbase
                   CALL  FileSeek ; seek base
                   MOV   D _resh._rmagic,'1234'
                   MOV   EDX,O _resh
                   MOV   ECX,size _RESHDR
                   CALL  FileRead ; read header
                   CMP   D _resh._rmagic,_RVERSIONMAGIC
                   JZ    @@isres
                                ; maybe exe ?
                   CMP   _resbase,0
                   JNZ   @@badclose ; second pass
                   CMP   _reshw,'ZM'
                   JNZ   @@badclose
                   MOVZX EAX,_reshw[4] ; pages in file
                   DEC   EAX
                   SHL   EAX,9
                   MOVZX EDX,_reshw[2] ; last page
                   ADD   EAX,EDX
                   MOV   _resbase,EAX
                   JMP   @@testres

@@isres:           MOV   EAX,_resbase
                   ADD   EAX,_resh._rrsize
                   CALL  FileSeek ; seek base
                   MOV   EAX, _resh._ritems
                   SHL   EAX,5 ; *32
                   MOV   ECX,EAX
                   CALL  malloc ; alloc directory
                   JZ    @@badclose
                   MOV   EDX,EAX
                   MOV   _resdir,EAX
                   CALL  FileRead ; read resource directory
                   CLC
@@druut:           POP   EDX
                   POP   ECX
                   POP   EBX
                   POP   EAX
                   RET
@@badclose:        CALL  FileClose
                   STC
                   JMP   @@druut
_RES_Init          ENDP

Comment #
!_RES_Done
  Explanation  : close resource file and free structures in memory
  Expects      : nothing
  Returns      : nothing
  Screwed regs : none
#
_RES_Done          PROC  NEAR
                   PUSH  EAX
                   PUSH  EBX
                   MOV   EAX,_resdir
                   CALL  free
                   MOV   EBX,_reshandle
                   CALL  FileClose
                   POP   EBX
                   POP   EAX
                   RET
_RES_Done          ENDP

comment #
 input: EDX - resource item name
 output: CF=1 - nothing found, EAX = 0
         CF=0 - EAX points to resource directory item
#
_RES_FindStr       PROC  NEAR
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  ESI
                   MOV   ECX,_resh._ritems
                   OR    ECX,ECX
                   JZ    @@notf
                   MOV   EAX,_resdir
@@FindLp:          PUSH  ECX
                   MOV   EBX,EAX
                   MOV   ESI,EDX

@@SLp:             MOV   CL,[EBX]
                   MOV   CH,[ESI]
                   INC   EBX
                   INC   ESI
                   OR    CX,CX
                   JZ    @@found
                   CMP   CL,CH
                   JZ    @@SLp

                   POP   ECX
                   ADD   EAX,size _RESITEM
                   LOOP  @@FindLp
@@notf:            CLR   EAX
                   STC
                   JMP   @@druut
@@found:           ADD   ESP,4
                   CLC
@@druut:           POP   ESI
                   POP   ECX
                   POP   EBX
                   RET
_RES_FindStr       ENDP

Comment #
!_RES_Load
  Explanation  : loads file of given name from resource file
                  and automaticaly allocates block of high memory
  Expects      : EDX = ptr to res item name
  Returns      : CF=1 - failure EAX = 0, ECX = 0
                  CF=0 - OK EAX = ptr to loaded resource, ECX = resource size
  Screwed regs : none
#
_RES_Load          PROC  NEAR
                   PUSH  EBX
                   PUSH  EDX
                   PUSH  ESI
                   PUSH  EDI
                   PUSH  EBP
                   CALL  _RES_FindStr
                   JC    @@bad
; seek
                   MOV   ESI,EAX
                   MOV   EBX,_reshandle
                   MOV   EAX,[ESI._rfpos]
                   ADD   EAX,_resbase
                   CALL  FileSeek
                   CMP   [ESI._rflags],1 ; packed
                   JZ    @@packed
                   MOV   EAX,[ESI._rsize]
                   MOV   ECX,EAX
                   CALL  malloc
                   JZ    @@bad
                   MOV   EDX,EAX
                   CALL  FileRead
                   MOV   EAX,EDX
                   JMP   @@ok
@@packed:
                   CALL  ExplodeFile
                   JC    @@bad
@@ok:              CLC
@@druut:           POP   EBP
                   POP   EDI
                   POP   ESI
                   POP   EDX
                   POP   EBX
                   RET
@@bad2:            MOV   EAX,EDX
                   CALL  free
@@bad:             CLR   EAX
                   CLR   ECX
                   STC
                   JMP   @@druut
_RES_Load          ENDP

