;
; some useful fileio

FileMode           DB  02H   ; file io mode

;
;!FileOpen
;  EXPLANATION  : opens dos file, name in null terminated string
;  INPUT        : EDX offset of string
;  OUTPUT       : CF, EAX err code or file handle
;  SCREWED REGS : none
;

FileOpen           PROC  NEAR
                   PUSH  EAX
                   MOV   AH,3DH
                   MOV   AL,FileMode
FOpen:             MOV   RI_AX,AX
                   POP   EAX
                   PUSHAD
                   MOV   ESI,EDX
                   MOV   EDI,DiskBuffer
                   CLD
@@NextByte:        LODSB
                   STOSB
                   OR    AL,AL
                   JNZ   @@NextByte
                   MOVZX EDX,W DiskBufferReal
                   MOV   RI_EDX,EDX
                   MOV   DX,W DiskBufferReal+2
                   MOV   RI_DS,DX
                   CALL  CallInt21
                   MOV   AH,B RI_Flags
                   SAHF
                   POPAD
                   MOVZX EAX,RI_AX
                   RET
FileOpen           ENDP

;
;!FileCreate
;  EXPLANATION  : creates dos file, name in null terminated string
;  INPUT        : EDX offset of string
;  OUTPUT       : CF, EAX err code or file handle
;  SCREWED REGS : none
;

FileCreate         PROC  NEAR
                   PUSH  EAX
                   MOV   AX,3C00H
                   MOV   RI_ECX,0
                   JMP   FOpen
FileCreate         ENDP

;
;!FileClose
;  EXPLANATION  : closes disk file
;  INPUT        : EBX - file handle
;  OUTPUT       : carry, andEAX - error codes
;  SCREWED REGS : flags,EAX
;

FileClose          PROC NEAR
                   PUSHAD
                   MOV  RI_EBX,EBX
                   MOV  RI_AH,3EH
                   CALL CallInt21
                   MOV  AH,B RI_Flags
                   SAHF
                   POPAD
                   MOVZX EAX,RI_AX
                   RET
FileClose          ENDP

;
;!FileRead
;  EXPLANATION  : reads ECX bytes  from file
;  INPUT        : also EBX - file handle, EDX - where
;  OUTPUT       : CF, and EAX - bytes read or error code
;  SCREWED REGS : none except above
;

FileRead           PROC  NEAR
                   LOCAL ToRead:DWORD,\
                         Where:DWORD,\
                         Readed:DWORD = FrameSize
                   ; enter is EVIL !
                   PUSH  EBP
                   MOV   EBP,ESP
                   SUB   ESP,FrameSize

                   PUSHAD
                   MOV   ToRead,ECX
                   MOV   Where,EDX
                   MOV   Readed,0
@@NextChunk:
                   MOV   ECX,DiskBufferSize
                   CMP   ToRead,ECX
                   JAE   @@Skip1
                   MOV   ECX,ToRead
@@Skip1:           SUB   ToRead,ECX

                   PUSHAD   ; start reading chunk
                   MOV   RI_EBX,EBX
                   MOV   RI_ECX,ECX
                   MOVZX EDX,W DiskBufferReal
                   MOV   RI_EDX,EDX
                   MOV   DX,W DiskBufferReal+2
                   MOV   RI_DS,DX
                   MOV   RI_AH,3FH
                   CALL  CallInt21
                   MOV   AH,B RI_Flags
                   SAHF
                   POPAD
                   JC    @@BadExit
                   MOVZX EAX,RI_AX
                   ADD   Readed,EAX
                   MOV   ECX,EAX
                   MOV   EDI,Where
                   MOV   ESI,DiskBuffer
                   CLD
                   REP   MOVSB
                   MOV   Where,EDI
                   CMP   ToRead,0
                   JNZ   @@NextChunk
                   POPAD
                   CLC
                   MOV   EAX,Readed
@@druut:
                   MOV   ESP,EBP
                   POP   EBP
                   RET

@@BadExit:         POPAD
                   STC
                   MOVZX EAX,RI_AX
                   JMP   SHORT @@druut

FileRead           ENDP

;
;!FileWrite
;  EXPLANATION  : writes ECX bytes to file
;  INPUT        : also EBX - file handle, EDX - from where
;  OUTPUT       : CF, and EAX - bytes read or error code
;  SCREWED REGS : none except above
;

FileWrite          PROC  NEAR
                   LOCAL ToWrite:DWORD,\
                         From:DWORD,\
                         Written:DWORD = FrameSize
                   ; enter is EVIL !
                   PUSH  EBP
                   MOV   EBP,ESP
                   SUB   ESP,FrameSize

                   PUSHAD
                   MOV   ToWrite,ECX
                   MOV   From,EDX
                   MOV   Written,0
@@NextChunk:
                   MOV   ECX,DiskBufferSize
                   CMP   ToWrite,ECX
                   JAE   @@Skip1
                   MOV   ECX,ToWrite
@@Skip1:           SUB   ToWrite,ECX

                   PUSH  ECX
                   MOV   ESI,From
                   MOV   EDI,DiskBuffer
                   CLD
                   REP   MOVSB
                   MOV   From,ESI
                   POP   ECX

@@ReadChunk:       PUSHAD
                   MOV   RI_EBX,EBX
                   MOV   RI_ECX,ECX
                   MOVZX EDX,W DiskBufferReal
                   MOV   RI_EDX,EDX
                   MOV   DX,W DiskBufferReal+2
                   MOV   RI_DS,DX
                   MOV   RI_AH,40H
                   CALL  CallInt21
                   MOV   AH,B RI_Flags
                   SAHF
                   POPAD
                   JC    @@BadExit
                   MOVZX EAX,RI_AX
                   ADD   Written,EAX
                   CMP   ToWrite,0
                   JNZ   @@NextChunk
                   POPAD
                   CLC
                   MOV   EAX,Written
@@druut:
                   MOV   ESP,EBP
                   POP   EBP
                   RET

@@BadExit:         POPAD
                   STC
                   MOVZX EAX,RI_AX
                   JMP   SHORT @@druut
                   RET

FileWrite          ENDP

;
;!FileSeek
;  EXPLANATION  : sets file pointer
;  INPUT        : EAX - req. pos., ebx - handle
;  OUTPUT       : EAX - new file ptr or err code
;  SCREWED REGS : eax as always :)
;

FileSeek           PROC  NEAR
                   PUSHAD
                   MOV   RI_EBX,EBX
                   MOV   RI_AX,4200H
                   MOV   RI_DX,AX
                   SHR   EAX,16
                   MOV   RI_CX,AX
                   CALL  CallInt21
                   MOV   AH,B RI_Flags
                   SAHF
                   POPAD
                   MOVZX EAX,RI_AX
                   JC    @@Skip
                   MOV   AX,RI_DX
                   SHL   EAX,16
                   MOV   AX,RI_AX
                   CLC
@@Skip:
                   RET
FileSeek           ENDP

;
;!FileTell
;  EXPLANATION  : tells position in file
;  INPUT        : ebx - handle
;  OUTPUT       : eax - position in file
;  SCREWED REGS : ehh
;

FileTell           PROC  NEAR
                   PUSHAD
                   MOV   RI_EBX,EBX
                   MOV   RI_AX,4201H
                   MOV   RI_DX,0
                   MOV   RI_CX,0
                   CALL  CallInt21
                   MOV   AH,B RI_Flags
                   SAHF
                   POPAD
                   MOVZX EAX,RI_AX
                   JC    @@Skip
                   MOV   AX,RI_DX
                   SHL   EAX,16
                   MOV   AX,RI_AX
                   CLC
@@Skip:
                   RET
FileTell           ENDP

;
;!FileSize
;  EXPLANATION  : returns size of file
;  INPUT        : ebx - file handle
;  OUTPUT       : eax - file size, or cf,eax -err code
;  SCREWED REGS : eax
;

FileSize           PROC  NEAR
                   CALL  FileTell
                   JC    @@druut
                   PUSH  EAX
                   PUSHAD
                   MOV   RI_EBX,EBX
                   MOV   RI_AX,4202H ; seek end
                   MOV   RI_DX,0
                   MOV   RI_CX,0
                   CALL  CallInt21
                   MOV   AH,B RI_Flags
                   SAHF
                   POPAD
                   JNC   @@AllRite
                   ADD   ESP,4 ; skip last pos
                   MOVZX EAX,RI_AX
                   JMP   SHORT @@druut
@@AllRite:         MOV   AX,RI_DX
                   SHL   EAX,16
                   MOV   AX,RI_AX
                   XCHG  EAX,[ESP]
                   CALL  FileSeek
                   JNC   @@AllRite2
                   ADD   ESP,4
                   JMP   SHORT @@druut
@@AllRite2:        POP   EAX
@@druut:           RET

FileSize           ENDP

Comment #
!FileDelete
  Explanation  : delete file
  Expects      : EDX - filename
  Returns      : CF, AND EAX
  Screwed regs : none
#
FileDelete         PROC  NEAR
                   PUSHAD
                   MOV   EBX,DiskBuffer
@@CpyLp:           MOV   AL,[EDX]
                   INC   EDX
                   MOV   [EBX],AL
                   INC   EBX
                   OR    AL,AL
                   JNZ   @@CpyLp
                   MOVZX EDX,W DiskBufferReal
                   MOV   RI_EDX,EDX
                   MOV   DX,W DiskBufferReal+2
                   MOV   RI_DS,DX
                   MOV   RI_AH,41H
                   CALL  CallInt21
                   MOV   AH,B RI_Flags
                   SAHF
                   POPAD
                   MOVZX EAX,RI_AX
                   RET
FileDelete         ENDP

Comment #
!FileRename
  Explanation  : rename a file
  Expects      : EDX - oldname
                  EDI - newname
  Returns      : CF,EAX
  Screwed regs : none
#
FileRename         PROC  NEAR
                   PUSHAD
                   MOV   EBX,DiskBuffer
                   CLR   ECX
@@CpyLp:           MOV   AL,[EDX]
                   INC   EDX
                   MOV   [EBX],AL
                   INC   EBX
                   INC   ECX
                   OR    AL,AL
                   JNZ   @@CpyLp

@@CpyLp2:          MOV   AL,[EDI]
                   INC   EDI
                   MOV   [EBX],AL
                   INC   EBX
                   OR    AL,AL
                   JNZ   @@CpyLp2

                   MOVZX EDX,W DiskBufferReal
                   MOV   RI_EDX,EDX
                   ADD   EDX,ECX
                   MOV   RI_EDI,EDX
                   MOV   DX,W DiskBufferReal+2
                   MOV   RI_DS,DX
                   MOV   RI_ES,DX
                   MOV   RI_AH,56H
                   CALL  CallInt21
                   MOV   AH,B RI_Flags
                   SAHF
                   POPAD
                   MOVZX EAX,RI_AX

                   RET
FileRename         ENDP
