Include UnAsm.Inc

DBG_ScreenSize     EQU   28

DBG_Video          DD    ?
DBG_Cursor         DD    0
DBG_TextAttr       DB    07H
DBG_Screen         DW    DBG_ScreenSize*80 DUP(0720H)
DBG_LastMode       DB    3
DBG_SavedScreen    DD    0
DBG_InDebug        DB    FALSE
DBG_UserKbd        DF    ?

DBG_EFLAGS         LABEL DWORD
DBG_FLAGS          DW   ?
                   DW   ?
DBG_EAX            LABEL DWORD
DBG_AX             LABEL WORD
DBG_AL             DB   ?
DBG_AH             DB   ?
                   DW   ?
DBG_EBX            LABEL DWORD
DBG_BX             LABEL WORD
DBG_BL             DB   ?
DBG_BH             DB   ?
                   DW   ?
DBG_ECX            LABEL DWORD
DBG_CX             LABEL WORD
DBG_CL             DB   ?
DBG_CH             DB   ?
                   DW   ?
DBG_EDX            LABEL DWORD
DBG_DX             LABEL WORD
DBG_DL             DB   ?
DBG_DH             DB   ?
                   DW   ?
DBG_ESI            LABEL DWORD
DBG_SI             DW   ?
                   DW   ?
DBG_EDI            LABEL DWORD
DBG_DI             DW   ?
                   DW   ?
DBG_EBP            LABEL DWORD
DBG_BP             DW   ?
                   DW   ?
DBG_ESP            LABEL DWORD
DBG_SP             DW   ?
                   DW   ?
DBG_EIP            LABEL DWORD
DBG_IP             DW   ?
                   DW   ?
DBG_CS             DD   ?

DBG_VGACRTC        DB    19H+1 DUP(0)
DBG_VGAGDC         DB    9H+1 DUP(0)
DBG_VGASEQ         DB    5H+1 DUP(0)
DBG_VGACLOCK       DB    0
DBG_PALETTE        DB    768D DUP(0)

Dbd_Get            PROC  NEAR
                   PUSH  ESI
@@Here:            MOV   ESI,Kbd_BufferHead
                   CMP   ESI,Kbd_BufferTail
                   JZ    @@Here
                   MOV   EAX,DWORD PTR [ESI]
                   CALL  IncKbdBuffHead
                   MOV   Kbd_BufferHead,ESI
                   POP   ESI
                   RET
Dbd_Get            ENDP


DBG_GetCRTC        PROC  NEAR
                   CLD
                   MOV   EDI,OFFSET DBG_VGACRTC
                   MOV   DX,3D4H
                   IN    AL,DX ; index REG
                   STOSB
                   XOR   BL,BL
                   MOV   ECX,19H
@@StLp:            MOV   AL,BL
                   OUT   DX,AL
                   INC   DX
                   IN    AL,DX
                   STOSB
                   DEC   DX
                   INC   BL
                   LOOP  @@StLp
                   RET
DBG_GetCRTC        ENDP

DBG_SetCRTC        PROC  NEAR
                   CLD
; 1. write protect off
                   MOV   DX,3D4H      ;CRTC
                   MOV   AL,11H       ;Register 11H, Light pen low
                   OUT   DX,AL
                   INC   DX
                   IN    AL,DX
                   AND   AL,01111111B ;Delete b7, write protect off
                   OUT   DX,AL
; 2. set all regs
                   MOV   ESI,OFFSET DBG_VGACRTC+1
                   MOV   DX,3D4H
                   XOR   AL,AL
                   MOV   ECX,19H
@@StLp:            MOV   AH,[ESI]
                   INC   ESI
                   OUT   DX,AX
                   INC   AL
                   LOOP  @@StLp
; 3. set index reg
                   MOV   AL,B DBG_VGACRTC
                   OUT   DX,AL
                   RET
DBG_SetCRTC        ENDP

DBG_GetGDC         PROC  NEAR
                   CLD
                   MOV   EDI,OFFSET DBG_VGAGDC
                   MOV   DX,3CEH
                   IN    AL,DX ; index REG
                   STOSB
                   XOR   BL,BL
                   MOV   ECX,9H
@@StLp:            MOV   AL,BL
                   OUT   DX,AL
                   INC   DX
                   IN    AL,DX
                   STOSB
                   DEC   DX
                   INC   BL
                   LOOP  @@StLp
                   RET
DBG_GetGDC         ENDP

DBG_SetGDC         PROC  NEAR
                   CLD
; 1. set all regs
                   MOV   ESI,OFFSET DBG_VGAGDC+1
                   MOV   DX,3CEH
                   XOR   AL,AL
                   MOV   ECX,9H
@@StLp:            MOV   AH,[ESI]
                   INC   ESI
                   OUT   DX,AX
                   INC   AL
                   LOOP  @@StLp
; 2. set index reg
                   MOV   AL,B DBG_VGAGDC
                   OUT   DX,AL
                   RET
DBG_SetGDC         ENDP

DBG_GetSEQ         PROC  NEAR
                   CLD
                   MOV   EDI,OFFSET DBG_VGASEQ
                   MOV   DX,3C4H
                   IN    AL,DX ; index REG
                   STOSB
                   XOR   BL,BL
                   MOV   ECX,5H
@@StLp:            MOV   AL,BL
                   OUT   DX,AL
                   INC   DX
                   IN    AL,DX
                   STOSB
                   DEC   DX
                   INC   BL
                   LOOP  @@StLp
                   RET
DBG_GetSEQ         ENDP

DBG_SetSEQ         PROC  NEAR
                   CLD
; 1. set all regs
                   MOV   ESI,OFFSET DBG_VGASEQ+1
                   MOV   DX,3C4H
                   XOR   AL,AL
                   MOV   ECX,5H
@@StLp:            MOV   AH,[ESI]
                   INC   ESI
                   OUT   DX,AX
                   INC   AL
                   LOOP  @@StLp
; 2. set index reg
                   MOV   AL,B DBG_VGASEQ
                   OUT   DX,AL
                   RET
DBG_SetSEQ         ENDP

DBG_SetX           PROC  NEAR

                   MOV   DX,03C4H     ; Sequencer
                   MOV   AX,0604H
                   OUT   DX,AX        ; disable chain4 mode

                   RET
DBG_SetX           ENDP

DBG_VGASave        PROC  NEAR
                   MOV   AH,0FH ; get current video mode
                   PUSH  10H
                   CALL  CallInt
                   MOV   DBG_LastMode,AL

                   CALL  DBG_GetCRTC
                   CALL  DBG_GetGDC
                   CALL  DBG_GetSEQ
                   MOV   DX,3CCH ; clock
                   IN    AL,DX
                   MOV   DBG_VGACLOCK,AL

                   MOV   EDI,OFFSET DBG_PALETTE
		   CLD
                   MOV   DX,3C7H
                   XOR   AL,AL
                   OUT   DX,AL
                   ADD   DX,2
                   MOV   ECX,768D
                   REP   INSB

                   CMP   DBG_LastMode,3
                   JZ    @@saveText
                   CMP   DBG_LastMode,13H
                   JZ    @@saveGfx
@@stored:
                   RET

@@saveText:        MOV   EAX,50*160
                   CALL  malloc
                   MOV   DBG_SavedScreen,EAX
                   MOV   EDI,EAX
                   MOV   ECX,50*160/4
                   CLD
                   MOV   ESI,SegB800
                   REP   MOVSD
                   JMP   @@stored

@@saveGfx:         CALL  DBG_SetX
                   MOV   EAX,256*1024
                   CALL  malloc
                   MOV   DBG_SavedScreen,EAX
                   MOV   EDI,EAX
                   CLD
                   MOV   DX,3CEH

                   MOV   AX,0004H
                   OUT   DX,AX
                   MOV   ESI,SegA000
                   MOV   ECX,16384
                   REP   MOVSD

                   MOV   AX,0104H
                   OUT   DX,AX
                   MOV   ESI,SegA000
                   MOV   ECX,16384
                   REP   MOVSD

                   MOV   AX,0204H
                   OUT   DX,AX
                   MOV   ESI,SegA000
                   MOV   ECX,16384
                   REP   MOVSD

                   MOV   AX,0304H
                   OUT   DX,AX
                   MOV   ESI,SegA000
                   MOV   ECX,16384
                   REP   MOVSD

                   JMP   @@stored
DBG_VGASave        ENDP

DBG_VGARestore     PROC  NEAR
                   MOVZX EAX,DBG_LastMode
                   PUSH  10H
                   CALL  CallInt

                   CMP   DBG_LastMode,3
                   JZ    @@restoreText
                   CMP   DBG_LastMode,13H
                   JZ    @@restoreGfx
@@restored:
                   MOV   DX,3C4H
                   MOV   AX,0100H
                   OUT   DX,AX       ;  synchronous reset while setting Misc

                   MOV   AL,DBG_VGACLOCK
                   MOV   DX,03C2H    ; miscellaneous output
                   OUT   DX,AL

                   CALL  DBG_SetSEQ
                   CALL  DBG_SetGDC
                   CALL  DBG_SetCRTC

                   MOV  ESI,OFFSET DBG_PALETTE
		   CLD
		   MOV  DX,3C8H
		   XOR  AL,AL
		   OUT  DX,AL
		   INC  DX
                   MOV  ECX,768D
                   REP  OUTSB

                   RET

@@restoreText:     MOV   ESI,DBG_SavedScreen
                   MOV   ECX,50*160/4
                   MOV   EDI,SegB800
                   CLD
                   REP   MOVSD
                   MOV   EAX,DBG_SavedScreen
                   CALL  free
                   JMP   @@restored

@@restoreGfx:      CALL  DBG_SetX
                   MOV   ESI,DBG_SavedScreen
                   MOV   DX,3C4H
                   CLD

                   MOV   AX,0102H
                   OUT   DX,AX
                   MOV   EDI,SegA000
                   MOV   ECX,16384
                   REP   MOVSD

                   MOV   AX,0202H
                   OUT   DX,AX
                   MOV   EDI,SegA000
                   MOV   ECX,16384
                   REP   MOVSD

                   MOV   AX,0402H
                   OUT   DX,AX
                   MOV   EDI,SegA000
                   MOV   ECX,16384
                   REP   MOVSD

                   MOV   AX,0802H
                   OUT   DX,AX
                   MOV   EDI,SegA000
                   MOV   ECX,16384
                   REP   MOVSD

                   MOV   EAX,DBG_SavedScreen
                   CALL  free
                   JMP   @@restored
DBG_VGARestore     ENDP

DBG_UserScreen     PROC  NEAR
                   CALL  DBG_SaveScreen
                   CALL  DBG_VGARestore
                   CALL  Dbd_Get
                   CALL  DBG_VGASave
                   CALL  DBG_SetScreen
                   RET
DBG_UserScreen     ENDP

DBG_DisplayCursor  PROC  NEAR
                   PUSH  EAX
                   PUSH  EBX
                   PUSH  EDX
                   MOV   EBX,DBG_Cursor
                   SHR   EBX,1
                   MOV   DX,3D4H
                   MOV   AL,14
                   MOV   AH,BH
                   OUT   DX,AX
                   INC   AL
                   MOV   AH,BL
                   OUT   DX,AX
                   POP   EDX
                   POP   EBX
                   POP   EAX
                   RET
DBG_DisplayCursor  ENDP

DBG_OutChar        PROC  NEAR
                   PUSH  EAX
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX
                   PUSH  ESI
                   PUSH  EDI

                   MOV   EDI,DBG_Cursor
                   MOV   EBX,DBG_Video
                   MOV   AH,DBG_TextAttr

                   CMP   AL,0DH
                   JNZ   @@Skp1
                   ; Carriage return
                   MOV   EAX,EDI
                   MOV   EBX,160D
                   XOR   EDX,EDX
                   DIV   EBX
                   MUL   EBX
                   MOV   EDI,EAX
                   JMP   @@SkipDisplay

@@Skp1:            CMP   AL,0AH
                   JNZ   @@Skp2
                   ; Line feed
                   ADD   EDI,160D
                   JMP   @@SkipDisplay
@@Skp2:
                   MOV   [EDI+EBX],AX
                   ADD   EDI,2
@@SkipDisplay:
                   CMP   EDI,160*DBG_ScreenSize
                   JB    @@ProcEnd

                   ; scroll up one line
                   PUSH  EDI
                   MOV   EDI,DBG_Video
                   LEA   ESI,[EDI+160]
                   MOV   ECX,(DBG_ScreenSize-1)*40
                   CLD
                   REP   MOVSD
                   MOV   EAX,07200720H
                   MOV   ECX,160/4
                   REP   STOSD
                   POP   EDI
                   SUB   EDI,160D
@@ProcEnd:         MOV   DBG_Cursor,EDI
                   CALL  DBG_DisplayCursor
                   POP   EDI
                   POP   ESI
                   POP   EDX
                   POP   ECX
                   POP   EBX
                   POP   EAX
                   RET
DBG_OutChar        ENDP

DBG_OutString      PROC  NEAR
                   PUSH  EAX
                   PUSH  ESI
                   CLD
@@Here:            LODSB
                   OR    AL,AL
                   JZ    @@ProcExit
                   CALL  DBG_OutChar
                   JMP   @@Here
@@ProcExit:        POP   ESI
                   POP   EAX
                   RET
DBG_OutString      ENDP

DBG_OutHByte       PROC  NEAR
                   PUSH  EAX
                   PUSH  EBX
                   MOV   EBX,EAX
                   SHR   EAX,4
                   AND   EAX,0FH
                   MOV   AL,[EAX + OFFSET _hextbl]
                   CALL  DBG_OutChar
                   AND   EBX,0FH
                   MOV   AL,[EBX + OFFSET _hextbl]
                   CALL  DBG_OutChar
                   POP   EBX
                   POP   EAX
                   RET
DBG_OutHByte       ENDP

DBG_OutHWord       PROC  NEAR
                   REPT  2
                   ROL   AX,8
                   CALL  DBG_OutHByte
                   ENDM
                   RET
DBG_OutHWord       ENDP

DBG_OutHLong       PROC  NEAR
                   REPT  4
                   ROL   EAX,8
                   CALL  DBG_OutHByte
                   ENDM
                   RET
DBG_OutHLong       ENDP

; out decimal
DBG_OutDLong       PROC  NEAR
                   PUSH  EBX
                   PUSH  EDX
                   PUSH  ESI
                   TEST  EAX,80000000H
                   JZ    @@SkipSign
                   NEG   EAX
                   PUSH  EAX
                   MOV   AL,'-'
                   CALL  DBG_OutChar
                   POP   EAX
@@SkipSign:        MOV   ESI,O @@buffer
@@lp:              DEC   ESI
                   XOR   EDX,EDX
                   MOV   EBX,10
                   DIV   EBX
                   ADD   DL,'0'
                   MOV   [ESI],DL
                   OR    EAX,EAX
                   JNZ   @@lp
                   CALL  DBG_OutString
                   POP   ESI
                   POP   EDX
                   POP   EBX
                   RET
                   DB    19D DUP(0)
@@buffer           DB    0
DBG_OutDLong       ENDP

DBG_Say            MACRO Tekst,attr
                   LOCAL Skip,Dane
                   JMP   Skip
Dane               DB    Tekst
                   DB    00H
Skip:              IFNB  <attr>
                   MOV   DBG_TextAttr,attr
                   ENDIF
                   PUSH  ESI
                   MOV   ESI,OFFSET Dane
                   CALL  DBG_OutString
                   POP   ESI
                   IFNB  <attr>
                   MOV   DBG_TextAttr,07H
                   ENDIF
                   ENDM

DBG_SayLn          MACRO Tekst,attr
                   LOCAL Skip,Dane
                   JMP   Skip
Dane               DB    Tekst
                   DB    0DH,0AH,00H
Skip:              IFNB  <attr>
                   MOV   DBG_TextAttr,attr
                   ENDIF
                   PUSH  ESI
                   MOV   ESI,OFFSET Dane
                   CALL  DBG_OutString
                   POP   ESI
                   IFNB  <attr>
                   MOV   DBG_TextAttr,07H
                   ENDIF
                   ENDM

DBG_SayValue       MACRO Value,attr
                   IFNB  <attr>
                   MOV   DBG_TextAttr,attr
                   ENDIF
                   PUSH  EAX
                   MOV   EAX,Value
                   CALL  DBG_OutHLong
                   POP   EAX
                   IFNB  <attr>
                   MOV   DBG_TextAttr,07H
                   ENDIF
                   ENDM

DBG_SayDec         MACRO Value,attr
                   IFNB  <attr>
                   MOV   DBG_TextAttr,attr
                   ENDIF
                   PUSH  EAX
                   MOV   EAX,Value
                   CALL  DBG_OutDLong
                   POP   EAX
                   IFNB  <attr>
                   MOV   DBG_TextAttr,07H
                   ENDIF
                   ENDM

DBG_SayZ           MACRO attr
                   LOCAL Skip
                   IFNB  <attr>
                   MOV   DBG_TextAttr,attr
                   ENDIF
                   PUSH  EAX
                   MOV   AL,'0'
                   JZ    Skip
                   MOV   AL,'1'
Skip:              CALL  DBG_OutChar
                   POP   EAX
                   IFNB  <attr>
                   MOV   DBG_TextAttr,07H
                   ENDIF
                   ENDM

DBG_NextLine       PROC  NEAR
                   PUSH  EAX
                   MOV   AL,0DH
                   CALL  DBG_OutChar
                   MOV   AL,0AH
                   CALL  DBG_OutChar
                   POP   EAX
                   RET
DBG_NextLine       ENDP

DBG_NewLine        MACRO
                   CALL  DBG_NextLIne
                   ENDM

DBG_StrDup         MACRO From,To
                   LOCAL Here
                   PUSH  EAX
                   PUSH  ESI
                   PUSH  EDI
                   MOV   ESI,OFFSET From
                   MOV   EDI,OFFSET To
                   CLD
Here:              LODSB
                   STOSB
                   OR    AL,AL
                   JNZ   Here
                   POP   EDI
                   POP   ESI
                   POP   EAX
                   ENDM

DBG_StrDupP        PROC  NEAR
                   PUSH  EAX
                   PUSH  ESI
                   PUSH  EDI
                   CLD
@@Here:            LODSB
                   STOSB
                   OR    AL,AL
                   JNZ   @@Here
                   POP   EDI
                   POP   ESI
                   POP   EAX
                   RET
DBG_StrDupP        ENDP

DBG_GetString      PROC  NEAR
                   PUSHAD
                   MOV   EAX,@@LastPtr
                   MOV   @@LastCur,EAX
                   MOV   B @@Buffer,0
                   MOV   @@Position,0
                   MOV   EAX,DBG_Cursor
                   MOV   @@StartCursor,EAX

@@NextChar:        CALL  Dbd_Get
                   CMP   AL,0DH
                   JZ    @@ProcExit

                   CMP   AX,5300H  ; del
                   JNZ   @@Skip1
@@DeleteChar:      MOV   EBX,@@Position
                   ADD   EBX,OFFSET @@Buffer
                   CMP   B [EBX],0
                   JZ    @@DisplayAll
@@DelLoop:         MOV   AL,[EBX+1]
                   MOV   [EBX],AL
                   INC   EBX
                   OR    AL,AL
                   JNZ   @@DelLoop
                   JMP   @@DisplayAll

@@Skip1:           CMP   AX,4B00H  ; arrow left
                   JNZ   @@Skip2
                   CMP   @@Position,0
                   JZ    @@DisplayAll
                   DEC   @@Position
                   JMP   @@DisplayAll

@@Skip2:           CMP   AX,4D00H   ; arrow rite
                   JNZ   @@Skip3
                   MOV   EBX,@@Position
                   ADD   EBX,OFFSET @@Buffer
                   CMP   B [EBX],0
                   JZ    @@DisplayAll
                   INC   @@Position
                   JMP   @@DisplayAll

@@Skip3:           CMP   AL,08H  ; backspace
                   JNZ   @@Skip4
                   CMP   @@Position,0
                   JZ    @@DisplayAll
                   DEC   @@Position
                   JMP   @@DeleteChar

@@Skip4:           CMP   AX,4700H ; home
                   JNZ   @@Skip5
                   MOV   @@Position,0
                   JMP   @@DisplayAll

@@Skip5:           CMP   AX,4F00H ; end
                   JNZ   @@Skip6
@@FindEnd:         MOV   EBX,OFFSET @@Buffer
@@EndLoop:         CMP   B [EBX],0
                   JZ    @@EndFound
                   INC   EBX
                   JMP   @@EndLoop
@@EndFound:        SUB   EBX,OFFSET @@Buffer
                   MOV   @@Position,EBX
                   JMP   @@DisplayAll

@@Skip6:           CMP   AX,3D00H    ; F3, copy last string
                   JNZ   @@Skip7
                   MOV   ESI,@@LastPtr
                   DEC   ESI
                   AND   ESI,0FH
                   SHL   ESI,7
                   ADD   ESI,OFFSET @@LastB
                   MOV   EDI,OFFSET @@Buffer
                   CALL  DBG_StrDupP
                   JMP   @@FindEnd

@@Skip7:           CMP   AX,3B00H    ; F1, help
                   JNZ   @@Skip8
                   DBG_StrDup @@KEY_F1,@@Buffer
                   JMP   @@ProcExit

@@Skip8:           CMP   AX,4100H    ; F7, trace into
                   JNZ   @@Skip9
                   DBG_StrDup @@KEY_F7,@@Buffer
                   JMP   @@ProcExit

@@Skip9:           CMP   AX,4200H    ; F8 step
                   JNZ   @@SkipA
                   DBG_StrDup @@KEY_F8,@@Buffer
                   JMP   @@ProcExit

@@SkipA:           CMP   AX,3E00H    ; F4, watch
                   JNZ   @@SkipB
                   DBG_StrDup @@KEY_F4,@@Buffer
                   JMP   @@ProcExit

@@SkipB:           CMP   AX,3F00H    ; F5, user screen
                   JNZ   @@SkipC
                   DBG_StrDup @@KEY_F5,@@Buffer
                   JMP   @@ProcExit

@@SkipC:           CMP   AX,4800H    ; arrow up
                   JNZ   @@SkipD
                   DEC   @@LastCur
                   MOV   ESI,@@LastCur
                   AND   ESI,0FH
                   SHL   ESI,7
                   ADD   ESI,OFFSET @@LastB
                   MOV   EDI,OFFSET @@Buffer
                   CALL  DBG_StrDupP
                   JMP   @@DisplayAll

@@SkipD:           CMP   AX,5000H    ; arrow down
                   JNZ   @@SkipE
                   INC   @@LastCur
                   MOV   ESI,@@LastCur
                   AND   ESI,0FH
                   SHL   ESI,7
                   ADD   ESI,OFFSET @@LastB
                   MOV   EDI,OFFSET @@Buffer
                   CALL  DBG_StrDupP
                   JMP   @@DisplayAll

@@SkipE:           CMP   AX,011BH ; escape
                   JNZ   @@SkipF
                   MOV   B @@Buffer,0
                   JMP   @@DisplayAll

@@SkipF:           CMP   AX,4300H ; F9, go
                   JNZ   @@SkipG
                   DBG_StrDup @@KEY_F9,@@Buffer
                   JMP   @@ProcExit

@@SkipG:           CMP   AX,4400H ; F0, bye
                   JNZ   @@SkipH
                   DBG_StrDup @@KEY_F0,@@Buffer
                   JMP   @@ProcExit

@@SkipH:
                   CMP   AL,00H
                   JZ    @@DisplayAll
; insert char
                   MOV   ESI,OFFSET @@Buffer
                   ADD   ESI,@@Position

@@InsertLoop:      XCHG  AL,[ESI]
                   INC   ESI
                   OR    AL,AL
                   JNZ   @@InsertLoop
                   MOV   [ESI],AL
                   INC   @@Position

@@DisplayAll:      MOV   EAX,@@StartCursor
                   MOV   DBG_Cursor,EAX
                   MOV   ESI,OFFSET @@Buffer
                   CALL  DBG_OutString

@@FillSpaces:      MOV   AL,' '
                   CALL  DBG_OutChar
                   MOV   EAX,DBG_Cursor
                   MOV   EBX,160D
                   XOR   EDX,EDX
                   DIV   EBX
                   CMP   EDX,156
                   JB    @@FillSpaces

                   MOV   EAX,@@Position
                   ADD   EAX,EAX
                   ADD   EAX,@@StartCursor
                   MOV   DBG_Cursor,EAX
                   CALL  DBG_DisplayCursor

                   JMP   @@NextChar
@@ProcExit:        MOV   ESI,OFFSET @@Buffer
                   MOV   EDI,@@LastPtr
                   AND   EDI,0FH
                   SHL   EDI,7
                   ADD   EDI,OFFSET @@LastB
                   CALL  DBG_StrDupP
                   INC   @@LastPtr
                   POPAD
                   MOV   EAX,OFFSET @@Buffer
                   RET
@@KEY_F1           DB    'HELP',00H
@@KEY_F2           DB    00H
@@KEY_F3           DB    00H
@@KEY_F4           DB    'WATCH',00H
@@KEY_F5           DB    'USER',00H
@@KEY_F6           DB    00H
@@KEY_F7           DB    'TRACE',00H
@@KEY_F8           DB    'STEP',00H
@@KEY_F9           DB    'GO',00H
@@KEY_F0           DB    'BYE',00H
@@Buffer           DB    128D DUP(00H)
@@Position         DD    0
@@StartCursor      DD    ?
@@LastB            DB    128D*16 DUP(0)
@@LastPtr          DD    0
@@LastCur          DD    0
DBG_GetString      ENDP

BrkPtStruc         STRUC
BPS_Addy           DD    -1
BPS_Save           DB    ?
                   DB    ?,?,?
BrkPtStruc         ENDS

WPS_Empty          EQU 0
WPS_Byte           EQU 1
WPS_Word           EQU 2
WPS_Long           EQU 3

WtPtStruc          STRUC
WPS_Addy           DD   0
WPS_Type           DB   WPS_Empty
                   DB   ?,?,?
WtPtStruc          ENDS

BreakPoints        LABEL BYTE
                   REPT  8
                   BrkPtStruc <>
                   ENDM
BrkSStep           BrkPtStruc <>

Watches            LABEL BYTE
                   REPT 8
                   WtPtStruc <>
                   ENDM

DBG_FukBrk         PROC  NEAR
                   PUSHAD
                   MOV   ESI,OFFSET BreakPoints
                   MOV   ECX,8
@@Here:            CMP   [ESI.BPS_Addy],-1
                   JZ    @@Next
                   MOV   AL,[ESI.BPS_Save]
                   MOV   EBX,[ESI.BPS_Addy]
                   MOV   [EBX],AL
@@Next:            ADD   ESI,Size BrkPtStruc
                   LOOP  @@Here
                   POPAD
                   RET
DBG_FukBrk         ENDP

DBG_RestBrk        PROC  NEAR
                   PUSHAD
                   MOV   ESI,OFFSET BreakPoints
                   MOV   ECX,8
@@Here:            CMP   [ESI.BPS_Addy],-1
                   JZ    @@Next
                   MOV   EBX,[ESI.BPS_Addy]
                   MOV   AL,[EBX]
                   MOV   [ESI.BPS_Save],AL
                   MOV   B [EBX],0CCH
@@Next:            ADD   ESI,Size BrkPtStruc
                   LOOP  @@Here
                   POPAD
                   RET
DBG_RestBrk        ENDP

DBG_AddBrkPt       PROC  NEAR
                   MOV   ECX,8
                   MOV   ESI,OFFSET BreakPoints
@@Here:            CMP   [ESI.BPS_Addy],-1
                   JZ    @@Found
                   ADD   ESI,Size BrkPtStruc
                   LOOP  @@Here
                   JMP   @@ProcExit
@@Found:           MOV   [ESI.BPS_Addy],EAX
@@ProcExit:
                   RET
DBG_AddBrkPt       ENDP

DBG_SetTrap        PROC  NEAR
                   CALL  DBG_FukBrk
                   CALL  DBG_AddBrkPt
                   CALL  DBG_RestBrk
                   RET
DBG_SetTrap        ENDP

DBG_SetBrkPt       PROC  NEAR
                   MOV   BL,[EAX]
                   MOV   BrkSStep.BPS_Save,BL
                   MOV   BrkSStep.BPS_Addy,EAX
                   MOV   B [EAX],0CCH
                   RET
DBG_SetBrkPt       ENDP

DBG_SaveRegs       MACRO   ; assumed to be called right after entry of interrupt
                   MOV   DBG_EAX,EAX
                   MOV   DBG_EBX,EBX
                   MOV   DBG_ECX,ECX
                   MOV   DBG_EDX,EDX
                   MOV   DBG_ESI,ESI
                   MOV   DBG_EDI,EDI
                   MOV   DBG_EBP,EBP
                   POP   DBG_EIP
                   POP   DBG_CS
                   POP   DBG_EFLAGS
                   MOV   DBG_ESP,ESP
                   STI
                   ENDM

DBG_Resume         MACRO
                   MOV   EAX,DBG_EAX
                   MOV   EBX,DBG_EBX
                   MOV   ECX,DBG_ECX
                   MOV   EDX,DBG_EDX
                   MOV   ESI,DBG_ESI
                   MOV   EDI,DBG_EDI
                   MOV   EBP,DBG_EBP
                   CLI
                   MOV   ESP,DBG_ESP
                   PUSH  DBG_EFLAGS
                   PUSH  DBG_CS
                   PUSH  DBG_EIP
                   IRETD
                   ENDM

DBG_IsJump         PROC  NEAR
                   CMP   B [EAX],066H
                   JZ    @@Prefix
                   CMP   B [EAX],067H
                   JNZ   @@Chek
@@Prefix:          INC   EAX
                   JMP   DBG_IsJump

@@Chek:            MOV   DH,[EAX]
                   MOV   DL,DH
                   AND   DL,0F0H
                   CMP   DL,70H
                   JZ    @@IsJump
                   ;MOV   DL,DH ; loops
                   ;AND   DL,011111100B
                   ;CMP   DL,0E0H
                   ;JZ    @@IsJump

                   CMP   DH,0E9H
                   JZ    @@IsJump
                   CMP   DH,0EAH
                   JZ    @@IsJump
                   CMP   DH,0EBH
                   JZ    @@IsJump
                   CMP   DH,0C2H
                   JZ    @@IsJump
                   CMP   DH,0C3H
                   JZ    @@IsJump
                   CMP   DH,0CAH
                   JZ    @@IsJump
                   CMP   DH,0CBH
                   JZ    @@IsJump

                   CMP   DH,0FH
                   JNZ   @@NoJump
                   MOV   DL,[EAX+1]
                   AND   DL,0F0H
                   CMP   DL,080H
                   JZ    @@IsJump

@@NoJump:          CLC
                   RET
@@IsJump:          STC
                   RET
DBG_IsJump         ENDP

DBG_Trace          PROC  NEAR
                   CALL  DBG_RestBrk
                   OR    D DBG_EFLAGS,100000000B  ; set trap flag
                   CALL  DBG_Leave
                   DBG_Resume
DBG_Trace          ENDP

DBG_SingleStep     PROC  NEAR
                   MOV   EAX,DBG_EIP
                   CALL  DBG_IsJump
                   JC    DBG_Trace
                   MOV   EAX,DBG_EIP
                   MOV   EDX,OFFSET @@weird
                   CALL  disassemble_
                   MOV   EAX,DBG_EIP
                   ADD   EAX,@@weird
                   CALL  DBG_SetBrkPt
                   CALL  DBG_RestBrk
                   CALL  DBG_Leave
                   DBG_Resume
@@weird            DD    ?
DBG_SingleStep     ENDP

DBG_KillWhities    PROC  NEAR
                   ; input, output - ESI
@@KeepKilling:     CMP   B [ESI],' '
                   JNZ   @@ProcExit
                   INC   ESI
                   JMP   @@KeepKilling
@@ProcExit:        RET
DBG_KillWhities    ENDP

; scan for char till end of string
; if found zf=1, esi moved
; if not found esi at end of string
ScanFor            MACRO sf
                   LOCAL lp,fail,done
lp:                CMP   B[ESI],sf
                   JZ    done
                   CMP   B[ESI],0
                   JZ    fail
                   INC   ESI
                   JMP   lp
fail:              CMP   B[ESI],1 ; clear zero flg
done:
                   ENDM

Separators         EQU   <'+-*/])&|^ ',0>

IsIn               MACRO reg,string
                   LOCAL dat,skip,done,lp,toobad
                   JMP   SHORT skip
dat                DB    string
                   DB    0FFH
skip:              PUSH  EDI
                   MOV   EDI,O dat
lp:                CMP   B [EDI],0FFH
                   JZ    toobad
                   CMP   [EDI],reg
                   JZ    done
                   INC   EDI
                   JMP   SHORT lp
toobad:            CMP   B [EDI],0 ; clear zero flg
done:              POP   EDI
                   ENDM

;-----------------------------------------------------------------------
;*expression stuff

; input esi - string
; output esi - pointer to first char after reg name
;        ecx - reg len
;        ebx - reg address
DBG_FindReg        PROC  NEAR
                   MOV   EBX,ESI
                   MOV   EDX,OFFSET @@regs
@@FindLp:          CMP   B [EDX],0
                   JZ    @@FindDn
                   MOV   ESI,EBX
                   MOV   EDI,EDX

@@CmpLp:           MOV   AL,[ESI]
                   OR    AL,AL
                   JZ    @@RegEnd
                   IsIn  AL,Separators
                   JZ    @@RegEnd
                   CMP   AL,[EDI]
                   JNZ   @@CmpFail
                   INC   ESI
                   INC   EDI
                   JMP   @@CmpLp
@@RegEnd:          CMP   B [EDI],0
                   JZ    @@FindOk  ; yes, we found it
@@CmpFail:         CMP   B [EDX],0 ; compare failed, find next item to compare
                   JZ    @@FailSkipDn
                   INC   EDX
                   JMP   @@CmpFail
@@FailSkipDn:      ADD   EDX,6
                   JMP   @@FindLp

@@FindDn:          MOV   ESI,EBX
                   STC
@@ProcExit:        RET
@@FindOk:          MOVZX ECX,B [EDI+1]
                   MOV   EBX,D [EDI+2]
                   CLC
                   JMP   @@ProcExit

@@regs             DB    'EAX',00,4
                   DD    OFFSET DBG_EAX
                   DB    'EBX',00,4
                   DD    OFFSET DBG_EBX
                   DB    'ECX',00,4
                   DD    OFFSET DBG_ECX
                   DB    'EDX',00,4
                   DD    OFFSET DBG_EDX
                   DB    'ESI',00,4
                   DD    OFFSET DBG_ESI
                   DB    'EDI',00,4
                   DD    OFFSET DBG_EDI
                   DB    'EBP',00,4
                   DD    OFFSET DBG_EBP
                   DB    'ESP',00,4
                   DD    OFFSET DBG_ESP
                   DB    'EIP',00,4
                   DD    OFFSET DBG_EIP
                   DB    'AX',00,2
                   DD    OFFSET DBG_AX
                   DB    'BX',00,2
                   DD    OFFSET DBG_BX
                   DB    'CX',00,2
                   DD    OFFSET DBG_CX
                   DB    'DX',00,2
                   DD    OFFSET DBG_DX
                   DB    'SI',00,2
                   DD    OFFSET DBG_SI
                   DB    'DI',00,2
                   DD    OFFSET DBG_DI
                   DB    'BP',00,2
                   DD    OFFSET DBG_BP
                   DB    'SP',00,2
                   DD    OFFSET DBG_SP
                   DB    'IP',00,2
                   DD    OFFSET DBG_IP
                   DB    'AL',00,1
                   DD    OFFSET DBG_AL
                   DB    'BL',00,1
                   DD    OFFSET DBG_BL
                   DB    'CL',00,1
                   DD    OFFSET DBG_CL
                   DB    'DL',00,1
                   DD    OFFSET DBG_DL
                   DB    'AH',00,1
                   DD    OFFSET DBG_AH
                   DB    'BH',00,1
                   DD    OFFSET DBG_BH
                   DB    'CH',00,1
                   DD    OFFSET DBG_CH
                   DB    'DH',00,1
                   DD    OFFSET DBG_DH
                   ; now flags
                   DB    'CF',00,80H+0
                   DD    OFFSET DBG_EFLAGS
                   DB    'PF',00,80H+2
                   DD    OFFSET DBG_EFLAGS
                   DB    'AF',00,80H+4
                   DD    OFFSET DBG_EFLAGS
                   DB    'ZF',00,80H+6
                   DD    OFFSET DBG_EFLAGS
                   DB    'SF',00,80H+7
                   DD    OFFSET DBG_EFLAGS
                   DB    'IF',00,80H+9
                   DD    OFFSET DBG_EFLAGS
                   DB    'DF',00,80H+10
                   DD    OFFSET DBG_EFLAGS
                   DB    'OF',00,80H+11
                   DD    OFFSET DBG_EFLAGS

                   DD    0
DBG_FindReg        ENDP

; input esi - pointer to string to parse
; output eax - value
;        esi - pointer to separator or pointer to beginning of string
DBG_SymFindByName  PROC  NEAR
                   MOV   ECX,D _symtablen
                   OR    ECX,ECX
                   JZ    @@BadExit

                   MOV   EBX,ESI

@@ItemLp:          MOV   ESI,EBX
                   MOV   EDI,ECX
                   DEC   EDI
                   SHL   EDI,5
                   ADD   EDI,D _symtable
                   ADD   EDI,4

@@CmpLp:           MOV   AL,[ESI]
                   OR    AL,AL
                   JZ    @@CpEnd
                   IsIn  AL,Separators
                   JZ    @@CpEnd
                   CMP   AL,[EDI]
                   JNZ   @@CmpFail
                   INC   ESI
                   INC   EDI
                   JMP   @@CmpLp
@@CpEnd:           CMP   B[EDI],0
                   JZ    @@Found
@@CmpFail:         LOOP  @@ItemLp
                   MOV   ESI,EBX
                   JMP   @@BadExit

@@Found:           MOV   EDI,ECX
                   DEC   EDI
                   SHL   EDI,5
                   ADD   EDI,D _symtable
                   MOV   EAX,D [EDI]

@@GoodExit:        CLC
@@ProcExit:        RET
@@BadExit:         STC
                   JMP   @@ProcExit
DBG_SymFindByName  ENDP

regsym_            PROC  NEAR
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX
                   PUSH  ESI
                   PUSH  EDI
                   PUSH  EBP

                   PUSH  EAX
                   MOV   ESI,[EAX]
                   CALL  DBG_FindReg
                   JC    @@maybesym
                   CMP   ECX,1
                   JNZ   @@s1
                   MOVZX EAX,B [EBX]
                   JMP   @@regdone
@@s1:              CMP   ECX,2
                   JNZ   @@s2
                   MOVZX EAX,W [EBX]
                   JMP   @@regdone
@@s2:              MOV   EAX,D [EBX]
@@regdone:
                   POP   EBX
                   MOV   [EBX],ESI
                   JMP   @@druut

@@maybesym:        POP   EAX
                   PUSH  EAX
                   MOV   ESI,[EAX]
                   CALL  DBG_SymFindByName
                   JC    @@dup
                   POP   EBX
                   MOV   [EBX],ESI
                   JMP   @@druut

@@dup:             ADD   ESP,4
                   MOV   _experr,1
                   CLR   EAX
@@druut:           POP   EBP
                   POP   EDI
                   POP   ESI
                   POP   EDX
                   POP   ECX
                   POP   EBX
                   RET
regsym_            ENDP

Include exp.inc
comment #
 input:
  ESI - pointer to string
 output:
  EAX - value
  ESI - points after expression
  CF - error flag
#

DBG_Expression     PROC  NEAR
                   CALL  DBG_KillWhities ; get rid of spaces
                   CMP   B[ESI],0
                   JZ    @@badexit
                   MOV   EDI,ESI
@@spacelp:         CMP   B [EDI],' '
                   JZ    @@space
                   CMP   B [EDI],0
                   JZ    @@eos
                   INC   EDI
                   JMP   @@spacelp
@@eos:             INC   EDI
                   MOV   B [EDI],0
                   JMP   @@goforit
@@space:           MOV   B[EDI],0
                   INC   EDI
@@goforit:         MOV   EAX,ESI
                   PUSH  EDI
                   CALL  expression_
                   POP   ESI
                   CMP   _experr,0
                   JNZ   @@badexit
                   CLC
@@druut:
                   RET
@@badexit:         STC
                   JMP  @@druut
DBG_Expression     ENDP

DBG_Error          PROC  NEAR
                   MOV   ESI,OFFSET @@EMSG
                   CALL  DBG_OutString
                   RET
@@EMSG             DB    'invalid command or parameters',0DH,0AH,00H
DBG_Error          ENDP

DBG_GO             PROC  NEAR
                   CALL  DBG_Expression
                   JC    @@NoBrkPt
                   CALL  DBG_AddBrkPt
@@NoBrkPt:         CALL  DBG_RestBrk
                   CALL  DBG_Leave
                   DBG_Resume

                   RET
DBG_GO             ENDP

DBG_Echo           PROC  NEAR
                   CALL  DBG_Expression
                   JC    DBG_Error
                   DBG_SayDec EAX,0FH
                   DBG_Say ' $',0FH
                   DBG_SayValue EAX,0FH
                   DBG_Say '  '
                   MOV   ECX,4
@@Lp:              CMP   AL,0DH
                   JNZ   @@S1
                   MOV   AL,' '
@@S1:              CMP   AL,0AH
                   JNZ   @@S2
                   MOV   AL,' '
@@S2:              CALL  DBG_OutChar
                   ROR   EAX,8
                   LOOP  @@Lp
                   DBG_NewLine
                   RET
DBG_Echo           ENDP

DBG_UnAsmPtr       DD    ?

DBG_UnAsmLine      PROC  NEAR
                   MOV   @@UnAsmFrom,EAX
                   MOV   EAX,DBG_Cursor
                   MOV   @@StoreCursor,EAX
                   MOV   DBG_TextAttr,0CH
                   MOV   EAX,@@UnAsmFrom
                   CALL  symfind_
                   OR    EAX,EAX
                   JZ    @@NoSymInLine
                   MOV   ESI,EAX
                   CALL  DBG_OutString
                   MOV   AL,':'
                   CALL  DBG_OutChar
                   DBG_NewLine
                   MOV   EAX,DBG_Cursor
                   MOV   @@StoreCursor,EAX
@@NoSymInLine:
                   MOV   DBG_TextAttr,0AH
                   MOV   EAX,@@UnAsmFrom
                   CALL  DBG_OutHLong
                   MOV   AL,':'
                   CALL  DBG_OutChar
                   MOV   DBG_TextAttr,07H

                   MOV   EAX,@@UnAsmFrom
                   MOV   EDX,OFFSET @@UnAsmLen
                   CALL  disassemble_
                   PUSH  EAX
                   MOV   ESI,@@UnAsmFrom
                   MOV   ECX,@@UnAsmLen
@@DumpNext:        MOV   AL,[ESI]
                   INC   ESI
                   CALL  DBG_OutHByte
                   ;MOV   AL,' '
                   ;CALL  DBG_OutChar
                   XOR   DBG_TextAttr,08H
                   LOOP  @@DumpNext
                   MOV   DBG_TextAttr,07H
                   MOV   EAX,@@StoreCursor
                   ADD   EAX,35*2
                   MOV   DBG_Cursor,EAX
                   POP   ESI
                   MOV   DBG_TextAttr,07H
                   CALL  DBG_OutString
                   MOV   DBG_TextAttr,07H
                   MOV   ESI,@@UnAsmFrom
                   CMP   B [ESI],0E8H  ; call near
                   JZ    @@CallFound
                   CMP   B [ESI],0E9H  ; jump near
                   JNZ   @@NoJump
@@CallFound:       MOV   EAX,D [ESI+1]
                   LEA   EAX,[EAX+ESI+5]
                   CMP   EAX,OFFSET KernelEnd
                   JA    @@NoJump
                   DBG_Say '(kernel?)',0EH
@@NoJump:
                   DBG_NewLine
                   MOV   EAX,@@UnAsmFrom
                   ADD   EAX,@@UnAsmLen
                   RET
@@UnAsmFrom        DD    ?
@@StoreCursor      DD    ?
@@UnAsmLen         DD    ?
DBG_UnAsmLine      ENDP

DBG_UnAsm          PROC  NEAR
                   MOV   EAX,DBG_UnAsmPtr
                   MOV   @@DefaultFrom,EAX
                   MOV   @@DefaultLines,16
                   CALL  DBG_Expression
                   JC    @@UseDefaults
                   MOV   @@DefaultFrom,EAX
                   CALL  DBG_Expression
                   JC    @@UseDefaults
                   CMP   EAX,1000
                   JA    @@UseDefaults
                   CMP   EAX,0
                   JZ    @@UseDefaults
                   MOV   @@DefaultLines,EAX
@@UseDefaults:     MOV   EAX,@@DefaultFrom
                   CALL  DBG_UnAsmLine
                   MOV   @@DefaultFrom,EAX
                   DEC   @@DefaultLines
                   JNZ   @@UseDefaults
                   MOV   EAX,@@DefaultFrom
                   MOV   DBG_UnAsmPtr,EAX
                   RET
@@DefaultFrom      DD   ?
@@DefaultLines     DD   ?
DBG_UnAsm          ENDP

DBG_Regs           PROC  NEAR
                   DBG_Say 'EFLAGS: '
                   DBG_SayValue DBG_EFLAGS,0FH

                   DBG_Say ' C:'
                   TEST  DBG_EFLAGS,1
                   DBG_SayZ 0FH
                   DBG_Say ' P:'
                   TEST  DBG_EFLAGS,4
                   DBG_SayZ 0FH
                   DBG_Say ' A:'
                   TEST  DBG_EFLAGS,16
                   DBG_SayZ 0FH
                   DBG_Say ' Z:'
                   TEST  DBG_EFLAGS,64
                   DBG_SayZ 0FH
                   DBG_Say ' S:'
                   TEST  DBG_EFLAGS,128
                   DBG_SayZ 0FH
                   DBG_Say ' I:'
                   TEST  DBG_EFLAGS,128*4
                   DBG_SayZ 0FH
                   DBG_Say ' D:'
                   TEST  DBG_EFLAGS,128*4*2
                   DBG_SayZ 0FH
                   DBG_Say ' O:'
                   TEST  DBG_EFLAGS,128*4*2*2
                   DBG_SayZ 0FH

                   DBG_Say '   EIP: '
                   DBG_SayValue DBG_EIP,0FH
                   DBG_NewLine

                   DBG_Say 'EAX: '
                   DBG_SayValue DBG_EAX,0FH
                   DBG_Say '  EBX: '
                   DBG_SayValue DBG_EBX,0FH
                   DBG_Say '  ECX: '
                   DBG_SayValue DBG_ECX,0FH
                   DBG_Say '  EDX: '
                   DBG_SayValue DBG_EDX,0FH
                   DBG_NewLine

                   DBG_Say 'ESI: '
                   DBG_SayValue DBG_ESI,0FH
                   DBG_Say '  EDI: '
                   DBG_SayValue DBG_EDI,0FH
                   DBG_Say '  EBP: '
                   DBG_SayValue DBG_EBP,0FH
                   DBG_Say '  ESP: '
                   DBG_SayValue DBG_ESP,0FH
                   DBG_NewLine

                   RET
DBG_Regs           ENDP

DBG_DumpPtr        DD   0

DBG_DumpChars      PROC  NEAR
                   ; from esi
                   PUSH  EAX
                   PUSH  ECX
                   PUSH  ESI
                   MOV   ECX,16
                   CLD
@@Here:            LODSB
                   CMP   AL,0DH
                   JZ    @@Kropa
                   CMP   AL,0AH
                   JZ    @@Kropa
                   JMP   @@OminKrope
@@Kropa:           MOV   AL,'.'
@@OminKrope:       CALL  DBG_OutChar
                   LOOP  @@Here
                   POP   ESI
                   POP   ECX
                   POP   EAX
                   RET
DBG_DumpChars      ENDP

DBG_DumpAd         PROC  NEAR
                   MOV   DBG_TextAttr,0AH
                   CALL  DBG_OutHLong
                   MOV   AL,':'
                   CALL  DBG_OutChar
                   MOV   DBG_TextAttr,07
                   MOV   AL,' '
                   CALL  DBG_OutChar
                   RET
DBG_DumpAd         ENDP

DBG_DumpDLine      PROC  NEAR
                   ; from esi
                   MOV   EAX,ESI
                   CALL  DBG_DumpAd

                   REPT  4
                   MOV   EAX,[ESI]
                   ADD   ESI,4
                   CALL  DBG_OutHLong
                   MOV   AL,' '
                   CALL  DBG_OutChar
                   ENDM

                   SUB   ESI,16
                   CALL  DBG_DumpChars
                   ADD   ESI,16

                   DBG_NewLine
                   RET
DBG_DumpDLine      ENDP

DBG_DumpWLine      PROC  NEAR
                   ; from esi
                   MOV   EAX,ESI
                   CALL  DBG_DumpAd

                   REPT  8
                   MOV   AX,[ESI]
                   ADD   ESI,2
                   CALL  DBG_OutHWord
                   MOV   AL,' '
                   CALL  DBG_OutChar
                   ENDM

                   SUB   ESI,16
                   CALL  DBG_DumpChars
                   ADD   ESI,16

                   DBG_NewLine
                   RET
DBG_DumpWLine      ENDP

DBG_DumpBLine      PROC  NEAR
                   ; from esi
                   MOV   EAX,ESI
                   CALL  DBG_DumpAd

                   REPT  16
                   MOV   AL,[ESI]
                   ADD   ESI,1
                   CALL  DBG_OutHByte
                   MOV   AL,' '
                   CALL  DBG_OutChar
                   ENDM

                   SUB   ESI,16
                   CALL  DBG_DumpChars
                   ADD   ESI,16

                   DBG_NewLine
                   RET
DBG_DumpBLine      ENDP

DBG_DumpD          PROC  NEAR
                   MOV   EAX,DBG_DumpPtr
                   MOV   @@DefaultFrom,EAX
                   MOV   @@DefaultLines,16
                   CALL  DBG_Expression
                   JC    @@UseDefaults
                   MOV   @@DefaultFrom,EAX
                   CALL  DBG_Expression
                   JC    @@UseDefaults
                   CMP   EAX,1000
                   JA    @@UseDefaults
                   OR    EAX,EAX
                   JZ    @@UseDefaults
                   MOV   @@DefaultLines,EAX

@@UseDefaults:     MOV   ESI,@@DefaultFrom
                   CALL  DBG_DumpDLine
                   MOV   @@DefaultFrom,ESI
                   DEC   @@DefaultLines
                   JNZ   @@UseDefaults
                   MOV   EAX,@@DefaultFrom
                   MOV   DBG_DumpPtr,EAX
                   RET
@@DefaultFrom      DD    ?
@@DefaultLines     DD    ?
DBG_DumpD          ENDP

DBG_DumpW          PROC  NEAR
                   MOV   EAX,DBG_DumpPtr
                   MOV   @@DefaultFrom,EAX
                   MOV   @@DefaultLines,16
                   CALL  DBG_Expression
                   JC    @@UseDefaults
                   MOV   @@DefaultFrom,EAX
                   CALL  DBG_Expression
                   JC    @@UseDefaults
                   CMP   EAX,1000
                   JA    @@UseDefaults
                   OR    EAX,EAX
                   JZ    @@UseDefaults
                   MOV   @@DefaultLines,EAX

@@UseDefaults:     MOV   ESI,@@DefaultFrom
                   CALL  DBG_DumpWLine
                   MOV   @@DefaultFrom,ESI
                   DEC   @@DefaultLines
                   JNZ   @@UseDefaults
                   MOV   EAX,@@DefaultFrom
                   MOV   DBG_DumpPtr,EAX
                   RET
@@DefaultFrom      DD    ?
@@DefaultLines     DD    ?
DBG_DumpW          ENDP

DBG_DumpB          PROC  NEAR
                   MOV   EAX,DBG_DumpPtr
                   MOV   @@DefaultFrom,EAX
                   MOV   @@DefaultLines,16
                   CALL  DBG_Expression
                   JC    @@UseDefaults
                   MOV   @@DefaultFrom,EAX
                   CALL  DBG_Expression
                   JC    @@UseDefaults
                   CMP   EAX,1000
                   JA    @@UseDefaults
                   OR    EAX,EAX
                   JZ    @@UseDefaults
                   MOV   @@DefaultLines,EAX

@@UseDefaults:     MOV   ESI,@@DefaultFrom
                   CALL  DBG_DumpBLine
                   MOV   @@DefaultFrom,ESI
                   DEC   @@DefaultLines
                   JNZ   @@UseDefaults
                   MOV   EAX,@@DefaultFrom
                   MOV   DBG_DumpPtr,EAX
                   RET
@@DefaultFrom      DD    ?
@@DefaultLines     DD    ?
DBG_DumpB          ENDP

DBG_Watch          PROC  NEAR
                   MOV   ECX,8
                   MOV   EBX,OFFSET Watches
@@Here:            CMP   [EBX.WPS_Type],WPS_Empty
                   JZ    @@Next
                   MOV   ESI,[EBX.WPS_Addy]
                   CMP   [EBX.WPS_Type],WPS_Byte
                   JNZ   @@Skip1
                   CALL  DBG_DumpBLine
                   JMP   @@Next
@@Skip1:           CMP   [EBX.WPS_Type],WPS_Word
                   JNZ   @@Skip2
                   CALL  DBG_DumpWLine
                   JMP   @@Next
@@Skip2:           CMP   [EBX.WPS_Type],WPS_Long
                   JNZ   @@Skip3
                   CALL  DBG_DumpDLine
                   JMP   @@Next
@@Skip3:
@@Next:            ADD   EBX,Size WtPtStruc
                   LOOP  @@Here
                   RET
DBG_Watch          ENDP

DBG_AddWD          PROC  NEAR
                   CALL  DBG_Expression
                   JC    DBG_Error
                   MOV   EBX,OFFSET Watches
                   MOV   ECX,8
@@Here:            CMP   [EBX.WPS_Type],WPS_Empty
                   JZ    @@Found
                   ADD   EBX,Size WtPtStruc
                   LOOP  @@Here
                   DBG_SayLn 'No empty watch slot found!'
                   RET
@@Found:           MOV   [EBX.WPS_Type],WPS_Long
                   MOV   [EBX.WPS_Addy],EAX
                   RET
DBG_AddWD          ENDP

DBG_AddWW          PROC  NEAR
                   CALL  DBG_Expression
                   JC    DBG_Error
                   MOV   EBX,OFFSET Watches
                   MOV   ECX,8
@@Here:            CMP   [EBX.WPS_Type],WPS_Empty
                   JZ    @@Found
                   ADD   EBX,Size WtPtStruc
                   LOOP  @@Here
                   DBG_SayLn 'No empty watch slot found!'
                   RET
@@Found:           MOV   [EBX.WPS_Type],WPS_Word
                   MOV   [EBX.WPS_Addy],EAX
                   RET
DBG_AddWW          ENDP

DBG_AddWB          PROC  NEAR
                   CALL  DBG_Expression
                   JC    DBG_Error
                   MOV   EBX,OFFSET Watches
                   MOV   ECX,8
@@Here:            CMP   [EBX.WPS_Type],WPS_Empty
                   JZ    @@Found
                   ADD   EBX,Size WtPtStruc
                   LOOP  @@Here
                   DBG_SayLn 'No empty watch slot found!'
                   RET
@@Found:           MOV   [EBX.WPS_Type],WPS_Byte
                   MOV   [EBX.WPS_Addy],EAX
                   RET
DBG_AddWB          ENDP

DBG_DelW           PROC  NEAR
                   CALL  DBG_Expression
                   JC    DBG_Error
                   MOV   EBX,OFFSET Watches
                   MOV   ECX,8
@@Here:            CMP   [EBX.WPS_Type],WPS_Empty
                   JZ    @@Next
                   CMP   [EBX.WPS_Addy],EAX
                   JNZ   @@Next
                   MOV   [EBX.WPS_Type],WPS_Empty
                   DBG_SayLn 'watchpoint removed!'
@@Next:            ADD   EBX,Size WtPtStruc
                   LOOP  @@Here
                   RET
DBG_DelW           ENDP

DBG_HelpData       LABEL BYTE
DB 'Kernel monitor v0.21 (c) Technomancer 1994',0DH,0AH
DB 'bye | system - exit to dos ',0DH,0AH
DB 'step | F8 - single step (int3)',0DH,0AH
DB 'trace | F7 - trace into (int1)',0DH,0AH
DB 'go [addy] - continue (and set brkpt at addy)',0DH,0AH
DB 'watch | F4 - see watches    addw{ d | w | b } addy - add watch ',0DH,0AH
DB 'delw addy - kill watch',0DH,0AH
DB 'regs - see registers    reg regname value - change reg contents ',0DH,0AH
DB 'dump{ | d | w | b } [addy] [lines]  - dump memory ',0DH,0AH
DB 'unasm [addy] [lines] - unassemble ',0DH,0AH
DB 'addbrk addy - set breakpoint    delbrk addy - delete breakpoint ',0DH,0AH
DB 'seebrk - see breakpoints ',0DH,0AH
DB 'sane - reset screen to text mode  cls ',0DH,0AH
DB 'heap - display heap info  symload filename - load symbols ',0DH,0AH
DB 00H

DBG_Help           PROC  NEAR
                   MOV   ESI,OFFSET DBG_HelpData
                   CALL  DBG_OutString
                   RET
DBG_Help           ENDP

DBG_AddBrk         PROC  NEAR
                   CALL  DBG_Expression
                   JC    DBG_Error
                   CALL  DBG_AddBrkPt
                   RET
DBG_AddBrk         ENDP

DBG_DelBrk         PROC  NEAR
                   CALL  DBG_Expression
                   JC    DBG_Error
                   MOV   ESI,OFFSET BreakPoints
                   MOV   ECX,8
@@RemoveLoop:      CMP   [ESI.BPS_Addy],EAX
                   JNZ   @@Skip
                   MOV   BL,[ESI.BPS_Save]
                   MOV   [EAX],BL
                   MOV   [ESI.BPS_Addy],-1
                   DBG_SayLn 'Breakpoint removed!'
                   JMP   @@ProcExit
@@Skip:            ADD   ESI,Size BrkPtStruc
                   LOOP  @@RemoveLoop
@@ProcExit:        RET
DBG_DelBrk         ENDP

DBG_SeeBrk         PROC  NEAR
                   MOV   ESI,OFFSET BreakPoints
                   MOV   ECX,8
@@Here:            CMP   [ESI.BPS_Addy],-1
                   JZ    @@Next
                   MOV   EAX,[ESI.BPS_Addy]
                   PUSH  ECX
                   PUSH  ESI
                   CALL  DBG_UnAsmLine
                   POP   ESI
                   POP   ECX
@@Next:            ADD   ESI,Size BrkPtStruc
                   LOOP  @@Here
                   RET
DBG_SeeBrk         ENDP

DBG_StrTok         PROC  NEAR
                   MOV   AL,[ESI]
                   OR    AL,AL
                   JZ    @@Done
                   CMP   AL,' '
                   JNZ   @@CpLp
                   INC   ESI
                   JMP   DBG_StrTok

@@CpLp:            MOV   AL,[ESI]
                   OR    AL,AL
                   JZ    @@Done
                   CMP   AL,' '
                   JZ    @@Done
                   MOV   [EDI],AL
                   INC   ESI
                   INC   EDI
                   JMP   @@CpLp

@@Done:            MOV   B [EDI],0
                   RET
DBG_StrTok         ENDP

DBG_RegMod         PROC  NEAR
; 1. get token
                   MOV   EDI,OFFSET @@regtomod
                   CALL  DBG_StrTok
                   PUSH  ESI ; store current pos for a while
                   MOV   ESI,OFFSET @@regtomod
                   CALL  DBG_FindReg
                   POP   ESI
                   JNC   @@RegOK
                   JMP   DBG_Error
@@RegOK:           PUSH  EBX
                   PUSH  ECX
                   CALL  DBG_Expression
                   POP   ECX
                   POP   ESI
                   JC    DBG_Error
                   DBG_SayValue EAX
                   TEST  CL,80H
                   JZ    @@NotFlag
                   AND   CL,01111111B
                   PUSH  ECX
                   AND   EAX,1
                   SHL   EAX,CL
                   POP   ECX
                   MOV   EBX,-2
                   ROL   EBX,CL
                   AND   D[ESI],EBX
                   OR    D[ESI],EAX
                   JMP   @@ProcExit
@@NotFlag:         MOV   [ESI],AL
                   SHR   EAX,8
                   INC   ESI
                   LOOP  @@NotFlag

@@ProcExit:        DBG_NewLine
                   RET

@@regtomod         DB    64D DUP(0)
DBG_RegMod         ENDP

DBG_Shit           PROC  NEAR
                   DBG_SayLn 'Too bad you mother cant hear this !'
                   RET
DBG_Shit           ENDP

DBG_Fuck           PROC  NEAR
                   DBG_SayLn 'Same to you dude !'
                   RET
DBG_Fuck           ENDP

DBG_Sane           PROC  NEAR
                   CALL  DBG_SetScreen
                   CALL  DBG_CLS
                   RET
DBG_Sane           ENDP

DBG_HeapInfo       PROC  NEAR
                   DBG_SayLn 'Heap information'
                   DBG_SayLn 'Heap ORG      END      FreePtr  Free'
                   DBG_Say   'Low  '
                   DBG_SayValue LoHeapOrg,0FH
                   DBG_Say   ' '
                   DBG_SayValue LoHeapEnd,0FH
                   DBG_Say   ' '
                   DBG_SayValue LoFreeList,0FH
                   DBG_Say   ' '
                   CALL Lo_MaxAvail
                   DBG_SayValue EAX
                   DBG_NewLine
                   DBG_Say   'High '
                   DBG_SayValue HiHeapOrg,0FH
                   DBG_Say   ' '
                   DBG_SayValue HiHeapEnd,0FH
                   DBG_Say   ' '
                   DBG_SayValue HiFreeList,0FH
                   DBG_Say   ' '
                   CALL Hi_MaxAvail
                   DBG_SayValue EAX
                   DBG_NewLine
                   CMP  PagingOn,True
                   DBG_SayLn 'Paging is ON',0FH
                   DBG_Say   'Page dir at '
                   MOV   EAX,PageDirBase
                   SUB   EAX,Code32Base
                   DBG_SayValue EAX,0AH
                   DBG_NewLine
                   DBG_Say   '0th page at '
                   MOV   EAX,Page1stBase
                   SUB   EAX,Code32Base
                   DBG_SayValue EAX,0AH
                   DBG_NewLine
                   DBG_Say   'Extra page at '
                   MOV   EAX,PageExtraBase
                   SUB   EAX,Code32Base
                   DBG_SayValue EAX,0AH
                   DBG_NewLine
@@NoPaging:
                   RET
DBG_HeapInfo       ENDP

__textbuf          DB    256D DUP(0)
__tbptr            DD    0
__tblen            DD    0
__thandle          DD    0

TextOpen           PROC  NEAR
                   CALL  FileOpen
                   MOV   __thandle,EAX
                   MOV   __tbptr,256
                   RET
TextOpen           ENDP

TextClose          PROC  NEAR
                   MOV   EBX,__thandle
                   CALL  FileClose
                   RET
TextClose          ENDP

TextGet            PROC  NEAR
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX
                   MOV   EAX,__tbptr
                   CMP   EAX,__tblen
                   JL    @@skipread
                   MOV   EDX,OFFSET __textbuf
                   MOV   ECX,256
                   MOV   EBX,__thandle
                   CALL  FileRead
                   MOV   __tblen,EAX
                   MOV   __tbptr,0
@@skipread:        MOV   EAX,__tbptr
                   CMP   EAX,__tblen
                   JAE   @@eof
                   MOVZX EAX,B __textbuf[EAX]
                   INC   __tbptr
                   JMP   @@ProcExit
@@eof:             MOV   EAX,26 ; ctrl z
@@ProcExit:        POP   EDX
                   POP   ECX
                   POP   EBX
                   RET
TextGet            ENDP

TextPreFetch       PROC  NEAR
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX
                   MOV   EAX,__tbptr
                   CMP   EAX,__tblen
                   JL    @@skipread
                   MOV   EDX,OFFSET __textbuf
                   MOV   ECX,256
                   MOV   EBX,__thandle
                   CALL  FileRead
                   MOV   __tblen,EAX
                   MOV   __tbptr,0
@@skipread:        MOV   EAX,__tbptr
                   CMP   EAX,__tblen
                   JAE   @@eof
                   MOVZX EAX,B __textbuf[EAX]
                   JMP   @@ProcExit
@@eof:             MOV   EAX,26 ; ctrl z
@@ProcExit:        POP   EDX
                   POP   ECX
                   POP   EBX
                   RET
TextPreFetch       ENDP

TextGetString      PROC  NEAR
                   PUSH  EDX
@@CharLoop:        CALL  TextGet
                   CMP   AL,26
                   JZ    @@ProcExit
                   CMP   AL,0DH
                   JZ    @@Caret
                   MOV   [EDX],AL
                   INC   EDX
                   JMP   @@CharLoop
@@Caret:           CALL  TextPreFetch
                   CMP   AL,0AH
                   JNZ   @@ProcExit
                   CALL  TextGet
@@ProcExit:        MOV   B [EDX],0
                   POP   EDX
                   RET
TextGetString      ENDP

StrSkip            PROC  NEAR
                   MOV   AH,AL
@@CharLoop:        MOV   AL,[ESI]
                   INC   ESI
                   CMP   AL,AH
                   JZ    @@CharLoop
                   DEC   ESI
                   MOV   AL,AH
                   RET
StrSkip            ENDP

WeirdStrCmp        PROC  NEAR
                   MOV   AL,[EBX]
                   INC   EBX
                   OR    AL,AL
                   JZ    @@Equal
                   MOV   AH,[ESI]
                   INC   ESI
                   CMP   AL,AH
                   JZ    WeirdStrCmp
                   STC
                   RET
@@Equal:           CLC
                   RET
WeirdStrCmp        ENDP

GetHex             PROC  NEAR
                   XOR   EAX,EAX
@@NextChar:        MOV   BL,B [ESI]
                   CMP   BL,'0'
                   JB    @@ProcExit
                   CMP   BL,'9'
                   JBE   @@zeronine
                   CMP   BL,'A'
                   JB    @@ProcExit
                   CMP   BL,'F'
                   JBE   @@af1
                   CMP   BL,'a'
                   JB    @@ProcExit
                   CMP   BL,'f'
                   JBE   @@af2
                   JMP   @@ProcExit

@@zeronine:        SUB   BL,'0'
@@common:          SHL   EAX,4
                   OR    AL,BL
                   INC   ESI
                   JMP   @@NextChar
@@af1:             SUB   BL,'A'
                   ADD   BL,10
                   JMP   @@common
@@af2:             SUB   BL,'a'
                   ADD   BL,10
                   JMP   @@common
@@ProcExit:
                   RET
GetHex             ENDP

SymLoad            PROC  NEAR
                   MOV   EAX,D _symtable
                   OR    EAX,EAX
                   JZ    @@SkipFree
                   CALL  free
@@SkipFree:
                   MOV   D _symtablen,0
                   MOV   EAX,4096*32
                   CALL  malloc
                   MOV   D _symtable,EAX
                   OR    EAX,EAX
                   JZ    @@ProcExit
                   CALL  TextOpen
                   JC    @@TooBad

@@skipper:         MOV   EDX,OFFSET @@str
                   CALL  TextGetString
                   CMP   B [EDX],0
                   JZ    @@skipper

                   MOV   ESI,OFFSET @@str
                   MOV   AL,' '
                   CALL  StrSkip
                   MOV   EBX,OFFSET @@tex2find0
                   CALL  WeirdStrCmp
                   JC    @@skipper
                   MOV   AL,' '
                   CALL  StrSkip
                   MOV   EBX,OFFSET @@tex2find
                   CALL  WeirdStrCmp
                   JC    @@skipper
                   ; now we found line "Address     Publics by Name"
                   MOV   EDX,OFFSET @@str
                   CALL  TextGetString ; skip one line

@@NextItem:        MOV   EDX,OFFSET @@str
                   CALL  TextGetString
                   CMP   B [EDX],0
                   JZ    @@TabDone
                   MOV   ESI,OFFSET @@str
                   MOV   AL,' '
                   CALL  StrSkip
                   CALL  GetHex
                   MOV   AL,':'
                   CALL  StrSkip
                   MOV   EDI,D _symtablen
                   SHL   EDI,5
                   ADD   EDI,D _symtable
                   CALL  GetHex
                   MOV   [EDI],EAX
                   ADD   EDI,4
                   ADD   ESI,7
@@Cop:             MOV   AL,[ESI]
                   MOV   [EDI],AL
                   INC   ESI
                   INC   EDI
                   OR    AL,AL
                   JNZ   @@Cop
                   INC   D _symtablen
                   JMP   @@NextItem
@@TabDone:
                   CALL  TextClose
                   CLC
@@ProcExit:
                   RET
@@TooBad:          STC
                   JMP   @@ProcExit

@@str              DD    512D DUP(0)
@@tex2find0        DB    'Address',0
@@tex2find         DB    'Publics by Name',0
SymLoad            ENDP

DBG_SymLoad        PROC  NEAR
                   MOV   EDI,OFFSET @@symname
                   CALL  DBG_StrTok
                   MOV   EDX,OFFSET @@symname
                   CALL  SymLoad
                   JC    @@Bad
                   MOV   EAX,D _symtablen
                   CALL  DBG_OutHLong
                   DBG_SayLn ' symbols have been loaded.'
                   JMP   @@ProcExit

@@Bad:             DBG_SayLn 'Symbols haven''t been loaded.'
@@ProcExit:
                   RET
@@symname          DB    32D DUP(0)
DBG_SymLoad        ENDP

DBG_Load           PROC  NEAR
                   MOV   EDI,OFFSET @@ldname
                   CALL  DBG_StrTok
                   CMP   B @@ldname,0
                   JZ    @@druut
                   CALL  DBG_Expression
                   JC    @@druut
                   PUSH  EAX
                   MOV   EDX,OFFSET @@ldname
                   CALL  FileOpen
                   JC    @@druut
                   MOV   EBX,EAX
                   PUSH  EBX
                   CALL  DBG_Expression
                   POP   EBX
                   JNC   @@LenOk
                   CALL  FileSize
@@LenOk:           POP   EDX
                   MOV   ECX,EAX
                   CALL  FileRead
                   DBG_SayValue EAX,0FH
                   DBG_SayLn ' bytes loaded.'
                   CALL  FileClose

@@druut:
                   RET
@@ldname           DB    128D DUP(0)
DBG_Load           ENDP

DBG_Save           PROC  NEAR
                   MOV   EDI,OFFSET @@ldname
                   CALL  DBG_StrTok
                   CMP   B @@ldname,0
                   JZ    @@druut
                   CALL  DBG_Expression
                   JC    @@druut
                   PUSH  EAX
                   CALL  DBG_Expression
                   POP   EDX
                   JC    @@druut
                   PUSH  EDX
                   PUSH  EAX

                   MOV   EDX,OFFSET @@ldname
                   CALL  FileCreate
                   POP   ECX
                   POP   EDX
                   JC    @@druut
                   MOV   EBX,EAX
                   CALL  FileWrite
                   DBG_SayValue EAX,0FH
                   DBG_SayLn ' bytes saved.'
                   CALL  FileClose
@@druut:
                   RET
@@ldname           DB    128D DUP(0)
DBG_Save           ENDP

DBG_Key            PROC  NEAR
                   DBG_Say 'Key '
                   CALL  Dbd_Get
                   DBG_SayValue EAX,0FH
                   DBG_NewLine
                   RET
DBG_Key            ENDP

DBG_Def            PROC  NEAR
                   MOV   EDI,D _symtablen
                   OR    EDI,EDI
                   JZ    @@druut
                   SHL   EDI,5
                   ADD   EDI,D _symtable
                   MOV   EBX,EDI
                   ADD   EDI,4
                   CALL  DBG_StrTok
                   CMP   B [EBX+4],0
                   JZ    @@druut
                   PUSH  EBX
                   CALL  DBG_Expression
                   POP   EBX
                   JC    @@druut
                   MOV   D[EBX],EAX
                   INC   D _symtablen
@@druut:
                   RET
DBG_Def            ENDP

DBG_BDef           PROC  NEAR
                   MOV   EDI,D _symtablen
                   OR    EDI,EDI
                   JZ    @@druut
                   SHL   EDI,5
                   ADD   EDI,D _symtable
                   MOV   EBX,EDI
                   ADD   EDI,4
                   CALL  DBG_StrTok
                   CMP   B [EBX+4],0
                   JZ    @@druut
; search for #
@@HashLp:          CMP   B[ESI],'#'
                   JZ    @@HashFound
                   CMP   B[ESI],0
                   JZ    @@druut
                   INC   ESI
                   JMP   @@HashLp

@@HashFound:       MOV   EAX,D [ESI+1]
                   MOV   D[EBX],EAX
                   INC   D _symtablen
@@druut:
                   RET
DBG_BDef           ENDP

DBG_View           PROC  NEAR
                   MOV   @@width,320
                   CALL  DBG_Expression
                   JC    DBG_Error
                   MOV   @@vadr,EAX
                   MOV   EAX,13H
                   CALL  SetGrMode
                   CALL  DBG_Expression
                   JC    @@ForgetPal
                   MOV   ESI,EAX
                   XOR   AL,AL
                   MOV   DX,3C8H
                   OUT   DX,AL
                   MOV   ECX,768
                   INC   DX
                   REP   OUTSB
@@ForgetPal:
@@Lp:              MOV   EDX,200
                   CLD
                   MOV   ESI,@@vadr
                   MOV   EDI,SegA000
@@CpLp:            MOV   ECX,@@width
                   ADD   ECX,3
                   SHR   ECX,2
                   MOV   EBX,ECX
                   REP   MOVSD
                   SHL   EBX,2
                   SUB   EDI,EBX
                   ADD   EDI,320
                   SUB   ESI,EBX
                   ADD   ESI,@@width
                   DEC   EDX
                   JNZ   @@CpLp
@@KLp:             CALL  Dbd_Get

                   CMP   EAX,011BH ; esc
                   JZ    @@Done
                   CMP   EAX,4800H  ; up
                   JNZ   @@s1
                   MOV   EAX,@@width
                   SUB   @@vadr,EAX
                   JMP   @@Lp

@@s1:              CMP   EAX,5000H ; dn
                   JNZ   @@s2
                   MOV   EAX,@@width
                   ADD   @@vadr,EAX
                   JMP   @@Lp

@@s2:              CMP   EAX,4B00H ; lt
                   JNZ   @@s3
                   DEC   @@vadr
                   JMP   @@Lp

@@s3:              CMP   EAX,4D00H ; rt
                   JNZ   @@s4
                   INC   @@vadr
                   JMP   @@Lp

@@s4:              CMP   EAX,4E2BH
                   JNZ   @@s5
                   CMP   @@width,320
                   JE    @@KLp
                   INC   @@width
                   JMP   @@Lp

@@s5:              CMP   EAX,4A2DH
                   JNZ   @@s6
                   CMP   @@width,1
                   JE    @@KLp
                   DEC   @@width
                   JMP   @@Lp

@@s6:              JMP   @@Lp

@@Done:            JMP   DBG_Sane
                   RET
@@vadr             DD    ?
@@width            DD    320
DBG_View           ENDP

DBG_PCXHEAD        STRUC
DPH_Flag           DB    ? ; 10
DPH_Version        DB    ? ; 5
DPH_Encoding       DB    ? ; 1
DPH_BPP            DB    ? ; 8
DPH_XMin           DW    ?
DPH_YMin           DW    ?
DPH_XMax           DW    ?
DPH_YMax           DW    ?
DPH_HDPI           DW    ? ; 300
DPH_VDPI           DW    ? ; 300
DPH_Colormap       DB    48 DUP(?)
DPH_Res            DB    ?
DPH_NPlanes        DB    ? ; 1
DPH_BytesPerLine   DW    ? ; = width
DBG_PCXHEAD        ENDS

DBG_SavePCX        PROC  NEAR
                   MOV   @@width,320
                   MOV   @@height,200
                   MOV   EDI,O @@sname
                   CALL  DBG_StrTok
                   CMP   B @@sname,0
                   JZ    @@druut
                   CALL  DBG_Expression
                   JC    @@default
                   MOV   @@width,EAX
                   CALL  DBG_Expression
                   JC    @@default
                   MOV   @@height,EAX
@@default:         MOV   EAX,128*1024
                   CALL  malloc
                   JZ    @@druut
                   MOV   @@pcxspace,EAX
                   MOV   EDI,EAX
                   XOR   EAX,EAX
                   MOV   ECX,32*1024 ; clear it all
                   CLD
                   REP   STOSD
                   MOV   EDI,@@pcxspace
                   MOV   B [EDI.DPH_Flag],10
                   MOV   B [EDI.DPH_Version],5
                   MOV   B [EDI.DPH_Encoding],1
                   MOV   B [EDI.DPH_BPP],8
                   MOV   EAX,@@width
                   DEC   EAX
                   MOV   [EDI.DPH_XMax],AX
                   MOV   EAX,@@height
                   DEC   EAX
                   MOV   [EDI.DPH_YMax],AX
                   MOV   W [EDI.DPH_HDPI],300
                   MOV   W [EDI.DPH_VDPI],300
                   MOV   B [EDI.DPH_NPlanes],1
                   MOV   EAX,@@width
                   MOV   [EDI.DPH_BytesPerLine],AX
                   ADD   EDI,128
                   MOV   EAX,@@width
                   MUL   @@height
                   SHR   EAX,2
                   MOV   ECX,EAX
                   MOV   ESI,DBG_SavedScreen

@@dobyte           MACRO
                   LOCAL twobyte,druut
                   MOV   AL,[ESI]
                   MOV   AH,AL
                   AND   AL,0C0H
                   CMP   AL,0C0H
                   JZ    twobyte
                   MOV   [EDI],AH
                   INC   EDI
                   JMP   druut
twobyte:           INC   AL   ;c1
                   STOSW
druut:
                   ENDM
@@encodelp:
                   @@dobyte
                   ADD   ESI,10000H
                   @@dobyte
                   ADD   ESI,10000H
                   @@dobyte
                   ADD   ESI,10000H
                   @@dobyte
                   SUB   ESI,2FFFFH
                   LOOP  @@encodelp
; palette
                   MOV   AL,12
                   STOSB
                   MOV   ECX,768
                   MOV   ESI,O DBG_Palette
@@PalLp:           LODSB
                   SHL   AL,2
                   STOSB
                   LOOP  @@PalLp

                   MOV   EDX,O @@sname
                   CALL  FileCreate
                   JC    @@fucked
                   MOV   EBX,EAX
                   MOV   EDX,@@pcxspace
                   MOV   ECX,EDI
                   SUB   ECX,EDX
                   CALL  FileWrite
                   CALL  FileClose

@@fucked:          MOV   EAX,@@pcxspace
                   CALL  free
@@druut:
                   RET
@@sname            DB    128D DUP(0)
@@width            DD    ?
@@height           DD    ?
@@pcxspace         DD    ?
DBG_SavePCX        ENDP

DBG_System         PROC  NEAR
                   MOV   EAX,3
                   PUSH  10H
                   CALL  CallInt
                   MOV  AL,36H
                   OUT  43H,AL
                   XOR  AL,AL
                   OUT  40H,AL
                   IOWait
                   OUT  40H,AL
                   JMP   BackToReality
DBG_System         ENDP

DBG_Commands       DB    'SYSTEM '
                   DD    OFFSET DBG_System
                   DB    'BYE '
                   DD    OFFSET DBG_System
                   DB    'QUIT '
                   DD    OFFSET DBG_System
                   DB    'EXIT '
                   DD    OFFSET DBG_System
                   DB    'HELP '
                   DD    OFFSET DBG_Help
                   DB    '? '
                   DD    OFFSET DBG_Help
                   DB    'TRACE '
                   DD    OFFSET DBG_Trace
                   DB    'STEP '
                   DD    OFFSET DBG_SingleStep
                   DB    'CLS '
                   DD    OFFSET DBG_CLS
                   DB    'GO '
                   DD    OFFSET DBG_GO
                   DB    'ECHO '
                   DD    OFFSET DBG_Echo
                   DB    'UNASM '
                   DD    OFFSET DBG_UnAsm
                   DB    'U '
                   DD    OFFSET DBG_UnAsm
                   DB    'REGS '
                   DD    OFFSET DBG_Regs
                   DB    'DUMPD '
                   DD    OFFSET DBG_DumpD
                   DB    'DUMPW '
                   DD    OFFSET DBG_DumpW
                   DB    'DUMPB '
                   DD    OFFSET DBG_DumpB
                   DB    'DUMP '
                   DD    OFFSET DBG_DumpB
                   DB    'WATCH '
                   DD    OFFSET DBG_Watch
                   DB    'ADDWD '
                   DD    OFFSET DBG_AddWD
                   DB    'ADDWW '
                   DD    OFFSET DBG_AddWW
                   DB    'ADDWB '
                   DD    OFFSET DBG_AddWB
                   DB    'DELW '
                   DD    OFFSET DBG_DelW
                   DB    'ADDBRK '
                   DD    OFFSET DBG_AddBrk
                   DB    'DELBRK '
                   DD    OFFSET DBG_DelBrk
                   DB    'SEEBRK '
                   DD    OFFSET DBG_SeeBrk
                   DB    'REG '
                   DD    OFFSET DBG_RegMod
                   DB    'SHIT '
                   DD    OFFSET DBG_Shit
                   DB    'FUCK '
                   DD    OFFSET DBG_Fuck
                   DB    'SANE '
                   DD    OFFSET DBG_Sane
                   DB    'HEAP '
                   DD    OFFSET DBG_HeapInfo
                   DB    'SYMLOAD '
                   DD    OFFSET DBG_SymLoad
                   DB    'LOADSYM '
                   DD    OFFSET DBG_SymLoad
                   DB    'USER '
                   DD    OFFSET DBG_UserScreen
                   DB    'LOAD '
                   DD    OFFSET DBG_Load
                   DB    'SAVE '
                   DD    OFFSET DBG_Save
                   DB    'KEY '
                   DD    OFFSET DBG_Key
                   DB    'DEF '
                   DD    OFFSET DBG_Def
                   DB    'BDEF '        ; binary def
                   DD    OFFSET DBG_BDef
                   DB    'DEFV '        ; binary def
                   DD    OFFSET DBG_BDef
                   DB    'VIEW '
                   DD    OFFSET DBG_View
                   DB    'SAVEPCX '
                   DD    OFFSET DBG_SavePCX

                   DD    -1

DBG_SetScreen      PROC  NEAR
                   ;MOV   EAX,3
                   ;PUSH  10H
                   ;CALL  CallInt

                   MOV   AX,1202H ; set 400 lines
                   MOV   BL,30H
                   PUSH  10H
                   CALL  CallInt

                   MOV   AX,0003H ; initialize text mode
                   PUSH  10H
                   CALL  CallInt

                   MOV   AX,1111H ; load ROM 8x14 font to block 0
                   MOV   BL,0H
                   PUSH  10H
                   CALL  CallInt

                   MOV   ESI,OFFSET DBG_Screen
                   MOV   EDI,DBG_Video
                   MOV   ECX,DBG_ScreenSize*40
                   CLD
                   REP   MOVSD

                   CALL  DBG_DisplayCursor

                   RET
DBG_SetScreen      ENDP

DBG_SaveScreen     PROC  NEAR
                   MOV   EDI,OFFSET DBG_Screen
                   MOV   ESI,DBG_Video
                   MOV   ECX,DBG_ScreenSize*40
                   CLD
                   REP   MOVSD
                   RET
DBG_SaveScreen     ENDP

DBG_CLS            PROC  NEAR
                   MOV   DBG_Cursor,0
                   MOV   EDI,DBG_Video
                   MOV   ECX,40*DBG_ScreenSize
                   MOV   EAX,07200720H
                   CLD
                   REP   STOSD
                   CALL  DBG_DisplayCursor
                   RET
DBG_CLS            ENDP

DBG_Enter          PROC  NEAR
                   MOV   AL,IRQMap[1]
                   CALL  GetIntVec
                   MOV   D DBG_UserKbd,EAX
                   MOV   W DBG_UserKbd+4,BX
                   MOV   BL,IRQMap[1]
                   MOV   EAX,OFFSET Kbd_Handler
                   MOV   CX,CS
                   CALL  SetIntVec

                   MOV   DBG_InDebug,TRUE
                   CALL  DBG_VGASave
                   CALL  DBG_SetScreen
                   RET
DBG_Enter          ENDP

DBG_Leave          PROC  NEAR
                   CALL  DBG_SaveScreen
                   CALL  DBG_VGARestore
                   MOV   DBG_InDebug,FALSE

                   MOV   BL,IRQMap[1]
                   MOV   EAX,D DBG_UserKbd
                   MOV   CX,W DBG_UserKbd+4
                   CALL  SetIntVec
                   RET
DBG_Leave          ENDP

DBG_INT3           PROC  NEAR
                   DBG_SaveRegs
                   DEC   DBG_EIP
                   MOV   EAX,DBG_EIP
                   MOV   ESI,OFFSET BreakPoints
                   MOV   ECX,9
@@RemoveLoop:      CMP   [ESI.BPS_Addy],EAX
                   JNZ   @@Skip
                   MOV   BL,[ESI.BPS_Save]
                   MOV   [EAX],BL
                   MOV   [ESI.BPS_Addy],-1
                   JMP   @@ProcExit
@@Skip:            ADD   ESI,Size BrkPtStruc
                   LOOP  @@RemoveLoop
@@ProcExit:
                   CALL  DBG_Enter
                   JMP   DBG_Main
DBG_INT3           ENDP

DBG_INT1           PROC  NEAR
                   DBG_SaveRegs
                   AND   DBG_EFLAGS,0FFFFFEFFH
                   CALL  DBG_Enter
                   JMP   DBG_Main
DBG_INT1           ENDP

DBG_ParseCommand   PROC  NEAR
                   CMP   B [EAX],0
                   JZ    @@ParseFail
                   PUSH  EAX
                   MOV   EBX,EAX
@@UpCaseLoop:      MOV   AL,[EBX]
                   OR    AL,AL
                   JZ    @@UpCaseDone
                   CMP   AL,'#'
                   JNZ   @@NoHash
                   ADD   EBX,5
                   JMP   @@UpCaseLoop
@@NoHash:          CMP   AL,'a'
                   JB    @@Skip1
                   CMP   AL,'z'
                   JA    @@Skip1
                   SUB   AL,32
@@Skip1:           MOV   [EBX],AL
                   INC   EBX
                   JMP   @@UpCaseLoop
@@UpCaseDone:      POP   EDX
@@NextS:           CMP   B[EDX],' '
                   JNZ   @@NotS
                   INC   EDX
                   JMP   @@NextS
@@NotS:
                   MOV   EBX,OFFSET DBG_Commands
@@ParseMLoop:      CMP   D [EBX],-1
                   JZ    @@ParseFail
                   MOV   ESI,EDX
@@ParseNextChar:   MOV   AL,[EBX]
                   MOV   AH,[ESI]
                   OR    AH,AH
                   JNZ   @@SkipZ
                   MOV   AH,' '
@@SkipZ:           CMP   AL,AH
                   JNZ   @@ParseBad
                   INC   EBX
                   INC   ESI
                   CMP   AL,' '
                   JNZ   @@ParseNextChar
                   CMP   B [ESI-1],0
                   JNZ   @@AnyWay
                   DEC   ESI
@@AnyWay:          MOV   EAX,[EBX]
                   JMP   @@ProcExit

@@ParseBad:        CMP   B[EBX],' '
                   JZ    @@Pre
                   INC   EBX
                   JMP   @@ParseBad
@@Pre:             ADD   EBX,5
                   JMP   @@ParseMLoop

@@ParseFail:       DBG_SayLn 'What ?'
                   XOR   EAX,EAX
@@ProcExit:
                   RET
DBG_ParseCommand   ENDP

DBG_Main           PROC  NEAR
                   ; now initialize some vars

                   CALL  DBG_FukBrk
                   MOV   EAX,DBG_EIP
                   MOV   DBG_UnAsmPtr,EAX

                   CALL  DBG_Regs

                   ; debug a little one line
                   MOV   EAX,DBG_EIP
                   CALL  DBG_UnAsmLine

@@Here:            MOV   AL,'.'
                   CALL  DBG_OutChar
                   CMP   DBG_Script,0
                   JZ    @@KeyInput
                   MOV   EAX,DBG_Script
                   MOV   ESI,EAX
                   CALL  DBG_OutString
                   DBG_NewLine
@@Scan:            CMP   B [ESI],0
                   JZ    @@OK1
                   CMP   B [ESI],'#'
                   JZ    @@bytes4
                   INC   ESI
                   JMP   @@Scan
@@bytes4:          ADD   ESI,5
                   JMP   @@scan
@@OK1:             INC   ESI
                   CMP   B [ESI],0
                   JNZ   @@OK2
                   XOR   ESI,ESI
@@OK2:             MOV   DBG_Script,ESI
                   JMP   @@DoParse
@@KeyInput:
                   CALL  DBG_GetString
                   DBG_NewLine
@@DoParse:
                   CALL  DBG_ParseCommand
                   OR    EAX,EAX
                   JZ    @@Here
                   CALL  EAX
                   JMP   @@Here
                   RET
DBG_Main           ENDP

DBG_Init           PROC  NEAR
                   POP   EAX
                   PUSH  EAX
                   CALL  DBG_AddBrkPt
                   CALL  DBG_RestBrk
                   MOV   BL,01
                   MOV   EAX,O DBG_INT1
                   MOV   CX,CS
                   CALL  SetIntVec
                   MOV   BL,03
                   MOV   EAX,O DBG_INT3
                   MOV   CX,CS
                   CALL  SetIntVec
                   MOV   EAX,SegB800
                   MOV   DBG_Video,EAX
                   MOV   DBG_Cursor,00H
                   RET
DBG_Init           ENDP

DBG_Script         DD    0

DBG_InitS          PROC  NEAR
                   MOV   DBG_Script,EAX
                   JMP   DBG_Init
DBG_InitS          ENDP

DBG_Trap           PROC  NEAR
                   PUSH  EAX
                   MOV   EAX,[ESP+4]
                   PUSHAD
                   CALL  DBG_SetTrap
                   POPAD
                   POP   EAX
                   RET
DBG_Trap           ENDP
