;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; module player constants and structures
COMM_TIMERSPEED    EQU 23850

ExtendedOctaves    EQU 0
; here we define if we want extended octaves (5 instead of 3)

IFDEF ExtendedOctaves
MaxNote            EQU  1712
MinNote            EQU  57
Octaves            EQU  5
ELSE
MaxNote            EQU  856
MinNote            EQU  113
Octaves            EQU  3
ENDIF

NTSampleInfo       STRUC
                   DB  22D DUP(00H)   ; SampleName
NT_Len             DW  00H
                   DB  00H  ; HIGH BYTE OF Volume (FINE TUNE)
NT_Vol             DB  00H
NT_Repeat          DW  00H  ; START OF Repeat
NT_RepLen          DW  00H  ; Repeat Length
NTSampleInfo       EndS

SampleInfo         STRUC
SI_Addr            DD  00H  ; Beginning of sample in the memory
SI_End             DD  00H  ; length of sample (end of sample in mem)
SI_FineTune        DB  00H  ; High byte of Volume (Fine Tune)
SI_Volume          DB  00H  ; sample default volume
SI_Repeat          DD  00H  ; Start Of Repeat
SI_RepLen          DD  00H  ; Repeat Length
SampleInfo         ENDS

ChannelInfo        STRUC
CI_Pos             DD   0 ; current position in sample, for SB mixer
CI_Fraction        DB   0 ; fraction for SB mixer
CI_Addr            DD   0 ; address of sample
CI_Speed           DD   0 ; amiga period ???
CI_End             DD   0 ; actual length of sample
CI_Repeat          DD   0 ; from where to restart
CI_RepLen          DD   2 ; to test if sample should be looped
CI_InfoByte        DB   0 ; just info byte
CI_PortaSpeed      DD   0 ; speed of tone portamento
CI_PortaDest       DD   0 ; destination of tone portamento
CI_LoopDivision    DD   0 ; number of division where to loop
CI_LoopCounter     DB   0FFH ;
CI_VibPos          DB   0 ; vibrato position
CI_VibRate         DB   0 ; vibrato rate
CI_VibDepth        DB   0 ; vibrato depth
CI_TremoloCmd      DB   0 ; tremolo command
CI_TremoloPos      DB   0 ; tremolo position
CI_WaveCtrl        DB   0 ; wave used for vibrato, do we really use it ?
CI_EffectProc      DD   0 ; offset of tick effect proc
CI_Volume          DB   0 ; real volume
CI_MixVolume       DB   0 ; volume that is used by mixer
CI_AfterDivF       DB   0 ; fraction to add
CI_AfterDivM       DD   0 ; integral part to add
CI_OldSamp         DB   0 ; old sample number, used by gus routines
CI_Panning         DB   7 ; panning value, center
CI_FineTune        DB   0 ; finetune
ChannelInfo        ENDS

;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; module player variables
OldIRQ             DF   ?
ALIGN 4
IFDEF _MIXCH
MixingChannels     DD   _MIXCH
ELSE
MixingChannels     DD   4
ENDIF
ModuleChannels     DD   4
SamplesInfo        DB   64*(Size SampleInfo) DUP(0)
SampleInfoPtr      DD   O SamplesInfo
ChannelsInfo       DB   14 * (Size ChannelInfo) DUP(0)
ReStart            DB   127D ; VALUE TO ReStart FROM
SongOrder          DB   128D DUP(00H)
DefaultPanning     DB   3,12,12,3, 3,12,12,3, 3,12,12,3 ,3,12
ALIGN 4
Pattern_OFS        DD   1024   ; Position IN Pattern Current Pattern
PatternBase        DD   00H    ; Current Pattern SEGMENT ??? :)

SongLen            DB   00H  ; SIZE OF DEFINED AREA IN ORDER
Song_Position      DB   129    ; NUMBER OF CURRENT PLAYED PATTERN
Tempo              DB   06H
CounterHI          DB   1
PosJumpFlag        DB   FALSE
ModPlaying         DB   FALSE
PBreakPos          DD   0
FirstPattern       DD   0      ; Segment of First Pattern
PlaybackCallback   DD   O SB_DummyRet
PlaybackON         DB   FALSE
ArpeggioTbl        DB   15 DUP(0,1,2)

FineTuneTable      LABEL DWORD
DD 16777216 ; finetune 0 mult:    1.0000000000
DD 16898791 ; finetune 1 mult:    1.0072464120
DD 17021246 ; finetune 2 mult:    1.0145453345
DD 17144589 ; finetune 3 mult:    1.0218971480
DD 17268826 ; finetune 4 mult:    1.0293022357
DD 17393963 ; finetune 5 mult:    1.0367609838
DD 17520007 ; finetune 6 mult:    1.0442737810
DD 17646964 ; finetune 7 mult:    1.0518410191
DD 15835583 ; finetune -8 mult:    0.9438743144
DD 15950334 ; finetune -7 mult:    0.9507140165
DD 16065917 ; finetune -6 mult:    0.9576032820
DD 16182337 ; finetune -5 mult:    0.9645424699
DD 16299601 ; finetune -4 mult:    0.9715319420
DD 16417715 ; finetune -3 mult:    0.9785720627
DD 16536684 ; finetune -2 mult:    0.9856631991
DD 16656516 ; finetune -1 mult:    0.9928057207

VibratoTable LABEL BYTE
; taken directly from PT 3.0 replay
        DB 0,24,49,74,97,120,141,161
        DB 180,197,212,224,235,244,250,253
        DB 255,253,250,244,235,224,212,197
        DB 180,161,141,120,97,74,49,24

NoteTable LABEL WORD
IFDEF ExtendedOctaves
; octave 0, this is nonstandard but some protrackers use it
          DW 1712,1616,1525,1440,1357,1281,1209,1141,1077,1017, 961, 907
ENDIF
; octaves 1 - 3 taken directly from pt replay source
          DW  856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453
          DW  428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226
          DW  214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113
IFDEF ExtendedOctaves
; octave 4, same as above
          DW  107, 101,  95,  90,  85,  80,  76,  71,  67,  64,  60,  57
ENDIF

Mul10Table         DB    0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150

;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; module player common functions
IFDEF __DLL
_setes             MACRO
                   PUSH  EDX
                   GetVar EDX,RI_ES
                   MOV   W [EDX],AX
                   POP   EDX
                   ENDM
ENDIF

COMM_NoteFind      PROC  NEAR
; in AX - amiga period
; out AX - note number
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX
                   PUSH  EDI
                   PUSH  EBP

                   MOV   EDI,O NoteTable
                   XOR   EBX,EBX
                   OR    AX,AX
                   JZ    @@NoteZero

                   MOV   BP,AX      ; BP - current note
                   MOV   DI,0FFFFH  ; best result
                   XOR   CX,CX      ; best result note num

@@Here4:           MOV   AX,BP
                   SUB   AX,NoteTable[EBX*2]
                   CWD
                   XOR   AX,DX
                   SUB   AX,DX ; abs
                   CMP   DI,AX
                   JBE   @@NotBetter
                   MOV   DI,AX
                   MOV   CX,BX
@@NotBetter:
                   INC   EBX
                   CMP   EBX,Octaves * 12  ; octaves * 12 notes
                   JB    @@Here4
                   CMP   DI,0
                   JZ    @@ExactValue

                   IFDEF DEBUG
                   SayLn 'Not exact note found!'
                   Say   ' note = '
                   AND   EBP,0FFFFH
                   SayDec EBP
                   Say   ' difference = '
                   AND   EDI,0FFFFH
                   SayDec EDI
                   NewLine
                   ENDIF

@@ExactValue:      MOV   BL,CL
                   INC   BL
@@NoteZero:
                   MOVZX EAX,BL
                   POP   EBP
                   POP   EDI
                   POP   EDX
                   POP   ECX
                   POP   EBX
                   RET
COMM_NoteFind      ENDP


_DDS               STRUC
ddsRegionSize      DD    ?
ddsOffset          DD    ?
ddsSeg             DW    ?
ddsID              DW    ?
ddsAddress         DD    ?
_DDS               ENDS

DDS                DD    0
VDSFlipFlop        DD    0

COMM_AllocVDS      PROC  NEAR
                   PUSHAD
                   MOV   DDS,0
                   CMP   SystemFlag,SystemDPMI ; only under dpmi
                   JNZ   @@druut
                   TEST  B GS:[47BH],20H ; VDS avail ?
                   JZ    @@druut
                   MOV   EAX,2 * (SIZE _DDS)
                   CALL  Lo_Alloc
                   MOV   DDS,EAX
; alloc vds buffer
                   MOV   EDI,EAX
                   MOV   EAX,SB_DMAMax*2
                   MOV   [EDI.ddsRegionSize],EAX
                   MOV   D [EDI+4],0
                   MOV   D [EDI+8],0
                   MOV   D [EDI+12],0 ; clear first DDS
                   MOV   D [EDI+16],0
                   MOV   D [EDI+20],0
                   MOV   D [EDI+24],0
                   MOV   D [EDI+28],0 ; clear second dds

                   IFDEF __DLL
                   GetVar EAX,Code32Base
                   ADD   ESI,D [EAX]
                   ELSE
                   ADD   EDI,Code32Base
                   ENDIF
                   MOV   EAX,EDI
                   AND   EDI,1111B
                   SHR   EAX,4
                   IFDEF __DLL
                   _setes
                   ELSE
                   MOV   RI_ES,AX
                   ENDIF
                   CLR   EDX
                   MOV   EAX,8107H
                   REALINT 4BH
                   JNC   @@OK

                   MOV   EAX,DDS
                   MOV   ECX,2 * (SIZE _DDS)
                   CALL  Lo_Free
                   MOV   DDS,0
                   JMP   @@druut
@@OK:
; turn off dma translation
                   MOV   EAX,810BH
                   MOV   BX,CFG_SecondaryDMA
                   CMP   CFG_SoundCard,__BLASTER16
                   JZ    @@skipp
                   MOV   BX,CFG_PrimaryDMA
@@skipp:           CLR   EDX
                   REALINT 4BH

                   ;SayLn 'VDS used!'
@@druut:           POPAD
                   RET
COMM_AllocVDS      ENDP

COMM_FreeVDS       PROC  NEAR
                   CMP   DDS,0
                   JZ    @@druut
                   PUSHAD
                   MOV   EDI,DDS
                   IFDEF __DLL
                   GetVar EAX,Code32Base
                   ADD   ESI,D [EAX]
                   ELSE
                   ADD   EDI,Code32Base
                   ENDIF
                   MOV   EAX,EDI
                   AND   EDI,1111B
                   SHR   EAX,4
                   IFDEF __DLL
                   _setes
                   ELSE
                   MOV   RI_ES,AX
                   ENDIF
                   CLR   EDX
                   MOV   EAX,8108H
                   REALINT 4BH

; turn off dma translation
                   MOV   EAX,810CH
                   MOV   BX,CFG_SecondaryDMA
                   CMP   CFG_SoundCard,__BLASTER16
                   JZ    @@skipp
                   MOV   BX,CFG_PrimaryDMA
@@skipp:           CLR   EDX
                   REALINT 4BH

                   MOV   EAX,DDS
                   MOV   ECX,2 * (SIZE _DDS)
                   CALL  Lo_Free
                   MOV   DDS,0
                   POPAD
@@druut:
                   RET
COMM_FreeVDS       ENDP

COMM_DoVDS         PROC  NEAR
                   CMP   DDS,0
                   JZ    @@druut
                   PUSH  EAX
                   PUSH  ECX
                   PUSH  EDX
                   PUSH  EDI

                   MOV   EDI,DDS
                   MOV   DX,[EDI.ddsID]
                   ADD   EDI,SIZE _DDS
                   MOV   [EDI.ddsID],DX
                   INC   ECX
                   CMP   AL,4
                   JB    @@NotHigh
                   ADD   ECX,ECX
@@NotHigh:         MOV   [EDI.ddsRegionSize],ECX
                   MOV   [EDI.ddsOffset],EBX ; linear address of our buffer
                   MOV   [EDI.ddsSeg],0
                   MOV   [EDI.ddsAddress],0

                   CLR   EBX
                   MOV   ECX,VDSFlipFlop   ; buffer offset
                   IFDEF __DLL
                   GetVar EAX,Code32Base
                   ADD   ESI,D [EAX]
                   ELSE
                   ADD   EDI,Code32Base
                   ENDIF
                   MOV   EAX,EDI
                   AND   EDI,1111B      ; offset
                   SHR   EAX,4
                   IFDEF __DLL
                   _setes
                   ELSE
                   MOV   RI_ES,AX
                   ENDIF
                   CLR   EDX            ; flags
                   MOV   EAX,8109H
                   REALINT 4BH          ; copy buffer

                   MOV   EBX,DDS
                   MOV   EBX,[EBX.ddsAddress]
                   ADD   EBX,VDSFlipFlop  ; new physical buffer
                   XOR   VDSFlipFlop,SB_DMAMax ; do flip flop
                   POP   EDI
                   POP   EDX
                   POP   ECX
                   POP   EAX
@@druut:
                   RET
COMM_DoVDS         ENDP

Comment #
!COMM_DMARead
  Explanation  :
  Expects      : AL - DMA channel
                  EBX - linear address of buffer, for 16 bit dma bit 0 assumed 0
                  ECX - number of bytes/words to read from memory to device

  Returns      :
  Screwed regs :
#
COMM_DMARead       PROC  NEAR
                   CALL  COMM_DoVDS
                   PUSH  EAX
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX
                   PUSH  ESI
                   MOVZX ESI,CX
                   CMP   AL,4
                   JAE   @@go16bit

                   MOVZX ECX,AL
; mask channel
                   MOV   AL,CL
                   OR    AL,100B
                   OUT   0AH,AL
                   JmpWait
; clear flipflop
                   MOV   AL,00H
                   OUT   0CH,AL
; select channel mode
                   MOV   AL,CL
                   OR    AL,01001000B
                         ; single mode,address inc,no auto init,read,channel
                   OUT   0BH,AL
                   JmpWait
                   MOV   EDX,ECX
                   ADD   EDX,EDX
; dma offset
                   MOV   AL,BL
                   OUT   DX,AL
                   JmpWait
                   MOV   AL,BH
                   OUT   DX,AL
                   JmpWait
; dma len
                   INC   DX
                   MOV   EAX,ESI
                   OUT   DX,AL
                   JmpWait
                   MOV   AL,AH
                   OUT   DX,AL
                   JmpWait
; dma page
                   MOV   DL,@@pageslo[ECX]
                   SHR   EBX,8
                   MOV   AL,BH
                   OUT   DX,AL
                   JmpWait
; enable channel
                   MOV   AL,CL
                   OUT   0AH,AL
                   JmpWait
                   JMP   @@druut
; 16 bit dma stuff
@@go16bit:         SHR   EBX,1
                   SUB   AL,4
                   MOVZX ECX,AL
; high mask channel
                   MOV   AL,CL
                   OR    AL,100B
                   OUT   0D4H,AL
                   JmpWait
; high clear flipflop
                   MOV   AL,00H
                   OUT   0D8H,AL
; high select channel mode
                   MOV   AL,CL
                   OR    AL,01001000B
                         ; single mode,address inc,no auto init,read,channel
                   OUT   0D6H,AL
                   JmpWait
                   MOV   EDX,ECX
                   SHL   EDX,2
                   ADD   DL,0C0H
; high dma offset
                   MOV   AL,BL
                   OUT   DX,AL
                   JmpWait
                   MOV   AL,BH
                   OUT   DX,AL
                   JmpWait
; high dma len
                   INC   DX
                   INC   DX
                   MOV   EAX,ESI
                   OUT   DX,AL
                   JmpWait
                   MOV   AL,AH
                   OUT   DX,AL
                   JmpWait
; high dma page
                   MOV   DL,@@pageshi[ECX]
                   SHR   EBX,8
                   MOV   AL,BH
                   SHL   AL,1
                   OUT   DX,AL
                   JmpWait
; high enable channel
                   MOV   AL,CL
                   OUT   0D4H,AL
                   JmpWait
@@druut:           POP   ESI
                   POP   EDX
                   POP   ECX
                   POP   EBX
                   POP   EAX
                   RET
@@pageslo          DB    087H,083H,081H,082H
@@pageshi          DB    000H,08BH,089H,08AH
COMM_DMARead       ENDP

COMM_LoadModule    PROC  NEAR
                   ; input - EBP - pointer to song loaded to memory

                   MOV   EBX,EBP
                   CMP   D [EBX+438H],'.K.M' ; M.K.
                   JNZ   @@ch1
                   MOV   ModuleChannels,4
                   JMP   @@mchannels
@@ch1:             CMP   D [EBX+438H],'NHC6' ; 6CHN
                   JNZ   @@ch2
                   MOV   ModuleChannels,6
                   JMP   @@mchannels
@@ch2:             CMP   D [EBX+438H],'NHC8' ; 8CHN
                   JNZ   @@ch3
                   MOV   ModuleChannels,8
                   JMP   @@mchannels
@@ch3:             CMP   D [EBX+438H],'HC01' ; 10CH
                   JNZ   @@ch4
                   MOV   ModuleChannels,10
                   JMP   @@mchannels
@@ch4:
@@mchannels:
                   MOV   AL,[EBX+3B6H]
                   MOV   SongLen,AL
                   MOV   AL,[EBX+3B7H]
                   MOV   ReStart,AL
                   LEA   ESI,[EBX+3B8H]
                   MOV   ECX,128
                   MOV   EDI,O SongOrder
                   CLD
                   XOR   AH,AH
@@Here1:           LODSB
                   CMP   AL,AH
                   JLE   @@Skip1
                   MOV   AH,AL
@@Skip1:           STOSB
                   LOOP  @@Here1
                   INC   AH   ; number of patterns
                   MOVZX EAX,AH
                   PUSH  EAX
                   IFDEF DEBUG
                   Say   'number of patterns : '
                   SayDec EAX
                   NewLine
                   ENDIF
                   IMUL  EAX,ModuleChannels
                   SHL   EAX,6+2 ; rows * 4
                   CALL  malloc
                   MOV   FirstPattern,EAX
comment #
 now convert track
 BYTE note number
 BYTE sample number
 BYTE command
 BYTE command info byte
#
                   MOV   EDI,EAX
                   LEA   ESI,[EBP+1084] ; address of first pattern
                   POP   ECX
                   IMUL  ECX,ModuleChannels
                   SHL   ECX,6

@@ConvLp:          MOV   AX,[ESI]
                   MOV   BH,AL
                   XCHG  AL,AH
                   AND   AX,0FFFH
                   CALL  COMM_NoteFind
                   MOV   [EDI],AL

                   MOV   AX,[ESI+2]
                   MOV   BL,AL
                   SHR   BL,4
                   AND   BH,10H
                   OR    BL,BH
                   MOV   [EDI+1],BL

                   AND   AL,0FH
                   MOV   [EDI+2],AL

                   MOV   [EDI+3],AH
                   ADD   ESI,4
                   ADD   EDI,4
                   LOOP  @@ConvLp

; now lets take care of sample data
; esi actually should point at start of it

                   LEA   EDI,[EBP+20]
                   MOV   ECX,31
@@SmpLoadLp:       PUSH  ECX
                   MOV   AL,[EDI.NT_Vol]
                   MOV   AH,[EDI.NT_Vol-1] ; fine tune
                   AND   AH,0FH
                   MOVZX ECX,W [EDI.NT_Len]
                   XCHG  CL,CH
                   ADD   ECX,ECX
                   MOVZX EBX,W [EDI.NT_Repeat]
                   XCHG  BL,BH
                   ADD   EBX,EBX
                   MOVZX EDX,W [EDI.NT_RepLen]
                   XCHG  DL,DH
                   ADD   EDX,EDX
                   JNZ   @@DoAdd
                   MOV   EDX,2
@@DoAdd:           CALL  SND_AddSample
                   ADD   ESI,ECX
                   ADD   EDI,Size NTSampleInfo
                   POP   ECX
                   LOOP  @@SmpLoadLp
                   RET
COMM_LoadModule    ENDP

Align 4
TickCnt            DD    0
TotalTickCnt       DD    0
FrameCounter       DD    0
IRQ0_OldHandler    DF    ?
OverFlowCtr        DW    0
CountDown          DD    0

comment #
 expects: AL - irq num
          EBX - new handler EIP
          CX  - new handler CS
 returns: EBX - old handler EIP
          CX  - old handler CX
#
COMM_HookIRQ       PROC  NEAR
                   PUSH  EBX
                   PUSH  ECX

                   MOVZX EAX,AL
                   IFDEF __DLL
                   GetVar EBX,IRQMap
                   MOVZX EAX,B [EBX+EAX]
                   ELSE
                   MOVZX EAX,B IRQMap[EAX]
                   ENDIF

                   PUSH  EAX
                   CALL  GetIntVec
                   XCHG  EAX,[ESP+8] ; pushed EBX
                   XCHG  EBX,[ESP+4] ; pushed ECX
                   MOV   ECX,EBX
                   POP   EBX
                   CALL  SetIntVec

                   POP   ECX
                   POP   EBX
                   RET
COMM_HookIRQ       ENDP

IRQ0_Handler       PROC  NEAR
                   PushSegs
                   ReLoadSegs
                   PUSH  EAX
                   CMP   DBG_InDebug,0
                   JNZ   @@Idruut
                   INC   TotalTickCnt
                   INC   TickCnt
                   CMP   CountDown,0
                   JZ    @@Idruut
                   DEC   CountDown
@@Idruut:
                   ADD   OverFlowCtr,COMM_TIMERSPEED
                   JC    @@daJump
                   MOV   AL,20H
                   OUT   20H,AL
                   POP   EAX
                   PopSegs
                   STI
                   IRETD
@@daJump:          POP   EAX
                   PopSegs
                   JMP   FWORD PTR CS:IRQ0_OldHandler
IRQ0_Handler       ENDP

IRQ0_Init          PROC  NEAR
                   MOV   AL,0
                   MOV   EBX,O IRQ0_Handler
                   MOV   CX,CS
                   CALL  COMM_HookIRQ
                   MOV   D IRQ0_OldHandler,EBX
                   MOV   W IRQ0_OldHandler+4,CX
                   CLI
                   CALL  GetIRQMasks
                   AND   AX,1111111111111110B
                   CALL  SetIRQMasks
                   MOV  AL,36H
                   OUT  43H,AL
                   MOV  AX,COMM_TIMERSPEED
                   OUT  40H,AL
                   MOV  AL,AH
                   IOWait
                   OUT  40H,AL
                   STI
                   CLR  EBX
                   CALL EnableCallback
                   RET
IRQ0_Init          ENDP

IRQ0_Done          PROC  NEAR
                   CLR   EBX
                   CALL  DisableCallback
                   MOV   AL,0
                   MOV   EBX,D IRQ0_OldHandler
                   MOV   CX,W IRQ0_OldHandler+4
                   CALL  COMM_HookIRQ
                   CLI
                   MOV  AL,36H
                   OUT  43H,AL
                   CLR  AL
                   OUT  40H,AL
                   IOWait
                   OUT  40H,AL
                   STI
                   RET
IRQ0_Done          ENDP

PrintFrameRate     PROC  NEAR
                   CALL  KlearTextScreen
                   IFDEF __DLL
                   GetVar EAX,CursorPtr
                   MOV   D [EAX],2*160
                   ELSE
                   MOV   CursorPtr,2*160
                   ENDIF

                   Say   'Frames: '
                   SayDec FrameCounter
                   NewLine
                   Say   'Ticks: '
                   SayDec TotalTickCnt
                   NewLine
                   Say   'Frame rate: '

                   MOV   ECX,TotalTickCnt

                   MOV   EAX,FrameCounter
                   MOV   EBX,5000
                   MUL   EBX
                   DIV   ECX
                   CLR   EDX
                   MOV   ECX,100
                   DIV   ECX

                   SayDec EAX
                   MOV   AL,'.'
                   CALL  DisplayChar
                   MOV    EAX,EDX
                   CLR    EDX
                   MOV    ECX,10
                   DIV    ECX
                   ADD    AL,'0'
                   CALL   DisplayChar
                   MOV    AL,'0'
                   ADD    AL,DL
                   CALL   DisplayChar
                   SayLn   ' FPS'
                   RET
PrintFrameRate     ENDP

