ArgInit            MACRO
                   ArgPointer = 8
                   ArgSize = 0
                   FrameSize = 0
                   FramePointer = 0
                   ENDM

Argument           MACRO _Name , _Type
                   &_Name& = ArgPointer
                   IFNB <_Type>
                    ArgPointer = ArgPointer + 2
                    ArgSize = ArgSize + 2
                   ELSE
                    ArgPointer = ArgPointer + 4
                    ArgSize = ArgSize +4
                   ENDIF
                   ENDM

LocVar             MACRO _Name , _Type
                   IFNB <_Type>
                    FramePointer = FramePointer - 2
                    FrameSize = FrameSize + 2
                   ELSE
                    FramePointer = FramePointer - 4
                    FrameSize = FrameSize + 4
                   ENDIF
                   &_Name& = FramePointer
                   ENDM

ProcEnter          MACRO
                   IF ArgSize
                    PUSH EBP
                    MOV  EBP,ESP
                    IF FrameSize
                     SUB  ESP,FrameSize
                    ENDIF
                   ELSE
                    IF FrameSize
                     PUSH EBP
                     MOV  EBP,ESP
                     SUB  ESP,FrameSize
                    ENDIF
                   ENDIF
                   ENDM

ProcLeave          MACRO
                    IF ArgSize
                     IF FrameSize
                      MOV ESP,EBP
                     ENDIF
                     POP EBP
                     RET ArgSize
                    ELSE
                     If FrameSize
                      MOV  ESP,EBP
                      POP  EBP
                     ENDIF
                     RET
                    ENDIF
                   ENDM

LDST               MACRO REG,SV
                   MOV   REG,DWORD PTR [EBP+SV]
                   ENDM

STST               MACRO SV,REG
                   MOV   DWORD PTR [EBP+SV],REG
                   ENDM

ADST               MACRO SV,REG
                   ADD   DWORD PTR [EBP+SV],REG
                   ENDM

SBST               MACRO SV,REG
                   SUB   DWORD PTR [EBP+SV],REG
                   ENDM
