
/*ͻ
                                                                            
   EOS.H   (Tabs : 13 21 29 37)                                             
                                                                            
  ͼ*/

#ifndef __EOS_H__
#define __EOS_H__


#define OFF 0
#define ON  1

#ifdef __cplusplus
extern "C"
{
#endif

typedef unsigned long selector_t;


/*ͻ
                                                                            
   EOS Functions                                                            
                                                                            
  ͼ*/


/*ͻ
                                                                            
                                  System                                    
                                                                            
  ͼ*/


/*Ŀ
  Exit Error   Restore initial Video mode , interrupts , free all reserved  
               memory ,stop music if played and exit (with error code 1)    
               with a error message                                         
                                                                            
  */
void exit_error(char *msg_error);
#pragma aux exit_error "_Exit_Error" parm [edx] modify [eax]


/*Ŀ
  Use Int 08   Use Int 08 (IRQ 0) to count frame rate and have a stable     
               vertical retrace                                             
                                                                            
  */
void use_int_08(long value);
#pragma aux use_int_08 "_Use_Int_08" modify [eax] parm [ebx]


/*Ŀ
  Change Synchro Int 08   Change frequency for Interupt 08                  
                          Defaults frequency is 70Hz                        
                                                                            
  */
void change_synchro_int_08(short value);
#pragma aux change_synchro_int_08 "_Change_Synchro_Int_08" modify [eax] parm [bx]


/*Ŀ
  Use Int 09   Use Internal Keyboard handler to use keyboard                
               return address of the array of 128 char                      
                                                                            
  */
typedef struct keyboard_ {
  unsigned char all;
  unsigned char scancodes[127];
}keyboard_t;

keyboard_t* use_int_09(long value);
#pragma aux use_int_09 "_Use_Int_09" modify [eax] parm [ebx] value [eax]


/*Ŀ
  Restore Video Mode   Restore the inital video which is be active at the   
                       start of the program                                 
                                                                            
  */
void restore_video_mode();
#pragma aux restore_video_mode "_Restore_Video_Mode" modify [eax]

/*Ŀ
  Detect Windows       Detect If Windows is running                         
                                                                            
  Other Registers Change : None                                             
                                                                            
  */
#define WINDOWS_3X           3
#define WINDOWS_95           4
unsigned char detect_windows();
#pragma aux detect_windows "_Detect_Windows" modify [eax] value [al]


/*Ŀ
  Direct Send          Write a text directly to video ram . Color allowed   
                                                                            
  Command : 0,0      = end                                                  
            0,1..255 = color                                                
            13       = first colonne                                        
            10       = next ligne                                           
                                                                            
  */
void direct_send(char *msg);
#pragma aux direct_send "_Direct_Send" modify [eax edx] parm [edx]


/*ͻ
                                                                            
                                   Files                                    
                                                                            
  ͼ*/


/*Ŀ
  Load Internal file   Load a file which is link with LLINK                 
                       if the file is not present the program stop and      
                       display a error message                              
                                                                            
  */
char *load_internal_file(char *file_name,long *size_file);
#pragma aux load_internal_file "_Load_Internal_File" modify [eax ecx edx esi edi] value [eax] parm [edx] [ecx]


/*Ŀ
  Load Internal file Handle  Load a file which is link with LLINK           
                             if the file is not present the program stop    
                             and display a error message                    
                                                                            
  */
char *load_internal_file_handle(char *file_name,long *size_file,long *handle_file);
#pragma aux load_internal_file_handle "_Load_Internal_File_Handle" modify [eax ecx edx esi edi] value [eax] parm [edx] [ecx] [edi]


/*Ŀ
  Load External file   Load a external file and uncompress it if it has     
                       been compress with Diet 1.44                         
                                                                            
  */
char *load_external_file(char *file_name,long *size_file);
#pragma aux load_external_file "_Load_External_File" modify [eax ecx edx esi edi] value [eax] parm [edx] [ecx]


/*Ŀ
  Load External file Handle  Load a external file and uncompress it if it   
                             has been compress with Diet 1.44               
                                                                            
  */
char *load_external_file_handle(char *file_name,long *size_file,long *handle_file);
#pragma aux load_external_file_handle "_Load_External_File_Handle" modify [eax ecx edx esi edi] value [eax] parm [edx] [ecx] [edi]


/*Ŀ
  Write External File  Save a File on a Disk                                
                                                                            
  */
long write_external_file(char *file_name,long *addr_file,long size_file);
#pragma aux write_external_file "_Write_External_File" modify [eax ebx ecx edx esi edi] value [eax] parm [edx] [esi] [ecx]

/*ͻ
                                                                            
                             Memory Allocation                              
                                                                            
  ͼ*/

/*Ŀ
  DeAllocate Memory         Free the last allocate memory                   
                                                                            
  */
void deallocate_memory();
#pragma aux deallocate_memory "_DeAllocate_Memory" modify [eax]

/*Ŀ
  DeAllocate Memory Handle  Free the allocate memory with this handle       
                                                                            
  */
void deallocate_memory_handle(long handle_memory);
#pragma aux deallocate_memory_handle "_DeAllocate_Memory_Handle" modify [eax edi] parm [edi]

/*Ŀ
  Allocate Selector   Create a new selector                                 
                                                                            
  */
selector_t allocate_selector(char* vram_addr, long vram_size);
#pragma aux allocate_selector "_Allocate_Selector" modify [eax ebx esi edi] parm [esi edi] value [eax]

/*Ŀ
  DeAllocate Selector       Free a selector                                 
                                                                            
  */
long deallocate_selector(selector_t selector);
#pragma aux deallocate_selector "_DeAllocate_Selector" modify [eax ebx] parm [ebx]


/*ͻ
                                                                            
                                Synchronization                             
                                                                            
  ͼ*/


/*Ŀ
  Wait Vbl   Wait the vertical retrace                                      
                                                                            
  */
long wait_vbl();
#pragma aux wait_vbl "_Wait_Vbl" modify [eax] value [eax]


/*ͻ
                                                                            
                                Diamond Player                              
                                                                            
  ͼ*/
#define  NO_CARD    0x00
#define  SB_10      0x01
#define  SB_15      0x02
#define  SB_20      0x03
#define  SB_PRO     0x04
#define  SB_16      0x05
#define  SB_AWE     0x06
#define  GRAVIS     0x10
#define  GRAVIS_MAX 0x11
#define  GRAVIS_ACE 0x12
#define  GRAVIS_PNP 0x13
#define  WSS        0x20

/*Ŀ
  Detect Sound Card   Detect with the environment variable the sound        
                      card installed                                        
                                                                            
  */
int detect_sound_card(int display,int *port,int *irq,int *dma,int *infos);
#pragma aux detect_sound_card "_Detect_Sound_Card"  modify [eax ebx ecx edx esi edi] parm [ecx] [ebx] [edx] [esi] [edi]


/*Ŀ
  Load Module   Load a module & initialize into the memory                  
                                                                            
  */
long load_module(char *file_name,unsigned char type,int replay,int sfx_channel);
#pragma aux load_module "_Load_Module" modify [eax ebx ecx edx esi edi] value [eax] parm [edx] [eax] [ebx] [ecx]


/*Ŀ
  Play Module   Start playing the module                                    
                                                                            
  */
void play_module();
#pragma aux play_module "_Play_Module" modify [eax]


/*Ŀ
  Stop Module   Stop playing the module                                     
                                                                            
  */
void stop_module();
#pragma aux stop_module "_Stop_Module" modify [eax]


/*Ŀ
  Clear Module   Unload the module from memory                              
                                                                            
  */
void clear_module();
#pragma aux clear_module "_Clear_Module" modify [eax]


/*Ŀ
  Set Volume   Set the master volume of the module                          
                                                                            
  */
void set_volume(unsigned char volume,unsigned char sfx_volume);
#pragma aux set_volume "_Set_Volume" modify [eax ecx edx] parm [cl] [dl]

/*Ŀ
  Play Sample   Play a sample include into the module                       
                                                                            
  */
void play_sample(int num_sample,int frequence,int voice);
#pragma aux play_sample "_Play_Sample" modify [eax ebx ecx edx] parm [ebx] [ecx] [edx]


/*Ŀ
  Get Info   Get information about the module when playing                  
                                                                            
  */
void get_info(unsigned char *position,unsigned char *pattern,unsigned char *note,unsigned char *volume,unsigned char *sfx_volume);
#pragma aux get_info "_Get_Info" modify [eax ebx ecx edx esi] parm [eax] [ebx] [ecx] [edx] [esi]


/*Ŀ
  Set Pattern  Set the current position of the playing module               
                                                                            
  */
void set_pattern(int position,int note);
#pragma aux set_pattern "_Set_Pattern" parm [ebx] [ecx] modify [eax ecx edx]


/*ͻ
                                                                            
   Monochrome display                                                       
                                                                            
  ͼ*/

/*Ŀ
  Set Mono   Force On/Off the display of all the Monochrome Function        
                                                                            
  */
void set_mono(unsigned char value);
#pragma aux set_mono "_Set_Mono" parm [ebx] modify [eax]


/*Ŀ
  Set String Mono   Display a string on the Monochrome adapter              
                                                                            
  */
void set_string_mono(char *msg,int x,int y);
#pragma aux set_string_mono "_Set_String_Mono" parm [edx] [ebx] [ecx] modify [eax ebx ecx edx]


/*Ŀ
  Set Value Mono   Display A Word in Hexadecimal on the Monochrome adapter  
                                                                            
  */
void set_value_mono(long value,int x,int y);
#pragma aux set_value_mono "_Set_Value_Mono" parm [edx] [ebx] [ecx] modify [eax ebx ecx edx]


/*ͻ
                                                                            
   EOS Library                                                              
                                                                            
  ͼ*/


/*ͻ
                                                                            
   VESA                                                                     
                                                                            
  ͼ*/

/* ------------ VBE v1.0  ------------------ */
#define Mode640x400x256             0x100
#define Mode640x480x256             0x101
#define Mode800x600x16              0x102
#define Mode800x600x256             0x103
#define Mode1024x768x16             0x104
#define Mode1024x768x256            0x105
#define Mode1280x1024x16            0x106
#define Mode1280x1024x256           0x107
#define Mode80x60                   0x108
#define Mode132x25                  0x109
#define Mode132x43                  0x10a
#define Mode132x50                  0x10b
#define Mode132x60                  0x10c
/* ------------ VBE v1.2+ ------------------ */
#define Mode320x200x32k             0x10d
#define Mode320x200x64k             0x10e
#define Mode320x200x16M             0x10f
#define Mode640x480x32k             0x110
#define Mode640x480x64k             0x111
#define Mode640x480x16M             0x112
#define Mode800x600x32k             0x113
#define Mode800x600x64k             0x114
#define Mode800x600x16M             0x115
#define Mode1024x768x32k            0x116
#define Mode1024x768x64k            0x117
#define Mode1024x768x16M            0x118
#define Mode1280x1024x32k           0x119
#define Mode1280x1024x64k           0x11a
#define Mode1280x1024x16M           0x11b


extern unsigned char  vesa_current_bank;
#pragma aux  vesa_current_bank "Vesa_Current_Bank"

extern unsigned char  vesa_clear_palette;
#pragma aux  vesa_clear_palette "Vesa_Clear_Palette"


/*Ŀ
  Init Vesa   Initialize A Vesa video mode                                  
                                                                            
  */
char* init_vesa(int vesa_mode);
#pragma aux init_vesa "Init_Vesa" parm [eax] modify [eax ebx ecx edx esi edi] value [eax]


/*Ŀ
  Init Vesa2  Initialize A Vesa 2.0 Linear FrameBuffer mode                 
                                                                            
  */
char *init_vesa2(long vesa_mode,long vesa_size);
#pragma aux init_vesa2 "Init_Vesa2" parm [eax] [ecx] modify [eax ebx ecx edx esi edi] value [eax]


/*Ŀ
  Init Vesa Bank  Init the Automatic Bank Switching                         
                                                                            
  */
selector_t init_vesa_bank();
#pragma aux init_vesa_bank "Init_Vesa_Bank" modify [eax ebx ecx edx esi edi] value [ebx]

/*Ŀ
  Set Bank   Set the current bank                                           
                                                                            
  */
void set_bank(long new_bank);
#pragma aux set_bank "Set_Bank" value [edx]

/*Ŀ
  Next Bank   Set the next bank                                             
                                                                            
  */
void next_bank();
#pragma aux next_bank "Next_Bank"



/*ͻ
                                                                            
   FLI32                                                                    
                                                                            
  ͼ*/

extern char  fli_err;
#pragma aux  fli_err "Fli_Err"
extern char  fli_svga;
#pragma aux  fli_svga "Fli_Svga"
extern char  fli_swap;
#pragma aux  fli_swap "Fli_Swap"
extern char  fli_restart;
#pragma aux  fli_restart "Fli_ReStart"
extern char  fli_loop;
#pragma aux  fli_loop "Fli_Loop"
extern char  fli_trackdisk;
#pragma aux  fli_trackdisk "Fli_TrackDisk"
extern char  fli_last_frame;
#pragma aux  fli_last_frame "Fli_Last_Frame"
extern char  fli_ligne_shl;
#pragma aux  fli_ligne_shl "Fli_Ligne_Shl"
extern short fli_selector;
#pragma aux  fli_selector "Fli_Selector"
extern long  fli_delay;
#pragma aux  fli_delay "Fli_Delay"
extern long  fli_buffer;
#pragma aux  fli_buffer "Fli_Buffer"
extern long  fli_scr_x;
#pragma aux  fli_scr_x "Fli_Scr_X"
extern long  fli_scr_y;
#pragma aux  fli_scr_y "Fli_Scr_Y"
extern long  fli_decal_y;
#pragma aux  fli_decal_y "Fli_Decal_Y"
extern long  fli_decal_x;
#pragma aux  fli_decal_x "Fli_Decal_X"
extern long  fli_current_frame;
#pragma aux  fli_current_frame "Fli_Current_Frame"

/*Ŀ
                                                                            
   Load_Fli(*adrs_file_name)                                                
                                                                            
   Cette routine charge et vrifie le header d'un fichier FLI ou FLC        
                                                                            
  */
long load_fli(char *file_name);
#pragma aux load_fli "Load_Fli" modify [eax ebx ecx edx esi edi] value [eax] parm [edx]

/*Ŀ
                                                                            
   First_Frame_Fli()                                                        
                                                                            
   Cette routine dcompresse la premire image d'un fichier FLI ou FLC      
                                                                            
  */
void first_frame_fli();
#pragma aux first_frame_fli "First_Frame_Fli" modify [eax ebx ecx edx esi edi]

/*Ŀ
                                                                            
   Next_Frame_Fli()                                                         
                                                                            
   Cette routine dcompresse la prochaine image d'un fichier FLI ou FLC     
                                                                            
  */
void next_frame_fli();
#pragma aux next_frame_fli "Next_Frame_Fli" modify [eax ebx ecx edx esi edi]

/*Ŀ
                                                                            
   Dispose_Fli()                                                            
                                                                            
   Cette routine libre la mmoire alloue par la fonction Load_Fli         
                                                                            
  */
void dispose_fli();
#pragma aux dispose_fli "Dispose_Fli" modify [eax ebx ecx edx esi edi]


/*ͻ
                                                                            
   SNAP                                                                     
                                                                            
  ͼ*/

/*Ŀ
  Snap        Grab a 256 Colors screen in Non-Mode and save it in IFF format
              Scroll Lock to lunch it                                       
  */

/*Ŀ
  Init Snap   Initialize the screen grabber . (You can change the int 09    
              function Use_Int_09 after this Init                           
                                                                            
  */
void init_snap();
#pragma aux init_snap "Init_Snap"

/*Ŀ
  Snap IFF    Grab the current Screen from Video RAM                        
                                                                            
  */
void snap_iff();
#pragma aux snap_iff "Snap_Iff"

/*Ŀ
  Save IFF    Save a buffer to IFF                                          
                                                                            
  */
void save_iff(int x,int y,char *file_name,char *addr_file);
#pragma aux save_iff "Save_Iff" parm [eax] [ebx] [edx] [esi] modify [eax ebx edx esi]


/*ͻ
                                                                            
   JOYSTICK                                                                 
                                                                            
  ͼ*/

#define ANALOG_A          0x1
#define ANALOG_B          0x2
#define LPT_A             0x10
#define LPT_B             0x20

#define LPT1              0x1
#define LPT2              0x2
#define LPT3              0x3
#define LPT4              0x4

typedef struct joy_ {
  unsigned char j_type;
  unsigned short j_addr;
  long j_value_x;
  long j_value_y;
  long j_min_x;
  long j_max_x;
  long j_min_y;
  long j_max_y;
  long j_center_x;
  long j_center_y;
  long j_calibrate_left;
  long j_calibrate_right;
  long j_calibrate_up;
  long j_calibrate_down;
  unsigned char j_current_left;
  unsigned char j_current_right;
  unsigned char j_current_up;
  unsigned char j_current_down;
  unsigned char j_fire_1;
  unsigned char j_fire_2;
  unsigned char j_fire_3;
  unsigned char j_fire_4;
}joy_t;

extern struct joy_ joy1;
#pragma aux  joy1 "joy1"
extern struct joy_ joy2;
#pragma aux  joy2 "joy2"
extern struct joy_ joy3;
#pragma aux  joy3 "joy3"
extern struct joy_ joy4;
#pragma aux  joy4 "joy4"
extern struct joy_ joy5;
#pragma aux  joy5 "joy5"
extern struct joy_ joy6;
#pragma aux  joy6 "joy6"


/*Ŀ
  Init_Joystick  Init all port                                              
                                                                            
                                                                            
  */
void init_joystick();
#pragma aux init_joystick "Init_Joystick" modify [eax ebx ecx edx esi edi]


/*Ŀ
  Dectect_Joystick  Find if a analogic joystick is plug in port 1 ,2 or Both
                                                                            
  Out :        NULL No joystick                                             
               1    A joystick is plug in port 1                            
               2    A joystick is plug in port 2                            
               3    2 joystick is plug in port 1 and 2                      
                                                                            
  */
long detect_joystick();
#pragma aux detect_joystick "Detect_Joystick" modify [eax ebx ecx edx esi edi] value [eax]


/*Ŀ
  Add_Joystick                  Add a new joystick to be use by the library 
                                                                            
  In :                                                                      
          Type Of joystick                                                  
               ANALOG_A                                                     
               ANALOG_B                                                     
               LPT_A                                                        
               LPT_B                                                        
          Address of port                                                   
               LPT1                                                         
               LPT2                                                         
               LPT3                                                         
               LPT4                                                         
                                                                            
  Out :                                                                     
             NULL No Joystick Available                                     
             or   Address of structure of joystick                          
                                                                            
  */
joy_t *add_joystick(long type,long port);
#pragma aux add_joystick "Add_Joystick" modify [eax ebx ecx edx esi edi] value [esi] parm [eax] [ebx]


/*Ŀ
  Update_Joystick  Must be call often update all structure of all Joystick  
                   declare with Add_Joystick                                
                                                                            
                                                                            
  */
void update_joystick();
#pragma aux update_joystick "UpDate_Joystick" modify [eax ebx ecx edx esi edi]


/*Ŀ
  Sub_Joystick   Delete a Joystick create by Add_Joystick                   
                                                                            
  In :                                                                      
             Address of structure to be delete                              
                                                                            
  Out :                                                                     
             NULL Structure not found                                       
                                                                            
  */
long sub_joystick(joy_t* joy);
#pragma aux sub_joystick "Sub_Joystick" modify [eax ebx ecx edx esi edi] parm [esi] value [eax]


/*Ŀ
  Upper_Left     Take Value For Upper Left Joystick's Coordonate            
                                                                            
  In :                                                                      
             Address of structure                                           
                                                                            
  Out :                                                                     
             NULL No fire press                                             
                                                                            
  */
long upper_left(joy_t* joy);
#pragma aux upper_left "Upper_Left" modify [eax ebx ecx edx esi edi] parm [esi] value [eax]


/*Ŀ
  Lower_Right    Take Value For Lower Right Joystick's Coordonate           
                                                                            
  In :                                                                      
             Address of structure                                           
                                                                            
  Out :                                                                     
             NULL No fire press                                             
                                                                            
  */
long lower_right(joy_t* joy);
#pragma aux lower_right "Lower_Right" modify [eax ebx ecx edx esi edi] parm [esi] value [eax]


/*Ŀ
  Center         Take Value For Center Joystick's Coordonate                
                                                                            
  In :                                                                      
             Address of structure                                           
                                                                            
  Out :                                                                     
             NULL No fire press                                             
                                                                            
  */
long center(joy_t* joy);
#pragma aux center "Center" modify [eax ebx ecx edx esi edi] parm [esi] value [eax]


/*ͻ
                                                                            
   MEMORY                                                                   
                                                                            
  ͼ*/

/*Ŀ
  Init_Memory    Turn the display memory on                                 
                                                                            
  In :                                                                      
                                                                            
  Out :                                                                     
                                                                            
  Other Registers Change : None                                             
                                                                            
  */
void init_memory();
#pragma aux init_memory "Init_Memory"


/*ͻ
                                                                            
   RS232                                                                    
                                                                            
  ͼ*/

#define COM_1             0x3F8   /* base port address of port 0 */
#define COM_2             0x2F8   /* base port address of port 1 */

#define SER_BAUD_300      384     /*    300 bauds */
#define SER_BAUD_1200     96      /*   1200 bauds */
#define SER_BAUD_2400     48      /*   2400 bauds */
#define SER_BAUD_4800     24      /*   4800 bauds */
#define SER_BAUD_9600     12      /*   9600 bauds */
#define SER_BAUD_14400    8       /*  14400 bauds */
#define SER_BAUD_19200    6       /*  19200 bauds */
#define SER_BAUD_28800    4       /*  28800 bauds */
#define SER_BAUD_38400    3       /*  38400 bauds */
#define SER_BAUD_57600    2       /*  57600 bauds */
#define SER_BAUD_115200   1       /* 115200 bauds */

#define SER_STOP_1        0       /* 1 stop bit per character */
#define SER_STOP_2        4       /* 2 stop bits per character */

#define SER_BITS_5        0       /* send 5 bit characters */
#define SER_BITS_6        1       /* send 6 bit characters */
#define SER_BITS_7        2       /* send 7 bit characters */
#define SER_BITS_8        3       /* send 8 bit characters */

#define SER_PARITY_NONE   0       /* no parity */
#define SER_PARITY_ODD    8       /* odd parity */
#define SER_PARITY_EVEN   24      /* even parity */

/*Ŀ
                                                                            
   Serial_Open(COM_1,SER_BAUD_9600,SER_PARITY_NONE | SER_BITS_8 | SER_STOP_1
               ,taille buffer) -> NULL or Circular buffer address           
                                                                            
   this function sets the serial port up.                                   
                                                                            
  */
char *serial_open(long port_base,long baud,long configuration,long taille_buffer);
#pragma aux serial_open "Serial_Open" modify [eax ebx ecx edx esi edi] parm [edx] [eax] [ecx] [edi] value [eax]

/*Ŀ
                                                                            
   Serial_Close()                                                           
                                                                            
   This procedure closes the serial port.                                   
                                                                            
  */
void serial_close();
#pragma aux serial_close "Serial_Close" modify [eax ebx ecx edx esi edi]

/*Ŀ
                                                                            
   Serial_Read()                                                            
                                                                            
   This procedue reads a character in the circular buffer                   
                                                                            
  */
char serial_read();
#pragma aux serial_read "Serial_Read" modify [eax ebx ecx edx esi edi] value [al]

/*Ŀ
                                                                            
   Serial_Read_Block(char *buffer,long size)                                
                                                                            
                                                                            
                                                                            
  */
void serial_read_block(char *buffer,long size);
#pragma aux serial_read_block "Serial_Read_Block" modify [eax ebx ecx edx esi edi] parm [edi] [ecx] value [eax]

/*Ŀ
                                                                            
   Serial_Write(caractre) -> TRUE ou FALSE                                 
                                                                            
   This procedure sends characters.                                         
                                                                            
  */
long serial_write(char data);
#pragma aux serial_write "Serial_Write" modify [eax ebx ecx edx esi edi] parm [ebx] value [eax]

/*Ŀ
                                                                            
   Serial_Write_Block(char *Block,long Size) -> TRUE ou FALSE               
                                                                            
                                                                            
                                                                            
  */
long serial_write_block(char *Block,long Size);
#pragma aux serial_write_block "Serial_Write_Block" modify [eax ebx ecx edx esi edi] parm [esi] [ecx] value [eax]

/*Ŀ
                                                                            
   Serial_Clear_Buffer()                                                    
                                                                            
   This procedure clears the circular buffer.                               
                                                                            
  */
void serial_clear_buffer();
#pragma aux serial_clear_buffer "Serial_Clear_Buffer" modify [eax ebx ecx edx esi edi]

/*Ŀ
                                                                            
   Serial_Status()                                                          
                                                                            
   This procedure gets the status of the modem.                             
                                                                            
  */
char serial_status();
#pragma aux serial_status "Serial_Status" modify [eax ebx ecx edx esi edi] value [al]

      /*    7    6     5     4      3     2      1      0
        Ŀ
         DCD  RI  DSR  CTS  dDCD  dRI  dDSR  dCTS 
        

        Bit 0 (dCTS): Change in CTS
        Bit 1 (dDSR): Change in DSR
        Bit 2 (dRI): Change in RI
        Bit 3 (dDCD): Change in DCD
        Bit 4 (CTS): Clear To Send. Modem sets this line indicating that
                it is ready for data, after computer indicates that it
                is ready for data with an RTS. It used to be a signal
                that the local modem has connected with a remote modem
                too, in the olden days.
        Bit 5 (DSR): Data Set Ready. This is the completing signal in a
                DTR-DSR pair. Computer sends DTR to modem, saying it
                wants to connect with it. Modem sends DSR back to
                computer, saying that connection has been established.
        Bit 6 (RI): Ring Indicator. Indicates that there is remote modem
                attempting to call your local modem.
        Bit 7 (DCD): Data Carrier Detect. Indicates that the remote
                modem has established connection with local modem.
*/
/*Ŀ
                                                                            
   Serial_Set_Dtr()                                                         
                                                                            
   sets the DTR bit to 1                                                    
                                                                            
  */
void serial_set_dtr();
#pragma aux serial_set_dtr "Serial_Set_Dtr" modify [eax ebx ecx edx esi edi]

/*Ŀ
                                                                            
   Serial_Reset_Dtr()                                                       
                                                                            
   sets the DTR bit to 0                                                    
                                                                            
  */
void serial_reset_dtr();
#pragma aux serial_reset_dtr "Serial_Reset_Dtr" modify [eax ebx ecx edx esi edi]

/*Ŀ
                                                                            
   Serial_Set_Rtr()                                                         
                                                                            
   sets the RTS bit to 1                                                    
                                                                            
  */
void serial_set_rts();
#pragma aux serial_set_rts "Serial_Set_Rts" modify [eax ebx ecx edx esi edi]

/*Ŀ
                                                                            
   Serial_Reset_Rts()                                                       
                                                                            
   sets the RTS bit to 0                                                    
                                                                            
  */
void serial_reset_rts();
#pragma aux serial_reset_rts "Serial_Reset_Rts" modify [eax ebx ecx edx esi edi]

/*Ŀ
                                                                            
   Serial_Buffer_Full                                                       
                                                                            
   sets the RTS bit to 1                                                    
                                                                            
  */
extern char serial_buffer_full;
#pragma aux serial_buffer_full "Serial_Buffer_Full"

/*Ŀ
                                                                            
   Serial_Stand_By                                                          
                                                                            
   sets the RTS bit to 0                                                    
                                                                            
  */
extern volatile long serial_stand_by;
#pragma aux serial_stand_by "Serial_Stand_By"


/*ͻ
                                                                            
   CDROM                                                                    
                                                                            
  ͼ*/

typedef struct track_info {
  unsigned char _adr;
  unsigned char _track;
  unsigned char _index;
  unsigned char _min;
  unsigned char _sec;
  unsigned char _frame;
  unsigned char _zero;
  unsigned char _amin;
  unsigned char _asec;
  unsigned char _aframe;
}track_info_t;

extern struct track_info track_info;
#pragma aux track_info "Track_Info"

/*Ŀ
  Detect CDROM  Detect is a cdrom is connected to the system using the      
                MSCDEX functions                                            
                                                                            
  Out :                                                                     
         1 = No CDROM detected                                              
                                                                            
  */
long detect_cdrom();
#pragma aux detect_cdrom "Detect_CDROM" modify [eax ebx ecx edx esi edi] value [eax]

extern int first_cdrom;
#pragma aux first_cdrom "First_CDROM"
extern int number_cdrom;
#pragma aux number_cdrom "Number_CDROM"
extern int version_mscdex;
#pragma aux version_mscdex "Version_MSCDEX"


/*Ŀ
  Play a Track  Play a track from the CDROM                                 
                                                                            
  In :                                                                      
                                                                            
         Track number  = 1..xx                                              
         Play all      = ON or OFF                                          
                                                                            
  Out :                                                                     
         1 = Error on playing                                               
                                                                            
  */
long play_track(long track_number,long play_all);
#pragma aux play_track "Play_Track" modify [eax ebx ecx edx esi edi] value [eax] parm [eax] [ebx]


/*Ŀ
  Open CDROM   Open the CDROM door                                          
                                                                            
  Out :                                                                     
         1 = Error on command                                               
                                                                            
  */
long open_cdrom();
#pragma aux open_cdrom "Open_CDROM" modify [eax ebx ecx edx esi edi] value [eax]


/*Ŀ
  Close CDROM   Close the CDROM door                                        
                                                                            
  Out :                                                                     
         1 = Error on command                                               
                                                                            
  */
long close_cdrom();
#pragma aux close_cdrom "Close_CDROM" modify [eax ebx ecx edx esi edi] value [eax]


/*Ŀ
  Stop CDROM stop the music from the CDROM                                  
                                                                            
  Out :                                                                     
         1 = Error on command                                               
                                                                            
  */
long stop_cdrom();
#pragma aux stop_cdrom "Stop_CDROM" modify [eax ebx ecx edx esi edi] value [eax]


/*Ŀ
  Resume CDROM  Resume the music from the CDROM                             
                                                                            
  Out :                                                                     
         1 = Error on command                                               
                                                                            
  */
long resume_cdrom();
#pragma aux resume_cdrom "Resume_CDROM" modify [eax ebx ecx edx esi edi] value [eax]


/*Ŀ
  Get Nb Tracks Get the number of Tracks in the CDROM                       
                (Will also reload all the database all track a bit slow)    
  Out :                                                                     
         1 = Error on command                                               
                                                                            
  */
long get_nb_tracks();
#pragma aux get_nb_tracks "Get_Nb_Tracks" modify [eax ebx ecx edx esi edi] value [eax]

extern long track_nbs;
#pragma aux track_nbs "Track_Nbs"


/*Ŀ
  Get Track Info  Get the Track info on the CDROM                           
                                                                            
  In :                                                                      
         Track number = 1..xx                                               
                                                                            
  Out :                                                                     
         1 = Error on command                                               
                                                                            
  */
long get_track_info(long track_number);
#pragma aux get_track_info "Get_Track_Info" modify [eax ebx ecx edx esi edi] value [eax] parm [eax]


/*Ŀ
  Get Current Track Info  Get the current Track info on the CDROM           
                                                                            
  Out :                                                                     
         1 = Error on command                                               
                                                                            
  */
long get_current_track_info();
#pragma aux get_current_track_info "Get_Current_Track_Info" modify [eax ebx ecx edx esi edi] value [eax]



/*ͻ
                                                                            
   GIF                                                                      
                                                                            
  ͼ*/

extern long gif_handle;
#pragma aux gif_handle "gif_handle"
extern unsigned short gif_x;
#pragma aux gif_x "gif_x"
extern unsigned short gif_y;
#pragma aux gif_y "gif_y"
extern char *gif_palette;
#pragma aux gif_palette "gif_palette"

/*Ŀ
                                                                            
   char *Load_External_Gif_Handle(*adrs_file_name)                          
                                                                            
   Cette routine charge et dcompresse un fichier (compression GIF) et      
   retourne un pointeur sur le fichier dcompresse si la requte a          
   pu tre satisfaite ou NULL si elle n'a pu tre honore                   
                                                                            
  */
char *load_external_gif_handle(char *File_Name);
#pragma aux load_external_gif_handle "Load_External_Gif_Handle" modify [eax ebx ecx edx esi edi] value [eax] parm [edx]


/*Ŀ
                                                                            
   char *Load_Internal_Gif_Handle(*adrs_file_name)                          
                                                                            
   Cette routine charge et dcompresse un fichier (compression GIF) et      
   retourne un pointeur sur le fichier dcompresse si la requte a          
   pu tre satisfaite ou NULL si elle n'a pu tre honore                   
                                                                            
  */
char *load_internal_gif_handle(char *File_Name);
#pragma aux load_internal_gif_handle "Load_Internal_Gif_Handle" modify [eax ebx ecx edx esi edi] value [eax] parm [edx]


/*ͻ
                                                                            
   The 32bit debugger                                                       
                                                                            
  ͼ*/

void debug();
#pragma aux debug "Debug"
void debug_back();
#pragma aux debug_back "Debug_Back"

void break_point();
#pragma aux break_point = "int 3";

/*ͻ
                                                                            
   The EOS Emulation when using WATCON                                      
                                                                            
  ͼ*/

void init_eos(unsigned __near psp);
#pragma aux init_eos "Init_EOS" parm [ebx]


#ifdef __cplusplus
};
#endif

#endif