/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <process.h>
#include <dos32api.h>
#include <ctype.h>
#include <libc/dosexec.h>
#include <libc/unconst.h>
#include <libc/dosio.h>

extern char **environ;

int __dosexec_in_system = 0;

static int direct_exec_tail(const char *program, const char *args, char * const envp[])
{
  _dos32_regs r;
  char short_name[FILENAME_MAX];
  const char *progname;
  char *passed_args, *passed_env, *d, *d2;
  unsigned proglen;
  int i,a,f;
  int envsize=1;
  
  sync();

  proglen = strlen(program)+1;
  if(_USE_LFN) {
    memcpy(__dos32_dos_buffer,program, proglen);
    r.eax = 0x7160;            /* Truename */
    r.ecx = 1;             /* Get short name */
    r.ds  = r.es = __dos32_dos_buffer_seg;
    r.esi = r.edi = 0;
    __dos32_call_realmode_int(0x21, &r,0);
    if (r.flags & 1)
    {
      errno = __doserr_to_errno(r.eax);
      return -1;
    }
    memcpy(short_name,__dos32_dos_buffer, FILENAME_MAX);
    progname = short_name;
    proglen = strlen(short_name)+1;
  } else
    progname = program;

  for (i=0; envp[i]; i++) envsize+=strlen(envp[i])+1;
  passed_env=(char *)malloc(envsize+1);
  if (!envp[0]) *(short *)passed_env=0;
  else {
    for (i=0,d=passed_env; envp[i]; i++)
    {
       for (d2=envp[i];*d2;d2++,d++) *d=*d2;
       *(d++) =0;
    }
    *d=0;
  }
  passed_args=(char *)malloc(strlen(args)+2);
  strcpy(passed_args+1,args);
  *passed_args=strlen(args);
  *(passed_args + strlen(args) + 1)=13;
  asm("movw $0x4b00,%%ax\n\
       int  $0x21\n\
       sbbl %%edx,%%edx"
      : "=a" (a), "=d" (f)
      : "d" (progname),"D" (passed_env), "S" (passed_args)
      : "eax", "ebx", "ecx", "edx","edi","esi","ebp","cc");
  free(passed_env);
  free(passed_args);
  if (f)
  {
    errno = __doserr_to_errno(a);
    return -1;
  }
  
  asm("movb $0x4d,%%ah\n\
       int  $0x21\n\
       sbbl %%ebx,%%ebx"
      : "=a" (a), "=b" (f)
      :
      : "eax", "ebx");
  if (f)
  {
    errno = __doserr_to_errno(a);
    return -1;
  }
  return a & 0xffff;
}

#define _dos_exec(program,args,envp) direct_exec_tail(program, args, envp)

static int direct_exec(const char *program, char **argv, char **envp)
{
  int i, arglen;
  char *args, *argp;


  arglen = 0;
  for (i=1; argv[i]; i++)
    arglen += strlen(argv[i]) + 1;
  args = (char *)alloca(arglen+1);
  argp = args;
  for (i=1; argv[i]; i++)
  {
    const char *p = argv[i];
    if (argp - args > 125)
      break;
    *argp++ = ' ';
    while (*p)
    {
      if (argp - args > 125)
        break;
      *argp++ = *p++;
    }
  }
  *argp = 0;
  
  return direct_exec_tail(program, args, envp);
}

int
__dosexec_command_exec(const char *program, char **argv, char **envp)
{
  const char *comspec=0;
  char *cmdline;
  char *newargs[3];
  int cmdlen;
  int i;
  
  cmdlen = strlen(program) + 4;
  for (i=0; argv[i]; i++)
    cmdlen += strlen(argv[i]) + 1;
  cmdline = (char *)alloca(cmdlen);
  
  strcpy(cmdline, "/c ");
  for (i=0; program[i] > ' '; i++)
  {
    if (program[i] == '/')
      cmdline[i+3] = '\\';
    else
      cmdline[i+3] = program[i];
  }
  for (; program[i]; i++)
    cmdline[i+3] = program[i];
  cmdline[i+3] = 0;
  for (i=1; argv[i]; i++)
  {
    strcat(cmdline, " ");
    strcat(cmdline, argv[i]);
  }
  for (i=0; envp[i]; i++)
    if (strncmp(envp[i], "COMSPEC=", 8) == 0)
      comspec = envp[i]+8;
  if (!comspec)
    for (i=0; environ[i]; i++)
      if (strncmp(environ[i], "COMSPEC=", 8) == 0)
        comspec = environ[i]+8;
  if (!comspec)
    comspec = "c:\\command.com";
  newargs[0] = unconst(comspec, char *);
  newargs[1] = cmdline;
  newargs[2] = 0;
  i = direct_exec(comspec, newargs, envp);
  return i;
}

static struct {
  const char *extension;
  int (*interp)(const char *, char **, char **);
} interpreters[] = {
  { ".com", direct_exec },
  { ".exe", direct_exec },
  { ".bat", __dosexec_command_exec },
  { "",     direct_exec },
  { 0,      direct_exec },
  { 0,      0 },
};
#define INTERP_NO_EXT 3

/*-------------------------------------------------*/

char *
__dosexec_find_on_path(const char *program, char *envp[], char *buf)
{
  char *pp, *rp, *pe;
  const char *ptr;
  int i, hasdot=0, haspath=0;
  int tried_dot = 0;

  strcpy(buf, program);
  rp = buf + strlen(buf);

  for (ptr=program; *ptr; ptr++)
  {
    if (*ptr == '.')
      hasdot = 1;
    if (*ptr == '/' || *ptr == '\\' || *ptr == ':')
    {
      haspath = 1;
      hasdot = 0;
    }
  }

  if (hasdot)
  {
    if (access(buf, 0) == 0 && access(buf, D_OK))
      return buf;
  }
  else
    for (i=0; interpreters[i].extension; i++)
    {
      strcpy(rp, interpreters[i].extension);
      if (access(buf, 0) == 0 && access(buf, D_OK))
	return buf;
    }

  if (haspath)
    return 0;
  *rp = 0;

  pp = 0;
  for (i=0; envp[i]; i++)
    if (strncmp(envp[i], "PATH=", 5) == 0)
      pp = envp[i] + 5;
  if (pp == 0)
    return 0;

  while (1)
  {
    if (!tried_dot)
    {
      rp = buf;
      pe = pp;
      tried_dot = 1;
    }
    else
    {
      rp = buf;
      for (pe = pp; *pe && *pe != ';'; pe++)
        *rp++ = *pe;
      pp = pe+1;
      if (rp > buf && rp[-1] != '/' && rp[-1] != '\\' && rp[-1] != ':')
        *rp++ = '/';
    }
    for (ptr = program; *ptr; ptr++)
      *rp++ = *ptr;
    *rp = 0;
    
    if (hasdot)
    {
      if (access(buf, 0) == 0 && access(buf, D_OK))
	return buf;
    }
    else
    {
      for (i=0; interpreters[i].extension; i++)
      {
        strcpy(rp, interpreters[i].extension);
        if (access(buf, 0) == 0 && access(buf, D_OK))
          return buf;
      }
    }
    if (*pe == 0)
      return 0;
  }
}

int __spawnve(int mode, const char *path, char *const argv[], char *const envp[])
{
  /* This is the one that does the work! */
  union { char *const *x; char **p; } u;
  int i = -1;
  char **argvp;
  char **envpp;
  char rpath[80], *rp, *rd=0;

  u.x = argv; argvp = u.p;
  u.x = envp; envpp = u.p;

  fflush(stdout); /* just in case */
  for (rp=rpath; *path; *rp++ = *path++)
  {
    if (*path == '.')
      rd = rp;
    if (*path == '\\' || *path == '/')
      rd = 0;
  }
  *rp = 0;
  if (rd)
  {
    for (i=0; interpreters[i].extension; i++)
      if (stricmp(rd, interpreters[i].extension) == 0)
        break;
  }
  while (access(rpath, 0) && access(rpath, D_OK))
  {
    i++;
    if (interpreters[i].extension == 0 || rd)
    {
      errno = ENOENT;
      return -1;
    }
    strcpy(rp, interpreters[i].extension);
  }
  if (i == -1)
    i = INTERP_NO_EXT;
  i = interpreters[i].interp(rpath, argvp, envpp);
  if (mode == P_OVERLAY)
    exit(i);
  return i;
}
