/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <dos32api.h>
#include <io.h>
#include <libc/dosio.h>
#include <sys/fsext.h>
#include <stdio.h>

int
_open(const char* filename, int oflag)
{
  _dos32_regs r;
  char dummy[256];
  int rv;

  if (filename == 0)
  {
    errno = EINVAL;
    return -1;
  }

  if (__FSEXT_call_open_handlers(__FSEXT_open, &rv, &filename))
    return rv;

  
  if(_USE_LFN) {
    r.eax = 0x716c;
    r.ebx = oflag;
    r.edx = 1;         /* Open existing file */
    r.esi = 0;
    r.ecx = 0;
    r.ds  = __dos32_dos_buffer_seg;
    _put_path(filename);
    __dos32_call_realmode_int(0x21,&r, 0);
  }
  else {
    _path_unix2dos(filename,dummy,256);
    asm("xorl %%ecx,%%ecx\n\
    movb $0x3d,%%ah\n\
    int  $0x21\n\
    sbbl %%edx,%%edx"
    : "=a" (r.eax), "=d" (r.flags)
    : "d" (&dummy), "a" (oflag)
    : "eax", "ecx", "edx", "cc");
  }
  if(r.flags & 1)
  {
    errno = __doserr_to_errno(r.eax);
    return -1;
  }
  __file_handle_set(r.eax & 0xffff, O_BINARY);
  return r.eax;
}
