/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <dos32api.h>

static char pc_n[]= "pc";

int
gethostname (char *buf, int size)
{
  char *h;
  int len;
  _dos32_regs r;

  /* Try asking [a lan extension of] dos for a name.  */
  r.eax  = 0x5e00;
  r.ecx  = 0;  /* Try to detect overloading of 0x5e00  */
  r.edx  = 0;
  r.ds = __dos32_dos_buffer_seg;
  __dos32_call_realmode_int (0x21, &r,0);
  if ((r.flags & 1) || (r.ecx & 0xff00) == 0)
  {
    /* Failed.  Try $HOSTNAME, then "pc".  */
    h = getenv ("HOSTNAME");
    if (h == 0)
      h = pc_n;
  }
  else
  {
    h = __dos32_dos_buffer;
  }

  len = strlen (h);
  if (len + 1 > size)
  {
    errno = ERANGE;
    return -1;
  }
  strcpy (buf, h);
  return 0;
}


