/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <errno.h>
#include <sys/vfs.h>
#include <ctype.h>

int
statfs(const char *path, struct statfs *buf)
{
  int drive_number;
  unsigned short a,b,c,d;

  /* Get the drive number */
  if (isalpha(path[0]) && path[1] == ':')
    drive_number = (path[0] & 0x1f) - 1;
  else
  {
    asm("movb $0x19,%%ah\n\
         int  $0x21\n\
         movb %%al,%b0"
         : "=qm" (drive_number)
         :
         : "eax");
  }

  /* Get free space info */
  asm ("movb $0x36,%%ah\n\
        movb %b4,%%dl\n\
        int  $0x21\n\
        movw %%ax,%w0\n\
        movw %%bx,%w1\n\
        movw %%cx,%w2\n\
        movw %%dx,%w3"
        : "=g" (a), "=g" (b), "=g" (c), "=g" (d)
        : "qm" (drive_number+1)
        : "eax","ebx","ecx","edx");
  /* Check for errors */
  if (a == 0xffff)
  {
    errno = ENODEV;
    return -1;
  }

  /* Fill in the structure */
  buf->f_bavail = b;
  buf->f_bfree = b;
  buf->f_blocks = d;
  buf->f_bsize = c * a;
  buf->f_ffree = b;
  buf->f_files = d;
  buf->f_type = 0;
  buf->f_fsid[0] = drive_number;
  buf->f_fsid[1] = MOUNT_UFS;
  buf->f_magic = FS_MAGIC;

  return 0;
}
