/*             Power Assembly Library  C header file            */

typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned long ulong;
typedef void *pvoid;
typedef char *pchar;


#define  PAL_H

#ifndef FASTCALLS
#define _fastcall
#endif


#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************
 *       STARTUP
 ***************************************************************************/
extern ulong dos32version;       /* version of DOS32.                      */
extern char  dos32system;        /* system type-RAW,XMS,VCPI or DPMI       */
extern ulong exesize;            /* size in bytes                          */
extern char * exename;           /* PSZ to executable name                 */
extern pvoid _psp;               /* program segment prefix pointer         */
extern char *_environ;           /* environment pointer                    */
extern char **environ;           /* pointer of environment pointer table   */
extern ulong envsize;            /* environment table size                 */
extern pvoid _zero;              /* zero pointer                           */
extern ulong _zero_sel;          /* selector of zero based semgnet         */
extern char **_argv;             /* pointer to array of cmd line pointers  */
extern ulong _argc;              /* numnber of pointers in command line list */

extern pvoid DMA_addr;            /* DMA near pointer address         */
extern ulong DMA_size;            /* DMA buffer size                  */
extern pvoid DMA_phys;            /* DMA physical address             */


/****************************************************************************
 * FILEIO - file I/O
 ***************************************************************************/
extern long _fastcall chdir(pchar path);
extern long _fastcall close(long handle);
extern long _fastcall filelength(long handle);
extern long fprint(long handle,pchar fmtstr,...);
extern long _fastcall lseek(long handle,long filepos,long whence);
extern long _fastcall mkdir(pchar path);
extern long _fastcall open(pchar filename,ulong filemode);
extern long _fastcall read(long handle,pvoid buf,ulong len);
extern long _fastcall rename(pchar oldname,pchar newname);
extern long _fastcall rmdir(pchar path);
extern long _fastcall unlink(pchar filename);
extern long _fastcall write(long handle,pvoid buf,ulong len);
extern long _fastcall creat(pchar filename, long filemode);
extern pchar _fastcall getcwd(char *buf, long buflen);
extern pchar _fastcall _getdcwd(int drive, char *buf, long buflen);
extern long _fastcall getcurdir(int drive, char *directory);
extern long _fastcall getdisk(void);
extern long _fastcall setdisk(long drive);



#define O_BINARY   0          /* Binary mode                                 */
#define O_RDONLY   0          /* Read only                                   */
#define O_WRONLY   1          /* Write only                                  */
#define O_RDWR     2          /* Read and write                              */
#define O_APPEND   4          /* File pointer will be set to the end of file */
#define O_CREAT    8          /* Creates the file if it doesn't exist        */
#define O_TRUNC    16	      /* Truncate the file when open                 */
#define O_EXCL     32         /* Returns an error if file exists (O_CREAT)   */

#define SEEK_SET   0          /* Seek from file beginning                    */
#define SEEK_CUR   1          /* Seek from current file position             */
#define SEEK_END   2          /* Seek from end of file                       */


/* compatibility with other compilers */
#define remove(s)      unlink(s)

/*****************************************************************************
 * MALLOC - memory allocation
 ****************************************************************************/
extern pvoid _fastcall malloc(ulong blocksize);
extern pvoid _fastcall calloc(ulong blocksize,ulong items);
extern void _fastcall free(pvoid blockptr);
extern ulong maxavail(void);
extern ulong memavail(void);
extern pvoid _fastcall realloc(pvoid blockptr,ulong size);
extern pvoid _fastcall resize(pvoid blockptr,ulong size);


/*****************************************************************************
 *   MATH - math functions
 ****************************************************************************/
extern ulong _fastcall max(ulong a,ulong b);
extern ulong _fastcall max3(ulong a,ulong b,ulong c);
extern ulong _fastcall min(ulong a,ulong b);
extern ulong _fastcall max3(ulong a,ulong b,ulong c);
extern ulong _fastcall atoi(pchar string);


/*****************************************************************************
 * STRINGS - various string I/O
 ****************************************************************************/
extern ulong _fastcall isdigit(char chr);
extern ulong _fastcall isxdigit(char chr);
extern ulong _fastcall isalpha(char chr);
extern ulong _fastcall islower(char chr);
extern ulong _fastcall isupper(char chr);
extern ulong _fastcall isalnum(char chr);
extern ulong _fastcall iscntrl(char chr);
extern ulong _fastcall isspace(char chr);
extern ulong _fastcall ispunct(char chr);
extern ulong _fastcall isascii(char chr);
extern ulong _fastcall isprint(char chr);
extern ulong _fastcall toupper(char chr);
extern ulong _fastcall tolower(char chr);

extern pchar _fastcall btoa(ulong value,pchar string);
extern pchar _fastcall ltoa(long value,pchar string,int radix);
extern pchar _fastcall ultoa(ulong value,pchar string,int radix);
extern pchar _fastcall otoa(ulong value,pchar string);
extern pchar _fastcall xtoa(ulong value,pchar string);
extern pchar _fastcall ptos(pvoid pascalstr);
extern ulong sprintf(pchar dest,pchar fmtstr,...);
extern pchar _fastcall stpcpy(pchar dest,pchar source);
extern pchar _fastcall strcat(pchar dest,pchar source);
extern pchar _fastcall strchr(pchar string,char chr);
extern pchar _fastcall strchrn(char string,char chr);
extern pchar _fastcall strcpy(const char *,const char *);
extern pchar _fastcall strdup(pchar string);
extern int _fastcall strcmp(const char *,const char * );
extern long _fastcall strncmp(pchar srcptr,pchar destptr,long max_len);
extern long _fastcall stricmp(pchar srcptr,pchar destptr);
extern ulong _fastcall strlen(pchar string);
extern pchar _fastcall strlwr(pchar string);
extern pchar _fastcall strupr(pchar string);
extern pchar _fastcall strncpy(pchar dest,pchar source,ulong length);
extern pchar _fastcall strpbrk(pchar s1,pchar s2);

/* compatibility with other compilers */
#define strcmpi(s1,s2)      stricmp(s1,s2)
#define strncmpi(s1,s2,n)   strnicmp(s1,s2,n)

/**************************************************************************
 * CONIO - console I/O
 *************************************************************************/

extern long printf(pchar fmtstr,...);
extern long kbhit(void);


/**************************************************************************
 * STREAMS - file stream I/O
 *************************************************************************/

#define BUFSIZ 2048
#define _IOFBF  0
#define _IOLBF	1
#define _IONBF	2


typedef struct {
uchar   _mode;
uchar   _type;
short   _handle;	 /* DOS 16bit file handle            */
ulong   _size;	         /* current size of buffer           */
ulong   _buffersize;     /* maximum size of buffer           */
ulong   _position;       /* Current active position in buffer*/
ulong   _base;	         /* pointer to data transfer buffer  */
} FILE;



extern FILE _stdin_fstream;
extern FILE _stdout_fstream;
extern FILE _stderr_fstream;
extern FILE _stdaux_fstream;
extern FILE _stdprn_fstream;


#define stdin  &_stdin_fstream           /* Standard input file ptr    */
#define stdout &_stdout_fstream          /* Standard output file ptr   */
#define stderr &_stderr_fstream          /* Standard error file ptr    */
#define stdaux &_stdaux_fstream          /* Standard auxilary file ptr */
#define stdprn &_stdprn_fstream          /* Standard printer file ptr  */


#define  getc fgetc
#define  putc fputc
#define  getchar() fgetc(stdin)
#define  putchar(c) fputc((c),stdout)
#define  rewind(c) fseek((c),0,SEEK_SET)

extern long fprintf(FILE * stream, pchar fmtstr,...);
extern FILE* _fastcall fopen(const char *, const char *);
extern FILE* _fastcall freopen(const char *, const char * ,FILE *);
extern long _fastcall fclose(FILE * file_pointer);
extern long _fastcall fcloseall(void);
extern long _fastcall fread(void * e, ulong _size, int count, FILE *fileptr);
extern long _fastcall fwrite(void * e, ulong _size, int count, FILE *fileptr);
extern long _fastcall fgetc(FILE * stream);
extern long _fastcall fputc(char , FILE *);
extern char* _fastcall fgets(char *s, int n, FILE *stream);
extern long _fastcall fputs(FILE * stream);
extern long _fastcall fflush(FILE * stream);
extern long _fastcall fflushall(void);
extern long _fastcall fseek(FILE * file_pointer, int offset, int whence );
extern long _fastcall ftell(FILE * file_pointer);
extern long _fastcall setvbuf(FILE *stream, uchar *buf, ulong type, ulong size_t);
extern void _fastcall setbuf(FILE *stream, char *buf);


/*****************************************************************************
 * SYSTEM - system specific
 ****************************************************************************/
extern void abort(void);
extern ulong _fastcall atexit(pvoid exitfunc);
extern void _fastcall exit(int errorlevel);
extern pvoid _fastcall _getfarptr(pvoid PTR, char type);
extern pvoid _fastcall getvect(ulong _int);
extern pvoid _fastcall setvect(ulong _int, pvoid vect);
extern ulong _fastcall MK_FP(pvoid address);
extern pvoid _fastcall MK_FAR(ulong);
extern void _fastcall memset(pvoid buf,char value,ulong length);
extern pvoid _fastcall memcpy(const void * dest,const void *,int length);
extern int _fastcall memcmp(void * dest,void * source,int length);
extern pvoid _fastcall memmove(void * dest, void * source, ulong count);
extern void _fastcall _exit(ulong errorlevel);
extern void _fastcall _cexit(void);
extern pvoid _fastcall getenv(char * name);
extern int _fastcall inp(unsigned portid);
extern unsigned _fastcall inpw(unsigned portid);
extern int _fastcall outp(unsigned portid, int value);
extern unsigned _fastcall outpw(unsigned portid, unsigned value);
extern pvoid _fastcall loadlibrary(char* filename, int seekset);
extern int _fastcall GetLibrarySize(void);

extern long errno;                      /* System error code */
extern char ctrl_break_count;           /* number of time it's been pushed */


#ifdef __cplusplus
}
#endif


/******************************************************************************
  *  Standed macros
******************************************************************************/
#define  EOF  -1
#define  NULL  0
#define  EXIT_SUCCESS 0
#define  EXIT_FAILURE 1




