;

;
; Main Routines for FXVMM
;

	TITLE  FXVMM_API

	.386p
	.387

;

FXVMM_API_TEXT	SEGMENT	BYTE public USE16 'CODE'
FXVMM_API_TEXT	ENDS

_DATA	SEGMENT	WORD public USE16 'DATA'
_DATA	ENDS

_BSS	SEGMENT	WORD public USE16 'BSS'
_BSS	ENDS

DGROUP	GROUP	_DATA, _BSS

;[Includes]

include ..\source.asm\_fxvmm.inc

;[Externals]

	extrn		_free:NEAR
	extrn		_malloc:NEAR
	extrn		_exit:NEAR
	extrn		_memcpy:NEAR
	extrn		_puts:NEAR
	extrn		F_SCOPY@:NEAR

;[Publics]

	public	 __fxvmm_initialize
	public	 __fxvmm_vermajor
	public	 __fxvmm_verminor
	public	 __fxvmm_error
	public	 __fxvmm_splitnode
	public	 __fxvmm_alloc
	public	 __fxvmm_realloc
	public	 __fxvmm_free
	public	 __fxvmm_deinitialize
	public	 __fxvmm_absread
	public	 __fxvmm_read
	public	 __fxvmm_abswrite
	public	 __fxvmm_write
	public	 __fxvmm_absmove
	public	 __fxvmm_move
	public	 __fxvmm_setpos
	public	 __fxvmm_set_strategy

	public	 _fxvmm_global_xms_handle
	public	 _fxvmm_global_ems_handle
	public	 _fxvmm_global_vrt_handle
	public	 _fxvmm_global_dos_handle

	public	 _fxvmm_bufsource
	public	 _fxvmm_firstblk
	public	 _fxvmm_error_code

FXVMM_API_TEXT	SEGMENT
	assume	cs: FXVMM_API_TEXT

;[CODE]

__fxvmm_vermajor:
	mov  al, FXVMM_VERSION_MAJOR
	retf

;

__fxvmm_verminor:
	mov  al, FXVMM_VERSION_MINOR
	retf

;

__fxvmm_initialize:           ; we don't have to anything here
        xor al,al             ; just return TRUE
        mov al, TRUE          ;
	retf

;

__fxvmm_error:                                ; error code procedure
	push	bp
	mov	bp,sp
	sub	sp,+002h
	assume	ds: DGROUP
	mov	ax,_fxvmm_error_code
	mov	[bp-002h],ax
	mov	word ptr _fxvmm_error_code,0000h
	mov	ax,[bp-002h]
	mov	sp,bp
	pop	bp
	retf

;

__fxvmm_splitnode:
	push	bp
	mov	bp,sp
	les	bx,dword ptr [bp+00Ah]
	mov	ax,es:[bx+005h]
	mov	dx,es:[bx+003h]
	cmp	ax,[bp+010h]
	jnz	@@L1
	cmp	dx,[bp+00Eh]
	jnz	@@L1
	les	bx,dword ptr [bp+00Ah]
	or	byte ptr es:[bx+002h],80h
	les	bx,dword ptr [bp+006h]
	mov	word ptr es:[bx],0EDCBh
	push	word ptr [bp+008h]
	push	word ptr [bp+006h]
	call	far ptr _free
	add	sp,+004h
	pop	bp
	retf
@@L1:	push	word ptr [bp+008h]
	push	word ptr [bp+006h]
	push	word ptr [bp+00Ch]
	push	word ptr [bp+00Ah]
	mov	cx,001Bh
	call	far ptr F_SCOPY@
	les	bx,dword ptr [bp+006h]
	and	byte ptr es:[bx+002h],7Fh
	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	mov	_fxvmm_tmpval01,ax
	mov	_fxvmm_rovblock,dx
	les	bx,dword ptr [bp+00Ah]
	mov	ax,es:[bx+00Dh]
	mov	dx,es:[bx+00Bh]
	les	bx,dword ptr [bp+006h]
	mov	es:[bx+00Dh],ax
	mov	es:[bx+00Bh],dx
	mov	ax,[bp+00Ch]
	mov	dx,[bp+00Ah]
	cmp	ax,_fxvmm_tmpval02
	jnz	@@L4
	cmp	dx,_fxvmm_last
	jnz	@@L4
	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	mov	_fxvmm_tmpval02,ax
	mov	_fxvmm_last,dx
@@L4:	les	bx,dword ptr [bp+00Ah]
	mov	ax,es:[bx+00Bh]
	or	ax,es:[bx+00Dh]
	jz	@@L5
	les	bx,dword ptr [bp+00Ah]
	les	bx,dword ptr es:[bx+00Bh]
	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	mov	es:[bx+011h],ax
	mov	es:[bx+00Fh],dx
@@L5:	les	bx,dword ptr [bp+006h]
	mov	ax,[bp+00Ch]
	mov	dx,[bp+00Ah]
	mov	es:[bx+011h],ax
	mov	es:[bx+00Fh],dx
	les	bx,dword ptr [bp+00Ah]
	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	mov	es:[bx+00Dh],ax
	mov	es:[bx+00Bh],dx
	les	bx,dword ptr [bp+00Ah]
	mov	ax,es:[bx+005h]
	mov	dx,es:[bx+003h]
	sub	dx,[bp+00Eh]
	sbb	ax,[bp+010h]
	les	bx,dword ptr [bp+006h]
	mov	es:[bx+005h],ax
	mov	es:[bx+003h],dx
	les	bx,dword ptr [bp+00Ah]
	mov	ax,[bp+010h]
	mov	dx,[bp+00Eh]
	mov	es:[bx+005h],ax
	mov	es:[bx+003h],dx
	les	bx,dword ptr [bp+00Ah]
	or	byte ptr es:[bx+002h],80h
	les	bx,dword ptr [bp+006h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	cmp	ax,_fxvmm_global_vrt_handle
	jnz	@@L6
	les	bx,dword ptr [bp+00Ah]
	mov	ax,es:[bx+015h]
	mov	dx,es:[bx+013h]
	add	dx,[bp+00Eh]
	adc	ax,[bp+010h]
	les	bx,dword ptr [bp+006h]
	mov	es:[bx+015h],ax
	mov	es:[bx+013h],dx
	pop	bp
	retf
@@L6:	les	bx,dword ptr [bp+00Ah]
	mov	ax,es:[bx+019h]
	mov	dx,es:[bx+017h]
	add	dx,[bp+00Eh]
	adc	ax,[bp+010h]
	les	bx,dword ptr [bp+006h]
	mov	es:[bx+019h],ax
	mov	es:[bx+017h],dx
	pop	bp
	retf

;

__fxvmm_alloc:
	push	bp
	mov	bp,sp
	sub	sp,+008h
	push	si
	mov	ax,_fxvmm_tmpval03
	or	ax,_fxvmm_tmpval04
	jnz	@@L9
	les	bx,dword ptr _fxvmm_dosalptr
	mov	ax,es:[bx+002h]
	mov	dx,es:[bx]
	mov	_fxvmm_tmpval04,ax
	mov	_fxvmm_tmpval03,dx
	jmp	short @@L11
@@L9:	les	bx,dword ptr _fxvmm_dosalptr
	mov	ax,es:[bx+002h]
	mov	dx,es:[bx]
	sub	dx,_fxvmm_tmpval03
	sbb	ax,_fxvmm_tmpval04
	or	ax,ax
@@L11:	mov	ax,[bp+006h]
	or	ax,[bp+008h]
	jnz	@@L14
	jmp	@@L15
@@L14:	mov	ax,001Bh
	push	ax
	call	far ptr _malloc
	add	sp,+002h
	mov	[bp-002h],dx
	mov	[bp-004h],ax
	mov	ax,[bp-004h]
	or	ax,[bp-002h]
	jnz	@@L16
	jmp	@@L17
@@L16:	les	bx,dword ptr [bp-004h]
	mov	word ptr es:[bx],0FEDCh
	mov	ax,_fxvmm_rovblock
	or	ax,_fxvmm_tmpval01
	jz	@@L18
	les	bx,dword ptr _fxvmm_rovblock
	mov	ax,es:[bx+005h]
	mov	dx,es:[bx+003h]
	cmp	ax,[bp+008h]
	jc	@@L18
	jnz	@@L19
	cmp	dx,[bp+006h]
	jc	@@L18
@@L19:	mov	ax,_fxvmm_tmpval01
	mov	dx,_fxvmm_rovblock
	mov	[bp-006h],ax
	mov	[bp-008h],dx
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	push	_fxvmm_tmpval01
	push	_fxvmm_rovblock
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	push	cs
	call	__fxvmm_splitnode
	add	sp,+00Ch
	mov	dx,[bp-006h]
	mov	ax,[bp-008h]
	pop	si
	mov	sp,bp
	pop	bp
	retf
@@L18:	les	bx,dword ptr [bp-004h]
	mov	word ptr es:[bx+005h],0000h
	mov	word ptr es:[bx+003h],0000h
	xor	si,si
	jmp	short @@L20
@@L24:	mov	ax,si
	mov	dx,001Ah
	imul	dx
	mov	bx,ax
	cmp	word ptr [bx+_fxvmm_bufsource],+000h
	jz	@@L21
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	mov	ax,si
	mov	dx,001Ah
	imul	dx
	mov	bx,ax
	call	dword ptr [bx+_fxvmm_tmpval05]
	add	sp,+008h
	or	ax,ax
	jnz	@@L23
@@L21:	inc	si
@@L20:	cmp	si,+004h
	jl	@@L24
@@L23:	les	bx,dword ptr [bp-004h]
	mov	ax,es:[bx+003h]
	or	ax,es:[bx+005h]
	jnz	@@L25
	jmp	@@L26
@@L25:	les	bx,dword ptr [bp-004h]
	or	byte ptr es:[bx+002h],80h
	mov	ax,_fxvmm_firstblk
	or	ax,_fxvmm_tmpval09
	jnz	@@L28
	mov	ax,[bp-002h]
	mov	dx,[bp-004h]
	mov	_fxvmm_tmpval02,ax
	mov	_fxvmm_last,dx
	mov	_fxvmm_tmpval09,ax
	mov	_fxvmm_firstblk,dx
	les	bx,dword ptr [bp-004h]
	xor	ax,ax
	xor	dx,dx
	mov	es:[bx+011h],ax
	mov	es:[bx+00Fh],dx
	les	bx,dword ptr [bp-004h]
	mov	es:[bx+00Dh],ax
	mov	es:[bx+00Bh],dx
	jmp	short @@L29
@@L28:	les	bx,dword ptr [bp-004h]
	mov	ax,_fxvmm_tmpval02
	mov	dx,_fxvmm_last
	mov	es:[bx+011h],ax
	mov	es:[bx+00Fh],dx
	les	bx,dword ptr _fxvmm_last
	mov	ax,[bp-002h]
	mov	dx,[bp-004h]
	mov	es:[bx+00Dh],ax
	mov	es:[bx+00Bh],dx
	les	bx,dword ptr [bp-004h]
	mov	word ptr es:[bx+00Dh],0000h
	mov	word ptr es:[bx+00Bh],0000h
	mov	ax,[bp-002h]
	mov	dx,[bp-004h]
	mov	_fxvmm_tmpval02,ax
	mov	_fxvmm_last,dx
@@L29:	les	bx,dword ptr [bp-004h]
	mov	ax,es:[bx+005h]
	mov	dx,es:[bx+003h]
	cmp	ax,[bp+008h]
	jnc	@@L30
	jmp	@@L17
@@L30:	jnbe	@@L31
	cmp	dx,[bp+006h]
	jnbe	@@L31
	jmp	@@L17
@@L31:	mov	ax,001Bh
	push	ax
	call	far ptr _malloc
	add	sp,+002h
	mov	[bp-006h],dx
	mov	[bp-008h],ax
	mov	ax,[bp-008h]
	or	ax,[bp-006h]
	jz	@@L32
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	push    word ptr [bp-006h]
	push    word ptr [bp-008h]
	push	cs
	call	__fxvmm_splitnode
	add	sp,+00Ch
	les	bx,dword ptr [bp-008h]
	mov	word ptr es:[bx],0FEDCh
@@L32:	mov	dx,[bp-002h]
	mov	ax,[bp-004h]
	pop	si
	mov	sp,bp
	pop	bp
	retf
	jmp	@@L17
@@L26:	mov	ax,_fxvmm_tmpval09
	mov	dx,_fxvmm_firstblk
	mov	[bp-006h],ax
	mov	[bp-008h],dx
	jmp	short @@L33
@@L36:	les	bx,dword ptr [bp-008h]
	mov	al,es:[bx+002h]
	mov	cl,07h
	shr	ax,cl
	and	ax,0001h
	or	ax,ax
	jnz	@@L34
	les	bx,dword ptr [bp-008h]
	mov	ax,es:[bx+005h]
	mov	dx,es:[bx+003h]
	cmp	ax,[bp+008h]
	jc	@@L34
	jnz	@@L35
	cmp	dx,[bp+006h]
	jc	@@L34
@@L35:	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	push    word ptr [bp-006h]
	push    word ptr [bp-008h]
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	push	cs
	call	__fxvmm_splitnode
	add	sp,+00Ch
	mov	dx,[bp-006h]
	mov	ax,[bp-008h]
	pop	si
	mov	sp,bp
	pop	bp
	retf
@@L34:	les	bx,dword ptr [bp-008h]
	mov	ax,es:[bx+00Dh]
	mov	dx,es:[bx+00Bh]

	mov	[bp-006h],ax
	mov	[bp-008h],dx
@@L33:	mov	ax,[bp-008h]
	or	ax,[bp-006h]
	jnz	@@L36
	les	bx,dword ptr [bp-004h]
	mov	word ptr es:[bx],0EDCBh
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	call	far ptr _free
	add	sp,+004h
	xor	dx,dx
	xor	ax,ax
	pop	si
	mov	sp,bp
	pop	bp
	retf
@@L17:	mov	dx,[bp-002h]
	mov	ax,[bp-004h]
	pop	si
	mov	sp,bp
	pop	bp
	retf
@@L15:	xor	dx,dx
	xor	ax,ax
	pop	si
	mov	sp,bp
	pop	bp
	retf

;

__fxvmm_realloc:
	push	bp
	mov	bp,sp
	sub	sp,+008h
	push	si
	mov	ax,[bp+00Ah]
	or	ax,[bp+00Ch]
	jnz	@@L37
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	call	far ptr FXVMM_API_TEXT:__fxvmm_free
	add	sp,+004h
	xor	dx,dx
	xor	ax,ax
	pop	si
	mov	sp,bp
	pop	bp
	retf
@@L37:	mov	ax,[bp+006h]
	or	ax,[bp+008h]
	jnz	@@L38
	push    word ptr [bp+00Ch]
	push    word ptr [bp+00Ah]
	push	cs
	call	__fxvmm_alloc
	add	sp,+004h
	pop	si
	mov	sp,bp
	pop	bp
	retf
@@L38:	mov	ax,001Bh
	push	ax
	call	far ptr _malloc
	add	sp,+002h
	mov	[bp-002h],dx
	mov	[bp-004h],ax
	mov	ax,[bp-004h]
	or	ax,[bp-002h]
	jnz	@@L39
	jmp	@@L40
@@L39:	les	bx,dword ptr [bp-004h]
	mov	word ptr es:[bx],0FEDCh
	mov	ax,[bp+006h]
	or	ax,[bp+008h]
	jz	@@L41
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+005h]
	mov	dx,es:[bx+003h]
	cmp	ax,[bp+00Ch]
	jc	@@L41
	jnz	@@L42
	cmp	dx,[bp+00Ah]
	jc	@@L41
@@L42:	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	mov	[bp-006h],ax
	mov	[bp-008h],dx
	push    word ptr [bp+00Ch]
	push    word ptr [bp+00Ah]
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	push	cs
	call	__fxvmm_splitnode
	add	sp,+00Ch
	mov	dx,[bp-006h]
	mov	ax,[bp-008h]
	pop	si
	mov	sp,bp
	pop	bp
	retf
@@L41:	les	bx,dword ptr [bp-004h]
	mov	word ptr es:[bx+005h],0000h
	mov	word ptr es:[bx+003h],0000h
	xor	si,si
	jmp	short @@L43
@@L46:	mov	ax,si
	mov	dx,001Ah
	imul	dx
	mov	bx,ax
	cmp	word ptr [bx+_fxvmm_bufsource],+000h
	jz	@@L44
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	push    word ptr [bp+00Ch]
	push    word ptr [bp+00Ah]
	mov	ax,si
	mov	dx,001Ah
	imul	dx
	mov	bx,ax
	call	dword ptr [bx+_fxvmm_tmpval05]
	add	sp,+008h
	or	ax,ax
	jnz	@@L45
@@L44:	inc	si
@@L43:	cmp	si,+004h
	jl	@@L46
@@L45:	les	bx,dword ptr [bp-004h]
	mov	ax,es:[bx+003h]
	or	ax,es:[bx+005h]
	jnz	@@L47
	jmp	@@L48
@@L47:	les	bx,dword ptr [bp-004h]
	or	byte ptr es:[bx+002h],80h
	mov	ax,_fxvmm_firstblk
	or	ax,_fxvmm_tmpval09
	jnz	@@L49
	mov	ax,[bp-002h]
	mov	dx,[bp-004h]
	mov	_fxvmm_tmpval02,ax
	mov	_fxvmm_last,dx
	mov	_fxvmm_tmpval09,ax
	mov	_fxvmm_firstblk,dx
	les	bx,dword ptr [bp-004h]
	xor	ax,ax
	xor	dx,dx
	mov	es:[bx+011h],ax
	mov	es:[bx+00Fh],dx
	les	bx,dword ptr [bp-004h]
	mov	es:[bx+00Dh],ax
	mov	es:[bx+00Bh],dx
	jmp	short @@L50
@@L49:	les	bx,dword ptr [bp-004h]
	mov	ax,_fxvmm_tmpval02
	mov	dx,_fxvmm_last
	mov	es:[bx+011h],ax
	mov	es:[bx+00Fh],dx
	les	bx,dword ptr _fxvmm_last
	mov	ax,[bp-002h]
	mov	dx,[bp-004h]
	mov	es:[bx+00Dh],ax
	mov	es:[bx+00Bh],dx
	les	bx,dword ptr [bp-004h]
	mov	word ptr es:[bx+00Dh],0000h
	mov	word ptr es:[bx+00Bh],0000h
	mov	ax,[bp-002h]
	mov	dx,[bp-004h]
	mov	_fxvmm_tmpval02,ax
	mov	_fxvmm_last,dx
@@L50:	les	bx,dword ptr [bp-004h]
	mov	ax,es:[bx+005h]
	mov	dx,es:[bx+003h]
	cmp	ax,[bp+00Ch]
	jnc	@@L51
	jmp	@@L40
@@L51:	jnbe	@@L52
	cmp	dx,[bp+00Ah]
	jnbe	@@L52
	jmp	@@L40
@@L52:	mov	ax,001Bh
	push	ax
	call	far ptr _malloc
	add	sp,+002h
	mov	[bp-006h],dx
	mov	[bp-008h],ax
	mov	ax,[bp-008h]
	or	ax,[bp-006h]
	jz	@@L53
	push    word ptr [bp+00Ch]
	push    word ptr [bp+00Ah]
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	push    word ptr [bp-006h]
	push    word ptr [bp-008h]
	push	cs
	call	__fxvmm_splitnode
	add	sp,+00Ch
	les	bx,dword ptr [bp-008h]
	mov	word ptr es:[bx],0FEDCh
@@L53:	mov	dx,[bp-002h]
	mov	ax,[bp-004h]
	pop	si
	mov	sp,bp
	pop	bp
	retf
	jmp	@@L40
@@L48:	mov	ax,_fxvmm_tmpval09
	mov	dx,_fxvmm_firstblk
	mov	[bp-006h],ax
	mov	[bp-008h],dx
	jmp	short @@L54
@@L57:	les	bx,dword ptr [bp-008h]
	mov	al,es:[bx+002h]
	mov	cl,07h
	shr	ax,cl
	and	ax,0001h
	or	ax,ax
	jnz	@@L55
	les	bx,dword ptr [bp-008h]
	mov	ax,es:[bx+005h]
	mov	dx,es:[bx+003h]
	cmp	ax,[bp+00Ch]
	jc	@@L55
	jnz	@@L56
	cmp	dx,[bp+00Ah]
	jc	@@L55
@@L56:	push    word ptr [bp+00Ch]
	push    word ptr [bp+00Ah]
	push    word ptr [bp-006h]
	push    word ptr [bp-008h]
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	push	cs
	call	__fxvmm_splitnode
	add	sp,+00Ch
	mov	dx,[bp-006h]
	mov	ax,[bp-008h]
	pop	si
	mov	sp,bp
	pop	bp
	retf
@@L55:	les	bx,dword ptr [bp-008h]
	mov	ax,es:[bx+00Dh]
	mov	dx,es:[bx+00Bh]
	mov	[bp-006h],ax
	mov	[bp-008h],dx
@@L54:	mov	ax,[bp-008h]
	or	ax,[bp-006h]
	jnz	@@L57
	les	bx,dword ptr [bp-004h]
	mov	word ptr es:[bx],0EDCBh
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	call	far ptr _free
	add	sp,+004h
	xor	dx,dx
	xor	ax,ax
	pop	si
	mov	sp,bp
	pop	bp
	retf
@@L40:	mov	dx,[bp-002h]
	mov	ax,[bp-004h]
	pop	si
	mov	sp,bp
	pop	bp
	retf

;

__fxvmm_free:
	push	bp
	mov	bp,sp
	sub	sp,+004h
	les	bx,dword ptr [bp+006h]
	cmp	word ptr es:[bx],0EDCBh
	jnz	@@L58
	mov	ax,0FFFFh
	mov	sp,bp
	pop	bp
	retf
@@L58:	les	bx,dword ptr [bp+006h]
	cmp	word ptr es:[bx],0FEDCh
	jz	@@L59
	mov	ax,0FFFEh
	mov	sp,bp
	pop	bp
	retf
@@L59:	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Bh]
	or	ax,es:[bx+00Dh]
	jnz	@@L60
	jmp	@@L61
@@L60:	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	mov	al,es:[bx+002h]
	mov	cl,07h
	shr	ax,cl
	and	ax,0001h
	or	ax,ax
	jz	@@L62
	jmp	@@L61
@@L62:	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	les	bx,dword ptr [bp+006h]
	mov	dl,es:[bx+002h]
	and	dx,+07Fh
	cmp	ax,dx
	jz	@@L63
	jmp	@@L61
@@L63:	les	bx,dword ptr [bp+006h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	cmp	ax,_fxvmm_global_xms_handle
	jnz	@@L64
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+013h]
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	cmp	ax,es:[bx+013h]
	jz	@@L64
	jmp	@@L61
@@L64:	les	bx,dword ptr [bp+006h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	cmp	ax,_fxvmm_global_ems_handle
	jnz	@@L65
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+013h]
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	cmp	ax,es:[bx+013h]
	jz	@@L65
	jmp	@@L61
@@L65:	les	bx,dword ptr [bp+006h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	cmp	ax,_fxvmm_global_dos_handle
	jnz	@@L66
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+015h]
	mov	dx,es:[bx+013h]
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	cmp	ax,es:[bx+015h]
	jz	@@L67
	jmp	@@L61
@@L67:	cmp	dx,es:[bx+013h]
	jz	@@L66
	jmp	@@L61
@@L66:	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Dh]
	mov	dx,es:[bx+00Bh]
	cmp	ax,_fxvmm_tmpval02
	jnz	@@L68
	cmp	dx,_fxvmm_last
	jnz	@@L68
	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	mov	_fxvmm_tmpval02,ax
	mov	_fxvmm_last,dx
@@L68:	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Dh]
	mov	dx,es:[bx+00Bh]
	cmp	ax,_fxvmm_tmpval09
	jnz	@@L69
	cmp	dx,_fxvmm_firstblk

	jnz	@@L69
	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	mov	_fxvmm_tmpval09,ax
	mov	_fxvmm_firstblk,dx
@@L69:	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	mov	ax,es:[bx+005h]
	mov	dx,es:[bx+003h]
	les	bx,dword ptr [bp+006h]
	add	es:[bx+003h],dx
	adc	es:[bx+005h],ax
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Dh]
	mov	dx,es:[bx+00Bh]
	mov	[bp-002h],ax
	mov	[bp-004h],dx
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	mov	word ptr es:[bx],0EDCBh
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	mov	ax,es:[bx+00Dh]
	mov	dx,es:[bx+00Bh]
	les	bx,dword ptr [bp+006h]
	mov	es:[bx+00Dh],ax
	mov	es:[bx+00Bh],dx
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Bh]
	or	ax,es:[bx+00Dh]
	jz	@@L70
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	mov	es:[bx+011h],ax
	mov	es:[bx+00Fh],dx
@@L70:	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	call	far ptr _free
	add	sp,+004h
@@L61:	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Fh]
	or	ax,es:[bx+011h]
	jnz	@@L71
	jmp	@@L72
@@L71:	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Fh]
	mov	al,es:[bx+002h]
	mov	cl,07h
	shr	ax,cl
	and	ax,0001h
	or	ax,ax
	jz	@@L73
	jmp	@@L72
@@L73:	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Fh]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	les	bx,dword ptr [bp+006h]
	mov	dl,es:[bx+002h]
	and	dx,+07Fh
	cmp	ax,dx
	jz	@@L74
	jmp	@@L72
@@L74:	les	bx,dword ptr [bp+006h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	cmp	ax,_fxvmm_global_xms_handle
	jnz	@@L75
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+013h]
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Fh]
	cmp	ax,es:[bx+013h]
	jz	@@L75
	jmp	@@L72
@@L75:	les	bx,dword ptr [bp+006h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	cmp	ax,_fxvmm_global_ems_handle
	jnz	@@L76
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+013h]
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Fh]
	cmp	ax,es:[bx+013h]
	jz	@@L76
	jmp	@@L72
@@L76:	les	bx,dword ptr [bp+006h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	cmp	ax,_fxvmm_global_dos_handle
	jnz	@@L77
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+015h]
	mov	dx,es:[bx+013h]
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Fh]
	cmp	ax,es:[bx+015h]
	jz	@@L78
	jmp	@@L72
@@L78:	cmp	dx,es:[bx+013h]
	jz	@@L77
	jmp	@@L72
@@L77:	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	cmp	ax,_fxvmm_tmpval02
	jnz	@@L79
	cmp	dx,_fxvmm_last
	jnz	@@L79
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+011h]
	mov	dx,es:[bx+00Fh]
	mov	_fxvmm_tmpval02,ax
	mov	_fxvmm_last,dx
@@L79:	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	cmp	ax,_fxvmm_tmpval09
	jnz	@@L80
	cmp	dx,_fxvmm_firstblk
	jnz	@@L80
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+011h]
	mov	dx,es:[bx+00Fh]
	mov	_fxvmm_tmpval09,ax
	mov	_fxvmm_firstblk,dx
@@L80:	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+005h]
	mov	dx,es:[bx+003h]
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Fh]
	add	es:[bx+003h],dx
	adc	es:[bx+005h],ax
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Dh]
	mov	dx,es:[bx+00Bh]
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Fh]
	mov	es:[bx+00Dh],ax
	mov	es:[bx+00Bh],dx
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Bh]
	or	ax,es:[bx+00Dh]
	jz	@@L81
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+011h]
	mov	dx,es:[bx+00Fh]
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	mov	es:[bx+011h],ax
	mov	es:[bx+00Fh],dx
@@L81:	les	bx,dword ptr [bp+006h]
	mov	word ptr es:[bx],0EDCBh
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	call	far ptr _free
	add	sp,+004h
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+011h]
	mov	dx,es:[bx+00Fh]
	mov	[bp+008h],ax
	mov	[bp+006h],dx
@@L72:	les	bx,dword ptr [bp+006h]
	and	byte ptr es:[bx+002h],7Fh
	les	bx,dword ptr [bp+006h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	cmp	ax,_fxvmm_global_vrt_handle
	jnz	@@L82
	jmp	@@L83
@@L82:	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+017h]
	or	ax,es:[bx+019h]
	jz	@@L84
	jmp	@@L83
@@L84:	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Bh]
	or	ax,es:[bx+00Dh]
	jz	@@L85
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	les	bx,dword ptr [bp+006h]
	mov	dl,es:[bx+002h]
	and	dx,+07Fh
	cmp	ax,dx
	jnz	@@L85
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	mov	ax,es:[bx+015h]
	mov	dx,es:[bx+013h]
	les	bx,dword ptr [bp+006h]
	cmp	ax,es:[bx+015h]
	jnz	@@L85
	cmp	dx,es:[bx+013h]
	jnz	@@L85
	jmp	@@L83
@@L85:	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	cmp	ax,_fxvmm_tmpval02
	jnz	@@L86
	cmp	dx,_fxvmm_last
	jnz	@@L86
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+011h]
	mov	dx,es:[bx+00Fh]
	mov	_fxvmm_tmpval02,ax
	mov	_fxvmm_last,dx
@@L86:	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	cmp	ax,_fxvmm_tmpval09
	jnz	@@L87
	cmp	dx,_fxvmm_firstblk
	jnz	@@L87
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Dh]
	mov	dx,es:[bx+00Bh]
	mov	_fxvmm_tmpval09,ax
	mov	_fxvmm_firstblk,dx
@@L87:	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Fh]
	or	ax,es:[bx+011h]
	jz	@@L88
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Dh]
	mov	dx,es:[bx+00Bh]
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Fh]
	mov	es:[bx+00Dh],ax
	mov	es:[bx+00Bh],dx
@@L88:	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+00Bh]
	or	ax,es:[bx+00Dh]
	jz	@@L89
	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+011h]
	mov	dx,es:[bx+00Fh]
	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+00Bh]
	mov	es:[bx+011h],ax
	mov	es:[bx+00Fh],dx
@@L89:	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	les	bx,dword ptr [bp+006h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	mov	dx,001Ah
	imul	dx
	mov	bx,ax
	call	dword ptr [bx+_fxvmm_tmpval06]
	add	sp,+004h
	les	bx,dword ptr [bp+006h]
	mov	word ptr es:[bx],0EDCBh
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	call	far ptr _free
	add	sp,+004h
	xor	ax,ax
	mov	sp,bp
	pop	bp
	retf
@@L83:	mov	ax,[bp+008h]
	mov	dx,[bp+006h]
	mov	_fxvmm_tmpval01,ax
	mov	_fxvmm_rovblock,dx
	xor	ax,ax
	mov	sp,bp
	pop	bp
	retf

;

__fxvmm_deinitialize:
	push	bp
	mov	bp,sp
	sub	sp,+008h
	push	si
	mov	ax,_fxvmm_tmpval09
	mov	dx,_fxvmm_firstblk
	mov	[bp-002h],ax
	mov	[bp-004h],dx
	jmp	short @@L91
@@L93:	les	bx,dword ptr [bp-004h]
	mov	ax,es:[bx+00Dh]
	mov	dx,es:[bx+00Bh]
	mov	[bp-006h],ax
	mov	[bp-008h],dx
	les	bx,dword ptr [bp-004h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	cmp	ax,_fxvmm_global_vrt_handle
	jz	@@L92
	les	bx,dword ptr [bp-004h]
	mov	ax,es:[bx+017h]
	or	ax,es:[bx+019h]
	jnz	@@L92
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	les	bx,dword ptr [bp-004h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	mov	dx,001Ah
	imul	dx
	mov	bx,ax
	call	dword ptr [bx+_fxvmm_tmpval06]
	add	sp,+004h
@@L92:	les	bx,dword ptr [bp-004h]
	mov	word ptr es:[bx],0EDCBh
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	call	far ptr _free
	add	sp,+004h
	mov	ax,[bp-006h]
	mov	dx,[bp-008h]
	mov	[bp-002h],ax
	mov	[bp-004h],dx

@@L91:	mov	ax,[bp-004h]
	or	ax,[bp-002h]
	jnz	@@L93
	xor	si,si
	jmp	short @@L94
@@L97:	mov	ax,si
	mov	dx,001Ah
	imul	dx
	mov	bx,ax
	cmp	word ptr [bx+_fxvmm_bufsource],+000h
	jz	@@L95
	mov	ax,si
	mov	dx,001Ah
	imul	dx
	mov	bx,ax
	call	dword ptr [bx+_fxvmm_tmxblock]
@@L95:	inc	si
@@L94:	cmp	si,+004h
	jl	@@L97
	pop	si
	mov	sp,bp
	pop	bp
	retf

;

__fxvmm_absread:
	push	bp
	mov	bp,sp
	mov	ax,[bp+010h]
	mov	dx,[bp+00Eh]
	add	dx,[bp+012h]
	adc	ax,[bp+014h]
	les	bx,dword ptr [bp+00Ah]
	cmp	ax,es:[bx+005h]
	jc	@@L98
	jnbe	@@L99
	cmp	dx,es:[bx+003h]
	jbe	@@L98
@@L99:	mov	dx,0FFFFh
	mov	ax,0FFFFh
	pop	bp
	retf
@@L98:	push    word ptr [bp+014h]
	push    word ptr [bp+012h]
	push    word ptr [bp+010h]
	push    word ptr [bp+00Eh]
	push    word ptr [bp+00Ch]
	push    word ptr [bp+00Ah]
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	les	bx,dword ptr [bp+00Ah]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	mov	dx,001Ah
	imul	dx
	mov	bx,ax
	call	dword ptr [bx+_fxvmm_tmpval07]
	add	sp,+010h
	pop	bp
	retf

;

__fxvmm_read:
	push	bp
	mov	bp,sp
	push    word ptr [bp+010h]
	push    word ptr [bp+00Eh]
	les	bx,dword ptr [bp+00Ah]
	push    word ptr es:[bx+009h]
	push    word ptr es:[bx+007h]
	push    word ptr [bp+00Ch]
	push    word ptr [bp+00Ah]
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	les	bx,dword ptr [bp+00Ah]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	mov	dx,001Ah
	imul	dx
	mov	bx,ax
	call	dword ptr [bx+_fxvmm_tmpval07]
	add	sp,+010h
	pop	bp
	retf

;

__fxvmm_abswrite:
	push	bp
	mov	bp,sp
	mov	ax,[bp+00Ch]
	mov	dx,[bp+00Ah]
	add	dx,[bp+012h]
	adc	ax,[bp+014h]
	les	bx,dword ptr [bp+006h]
	cmp	ax,es:[bx+005h]
	jc	@@L101
	jnbe	@@L102
	cmp	dx,es:[bx+003h]
	jbe	@@L101
@@L102:	mov	dx,0FFFFh
	mov	ax,0FFFFh
	pop	bp
	retf
@@L101:	push    word ptr [bp+014h]
	push    word ptr [bp+012h]
	push    word ptr [bp+010h]
	push    word ptr [bp+00Eh]
	push    word ptr [bp+00Ch]
	push    word ptr [bp+00Ah]
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	les	bx,dword ptr [bp+006h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	mov	dx,001Ah
	imul	dx
	mov	bx,ax
	call	dword ptr [bx+_fxvmm_tmpval08]
	add	sp,+010h
	pop	bp
	retf

;

__fxvmm_write:
	push	bp
	mov	bp,sp
	push    word ptr [bp+010h]
	push    word ptr [bp+00Eh]
	push    word ptr [bp+00Ch]
	push    word ptr [bp+00Ah]
	les  bx,dword ptr [bp+006h]
	push    word ptr es:[bx+009h]
	push    word ptr es:[bx+007h]
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]

	les	bx,dword ptr [bp+006h]
	mov	al,es:[bx+002h]
	and	ax,007Fh
	mov	dx,001Ah
	imul	dx
	mov	bx,ax
	call	dword ptr [bx+_fxvmm_tmpval08]
	add	sp,+010h
	pop	bp
	retf

;

__fxvmm_absmove:
	push	bp
	mov	bp,sp
	sub	sp,+004h
@@L112:	cmp	word ptr [bp+018h],+000h
	jnbe	@@L104
	jc	@@L105
	cmp	word ptr [bp+016h],0200h
	jnc	@@L104
@@L105:	mov	dx,[bp+018h]
	mov	ax,[bp+016h]
	jmp	short @@L106
@@L104:	xor	dx,dx
	mov	ax,0200h
@@L106:	mov	[bp-002h],dx
	mov	[bp-004h],ax
	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	push    word ptr [bp+014h]
	push    word ptr [bp+012h]
	push    word ptr [bp+010h]
	push    word ptr [bp+00Eh]
	push	ds
	mov	ax,offset DGROUP:_fxvmm_tmpblock
	push	ax
	push	cs
	call	__fxvmm_absread
	add	sp,+010h
	cmp	dx,-001h
	jnz	@@L108
	cmp	ax,0FFFFh
	jnz	@@L108
	mov	dx,0FFFFh
	mov	ax,0FFFFh
	mov	sp,bp
	pop	bp
	retf
@@L108:	push    word ptr [bp-002h]
	push    word ptr [bp-004h]
	push	ds
	mov	ax,offset DGROUP:_fxvmm_tmpblock
	push	ax
	push    word ptr [bp+00Ch]
	push    word ptr [bp+00Ah]
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	push	cs
	call	__fxvmm_abswrite
	add	sp,+010h
	cmp	dx,-001h
	jnz	@@L109
	cmp	ax,0FFFFh
	jnz	@@L109
	mov	dx,0FFFFh
	mov	ax,0FFFFh
	mov	sp,bp
	pop	bp
	retf
@@L109:	cmp	word ptr [bp+018h],+000h
	jnbe	@@L110
	jnz	@@L111
	cmp	word ptr [bp+016h],0200h
	jbe	@@L111
@@L110:	sub	word ptr [bp+016h],0200h
	sbb	word ptr [bp+018h],+000h
	add	word ptr [bp+012h],0200h
	adc	word ptr [bp+014h],+000h
	add	word ptr [bp+00Ah],0200h
	adc	word ptr [bp+00Ch],+000h
	jmp	@@L112
@@L111:	les	bx,dword ptr [bp+006h]
	mov	dx,es:[bx+009h]
	mov	ax,es:[bx+007h]
	mov	sp,bp
	pop	bp
	retf

;

__fxvmm_move:
	push	bp
	mov	bp,sp
	push    word ptr [bp+010h]
	push    word ptr [bp+00Eh]
	les	bx,dword ptr [bp+00Ah]
	push    word ptr es:[bx+009h]
	push    word ptr es:[bx+007h]
	push    word ptr [bp+00Ch]
	push    word ptr [bp+00Ah]
	les  bx,dword ptr [bp+006h]
	push    word ptr es:[bx+009h]
	push    word ptr es:[bx+007h]
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	push	cs
	call	__fxvmm_absmove
	add	sp,+014h
	pop	bp
	retf

;

__fxvmm_setpos:
	push	bp
	mov	bp,sp
	les	bx,dword ptr [bp+006h]
	cmp	word ptr es:[bx],0FEDCh
	jz	@@L113
	mov	ax,0FFFFh
	pop	bp
	retf
@@L113:	les	bx,dword ptr [bp+006h]
	mov	ax,es:[bx+005h]
	mov	dx,es:[bx+003h]
	cmp	ax,[bp+00Ch]
	jnbe	@@L114
	jnz	@@L115
	cmp	dx,[bp+00Ah]
	jnbe	@@L114
@@L115:	mov	ax,0FFFEh
	pop	bp
	retf
@@L114:	les	bx,dword ptr [bp+006h]
	mov	ax,[bp+00Ch]
	mov	dx,[bp+00Ah]
	mov	es:[bx+009h],ax
	mov	es:[bx+007h],dx
	xor	ax,ax
	pop	bp
	retf

;

__fxvmm_set_strategy:
	push	bp
	mov	bp,sp
	push	si
	mov	si,[bp+00Ah]
	cmp	si,+004h
	jl	@@L116
	xor	ax,ax
	pop	si
	pop	bp
	retf
@@L116:	mov	ax,[bp+006h]
	or	ax,[bp+008h]
	jnz	@@L117
	xor	ax,ax
	pop	si
	pop	bp
	retf
@@L117:	les	bx,dword ptr [bp+006h]
	les	bx,dword ptr es:[bx+016h]
	mov	es:[bx],si
	mov	ax,001Ah
	push	ax
	push    word ptr [bp+008h]
	push    word ptr [bp+006h]
	push	ds
	mov	ax,si
	mov	dx,001Ah
	imul	dx
	add	ax,offset DGROUP:_fxvmm_bufsource
	push	ax
	call	far ptr _memcpy
	add	sp,+00Ah
	mov	ax,0001h
	pop	si
	pop	bp
	retf

FXVMM_API_TEXT	ENDS

;

_DATA	SEGMENT

_fxvmm_dosalptr	                dd	00000046Ch
_fxvmm_global_xms_handle	dw	00004h
_fxvmm_global_ems_handle	dw	00004h
_fxvmm_global_vrt_handle	dw	00004h
_fxvmm_global_dos_handle	dw	00004h

_DATA	ENDS

;

_BSS	SEGMENT

_fxvmm_tmpblock	   db	512 dup(?)
_fxvmm_rovblock	   dw	1   dup(?)
_fxvmm_tmpval01	   dw	1   dup(?)
_fxvmm_last	   dw	1   dup(?)
_fxvmm_tmpval02	   dw	1   dup(?)
_fxvmm_tmpval03	   dw	1   dup(?)
_fxvmm_tmpval04	   dw	1   dup(?)
_fxvmm_bufsource   dw	1   dup(?)
_fxvmm_tmpval05	   dd	1   dup(?)
_fxvmm_tmpval06	   dd	1   dup(?)
_fxvmm_tmpval07    dd	1   dup(?)
_fxvmm_tmpval08    dd	1   dup(?)
_fxvmm_tmxblock	   db	86  dup(?)
_fxvmm_firstblk	   dw	1   dup(?)
_fxvmm_tmpval09	   dw	1   dup(?)
_fxvmm_error_code  dw	1   dup(?)

_BSS	ENDS
	END

;
