	IDEAL
	MODEL tpascal
	SMART
	JUMPS
	MULTERRS
	LOCALS
	P286

; paranoid EQU 1		; Uncomment this line ONLY if you want
				; paranoid error checking mode enabled
				; in the interrupt set/reset procs (setting
				; an IVT higher than 255d and/or setting
				; the NMI vector)

CODESEG

;----------------------------------------------------------------------------
; Hooks a real mode interrupt vector and returns the original vector
;
; NOTE: This proc CANNOT set the NMI vector reliably, so don't try to do it
	PUBLIC PASCAL hook_RM_int_vector
PROC hook_RM_int_vector
	ARG ivect:WORD, ivect_ptr:DWORD

	mov bx, [ivect]

IFDEF paranoid				; Make *SURE* that int value is
	cmp bx, 255d			; not greater than 255
	jng @@check_nmi
	EXITCODE 255d
	cmp bx, 2d			; Trying to set the NMI vector?
	jng @@onwards
	EXITCODE 253d
@@onwards:
ENDIF
	push ds
	xor ax, ax
	mov ds, ax

	shl bx, 2			; Multiply by 4 to get offset into
					; IVT
	les si, [ivect_ptr]

	cli				; disable interrupts
	mov  [ds:bx + 0], si		; set ofs of new handler
	mov  [ds:bx + 2], es		; set seg of new handler
	sti

	pop ds
	ret
ENDP hook_RM_int_vector

	PUBLIC PASCAL get_RM_int_vector
PROC get_RM_int_vector
	ARG ivect:WORD

	mov bx, [ivect]
IFDEF paranoid				; Make *SURE* that int value is
	cmp bx, 255d			; not greater than 255
	jng @@check_nmi
	EXITCODE 255d
	cmp bx, 2d			; Trying to set the NMI vector?
	jng @@onwards
	EXITCODE 254d
@@onwards:
ENDIF
	push ds
	xor ax, ax
	mov ds, ax

	shl bx, 2			; Multiply by 4 to get offset into
					; IVT

	cli				; disable interrupts
	mov  ax, [ds:bx + 0]		; get ofs of handler
	mov  dx, [ds:bx + 2]		; get seg of handler
	sti

	pop ds
	ret
ENDP get_RM_int_vector

;----------------------------------------------------------------------------
; Restore a real mode interrupt vector
;
; NOTE: This proc CANNOT restore the NMI vector reliably, so don't try to
;	do it
	PUBLIC PASCAL release_RM_int_vector
PROC release_RM_int_vector
	ARG ivect:WORD, ivect_ptr:DWORD

	mov bx, [ivect]
IFDEF paranoid				; Make *SURE* that int value is
	cmp bx, 255d			; not greater than 255
	jng @@check_nmi
	EXITCODE 255d
@@check_nmi:
	cmp bx, 2d			; Trying to set the NMI vector?
	jng @@onwards
	EXITCODE 253d
@@onwards:
ENDIF
	push ds
	xor ax, ax
	mov ds, ax

	shl bx, 2		; Multiply by 4	to get offset into IVT
	les si, [ivect_ptr]	; Load interrupt vector pointer

	cli
	mov [ds:bx + 0], si	; set vector's offset
	mov [ds:bx + 2], es	; set vector's segment
	sti

	pop ds
	ret
ENDP release_RM_int_vector

END
