
#include <socom\gravis.h>
#include <socom\socomus.h>
#include <socom\tables.h>
#include <socom\channel.h>
#include <socom\sample.h>

//Ŀ
//                                                                           
// Global variables                                                          
//                                                                           
//

extern int     scPerTable[16*60];

Channel* mpCurChn;
int      mpCounter;
int      mpPatPos;
int      mpSpeed;
int      mpPatBreak;
int      mpPatDelayTime;
int      mpSongPos;
int      mpPatLoop;
int      mpPatLoopPos;
int      mpNumChn;
int      mpSongLen;
int      mpCurPat;
int      mpNumSmp;
int      mpMasterVolume;
ubyte    mpOrders[128];
Channel  mpChannels[32];
ubyte**  mpPatterns;


void  mpTickHandler( void )
{
   int      i;
   ubyte*   pat;

   if ( ++mpCounter == mpSpeed )          // if counter >= pat speed -> new note
   {
      mpCounter = 0;                      // clear counter

      if  ( mpPatDelayTime == 0 )         // do we have a pattern delay
      {
         if  ( mpPatPos > 63 )            // is it a new pattern ?
         {
            mpSongPos++;                  // yes, inc song pos
            mpPatPos  = 0;                // reset pattern position
            mpPatLoop = 0;                // clear pattern loop flag
         }

         if ( mpSongPos >= mpSongLen )    // is song at end ?
         {
            mpSongPos = 0;                // yepp, restart
         }

         mpCurPat = mpOrders[mpSongPos];  // get current pattern number

         pat = mpPatterns[mpCurPat] + mpPatPos * mpNumChn * 4;

         // parse note and update line effects for each channel

         for ( i = 0; i < mpNumChn; i++, pat += 4 )
         {
            mpChannels[i].ParseNote( pat );
            mpChannels[i].DoLineSfx();
         }

         if  ( mpPatBreak == 0 )
         {
            mpPatPos++;
         }
         else
         {
            mpPatBreak = 0;
         }
      }
      else
      {
         mpPatDelayTime--;
      }
   }

   // update real time effects for each channel

   for ( i = 0; i < mpNumChn; i++ )
   {
      mpChannels[i].DoRealSfx();
   }
}

