
//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// MOD - Implementation                                                      
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <string.h>
#include <stdlib.h>
#include <socom\mod.h>

//Ŀ
//                                                                           
// Data structures                                                           
//                                                                           
//

struct mdSampleInfo
{
   char  mySampleName[22];
   uword myLength;
   ubyte myFineTune;
   ubyte myVolume;
   uword myRepPos;
   uword myRepLen;
};

char* mdID[10] = {
   "M.K.",
   "M!K!",
   "FLT4",
   "4CHN",
   "6CHN",
   "8CHN",
   "CD81",
   "OKTA",
   "16CN",
   "32CN"
};

ubyte mdNumChan[10] = {
   4, 4, 4, 4, 6, 8, 8, 8, 16, 32
};

extern int  scPerTable[16*60];

//Ŀ
//                                                                           
// Constructor                                                               
//                                                                           
//

MOD::MOD( char* fileName ) : Module( fileName )
{

}

//Ŀ
//                                                                           
// Copy constructor                                                          
//                                                                           
//

MOD::MOD( const MOD& aMod ) : Module( aMod )
{

}

//Ŀ
//                                                                           
// Destructor                                                                
//                                                                           
//

MOD::~MOD( void )
{

}

//Ŀ
//                                                                           
// Assignment operator                                                       
//                                                                           
//

MOD& MOD::operator =( const MOD& aMod )
{
   Module::operator =( aMod );

   return *this;
}

//Ŀ
//                                                                           
// Find a period's DSM compatible note number                                
//                                                                           
//

ubyte MOD::FindNote( int period )
{
   if ( period == 0 )
   {
      return 0;
   }

   for ( int i = 0; i < 60; i++ )
   {
      if ( scPerTable[i] <= period )
      {
         return ++i * 2;
      }
   }

   return 0;
}

//Ŀ
//                                                                           
// Load module into memory                                                   
//                                                                           
//

int   MOD::LoadModule( void )
{
   int      retValue;
   ulong    size;
   char     id[4];
   Sample*  smp;
   ubyte*   buffer;

   if ( myFP != 0 )
   {
      fseek( myFP, 20, SEEK_CUR );

      if (( retValue = ReadSampleInfo()) == SOC_OK )
      {
         mySongLen = fgetc( myFP );

         fseek( myFP, 1, SEEK_CUR );
         fread( myOrders, 128, 1, myFP );
         fread( (char*)id, 4, 1, myFP );

         for ( int i = 0; i < 10; i++ )
         {
            if ( strncmp( mdID[i], id, 4 ) == 0 )
            {
               break;
            }
         }

         if ( i >= 10 )
         {
            if ( strncmp( &id[2], "CH", 2 ) == 0 )
            {
               id[2] = 0;

               myNumChn = atoi( id );

               i = 42;
            }
         }

         if ( i < 10 || i == 42 )
         {
            CalcNumPats();

            if ( i != 42 )
            {
               myNumChn = mdNumChan[i];
            }

            myNumSmp  = 31;
            myModType = SOC_MOD;
            myPatSize = 256 * myNumChn;
            myPatNote = myPatSize >> 2;
            myMasterVolume = 255;

            for ( int i = 0; i < myNumChn; i++ )
            {
               myPanPos[i] = (( i & 0x03 ) == 0x03 ) || (( i & 0x03 ) == 0x00 ) ? 0x03 : 0x0C;
            }

            if (( retValue = AllocPatterns()) == SOC_OK )
            {
               if (( retValue = ReadPatterns()) == SOC_OK )
               {
                  for ( int i = 0; i < 31; i++ )
                  {
                     smp  = &mySamples[i];
                     size = smp->myLength;

                     if ( size != 0 )
                     {
                        if (( buffer = new ubyte [size] ) != 0 )
                        {
                           smp->myAddress = buffer;

                           if ( fread( buffer, size, 1, myFP ) != 1 )
                           {
                              retValue = SOC_READ_FAULT;
                              break;
                           }
                        }
                     }
                     else
                     {
                        smp->myGravisLoc = 0;
                     }
                  }
               }
            }
         }
         else
         {
            retValue = SOC_UNKNOWN_MOD;
         }
      }

      fclose( myFP );
   }

   return retValue;
}

//Ŀ
//                                                                           
// Read patterns into memory and convert notes to DSM notes                  
//                                                                           
//

int   MOD::ReadPatterns( void )
{
   ubyte*   pat;
   ubyte    a, b, c;

   for ( int i = 0; i < myNumPat; i++ )
   {
      pat = myPatterns[i];

      if ( fread( pat, myPatSize, 1, myFP ) != 1 )
      {
         return SOC_READ_FAULT;
      }

      for ( int j = 0; j < myPatNote; j++, pat += 4 )
      {
         a = pat[0];
         b = pat[1];
         c = pat[2];

         pat[0] = ( a & 0xf0 ) | ( c >> 4 );
         pat[1] = FindNote( ( int( a & 0x0f ) << 8 ) | b );
         pat[2] = c & 0x0f;
      }
   }

   return SOC_OK;
}

//Ŀ
//                                                                           
// Read sample information structures                                        
//                                                                           
//

int   MOD::ReadSampleInfo( void )
{
   int   retValue;
   mdSampleInfo*  mdSamples = new mdSampleInfo [31];
   mdSampleInfo*  bSample;
   Sample*        aSample;

   if ( mdSamples != 0 )
   {
      mySamples = new Sample [31];

      if ( mySamples != 0 )
      {
         if ( fread( mdSamples, sizeof( mdSampleInfo ), 31, myFP ) == 31 )
         {
            for ( int i = 0; i < 31; i++ )
            {
               aSample = &mySamples[i];
               bSample = &mdSamples[i];

               aSample->myLength     = scFlipWord( bSample->myLength );
               aSample->myRepPos     = scFlipWord( bSample->myRepPos );
               aSample->myRepEnd     = scFlipWord( bSample->myRepLen );
               aSample->myVolume     = bSample->myVolume;
               aSample->myFineTune60 = bSample->myFineTune * 60;

               if ( aSample->myRepEnd > 2 )
               {
                  aSample->mySampleMode = SOC_LOOP;
               }
               else
               {
                  aSample->mySampleMode = 0;
               }
            }

            retValue = SOC_OK;
         }
         else
         {
            retValue = SOC_READ_FAULT;
         }
      }
      else
      {
         retValue = SOC_NO_MEMORY;
      }

      delete [] mdSamples;
   }
   else
   {
      retValue = SOC_NO_MEMORY;
   }

   return retValue;
}

