
//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// Channel - Implementation                                                  
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <stdlib.h>
#include <conio.h>
#include <socom\channel.h>
#include <socom\sample.h>

//Ŀ
//                                                                           
// Global variables                                                          
//                                                                           
//

extern int     mpCounter;
extern int     mpPatPos;
extern int     mpPatBreak;
extern int     mpSongPos;
extern int     mpSongLen;
extern int     mpSpeed;
extern int     mpPatDelayTime;
extern int     mpPatLoop;
extern int     mpPatLoopPos;
extern int     mpNumSmp;
extern int     mpModType;
extern int     mpMasterVolume;
extern int     scPerTable[16*60];
extern ubyte   scVibratoTable[32];

Sample*  Channel::mySamples;
int      Channel::myBpm;
int      Channel::myModType;
bool     Channel::myBpmChange;

//Ŀ
//                                                                           
// Constructor                                                               
//                                                                           
//

Channel::Channel( void )
{

}

//Ŀ
//                                                                           
// Destructor                                                                
//                                                                           
//

Channel::~Channel( void )
{

}

//Ŀ
//                                                                           
// Clear channel                                                             
//                                                                           
//

void  Channel::Clear( void )
{
   myRetrig       = 0;
   myLoNibble     = 0;
   myPanPos       = 7;
   mySampleNum    = 0;
   myEffect       = 0;
   myEffectData   = 0;
   myVolume       = 0;
   myOldVolume    = 0;
   myFineTune60   = 0;
   myKick         = 0;
   myWaveControl  = 0;
   myVibratoPos   = 0;
   myVibratoSpeed = 0;
   myVibratoDepth = 0;
   myTremoloPos   = 0;
   myTremoloDepth = 0;
   myTremoloSpeed = 0;
   myGlissando    = 0;
   myToneDirec    = 0;
   myToneSpeed    = 0;
   myWantNote     = 0;
   myNoteNum      = 0;
   myOrigPeriod   = 0;
   myPlayPeriod   = 0;
   myWantPeriod   = 0;
   myOldPeriod    = 0;
   myStartPos     = 0;
}

//Ŀ
//                                                                           
// Parse line effects (occur once every play line)                           
//                                                                           
//

void  Channel::DoLineSfx( void )
{
   myStartPos = 0;

   switch ( myEffect )
   {
      case  0x08:
         if ( myModType == SOC_MOD )
         {
            myPanPos = myEffectData >> 4;
         }
         else if ( myModType == SOC_DSM )
         {
            switch ( myHiNibble )
            {
               case  0x00:
                  PanControl();
                  break;
               case  0x02:
                  DefaultVolumeSlideUp();
                  break;
               case  0x03:
                  FinePortamentoUp5();
                  break;
               case  0x04:
                  FinePortamentoDown5();
                  break;
               default:
                  break;
            }
         }
         break;
      case  0x09:
         SampleOffset();
         break;
      case  0x0B:
         PositionJump();
         break;
      case  0x0C:
         SetVolume();
         break;
      case  0x0D:
         PatternBreak();
         break;
      case  0x0E:
         switch ( myHiNibble )
         {
            case  0x01:
               FinePortamentoUp();
               break;
            case  0x02:
               FinePortamentoDown();
               break;
            case  0x03:
               Glissando();
               break;
            case  0x04:
               SetVibratoWaveForm();
               break;
            case  0x05:
               SetFineTune();
               break;
            case  0x06:
               PatternLoop();
               break;
            case  0x07:
               SetTremoloWaveForm();
               break;
            case  0x08:
               myPanPos = myLoNibble;
               break;
            case  0x0A:
               FineVolumeSlideUp();
               break;
            case  0x0B:
               FineVolumeSlideDown();
               break;
            case  0x0E:
               PatternDelay();
               break;
            default:
               break;
         }
         break;
      case  0x0F:
         SetSpeed();
         break;
      case  0x13:
         Simulate3D();
         break;
      case  0x1C:
         SetMasterVolume();
         break;
      case  0x1D:
         MasterVolumeUp();
         break;
      case  0x1E:
         MasterVolumeDown();
         break;
      case  0x20:
      case  0x21:
      case  0x22:
      case  0x23:
      case  0x24:
      case  0x25:
      case  0x26:
      case  0x27:
      case  0x28:
      case  0x29:
      case  0x2A:
      case  0x2B:
      case  0x2C:
      case  0x2D:
      case  0x2E:
      case  0x2F:
         SetVolumeSampleOffset();
         break;
      default:
         break;
   }
}

//Ŀ
//                                                                           
// Parse real effects (occur once every play tick)                           
//                                                                           
//

void  Channel::DoRealSfx( void )
{
   switch ( myEffect )
   {
      case  0x00:
         Arpeggio();
         break;
      case  0x01:
         PortamentoUp();
         break;
      case  0x02:
         PortamentoDown();
         break;
      case  0x03:
         TonePortamento( true );
         break;
      case  0x04:
         Vibrato( true );
         break;
      case  0x05:
         TonePortamento( false );
         VolumeSlide();
         break;
      case  0x06:
         Vibrato( false );
         VolumeSlide();
         break;
      case  0x07:
         Tremolo();
         break;
      case  0x08:
         if ( myModType == SOC_DSM )
         {
            switch ( myHiNibble )
            {
               case  0x01:
                  DefaultVolumeSlideUp();
                  break;
               default:
                  break;
            }
         }
         break;
         break;
      case  0x0A:
         VolumeSlide();
         break;
      case  0x0E:
         switch ( myHiNibble )
         {
            case  0x09:
               RetrigNote();
               break;
            case  0x0C:
               NoteCut();
               break;
            case  0x0D:
               NoteDelay();
               break;
            default:
               break;
         }
         break;
      case  0x11:
         PortamentoUp5();
         break;
      case  0x12:
         PortamentoDown5();
         break;
      default:
         break;
   }
}

//Ŀ
//                                                                           
// Handle arpeggio                                                           
//                                                                           
//

void  Channel::Arpeggio( void )
{
   int   soffset;
   bool  flag = true;

   if ( myEffectData != 0 )
   {
      switch ( mpCounter % 3 )
      {
         case  0x00:
            flag = false;
            break;
         case  0x01:
            soffset = myEffectData >> 4;
            break;
         case  0x02:
            soffset = myEffectData & 0x0f;
            break;
         default:
            break;
      }

      if ( flag )
      {
         for ( int i = 0; i < 60; i++ )
         {
            if ( scPerTable[myFineTune60 + i] <= myOrigPeriod )
            {
               myPlayPeriod = scPerTable[myFineTune60 + i + soffset];
               break;
            }
         }
      }
   }
}

//Ŀ
//                                                                           
// Volume slide up to default sample volume                                  
//                                                                           
//

void  Channel::DefaultVolumeSlideUp( void )
{
   ubyte volume = mySamples[mySampleNum].myVolume;

   if (( myVolume += myLoNibble ) > volume )
   {
      myVolume = volume;
   }

   myPlayVolume = myVolume;
}

//Ŀ
//                                                                           
// Fine portamento down (once per line)                                      
//                                                                           
//

void  Channel::FinePortamentoDown( void )
{
   if (( myOrigPeriod += myLoNibble ) > 856 )
   {
      myOrigPeriod = 856;
   }

   myPlayPeriod = myOrigPeriod;
}

//Ŀ
//                                                                           
// Fine portamento down (once per line) using 5 octaves                      
//                                                                           
//

void  Channel::FinePortamentoDown5( void )
{
   if (( myOrigPeriod += myLoNibble ) > 1814 )
   {
      myOrigPeriod = 1814;
   }

   myPlayPeriod = myOrigPeriod;
}

//Ŀ
//                                                                           
// Fine portamento up (once per line)                                        
//                                                                           
//

void  Channel::FinePortamentoUp( void )
{
   if (( myOrigPeriod -= myLoNibble ) < 113 )
   {
      myOrigPeriod = 113;
   }

   myPlayPeriod = myOrigPeriod;
}

//Ŀ
//                                                                           
// Fine portamento up (once per line) using 5 octaves                        
//                                                                           
//

void  Channel::FinePortamentoUp5( void )
{
   if (( myOrigPeriod -= myLoNibble ) < 54 )
   {
      myOrigPeriod = 54;
   }

   myPlayPeriod = myOrigPeriod;
}

//Ŀ
//                                                                           
// Fine volume slide down (once per line)                                    
//                                                                           
//

void  Channel::FineVolumeSlideDown( void )
{
   if (( myVolume -= myLoNibble ) < 0 )
   {
      myVolume = 0;
   }

   myPlayVolume = myVolume;
}

//Ŀ
//                                                                           
// Fine volume slide up (once per line)                                      
//                                                                           
//

void  Channel::FineVolumeSlideUp( void )
{
   if (( myVolume += myLoNibble ) > 64 )
   {
      myVolume = 64;
   }

   myPlayVolume = myVolume;
}

//Ŀ
//                                                                           
// Glissando control                                                         
//                                                                           
//

void  Channel::Glissando( void )
{
   myGlissando = myLoNibble;
}

//Ŀ
//                                                                           
// Slide master volume down                                                  
//                                                                           
//

void  Channel::MasterVolumeDown( void )
{
   if (( mpMasterVolume -= myEffectData ) < 0 )
   {
      mpMasterVolume = 0;
   }
}

//Ŀ
//                                                                           
// Slide master volume up                                                    
//                                                                           
//

void  Channel::MasterVolumeUp( void )
{
   if (( mpMasterVolume += myEffectData ) > 255 )
   {
      mpMasterVolume = 255;
   }
}

//Ŀ
//                                                                           
// Cut off note when tick counter passes effect data nibble                  
//                                                                           
//

void  Channel::NoteCut( void )
{
   if ( mpCounter >= myLoNibble )
   {
      myVolume     = 0;
      myPlayVolume = 0;
   }
}

//Ŀ
//                                                                           
// Delay start of sample until tick counter = effect data nibble             
//                                                                           
//

void  Channel::NoteDelay( void )
{
   myKick = mpCounter == myLoNibble ? 1 : 0;
}

//Ŀ
//                                                                           
// Panning control                                                           
//                                                                           
//

void  Channel::PanControl( void )
{
   myPanPos = myLoNibble;
}

//Ŀ
//                                                                           
// Handle pattern break                                                      
//                                                                           
//

void  Channel::PatternBreak( void )
{
   if ( mpPatBreak == 0 )
   {
      if ( ++mpSongPos >= mpSongLen )
      {
         mpSongPos = 0;
      }

      mpPatPos   = myHiNibble * 10 + myLoNibble;
      mpPatBreak = 1;
   }
}

//Ŀ
//                                                                           
// Handle pattern delay                                                      
//                                                                           
//

void  Channel::PatternDelay( void )
{
   if ( mpPatDelayTime == 0 )
   {
      mpPatDelayTime = myLoNibble;
   }
}

//Ŀ
//                                                                           
// Handle pattern loop                                                       
//                                                                           
//

void  Channel::PatternLoop( void )
{
   if ( myLoNibble != 0 )
   {
      if ( mpPatLoop > 0 )
      {
         mpPatLoop--;
      }
      else
      {
         mpPatLoop = myLoNibble;
      }

      if ( mpPatLoop != 0 )
      {
         mpPatPos = mpPatLoopPos;
      }
   }
   else
   {
      mpPatLoopPos = mpPatPos - 1;
   }
}

//Ŀ
//                                                                           
// Handle portamento up using 3 octaves                                      
//                                                                           
//

void  Channel::PortamentoUp( void )
{
   if (( myOrigPeriod -= myEffectData ) < 113 )
   {
      myOrigPeriod = 113;
   }

   myPlayPeriod = myOrigPeriod;
}

//Ŀ
//                                                                           
// Portamento up using 5 octaves                                             
//                                                                           
//

void  Channel::PortamentoUp5( void )
{
   if (( myOrigPeriod -= myEffectData ) < 54 )
   {
      myOrigPeriod = 54;
   }

   myPlayPeriod = myOrigPeriod;
}

//Ŀ
//                                                                           
// Handle portamento down using 3 octaves                                    
//                                                                           
//

void  Channel::PortamentoDown( void )
{
   if (( myOrigPeriod += myEffectData ) > 856 )
   {
      myOrigPeriod = 856;
   }

   myPlayPeriod = myOrigPeriod;
}

//Ŀ
//                                                                           
// Portamento down using 5 octaves                                           
//                                                                           
//

void  Channel::PortamentoDown5( void )
{
   if (( myOrigPeriod += myEffectData ) > 1814 )
   {
      myOrigPeriod = 1814;
   }

   myPlayPeriod = 1814;
}

//Ŀ
//                                                                           
// Handle position jump                                                      
//                                                                           
//

void  Channel::PositionJump( void )
{
   if ( myEffectData < mpSongLen )
   {
      mpPatPos   = 0;
      mpPatBreak = 1;
      mpSongPos  = myEffectData;
   }
}

//Ŀ
//                                                                           
// Retrig note after a specified number of ticks                             
//                                                                           
//

void  Channel::RetrigNote( void )
{
   if ( myLoNibble != 0 )
   {
      if ( myRetrig == 0 )
      {
         myKick   = 1;
         myRetrig = myLoNibble;
      }

      myRetrig--;
   }
}

//Ŀ
//                                                                           
// Handle sample offset                                                      
//                                                                           
//

void  Channel::SampleOffset( void )
{
   myStartPos = ulong( myEffectData ) << 8;
}

//Ŀ
//                                                                           
// Set finetune for current sample                                           
//                                                                           
//

void  Channel::SetFineTune( void )
{
   int   tune = myLoNibble * 60;

   mySamples[mySampleNum].myFineTune60 = tune;

   myFineTune60 = tune;
   myOrigPeriod = scPerTable[tune + myNoteNum];
   myPlayPeriod = myOrigPeriod;
}

//Ŀ
//                                                                           
// Set master volume                                                         
//                                                                           
//

void  Channel::SetMasterVolume( void )
{
   mpMasterVolume = myEffectData;
}

//Ŀ
//                                                                           
// Handle speed and BPM changes                                              
//                                                                           
//

void  Channel::SetSpeed( void )
{
   if ( myEffectData < 32 )
   {
      mpSpeed = myEffectData;
   }
   else
   {
      myBpm = myEffectData;

      myBpmChange = true;
   }
}

//Ŀ
//                                                                           
// Set new tremolo waveform type                                             
//                                                                           
//

void  Channel::SetTremoloWaveForm( void )
{
   myWaveControl &= 0x0f;
   myWaveControl |= myLoNibble << 4;
}

//Ŀ
//                                                                           
// Set new vibrato waveform type                                             
//                                                                           
//

void  Channel::SetVibratoWaveForm( void )
{
   myWaveControl &= 0xf0;
   myWaveControl |= myLoNibble;
}

//Ŀ
//                                                                           
// Directly set the volume of current sample                                 
//                                                                           
//

void  Channel::SetVolume( void )
{
   if (( myVolume = myEffectData ) > 64 )
   {
      myVolume = 64;
   }

   myPlayVolume = myVolume;
}

//Ŀ
//                                                                           
// Set volume and sample offset                                              
//                                                                           
//

void  Channel::SetVolumeSampleOffset( void )
{
   SampleOffset();

   myVolume     = (( myEffect & 0x0f ) << 2 ) + 4;
   myPlayVolume = myVolume;
}

//Ŀ
//                                                                           
// Simulate a 3D effect                                                      
//                                                                           
//

void  Channel::Simulate3D( void )
{
   ubyte panpos = myEffectData & 0x3f;
   ubyte range  = myEffectData >> 6;
   ubyte volume = panpos >> 1;

   panpos >>= 3;

   switch ( range )
   {
      case  0x00:
         panpos += 7;
         volume  = 0x40 - volume;
         break;
      case  0x01:
         panpos = 15 - panpos;
         volume = 0x20 - volume;
         break;
      case  0x02:
         panpos = 8 - panpos;
         volume++;
         break;
      case  0x03:
         volume = 0x20 + volume;
         break;
      default:
         break;
   }

   myPanPos     = panpos;
   myVolume     = volume;
   myPlayVolume = volume;
}

//Ŀ
//                                                                           
// Handle tone portamento                                                    
//                                                                           
//

void  Channel::TonePortamento( bool doInit )
{
   int   dist;

   if ( doInit )
   {
      if ( myEffectData != 0 )
      {
         myToneSpeed  = myEffectData;
         myEffectData = 0;
      }
   }

   if ( myWantPeriod )
   {
      if ( myToneDirec == 0 )
      {
         myOrigPeriod += myToneSpeed;

         if ( myWantPeriod <= myOrigPeriod )
         {
            myOrigPeriod = myWantPeriod;
            myWantPeriod = 0;
         }
      }
      else
      {
         myOrigPeriod -= myToneSpeed;

         if ( myWantPeriod >= myOrigPeriod )
         {
            myOrigPeriod = myWantPeriod;
            myWantPeriod = 0;
         }
      }

      if ( myGlissando )
      {
         for ( int i = 0; i < 60; i++ )
         {
            if ( myOrigPeriod >= scPerTable[myFineTune60 + i] )
            {
               myPlayPeriod = scPerTable[myFineTune60 + i];
               break;
            }
         }
      }
      else
      {
         myPlayPeriod = myOrigPeriod;
      }
   }
}

//Ŀ
//                                                                           
// Handle tremolo                                                            
//                                                                           
//

void  Channel::Tremolo( void )
{
   ubyte data;
   uword temp;

   if ( myLoNibble )
   {
      myTremoloDepth = myLoNibble;
   }

   if ( myHiNibble )
   {
      myTremoloSpeed = myHiNibble << 2;
   }

   data = ( myTremoloPos >> 2 ) & 0x1f;

   switch (( myWaveControl >> 4 ) & 0x03 )
   {
      case  0x00:
         temp = scVibratoTable[data];
         break;
      case  0x01:
         data <<= 3;

         if ( myTremoloPos < 0 )
         {
            data = 255 - data;
         }

         temp = data;
         break;
      case  0x02:
         temp = 255;
         break;
      default:
         break;
   }

   temp  *= myTremoloDepth;
   temp >>= 6;

   if ( myTremoloPos >= 0 )
   {
      myPlayVolume = myVolume + temp;

      if ( myPlayVolume > 64 )
      {
         myPlayVolume = 64;
      }
   }
   else
   {
      myPlayVolume = myVolume - temp;

      if ( myPlayVolume < 0 )
      {
         myPlayVolume = 0;
      }
   }

   myTremoloPos += myTremoloSpeed;
}

//Ŀ
//                                                                           
// Handle vibrato                                                            
//                                                                           
//

void  Channel::Vibrato( bool doInit )
{
   ubyte data;
   uword temp;

   if ( doInit )
   {
      if ( myLoNibble )
      {
         myVibratoDepth = myLoNibble;
      }

      if ( myHiNibble )
      {
         myVibratoSpeed = myHiNibble << 2;
      }
   }

   data = ( myVibratoPos >> 2 ) & 0x1f;

   switch ( myWaveControl & 0x03 )
   {
      case  0x00:
         temp = scVibratoTable[data];
         break;
      case  0x01:
         data <<= 3;

         if ( myVibratoPos < 0 )
         {
            data = 255 - data;
         }

         temp = data;
         break;
      case  0x02:
         temp = 255;
         break;
      default:
         break;
   }

   temp  *= myVibratoDepth;
   temp >>= 7;

   if ( myVibratoPos >= 0 )
   {
      myPlayPeriod = myOrigPeriod + temp;
   }
   else
   {
      myPlayPeriod = myOrigPeriod - temp;
   }

   myVibratoPos += myVibratoSpeed;
}

//Ŀ
//                                                                           
// Handle volume slide                                                       
//                                                                           
//

void  Channel::VolumeSlide( void )
{
   myVolume += myHiNibble;
   myVolume -= myLoNibble;

   if ( myVolume < 0 )        // make sure 0 <= volume <= 64
   {
      myVolume = 0;
   }
   else if ( myVolume > 64 )
   {
      myVolume = 64;
   }

   myPlayVolume = myVolume;   // update output volume
}

//Ŀ
//                                                                           
// Parse a new note                                                          
//                                                                           
//

void  Channel::ParseNote( ubyte* pat )
{
   ubyte    noteKey;
   ubyte    note;
   ubyte    smpNum;
   Sample*  smp;
   int      period;

   myEffect     = pat[2];              // get effect number from pattern
   myEffectData = pat[3];              // get effect data byte from pattern
   noteKey      = pat[1];              // get note key from pattern
   smpNum       = pat[0];              // get sample number from pattern
   myLoNibble   = myEffectData & 0x0f; // low nibble of effect data
   myHiNibble   = myEffectData >> 4;   // high nibble of effect data

   note = ( noteKey >> 1 ) - 1;        // convert note key to note number

   // if new valid sample number, get new data from sample structures

   if ( smpNum != 0 && smpNum <= mpNumSmp )
   {
      smpNum--;                           // make sample number an index

      smp = &mySamples[smpNum];           // get current sample

      mySampleNum  = smpNum;              // save sample number for later use
      myVolume     = smp->myVolume;       // get sample volume index
      myFineTune60 = smp->myFineTune60;   // get pre-calculated finetune
   }

   if ( noteKey != 0 )
   {
      period = scPerTable[myFineTune60 + note];

      // check if we have a tone slide coming and if so prepare slide

      if ( myEffect == 0x03 || myEffect == 0x05 )
      {
         myWantPeriod = period;
         myWantNote   = note;

         if ( myWantPeriod == myOrigPeriod )
         {
            myWantPeriod = 0;
         }
         else if ( myWantPeriod > myOrigPeriod )
         {
            myToneDirec = 0;
         }
         else
         {
            myToneDirec = 1;
         }
      }
      else  // no tone slide, just a simple note play
      {
         myOrigPeriod = period;
         myNoteNum    = note;
         myKick       = 1;
      }
   }

   myPlayPeriod = myOrigPeriod;
   myPlayVolume = myVolume;
}


