/****************************************************************************/
/* PACKER file routines                                                        */
/* Functions under DOS4Gw and PmodeW                                        */
/*--------------------------------------------------------------------------*/
/* Coded by Kodiak of The Apollo Project                                    */
/* AKA Charles Jones                                                        */
/*     1122 s 32nd St #2                                                    */
/*     Omaha, NE 68105                                                      */
/*     (402)-346-8974                                                       */
/*                                                                          */
/* Email: CAD@UnOmaha.edu                                                   */
/* IRC  : #Coders                                                           */
/*                                                                          */
/*                                                                          */
/* Copyright 1995 All Rights Reservered                                     */
/* Released to public domain, but hey if you use it greet me.               */
/****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "dir.stc"
#include "encrypt.h"
#define buffersize 32000                    /* buffersize for copyfile */
#define MAXDIRS 25
   
   FILE *file2, *file1;                       /* binary files */
   FILE *Projectfile;                         /* text files */
   dir_struc directory[MAXDIRS];              /* internal directory */
   char *buffer[buffersize];                  /* copy buffer */

/****************************************************************************/
/* Function : copyfile                                                      */
/* IN : directory's entry number                                            */
/* RETURNS:                                                                 */
/*          nothing                                                         */
/****************************************************************************/
/* Note :                                                                   */
/*      What do you think?                                                  */
/****************************************************************************/
void copyfile(int dirnum)
{
    int x;
    int y;

    file2 = fopen(directory[dirnum].name,"r+b");

    y = 0;
    x = buffersize;
    while (x == buffersize)
    {
	x = fread(&buffer, 1, buffersize, file2);
	y += x;
	printf("%d \n",x);
	fwrite(&buffer, 1, x, file1);
    }
    directory[dirnum].filesize = y;
    fclose(file2);
}

/****************************************************************************/
/* Function : copyfile                                                      */
/* IN : number of directory entries, and password                           */
/* RETURNS:                                                                 */
/*          nothing                                                         */
/****************************************************************************/
/* Note :                                                                   */
/*      This function encrypts our directory entries and save to disk.      */
/****************************************************************************/
void write_directory(int numdirs, char *password)
{ 
    encryptdir((char *) directory,numdirs,password);
    fwrite(&directory, sizeof(dir_struc), numdirs, file1);
    fwrite(&numdirs,sizeof(int),1,file1);
}


void main(int argc, char *argv[])
{
    int x;

    char buffer[35];

    if (argc != 4) {
	printf("'PACKER PROJECTFILE OUTPUTFILE PASSWORD' Builds the KADfile\n"
	       " Note : \n"
	       "        If outfile is an EXE then KADfile is appended.\n"
	       "        Otherwise, outfile is created.\n");
	       return;
    }
     if (strstr(argv[2],".exe") != NULL) {
	 file1 = fopen(argv[2],"r+w+b");
	 fseek(file1, 0, 2);
     }
     else
	 file1 = fopen(argv[2],"w+b");


     Projectfile = fopen(argv[1],"r");

     fgets(buffer,35,Projectfile);
     buffer[35] = 0;
     if (strstr(buffer,"Project File for KAD system. V1.0") == NULL) {
	 printf("Invalid Project File!\n");
	 fclose(Projectfile);
	 fclose(file1);
	 return;
     }


     x = -1;

     while (fgets(directory[++x].name, 13, Projectfile) != NULL)
     {
	 if (x > MAXDIRS) {
	     printf("Out of directory space! Alter MAXDIRS and recompile!");
	     exit ( EXIT_SUCCESS );
	 }            
	 directory[x].name[strlen(directory[x].name)-1] = 0;
	 directory[x].filepos = ftell(file1);
	 printf("File #%d Name:%s Size:",x,directory[x].name);
	 copyfile(x);

     }

     write_directory(++x, argv[3]);

     fclose(Projectfile);
     fclose(file1);
}
