;=============================== Triangle Gouraud Mapping + Gouraud Shading
;=============================== (C) 1995, SM Karibou

;=============================== Creation : 01/12/95
;=============================== Revision : 16/12/95

;= Entre:
;=        DS:ESI    Pointeur sur la liste des sommet du polygone (termine par la couleur)
;=        DS:EDI    Pointeur sur la liste des points 2D
;=        DS:TexPts Tableau des polygone texture (Coord X/Y) (Longueur maxi = 256)
;=        DS:TexOfs Tableau des offset des textures
;=        DS:ColMap Table eclairage
;=        DS:LTable Offset de la table de translation de couleurs
;=        DS:BufOfs Pointeur sur le buffer recevant le zoli dessin


; Constantes 

.386p
locals
.MODEL FLAT
.CODE

GLOBAL DrawTriML:near
GLOBAL TexPts:DWORD
GLOBAL TexOfs:DWORD
GLOBAL BufOfs:DWORD
GLOBAL LTable:DWORD
GLOBAL ColMap:DWORD
GLOBAL ClipMinX:DWord
GLOBAL ClipMaxX:DWord
GLOBAL ClipMinY:DWord
GLOBAL ClipMaxY:DWord
GLOBAL ScanLine:DWord
GLOBAL ScanMultiplier:DWord

;
.DATA?
align 4
Y1          dd  ?       ;==== Sommet le plus haut de l'ecran
Y2          dd  ?
Y3          dd  ?

NY1         dd  ?       ;==== Numero des sommet dans la face
NY2         dd  ?
NY3         dd  ?

X2mX1A      dd  ?       ;==== Bah c'est marke dessus
X2mX1B      dd  ?

Hauteur1    dd  ?       ;==== Hauteur
Hauteur2    dd  ?

Delta1      dd  ?       ;==== Delta des eux cots
Delta2      dd  ?

CX1         dd  ?       ;==== Current X  1=Gauche 2=droit
CX2         dd  ?

CurrentY    dd  ?       ;==== Ligne Courante

_o          dd  ?       ;==== Tampon

WhatRoutine dd  ?       ;==== Routine de remplissage courante

;==================== Mapping

Xt1          dd  ?       ;==== Coord de mapping courante sur les cots
Yt1          dd  ?
Xt2          dd  ?
Yt2          dd  ?

StepX1       dd  ?       ;==== Increment sur le cote
StepY1       dd  ?
StepX2       dd  ?
StepY2       dd  ?

_IncX        dd  ?       ;==== Increment interne
_IncY        dd  ?

_CurX        dd  ?       ;==== Tampon
_CurY        dd  ?

Xt2mXt1A     dd  ?
Yt2mYt1A     dd  ?
Xt2mXt1B     dd  ?
Yt2mYt1B     dd  ?

TexOfs2     dd ?            ; Gestion multitexture

;=============== GOURAUD
C1          dd  ?       ;==== Couleur courante sur les cots
C2          dd  ?

EdgeStepCol1 dd  ?       ;==== Increment sur le cote
EdgeStepCol2 dd  ?

_IncCol     dd  ?       ;==== Increment interne

_CurCol     dd  ?       ;==== Tampon couleur de ligne

C2mC1A      dd  ?
C2mC1B      dd  ?


.CODE
;
DrawPartC Proc Near;Macro
         push esi edi

@@DrawLoop:
         mov eax,CX1
         mov ecx,CX2
         mov ebx,Xt1
         mov edx,Yt1
         mov ebp,C1
         sar eax,16
         sar ecx,16
         mov _CurX,ebx
         mov _CurY,edx
         mov _CurCol,ebp

         ;====================== Clipping Y
       	 mov edx,CLIPMAXY
	     mov ebx,CLIPMINY
	     cmp CurrentY,edx
         jg SlowExit
         cmp CurrentY,ebx
         jl @@Step

         ;== Full Clip X ?
         cmp eax,ClipMaxX
         jg @@Step
         cmp ecx,ClipMinX
         jl @@Step

         ;====== Clipping
         cmp ecx,ClipMaxX
         jle @@Noclipright
         mov ecx,ClipMaxX
@@NoclipRight:
         cmp eax,ClipMinX
         jge @@NoClipLeft
         mov ebx,ClipMinX         ;========== Clipping Gauche
         sub ebx,eax

         mov eax,_IncX
         cdq
         imul ebx
         add _CurX,eax

         mov eax,_IncY
         cdq
         imul ebx
         add _CurY,eax

         mov eax,_IncCol
         cdq
         imul ebx
         add _CurCol,eax

         mov eax,ClipMinx
@@NoClipLeft:

         sub ecx,eax
         jng @@Step

         mov edi,bufOfs
         add edi,eax
         mov esi,TexOfs2

         mov eax,_IncX
         mov edx,_IncY
         mov ebp,_IncCol

         mov dword ptr [@@Automodif+1],eax
         mov dword ptr [@@Automodif2+2],edx
         mov dword ptr [@@Automodif3+6],ebp

         mov eax,_CurX
         mov edx,_CurY
         mov ebp,LTable
         xor ebx,ebx

@@HZLoop:
         mov bl,ah
         mov bh,dh

@@Automodif:
         add eax,012345678h

         mov bh,byte ptr [esi+ebx]
         mov bl,byte ptr [_CurCol+1]

@@AutoModif2:
         add edx,012345678h

         mov bh,byte ptr ds:[ebp+ebx]

@@AutoModif3:
         add _CurCol,012345678h

         mov [edi],bh
         inc edi

         dec ecx
         jnz @@HZLoop


@@Step:
         mov ecx,Delta1
         mov edx,Delta2
         add CX1,ecx
         add CX2,edx

         ;=================== Mapping + Gouraud
         mov eax,StepX1
         mov ebx,StepY1
         mov ecx,EdgeStepCol1
         add Xt1,eax
         add Yt1,ebx
         add C1,ecx

         mov edx,Scanline
         inc CurrentY
         add BufOfs,edx
         dec Hauteur1
         jnz @@DrawLoop

         pop edi esi
         ret
DrawPartC endp

DrawPartNC Proc Near;Macro
         push esi edi

@@DrawLoop:
         mov eax,CX1
         mov ecx,CX2
         mov ebp,C1
         sar eax,16
         sar ecx,16
         mov _CurCol,ebp

         ;====================== Clipping Y
       	 mov edx,CLIPMAXY
	     mov ebx,CLIPMINY
	     cmp CurrentY,edx
         jg SlowExit
         cmp CurrentY,ebx
         jl @@Step

         sub ecx,eax
         jng @@Step

         mov edi,bufOfs
         add edi,eax
         mov esi,TexOfs2

         mov eax,_IncX
         mov edx,_IncY
         mov ebp,_IncCol

         mov dword ptr [@@Automodif+1],eax
         mov dword ptr [@@Automodif2+2],edx
         mov dword ptr [@@Automodif3+6],ebp

         mov eax,Xt1
         mov edx,Yt1
         mov ebp,LTable
         xor ebx,ebx

@@HZLoop:
         mov bl,ah
         mov bh,dh

@@Automodif:
         add eax,012345678h

         mov bh,byte ptr [esi+ebx]
         mov bl,byte ptr [_CurCol+1]

@@AutoModif2:
         add edx,012345678h

         mov bh,byte ptr ds:[ebp+ebx]

@@AutoModif3:
         add _CurCol,012345678h

         mov [edi],bh
         inc edi

         dec ecx
         jnz @@HZLoop


@@Step:
         mov ecx,Delta1
         mov edx,Delta2
         add CX1,ecx
         add CX2,edx

         ;=================== Mapping + Gouraud
         mov eax,StepX1
         mov ebx,StepY1
         mov ecx,EdgeStepCol1
         add Xt1,eax
         add Yt1,ebx
         add C1,ecx

         mov edx,Scanline
         inc CurrentY
         add BufOfs,edx
         dec Hauteur1
         jnz @@DrawLoop

         pop edi esi
         ret
DrawPartNC endp

;

GetCoord Macro
         mov _o,esi
         mov ebx,[esi+eax*4]
         mov esi,TexPts
         movzx edx,byte ptr [esi+ebx*2]
         movzx ebp,byte ptr [esi+ebx*2+1]
         mov esi,ColMap
         movzx ecx,byte ptr [esi+ebx]
         mov esi,_o
         movsx eax,word ptr [edi+ebx*4+2]
endm

;

isClipped Macro
       local @@zob1,@@Zob2
       cmp eax,CLIPMAXX
           jng @@Zob1
           mov WhatRoutine,offset DrawPartC
           jmp @@Zob2
@@Zob1:
           cmp eax,CLIPMinX
           jnl @@Zob2
           mov WhatRoutine,offset DrawPartC
@@Zob2:
endm

;
CalcInc Macro
        local @@lm,@@noclac

         mov ebx,Delta1
         sub ebx,Delta2
         jnz @@noclac

         mov _IncX,0
         mov _IncY,0
         mov _IncCol,0
         jmp @@lm
@@noclac:

         mov eax,StepX1
         sub eax,StepX2
         cdq
         shl eax,16
         idiv ebx

         mov _IncX,eax

         mov eax,StepY1
         sub eax,StepY2
         cdq
         shl eax,16
         idiv ebx

         mov _IncY,eax

         mov eax,EdgeStepCol1
         sub eax,EdgeStepCol2
         cdq
         shl eax,16
         idiv ebx

         mov _IncCol,eax
@@lm:

endm

;

DrawTriML  Proc Near

         mov whatroutine,offset DrawPartNC

         ;======================= Tri des Y
         mov Ny1,0
         mov Ny2,1
         mov Ny3,2

         mov ebx,[esi]
         movsx edx,word ptr [edi+ebx*4]

         mov ebx,[esi+4]
         movsx ecx,word ptr [edi+ebx*4]

         mov ebx,[esi+8]
         movsx ebp,word ptr [edi+ebx*4]

         cmp edx,ecx
         jl @@Ok1
         xchg edx,ecx
         mov eax,NY1
         xchg NY2,eax
         mov NY1,eax
@@Ok1:
         cmp edx,ebp
         jl @@Ok2
         xchg edx,ebp
         mov eax,NY1
         xchg NY3,eax
         mov NY1,eax

@@Ok2:
         cmp ecx,ebp
         jl @@Ok3
         xchg ecx,ebp
         mov eax,NY2
         xchg NY3,eax
         mov NY2,eax
@@Ok3:
         mov y1,edx             ;===== Y1 pt le plus haut sur l'ecran
         mov y2,ecx
         mov y3,ebp

         cmp edx,ebp
         jge @@FastExit

         ;================= Turbo Clip Y
         cmp ebp,CLIPMINY
         jl @@FastExit
         cmp edx,CLIPMAXY
         jg @@FastExit

         ;================= O dans le buffer ?
         mov CurrentY,edx
         Call ScanMultiplier
         add BufOfs,edx

         ;===================== Chargement Texture
         mov _o,esi
         mov ebx,[esi+12]

         mov esi,TexOfs
         mov eax,[esi+ebx*4]
         mov TexOfs2,eax
         mov esi,_o

         ;================ Calcul des Hauteur
         mov eax,y2
         sub eax,y1
         jz @@TriPlat     ;=== Tri Plat
         mov Hauteur1,eax

         mov eax,y3
         sub eax,y1
         jz @@FastExit    ;=== Tri merdik
         mov hauteur2,eax

         ;=============== Recupere donne X2
         mov eax,ny2
         GetCoord
         mov X2mX1A,eax
         mov Xt2mXt1A,edx
         mov Yt2mYt1A,ebp
         mov C2mC1A,ecx

         ISClipped

         ;=============== Recupere donne X1
         mov eax,ny1
         GetCoord
         sub X2mX1A,eax
         sub Xt2mXt1A,edx
         sub Yt2mYt1A,ebp
         sub C2mC1A,ecx

         ISClipped

         ;=============== Init
         shl eax,16
         mov CX1,eax
         mov CX2,eax
         shl edx,8
         shl ebp,8
         shl ecx,8
         mov Xt1,edx
         mov Yt1,ebp
         mov C1,ecx

         ;=============== DeltaX  1 -> 2
         mov eax,X2mX1A
         cdq
         shl eax,16
         idiv Hauteur1
         mov Delta1,eax

         ;================ Recupere donne X3
         mov eax,ny3
         GetCoord
         mov X2mX1B,eax
         mov Xt2mXt1B,edx
         mov Yt2mYt1B,ebp
         mov C2mC1B,ecx

         ISClipped

         ;================ Recupere donne X1
         mov eax,ny1
         GetCoord
         sub X2mX1B,eax
         sub Xt2mXt1B,edx
         sub Yt2mYt1B,ebp
         sub C2mC1B,ecx

         ;=============== DeltaX 1 -> 3
         mov eax,X2mX1B
         cdq
         shl eax,16
         idiv Hauteur2
         mov Delta2,eax

         ;=============== Calcul de l'increment de couleur du triangle
         mov eax,Xt2mXt1A
         cdq
         shl eax,8
         idiv hauteur1
         mov StepX1,eax

         mov eax,Yt2mYt1A
         cdq
         shl eax,8
         idiv hauteur1
         mov StepY1,eax

         mov eax,Xt2mXt1B
         cdq
         shl eax,8
         idiv hauteur2
         mov StepX2,eax

         mov eax,Yt2mYt1B
         cdq
         shl eax,8
         idiv hauteur2
         mov StepY2,eax

         mov eax,C2mC1A
         cdq
         shl eax,8
         idiv hauteur1
         mov EdgeStepCol1,eax

         mov eax,C2mC1B
         cdq
         shl eax,8
         idiv hauteur2
         mov EdgeStepCol2,eax


         ;=============== Determination du sens du triangle
         mov eax,Delta2
         cmp Delta1,eax
         jl @@lom
         xchg Delta1,eax
         mov Delta2,eax

         mov eax,StepX1
         xchg eax,StepX2
         mov StepX1,eax
         mov eax,StepY1
         xchg eax,StepY2
         mov StepY1,eax
         mov eax,EdgeStepCol1
         xchg eax,EdgeStepCol2
         mov EdgeStepCol1,eax

@@lom:
         ;============== Setting Hauteur
         mov eax,hauteur1       ;=== Hauteur1 est le cote le moins long
         cmp eax,hauteur2
         jl @@h
         xchg eax,hauteur2
         mov hauteur1,eax
@@h:
         ;============= Calcul de L'incrment Interne
         CalcInc

         ;====================== Premiere Partie du triangle
         Call WhatRoutine
@@Part2:
         ;===== Hauteur 2 -> 3
         mov eax,y3
         sub eax,y2
         jz @@FastExit     ;=== Tri Plat en bas
         mov Hauteur1,eax

         ;======== Recupere donne X3
         mov eax,ny3
         GetCoord
         mov X2mX1A,eax
         mov Xt2mXt1A,edx
         mov Yt2mYt1A,ebp
         mov C2mC1A,ecx

         ;======== Recupere donne X2
         mov eax,ny2
         GetCoord
         sub X2mX1A,eax
         sub Xt2mXt1A,edx
         sub Yt2mYt1A,ebp
         sub C2mC1A,ecx

         ;=============== DeltaX 2 -> 3
         mov eax,X2mX1A
         cdq
         shl eax,16
         idiv Hauteur1

         ;===== Ou met-je ce Delta ? + Calcul second Increment Gouraud eventuel
         cmp eax,Delta1
         jl @@lok
         mov Delta1,eax

         mov eax,Xt2mXt1A
         cdq
         shl eax,8
         idiv Hauteur1
         mov StepX1,eax

         mov eax,Yt2mYt1A
         cdq
         shl eax,8
         idiv Hauteur1
         mov StepY1,eax

         mov eax,C2mC1A
         cdq
         shl eax,8
         idiv Hauteur1
         mov EdgeStepCol1,eax

         mov eax,CX1
         add eax,8000h
         xor ax,ax
         mov CX1,eax

         jmp @@lop
@@lok:
         mov Delta2,eax

         mov eax,CX2
         add eax,8000h
         xor ax,ax
         mov CX2,eax

@@lop:
         ;====================== Deuxieme Partie du triangle
         Call Whatroutine

@@FastExit:
         ret

SlowExit:
         pop edi esi
         pop eax
         ret

@@TriPlat:
         ;================ Calcul des Hauteur
         mov eax,y3
         sub eax,y1
         jz @@FastExit     ;=== Tri Bizarre
         mov Hauteur1,eax
         mov hauteur2,eax

         ;================ Recupere donne X3
         mov eax,ny3
         GetCoord
         mov X2mX1A,eax
         mov X2mX1B,eax
         mov Xt2mXt1A,edx
         mov Xt2mXt1B,edx
         mov Yt2mYt1A,ebp
         mov Yt2mYt1B,ebp
         mov C2mC1A,ecx
         mov C2mC1B,ecx

         ISClipped

         ;================ Recupere donne X1
         mov eax,ny1
         GetCoord
         sub X2mX1A,eax
         sub Xt2mXt1A,edx
         sub Yt2mYt1A,ebp
         sub C2mC1A,ecx

         ISClipped

         ;=============== Init
         shl eax,16
         mov CX1,eax
         shl edx,8
         shl ebp,8
         shl ecx,8
         mov Xt1,edx
         mov Yt1,ebp
         mov C1,ecx

         ;================ DeltaX 1 -> 3
         mov eax,X2mX1A
         cdq
         shl eax,16
         idiv Hauteur1
         mov Delta1,eax

         ;================ Recupere donne X2
         mov eax,ny2
         GetCoord
         sub X2mX1B,eax
         sub Xt2mXt1B,edx
         sub Yt2mYt1B,ebp
         sub C2mC1B,ecx

         ISClipped

         ;================ Init
         shl eax,16
         mov CX2,eax
         shl edx,8
         shl ebp,8
         shl ecx,8
         mov Xt2,edx
         mov Yt2,ebp
         mov C2,ecx

         ;================ DeltaX 2 -> 3
         mov eax,X2mX1B
         cdq
         shl eax,16
         idiv Hauteur1
         mov Delta2,eax

         ;=============== Calcul de l'increment de couleur du triangle
         mov eax,Xt2mXt1A
         cdq
         shl eax,8
         mov ebx,hauteur1
         idiv ebx
         mov StepX1,eax

         mov eax,Yt2mYt1A
         cdq
         shl eax,8
         idiv ebx
         mov StepY1,eax

         mov eax,Xt2mXt1B
         cdq
         shl eax,8
         idiv ebx
         mov StepX2,eax

         mov eax,Yt2mYt1B
         cdq
         shl eax,8
         idiv ebx
         mov StepY2,eax

         mov eax,C2mC1A
         cdq
         shl eax,8
         idiv ebx
         mov EdgeStepCol1,eax

         mov eax,C2mC1B
         cdq
         shl eax,8
         idiv ebx
         mov EdgeStepCol2,eax

         ;=============== Determination du sens du triangle
         mov eax,Delta2
         cmp Delta1,eax
         jnl @@lom2

         xchg Delta1,eax
         mov Delta2,eax

         mov eax,StepX1
         xchg eax,StepX2
         mov StepX1,eax
         mov eax,StepY1
         xchg eax,StepY2
         mov StepY1,eax

         mov eax,EdgeStepCol1
         xchg eax,EdgeStepCol2
         mov EdgeStepCol1,eax
@@lom2:
         mov eax,CX2
         cmp eax,CX1
         jg @@hjk
         mov eax,CX1
         xchg CX2,eax
         mov CX1,eax

         mov eax,Xt2
         mov ebx,Yt2
         mov Xt1,eax
         mov Yt1,ebx
         mov eax,C2
         mov C1,eax
@@hjk:
         ;============= Calcul de L'incrment Interne
         CalcInc

         ;====================== Dessin
         Call WhatRoutine
         ret
DrawTriML endp

;

end
