program starwars_scroller;
{
	STARWARS SCROLLER
	- by Bjarke Vikse
	feb 1994

	First try. Will be improved...
	Without z-effect!

	This is really a big horizontal line-scaler...

	The big idea with this scroller is that you precalc each line - that
	is, precalc each xpos which should be used from the colour-map (or the
	actual scroll-area). Eh, for each line you calc the points, ranging
	from 0 to 319, for each pixel on the actual line. The amount of points
	you calc is the size of the line - but you allways calc points from
	0 to 319.
	You can then simply use it as a look-up table to figure out from
	which xpos you should fetch the next colour-pixel.
	(what a shitty explanation...)

	Well, in order to speed things up we put precalc'ed data into four
	seperate tables. Each table contains pixels which are 4 pixels apart.
	This way it's much faster to put on a tweaked screen - and we can
	do word-writes to the video-screen (done in the next version)...
}

uses
	crt, DEMOINIT, TWEAK1;

const
	DEBUG = FALSE;
	LINES = 100;
	ABUFSIZE = 6000;

	MAXSTRINGS = 5;
	MAXTEXTSIZE = 80*190;


type
	addbufptr = ^addbuftype;
	addbuftype = array[0..ABUFSIZE] of word;
	addptrptr = ^addptrtype;
	addptrtype = array[0..lines] of pointer;
	addsizeptr = ^addsizetype;
	addsizetype = array[0..lines] of word;
	xposptr = ^xpostype;
	xpostype = array[0..lines] of word;

var
	font : pScreen;
	buffer : pScreen;
	stackseg : word;

	addbuffer1 : addbufptr;
	addbuffer2 : addbufptr;
	addbuffer3 : addbufptr;
	addbuffer4 : addbufptr;
	addptrs1 : addptrtype;
	addsize1 : addsizetype;
	xpos1 : xpostype;
	addptrs2 : addptrtype;
	addsize2 : addsizetype;
	xpos2 : xpostype;
	addptrs3 : addptrtype;
	addsize3 : addsizetype;
	xpos3 : xpostype;
	addptrs4 : addptrtype;
	addsize4 : addsizetype;
	xpos4 : xpostype;

	scrolloffset : word;
	textpos : integer;
	textypos : integer;

const
	display1 : integer = $0000;
	display2 : integer = $4000;

	persp : array[0..lines] of word =
	(2,1,1,2,1,1,1,2,1,1,1,2,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,0,
	1,1,1,0,1,1,0,1,1,0,1,0,1,0,1,0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,
	1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	1,0,0,0,0,0,0,0,0,0,0,0,0);

	scrolltext : array[1..MAXSTRINGS] of string[20] =
	('             ',
	 ' DETTE ER EN ',
	 '  STARWARS   ',
	 ' SCROLLER!!! ',
	 '             ');



(*------------------------------------------------*)

procedure CalcAddBuffer;
const
	scrsize = 80*200;
var
	x1,x2 : real;
	a1,a2,dela : real;
	x : word;
	i,j : integer;
	index1,size1 : word;
	index2,size2 : word;
	index3,size3 : word;
	index4,size4 : word;
begin
	for i:=0 to ABUFSIZE do addbuffer1^[i]:=0;
	for i:=0 to ABUFSIZE do addbuffer2^[i]:=0;
	for i:=0 to ABUFSIZE do addbuffer3^[i]:=0;
	for i:=0 to ABUFSIZE do addbuffer4^[i]:=0;

	index1:=0; index2:=0; index3:=0; index4:=0;

	x1:=104.0;
	x2:=215.0;
	for i:=0 to lines do begin
		addptrs1[i]:=@addbuffer1^[index1];
		addptrs2[i]:=@addbuffer2^[index2];
		addptrs3[i]:=@addbuffer3^[index3];
		addptrs4[i]:=@addbuffer4^[index4];
		size1:=0; size2:=0; size3:=0; size4:=0;

		a1:=0.0; a2:=319.0;
		dela := 319.0/(x2-x1);

		for j:=round(x1) to round(x2) do begin
			x:=round(a1);
			case (j and 3) of
				0 : begin
					if (size1=0) then xpos1[i]:=j shr 2;
					addbuffer1^[index1]:=(x shr 2)+((x and 3)*scrsize);
					inc(index1); inc(size1);
					 end;
				1 : begin
					if (size2=0) then xpos2[i]:=j shr 2;
					addbuffer2^[index2]:=(x shr 2)+((x and 3)*scrsize);
					inc(index2); inc(size2);
					 end;
				2 : begin
					if (size3=0) then xpos3[i]:=j shr 2;
					addbuffer3^[index3]:=(x shr 2)+((x and 3)*scrsize);
					inc(index3); inc(size3);
					 end;
				3 : begin
					if (size4=0) then xpos4[i]:=j shr 2;
					addbuffer4^[index4]:=(x shr 2)+((x and 3)*scrsize);
					inc(index4); inc(size4);
					 end;
			end;
			a1:=a1+dela;
		end;
		addsize1[i]:=size1;
		addsize2[i]:=size2;
		addsize3[i]:=size3;
		addsize4[i]:=size4;
		x1:=x1-1.0;
		x2:=x2+1.0;
	end;
end;

procedure SetScrollText;
var
	i,j : integer;
begin
	for i:=1 to MAXSTRINGS do
		for j:=1 to length(scrolltext[i]) do
			case scrolltext[i,j] of
			' ' : scrolltext[i,j]:=char(ord('A')+48);
			'!' : scrolltext[i,j]:=char(ord('Z')+11);
			'.' : scrolltext[i,j]:=char(ord('Z')+12);
			'?' : scrolltext[i,j]:=char(ord('Z')+13);
			end;
end;

procedure SetupDemo;
var
	i : word;
begin
	ClearWholeScreen;
	CalcAddBuffer;
	SetScrollText;

	for i:=0 to 65000 do buffer^[i]:=0;
	for i:=0 to lines do persp[i]:=persp[i]*WIDTH;
	scrolloffset:=0;
	textpos:=1; textypos:=0;
end;


(*------------------------------------------------*)

procedure SwapDisplay;
var
	temp : word;
begin
	temp:=display1;
	display1:=display2;
	display2:=temp;
	SetAddress(Ptr(SEGA000,display2));
end;


(*------------------------------------------------*)

procedure StarWars(addptrs : addptrptr; addsize : addsizeptr; xpos : xposptr);
var
	i : integer;
	scrx, scry : word;
	scrollpos : word;
	bptr : pointer;
	size : word;
begin
	scry := WIDTH*90;
	scrollpos:=scrolloffset;

	for i:=0 to lines do begin
	bptr := addptrs^[i];
	scrx := xpos^[i];
	size := addsize^[i];
	scrollpos:=scrollpos+persp[i];
	if (scrollpos >= MAXTEXTSIZE) then dec(scrollpos,MAXTEXTSIZE);
	asm
		mov	stackseg,ss
		mov	es,SEGA000
		mov	di,display1
		add	di,scry
		add	di,scrx
		mov	ax,WORD PTR buffer+2
		mov	dx,WORD PTR buffer
		add	dx,scrollpos
		mov	cx,size
		lds	si,bptr
		mov	ss,ax
		cld
@xloop:
		lodsw
		mov	bx,ax
		add	bx,dx
		mov	al,ss:[bx]
		stosb
		loop	@xloop
		mov	ax,SEG @DATA
		mov	ds,ax
		mov	ss,stackseg
	end;
	inc(scry,WIDTH);
	inc(scrollpos,WIDTH);
	if (scrollpos = MAXTEXTSIZE) then scrollpos:=0;
	end;
end;

procedure Scroller;
var
	i : integer;
	plotoffset : word;
	yoff,stroff : word;
	textantal : integer;
begin
	inc(scrolloffset,WIDTH);
	if (scrolloffset = MAXTEXTSIZE) then scrolloffset:=0;
	plotoffset:=scrolloffset+(180*WIDTH);
	if (plotoffset >= MAXTEXTSIZE) then dec(plotoffset,MAXTEXTSIZE);

	inc(textypos);
	if (textypos = 31) then begin
		textypos:=0;
		inc(textpos); if (textpos > MAXSTRINGS) then textpos:=1;
	end;
	yoff := textypos*WIDTH;
	stroff := (textpos-1)*21;

	asm
		mov	textantal,1
@loop:
		lea	si,scrolltext
		add	si,stroff
		add	si,textantal
		mov	al,[si]
		xor	ah,ah

		cmp	al,' '
		jne	@char1
		mov	al,'A'+48
@char1:
		cmp	al,'!'
		jne	@char2
		mov	al,'Z'+11
@char2:
		cmp	al,'.'
		jne	@char3
		mov	al,'Z'+12
@char3:
		cmp	al,'A'
		jb		@noprint
		sub	al,'A'
		xor	dx,dx
		mov	cx,10
		div	cx
		mov	bx,dx
		mov	cx,80*32
		xor	dx,dx
		mul	cx
		shl	bx,3

		push	ds
		les	di,buffer
		lds	si,font
		add	si,yoff
		add	si,ax
		add	si,bx
		add	di,plotoffset
		cld
		mov	bx,(80*200)-6
		movsw
		movsw
		movsw
		add	si,bx
		add	di,bx
		movsw
		movsw
		movsw
		add	si,bx
		add	di,bx
		movsw
		movsw
		movsw
		add	si,bx
		add	di,bx
		movsw
		movsw
		movsw
		pop	ds

@noprint:
		add	plotoffset,6
		inc	textantal
		cmp	textantal,15
		jne	@loop
	end;
end;


(*------------------------------------------------*)

procedure RunOnce;
begin
	SwapDisplay;
	VBLANK;
	if DEBUG then setRGB(0,63,0,0);
	SetBitplanes(1);
	StarWars(@addptrs1,@addsize1,@xpos1);
	SetBitplanes(2);
	StarWars(@addptrs2,@addsize2,@xpos2);
	SetBitplanes(4);
	StarWars(@addptrs3,@addsize3,@xpos3);
	SetBitplanes(8);
	StarWars(@addptrs4,@addsize4,@xpos4);
	Scroller;
	if DEBUG then setRGB(0,0,0,0);
end;

var
	i,j : integer;

begin
	new(font);
	new(buffer);
	new(addbuffer1);
	new(addbuffer2);
	new(addbuffer3);
	new(addbuffer4);
	LoadPix(font,'FONT.LBM');
	OpenScreen;
	SetCMAP;
	SetupDemo;

	while (not KeyPressed) do
	begin
		RunOnce;
	end;

	CloseScreen;
	dispose(addbuffer1);
	dispose(addbuffer2);
	dispose(addbuffer3);
	dispose(addbuffer4);
	dispose(buffer);
	dispose(font);

	crt.textmode(co80);
	writeln('ok..');
end.
-