{$M 16384,395459,655360}
{----------------------------------------------------------------------------}
program tex_env_mapping; {(c) 1996 by Daniel Vollmer}
uses crt,dos;            {wobbly!}
{$DEFINE fill}
{$DEFINE new}
{----------------------------------------------------------------------------}
const
   MaxPoints            = 1023;
   MaxPolys             = 1985;
   MaxLinesPP           = 4;
   HowMuch              = MaxLinesPP+12;
   AddX       : Word    = 1;
   ColorAdd   : Byte    = 0;
{----------------------------------------------------------------------------}
type
   ConvertP = array[1..MaxPoints,1..HowMuch] of Word;
   Matrix   = array [1..3, 1..3] of LongInt;
   Screen   = array[1..65535] of Byte;
   ZB       = array[1..65535] of ShortInt;
   Punkt    = record
                    x,y,z     : LongInt;
              end;
   PolyData = array[1..MaxLinesPP] of Word;
   Poly     = record
                    NumEdg       : Byte;                         { 1}
                    Data         : PolyData;                     { 8}
                    OriginNormal : Punkt;                        {12}
                    Normal       : Punkt;                        {12}
              end;                                               {->33}
   PolyType = array[1..MaxPolys] of Poly;
   Point    = record
                    OrgPoints    : Punkt;           {12}
                    Temp         : Punkt;           {12}
                    PNormals     : Punkt;           {12}
                    PointNormals : Punkt;           {12}
                    EnvCos       : Record
                                       X, Y: Word   { 4}
                                   End;
                    Coords       : record
                                         x,y       : integer;
                                         z         : Integer;
                                   end;             { 8}
                    Dummy        : LongInt;         { 4}
                    Dummy2       : Word;
              end;                                  {->64}
   PointType = array[1..MaxPoints] of Point;
   ObjectType  =  record
                        Polys                      : ^PolyType;
                        Points                     : ^PointType;
                        LPoints                    : Word;
                        LPolys                     : Word;
                        allocated                  : boolean;
                        XOffs                      : Word;
                        YOffs                      : Word;
                        XOffs3D                    : LongInt;
                        YOffs3D                    : LongInt;
                        ZOffs3D                    : LongInt;
                        Dist                       : LongInt;
                  end;
   PaletteType = array[0..254,0..255] of byte;
{----------------------------------------------------------------------------}
var
   T                          : ObjectType;
   sint,cost                  : array[-511..511] of LongInt;
   v_screen,EnvTex,TexMap     : ^Screen;
   PalConv                    : ^PaletteType;
   ZBuffer                    : ^ZB;
   VSeg,EnvSeg,ZSeg,
   PSeg,MapSeg                : Word;
   AngleX                     : Word;
   RotMatrix                  : Matrix;
   MinY, MaxY                 : integer;
   X_Data                     : Array [0..199] Of Record
                                      X1,X2:integer;
                                      dummy,dummy2:Word; {dummies wegen selben pointers wie EnvTable! }
                                end;
   Z_Data                     : Array [0..199] Of Record
                                      Z1,Z2:Integer;
                                      Dummy,dummy2:Word;
                                end;
   EnvironmentTable           : Array [0..199] Of Record
                                      X1, Y1, X2, Y2: Word;
                                End;
   TextureTable               : Array [0..199] Of Record
                                      X1, Y1, X2, Y2: Word;
                                End;
{----------------------------------------------------------------------------}
   cube                       : boolean;
   Dub                        : boolean;
   twocol                     : boolean;
   name                       : string;
   c                          : Word;
   Pics: LongInt;
   H,M,S,Hun:Word;
   {$IFNDEF NEW}
   mul:real;
   {$ENDIF}
{----------------------------------------------------------------------------}
Function LSqrt (A: LongInt): LongInt; External;
Function LAdd (A, B: LongInt): LongInt; External;
Function LSub (A, B: LongInt): LongInt; External;
Function LDiv (A, B: LongInt): LongInt; External;
Function LMul (A, B: LongInt): LongInt; External;
Function LQuad (A: LongInt): LongInt; External;
Function LTrunc (A: LongInt): integer; External;
procedure RotierePunkte (var X1, X2: LongInt;Count,Size:Word); External;
procedure SetMatrix (A,B,C:Integer); External;
procedure TransPunkte (var Obj:ObjectType;Count:Word); external;
procedure CalcEnvCos( var PointN:LongInt;Count:Word); external;
{$L calc.obj}
{----------------------------------------------------------------------------}
procedure retrace; external;
procedure switch(source,dest:Word); external;
procedure cls(segm:Word;col:Byte); external;
procedure dopal(c,r,g,b:Byte); external;
procedure ShadedXLines; external;
procedure prepxdata; external;
procedure EnvLine (var StartP:Word;P1, P2: Word;num,numed:byte); external;
{$L graph.obj}
{----------------------------------------------------------------------------}
procedure initarrays(var Obj:ObjectType);
var c1,c2,c3,found:Word;
    den,te1,te2,te3:LongInt;
    PointInFace:^ConvertP;
begin
     with Obj do begin
          getmem(PointInFace,LPoints*HowMuch*sizeof(word));
          for c1:=1 to LPolys do begin
              with Polys^[c1] do begin
                   te1:=LSub (
                   LMul (LSub (Points^[data[1]].OrgPoints.y, Points^[data[2]].OrgPoints.y),
                         LSub (Points^[data[1]].OrgPoints.z, Points^[data[3]].OrgPoints.z)),
                   LMul (LSub (Points^[data[1]].OrgPoints.z, Points^[data[2]].OrgPoints.z),
                         LSub (Points^[data[1]].OrgPoints.y, Points^[data[3]].OrgPoints.y)));

                   te2:=LSub (
                   LMul (LSub (Points^[data[1]].OrgPoints.z, Points^[data[2]].OrgPoints.z),
                         LSub (Points^[data[1]].OrgPoints.x, Points^[data[3]].OrgPoints.x)),
                   LMul (LSub (Points^[data[1]].OrgPoints.x, Points^[data[2]].OrgPoints.x),
                         LSub (Points^[data[1]].OrgPoints.z, Points^[data[3]].OrgPoints.z)));

                   te3:=LSub (
                   LMul (LSub (Points^[data[1]].OrgPoints.x, Points^[data[2]].OrgPoints.x),
                         LSub (Points^[data[1]].OrgPoints.y, Points^[data[3]].OrgPoints.y)),
                   LMul (LSub (Points^[data[1]].OrgPoints.y, Points^[data[2]].OrgPoints.y),
                         LSub (Points^[data[1]].OrgPoints.x, Points^[data[3]].OrgPoints.x)));

                   den:=LSqrt(LAdd(LAdd(LQuad(te1),LQuad(te2)),LQuad(te3)));
                   if den<>0 then begin
                      OriginNormal.x:=ldiv(te1,den);
                      OriginNormal.y:=ldiv(te2,den);
                      OriginNormal.z:=ldiv(te3,den);
                   end else begin
                       OriginNormal.x:=0;
                       OriginNormal.y:=0;
                       OriginNormal.z:=0;
                   end;
              end;
          end;

          for c1:=1 to LPoints do begin
              found:=0;
              for c2:=1 to LPolys do begin
                  with Polys^[c2] do
                  for c3:=1 to NumEdg do if data[c3]=c1 then begin
                      inc(Found);
                      PointInFace^[c1,found]:=c2
                  end;
              end;
              PointInFace^[c1,HowMuch]:=found
          end;

          for c1:=1 to LPoints do begin
              with Points^[c1] do begin
                   te2:=PointInFace^[c1,HowMuch];te2:=te2*65535;
                   te1:=Polys^[PointInFace^[c1,1]].OriginNormal.x;
                   for c2:=2 to PointInFace^[c1,HowMuch] do te1:=LAdd(te1,Polys^[PointInFace^[c1,c2]].OriginNormal.x);
                   pNormals.x:= LDiv(te1,te2);
                   te1:=Polys^[PointInFace^[c1,1]].OriginNormal.y;
                   for c2:=2 to PointInFace^[c1,HowMuch] do te1:=LAdd(te1,Polys^[PointInFace^[c1,c2]].OriginNormal.y);
                   pNormals.y:= LDiv(te1,te2);
                   te1:=Polys^[PointInFace^[c1,1]].OriginNormal.z;
                   for c2:=2 to PointInFace^[c1,HowMuch] do te1:=LAdd(te1,Polys^[PointInFace^[c1,c2]].OriginNormal.z);
                   pNormals.z:= LDiv(te1,te2);
                   den:=LSqrt (LAdd(LAdd(LQuad(pNormals.x),LQuad(pNormals.y)),LQuad(pNormals.z)));
                   if den<>0 then begin
                      pNormals.x:=LDiv (pNormals.x,den);
                      pNormals.y:=LDiv (pNormals.y,den);
                      pNormals.z:=LDiv (pNormals.z,den);
                   end else begin
                       pNormals.x:=0;
                       pNormals.y:=0;
                       pNormals.z:=0;
                   end;
              end;
          end;
          freemem(PointInFace,LPoints*HowMuch*sizeof(word));
     end;
end;
{----------------------------------------------------------------------------}
procedure setOffsets(var Obj:ObjectType);
begin
     with Obj do begin
          allocated:=false;
          Dist := 128;
          XOffs := 160;
          YOffs := 100;
          XOffs3D := 0;
          YOffs3D := 0;
          ZOffs3D := 40 shl 16;
     end;
end;
{----------------------------------------------------------------------------}
procedure FreeObject(var Obj:ObjectType);
begin
     if Obj.allocated then begin
        freemem(Obj.polys, Obj.LPolys * sizeof(poly));
        freemem(Obj.points, Obj.LPoints * sizeof(point));
        Obj.allocated:=false;
     end;
end;
{----------------------------------------------------------------------------}
function FileExists(dname : string) : boolean;
var dumf : file;
begin;
  FileExists:=false;
  {$I-}
  assign(dumf,dname);
  reset(dumf,1);
  {$I+}
  if IOResult = 0 then if filesize(dumf)>0 then begin
     FileExists := true;
     close(dumf);
  end else close(dumf);
end;
{$IFDEF new}
procedure readobj(var Obj:ObjectType;name:string);
var f:file;
    c,chk:word;
begin
     with Obj do begin
          if not FileExists(Name+'.666') then begin
             asm
                mov  ax,3
                int  10h
             end;
             writeln('Object File not found!');
	          halt(1);
          end;
          assign(f,name+'.666');
          reset(f,1);
          BlockRead(f,LPoints,2);
          BlockRead(f,LPolys,2);
          BlockRead(f,chk,2);
          if chk<>Swap(LPoints xor LPolys) then begin;
             asm
                mov  ax,3
                int  10h
             end;
             writeln('Object Checksum Error!');
	          halt(1);
          end;
          if allocated then freeobject(obj);
          getmem(points,LPoints * sizeof(point));
          getmem(polys,LPolys * sizeof(poly));
          allocated:=true;
          for c:=1 to LPoints do BlockRead(f,Points^[c].OrgPoints,sizeof(Punkt));
          for c:=1 to LPolys do BlockRead(f,Polys^[c].NumEdg,(MaxLinesPP*SizeOf(Word))+1);
          close(f);
     end;
     initarrays(Obj);
end;
{$ELSE}
procedure ReadObj(var Obj:ObjectType;Name : string;LoaderMul:real);
type
    poldataarr=array[1..MaxPolys] of PolyData;
    numedgarr=array[1..MaxPolys] of byte;
var
   i:integer;
   S:string;
   f:text;
   dummy:Byte;
   d1,d2,d3:real;
   PolDat:^PolDataArr;
   NumDat:^NumEdgArr;
begin
     if not FileExists(Name+'.geo') then begin
        writeln('Object File not found!');
	     halt(1);
     end;
     assign(f,Name+'.geo');
     reset(f);
     Readln(f,s);			{ Header }
     if s <> '3DG1' then begin
        asm
           mov  ax,3
           int  10h
        end;
        writeln(Name,' is no Object File!');
        halt(1);
     end;
     with Obj do begin
          if allocated then freeobject(obj);
          Read(f,LPoints); { Number of OrgPoints }
          getmem(points,LPoints * sizeof(point));
          getmem(poldat,MaxPolys * sizeof(polydata));
          getmem(numdat,MaxPolys * sizeof(byte));
          for i := 1 to LPoints do begin
              with Points^[i] do begin
	                Readln(F,d1,d2,d3); { Coords(x y z)) }
	                OrgPoints.x := Round(d1*65535 * LoaderMul);
	                OrgPoints.y := Round(d2*65535 * LoaderMul);
	                OrgPoints.z := Round(d3*65535 * LoaderMul);
              end;
	       end;
          LPolys := 0;
          while not eof(f) do begin
                inc(LPolys);
	             Read(f,NumDat^[LPolys]); { Number of Edges for this Poly }
		          for i := 1 to NumDat^[LPolys] do begin
                    Read(f,PolDat^[LPolys,i]);    { Read in Lines... }
                    inc(PolDat^[LPolys,i]);
                end;
		          Read(f,dummy);        { Read color }
          end;
          close(f);
          dec(LPolys);
          getmem(polys,LPolys * sizeof(poly));
          allocated:=true;
          for i:=1 to LPolys do begin
              Polys^[i].Data:=PolDat^[i];
              Polys^[i].NumEdg:=NumDat^[i];
          end;
          FreeMem(poldat,MaxPolys * sizeof(polydata));
          FreeMem(numdat,MaxPolys * sizeof(byte));
      end;
      initarrays(Obj);
end;
{$ENDIF}
{----------------------------------------------------------------------------}
procedure makecube(var Obj:ObjectType);
var c:byte;
begin
  with Obj do begin
     if allocated then freeobject(Obj);
     LPoints:=8;LPolys:=6;
     GetMem(polys,LPolys*sizeof(poly));
     GetMem(points,LPoints*sizeof(point));
     allocated:=true;
     points^[1].OrgPoints.x:=-12*65535;points^[1].OrgPoints.y:=12*65535; points^[1].OrgPoints.z:=12*65535;
     points^[2].OrgPoints.x:=12*65535; points^[2].OrgPoints.y:=12*65535; points^[2].OrgPoints.z:=12*65535;
     points^[3].OrgPoints.x:=-12*65535;points^[3].OrgPoints.y:=-12*65535;points^[3].OrgPoints.z:=12*65535;
     points^[4].OrgPoints.x:=12*65535; points^[4].OrgPoints.y:=-12*65535;points^[4].OrgPoints.z:=12*65535;
     points^[5].OrgPoints.x:=-12*65535;points^[5].OrgPoints.y:=12*65535; points^[5].OrgPoints.z:=-12*65535;
     points^[6].OrgPoints.x:=12*65535; points^[6].OrgPoints.y:=12*65535; points^[6].OrgPoints.z:=-12*65535;
     points^[7].OrgPoints.x:=-12*65535;points^[7].OrgPoints.y:=-12*65535;points^[7].OrgPoints.z:=-12*65535;
     points^[8].OrgPoints.x:=12*65535; points^[8].OrgPoints.y:=-12*65535;points^[8].OrgPoints.z:=-12*65535;

     polys^[1].data[1]:=1;polys^[1].data[2]:=3;polys^[1].data[3]:=4;polys^[1].data[4]:=2;
     polys^[2].data[1]:=5;polys^[2].data[2]:=6;polys^[2].data[3]:=8;polys^[2].data[4]:=7;
     polys^[3].data[1]:=1;polys^[3].data[2]:=2;polys^[3].data[3]:=6;polys^[3].data[4]:=5;
     polys^[4].data[1]:=3;polys^[4].data[2]:=7;polys^[4].data[3]:=8;polys^[4].data[4]:=4;
     polys^[5].data[1]:=1;polys^[5].data[2]:=5;polys^[5].data[3]:=7;polys^[5].data[4]:=3;
     polys^[6].data[1]:=2;polys^[6].data[2]:=4;polys^[6].data[3]:=8;polys^[6].data[4]:=6;
     for c:=1 to 6 do polys^[c].NumEdg:=4;
  end;
  initarrays(Obj);
end;
{----------------------------------------------------------------------------}
procedure plane(var Obj:ObjectType);
var c:byte;
begin
  with Obj do begin
     if allocated then freeobject(Obj);
     LPoints:=4;LPolys:=2;
     GetMem(polys,LPolys*sizeof(poly));
     GetMem(points,LPoints*sizeof(point));
     allocated:=true;
     points^[1].OrgPoints.x:=-12*65535;points^[1].OrgPoints.y:=12*65535; points^[1].OrgPoints.z:=0*65535;
     points^[2].OrgPoints.x:=12*65535; points^[2].OrgPoints.y:=12*65535; points^[2].OrgPoints.z:=0*65535;
     points^[3].OrgPoints.x:=-12*65535;points^[3].OrgPoints.y:=-12*65535;points^[3].OrgPoints.z:=0*65535;
     points^[4].OrgPoints.x:=12*65535; points^[4].OrgPoints.y:=-12*65535;points^[4].OrgPoints.z:=0*65535;

     polys^[1].data[1]:=1;polys^[1].data[2]:=2;polys^[1].data[3]:=4;polys^[1].data[4]:=3;
     polys^[2].data[1]:=3;polys^[2].data[2]:=4;polys^[2].data[3]:=2;polys^[2].data[4]:=1;
     for c:=1 to 2 do polys^[c].NumEdg:=4;
     polys^[1].OriginNormal.x:=0;polys^[1].OriginNormal.y:=0;polys^[1].OriginNormal.z:=-65535;
     polys^[2].OriginNormal.x:=0;polys^[2].OriginNormal.y:=0;polys^[2].OriginNormal.z:=65535;
     points^[1].PNormals.x:=-46340;points^[1].PNormals.y:=46340;points^[1].PNormals.z:=0;
     points^[2].PNormals.x:=46340;points^[2].PNormals.y:=46340;points^[2].PNormals.z:=0;
     points^[3].PNormals.x:=-46340;points^[3].PNormals.y:=-46340;points^[3].PNormals.z:=0;
     points^[4].PNormals.x:=46340;points^[4].PNormals.y:=-46340;points^[4].PNormals.z:=0;
  end;
end;
{----------------------------------------------------------------------------}
procedure askem;
var b:Char;bi:ShortInt;c:Byte;
begin
     clrscr;
     TextColor(LightMagenta);
     write('Made by ');
     TextColor(LightBlue);
     writeln('Daniel Vollmer!');
     TextColor(LightMagenta);
     writeln('Object ? [............................]');
     TextColor(Magenta);
     Write('[C] for Cube, [Return] for Torus or enter Filename without ".666"...');
     TextColor(Green);
     gotoxy(2,3);write('C');
     gotoxy(16,3);write('Return');
     gotoxy(43,3);write('Filename');
     gotoxy(11,2);
     Textcolor(LightBlue);
     read(name);
     if name='' then begin
        name:='Boingtor';
        gotoxy(11,2);
        writeln(Name);
     end else if (length(Name)=1) and (upcase(Name[1])='C') then begin
        gotoxy(11,2);
        writeln('Cube');
        cube:=true;
     end else cube:=false;
     Textcolor(LightMagenta);
     gotoxy(1,4);
     write('Double Object (Y/N) ? ');
     Textcolor(Green);
     gotoxy(16,4);write('Y/N');
     gotoxy(23,4);
     Textcolor(LightBlue);
     b:=readkey; if upcase(b)='Y' then Dub:=true else Dub:=false;
     if Dub then writeln('Y') else writeln('N');
     Textcolor(LightMagenta);
     gotoxy(1,5);
     write('Two Colors (Y/N) ? ');
     Textcolor(Green);
     gotoxy(13,5);write('Y/N');
     gotoxy(20,5);
     Textcolor(LightBlue);
     b:=readkey; if upcase(b)='Y' then twocol:=true else twocol:=false;
     if twocol then writeln('Y') else writeln('N');
{     writeln('Hi Micha. Schreib'' Mal!');}
   {$IFNDEF NEW}
     if not cube then begin
        wRite('LoaderMul: ');
        Readln(Mul);
     end;
   {$ENDIF}
end;

procedure read65535(var p:Screen;t:string);
var c,cc,ccc,cccc:word;
    b:array[0..1] of byte;f:file;
begin
     assign(f,t);
     reset(f,1);
     c:=1;
     cccc:=filesize(f)-1;
     if cccc<65534 then exit;
     for cc:=0 to 255 do begin
     ccc:=0;
     while (c<cccc) and (ccc<=255) do begin
         blockread(f,b,2);
         b[0]:=b[0] shr 1;
         p[1+(cc shl 8+ccc)]:=b[0];
         inc(c,2);
         inc(ccc);
     end;
     end;
     close(f);
end;

procedure read4096(var p:Screen;t:string);
var c,cc,ccc,cccc:word;
    b:byte;f:file;
begin
     assign(f,t);
     reset(f,1);
     c:=1;
     cccc:=filesize(f)-1;
     if cccc<4095 then exit;
     cc:=0;
     while cc<256 do begin
     ccc:=0;
     while (c<cccc) and (ccc<=127) do begin
         blockread(f,b,1);dec(b,118);
         p[1+(cc shl 8+ccc)]:=b;
         p[1+(cc shl 8+ccc)+1]:=b;
         inc(c,2);
         inc(ccc,2);
     end;
     for cc:=cc to cc+4 do
         move(p[1+(cc shl 8)],p[1+((cc+1) shl 8)],128);
     end;
end;

procedure setup;
var c,cc:Word;angle:real;c2:integer;
    f:file;
begin
     askem;
     getmem(EnvTex, sizeof(Screen));
     EnvSeg:=seg (EnvTex^);
     assign(f,'128x256.raw');
     reset(f,1);
     BlockRead(f,EnvTex^,2*16384);
     close(f);
     getmem(v_screen, sizeof(screen));
     VSeg := seg(v_screen^);
     getmem(TexMap, sizeof(screen));
     MapSeg := seg(TexMap^);
{     assign(f,'128x256.raw');
     reset(f,1);
     BlockRead(f,TexMap^,2*16384);
     close(f);}
     read4096(TexMap^,'texture.002');
{     fillchar(TexMap^,65535,9);}
{     for c:=1 to 65535 do TexMap^[c]:=TexMap^[c] shr 1;
     for c:=1 to 65535 do EnvTex^[c]:=EnvTex^[c] shr 1;}
     cls(VSeg,0);
     getmem(PalConv, 65535);
     PSeg := seg(PalConv^);
{     for c:=0 to 9 do
     for cc:=0 to 127 do begin
         if (Round((c*28)*(cc/255))-2*c) > Round((c*28)*(cc/255)) then
         PalConv^[c+118,cc]:=(Round((9*28)*(cc/255)))-2*c
         else PalConv^[c+118,cc]:=(Round((c*28)*(cc/255)));
     end;}
     for c:=0 to 9 do begin
         for cc:=0 to 100 do if (Round((c*28)*(cc/355){-(cc/11.6875)}))>0
         then PalConv^[c,cc]:=Round((c*28)*(cc/355){-(cc/11.6875)}) shr 1
         else PalConv^[c,cc]:=0;
         for cc:=101 to 127 do if Round((c*28)*(cc/(355-((cc-101)/0.26)))+((cc-101)/1.6875)+((cc-101)/27*(9-c)*4))<127
         then PalConv^[c,cc]:=Round((c*28)*(cc/(355-((cc-101)/0.26)))+((cc-101)/1.6875)+((cc-101)/27*(9-c)*4)) shr 1
         else PalConv^[c,cc]:=63;
     end;
     getmem(ZBuffer, sizeof(ZB));
     ZSeg := seg(ZBuffer^);
     for c2 := -511 to 511 do begin
         sint[c2] := round(65535*sin(c2 * pi / 256));
         cost[c2] := round(65535*cos(c2 * pi / 256));
     end;
     asm
        mov ax,13h
        int 10h
     end;
     for c:=0 to 100 do dopal(c,c div 9,c div 13,c div 2);
     for c:=0 to 26 do dopal(c+101,10+(c*2),8+(c*2),(c+101)div 2);
     for c:=0 to 100 do dopal(c+128,c div 2,c div 13,c div 2);
     for c:=0 to 26 do dopal(c+101+128,(c+101)div 2,8+(c*2),(c+101)div 2);

{     for c:=0 to 100 do dopal(c,c div 10,c div 15,c div 3);
     for c:=0 to 26 do dopal(c+101,7+(c*2),10+(c*2),33+(c));
     for c:=0 to 100 do dopal(c+128,c div 3,c div 15,c div 3);
     for c:=0 to 26 do dopal(c+229,33+(c),7+(c*2),33+(c));}
end;
{----------------------------------------------------------------------------}
procedure shutdown;

procedure MyExit;
var H2, M2, S2, Hun2: Word;
    Seks: Real;
begin
    GetTime (H2, M2, S2, Hun2);
    Seks:=60*(M2-Integer(M))+S2-Integer(S)+((Hun2-Integer(Hun))/100);
    TextMode(CO80);
    Writeln;
    WriteLn( Pics, ' Pics Painted...');
    if seks >0 then WriteLn ((Pics/Seks):4:1, ' Frames per second!');
    writeln('Free Mem: ',MemAvail,' Biggest Block: ',MaxAvail);
end;

begin;
      MyExit;
      freemem(v_screen, sizeof(screen));
      freemem(EnvTex, sizeof(Screen));
      freemem(TexMap, sizeof(Screen));
      freemem(PalConv, 65535);
      freemem(ZBuffer, sizeof(ZB));
      freeobject(t);
end;
{----------------------------------------------------------------------------}
(*procedure SetzeMatrix (A, B, C: Integer);
  Var SA, SB, SC: LongInt;
      CA, CB, CC: LongInt;
      SBCC, SBSC: LongInt;
  Begin
    SA:=SinT[A];     {IIIII}
    SB:=SinT[B];     {I}
    SC:=SinT[C];     {III}
    CA:=CosT[A];     {IIIII}
    CB:=CosT[B];     {IIII}
    CC:=CosT[C];     {III}
    SBCC:=LMul(SB,CC);
    SBSC:=LMul(SB,SC);
    RotMatrix [1,1]:=LMul(CB,CC);
    RotMatrix [1,2]:=LSub(LMul(SA,SBCC),LMul(CA,SC));
    RotMatrix [1,3]:=LAdd(LMul(CA,SBCC),LMul(SA,SC));
    RotMatrix [2,1]:=LMul(CB,SC);
    RotMatrix [2,2]:=LAdd(LMul(SA,SBSC),LMul(CA,CC));
    RotMatrix [2,3]:=LSub(LMul(CA,SBSC),LMul(SA,CC));
    RotMatrix [3,1]:=-SB;
    RotMatrix [3,2]:=LMul(SA,CB);
    RotMatrix [3,3]:=LMul(CA,CB);
End;*)
{----------------------------------------------------------------------------}
procedure rotatedraw(var Obj:ObjectType);
var c,c2:Word;
    tt,tt2:longint;
begin
     with Obj do begin
          RotierePunkte(points^[1].OrgPoints.x,points^[1].Temp.x, LPoints,sizeof(Point));
          RotierePunkte(points^[1].PNormals.x,points^[1].PointNormals.x, LPoints,sizeof(Point));
          RotierePunkte(polys^[1].OriginNormal.x,polys^[1].Normal.x, LPolys,sizeof(Poly));
          for c:=1 to LPoints do begin
              tt:=(sint[((pics shl 6)+(c shl 7)) and 511]{ shl 1});
              points^[c].Temp.x:=LAdd(points^[c].Temp.x,tt);
              points^[c].Temp.y:=LAdd(points^[c].Temp.y,(cost[((pics shl 5)+(c shl 6)) and 511]{ shl 1}));
              points^[c].Temp.z:=LAdd(points^[c].Temp.z,tt shl 1);
              tt:=(sint[((pics shl 3)+(c shl 7)) and 511] div 4);
              tt2:=LAdd(points^[c].PointNormals.x,tt);
              if tt2>65535 then points^[c].PointNormals.x:=65535
              else if tt2<-65535 then points^[c].PointNormals.x:=-65535
              else points^[c].PointNormals.x:=tt2;
              tt2:=LSub(points^[c].PointNormals.y,tt);
              if tt2>65535 then points^[c].PointNormals.y:=65535
              else if tt2<-65535 then points^[c].PointNormals.y:=-65535
              else points^[c].PointNormals.y:=tt2;
          end;
          TransPunkte(Obj,LPoints);
          CalcEnvCos(points^[1].PointNormals.x, LPoints);
          for c := 1 to LPolys do with polys^[c] do begin
              if normal.z<13107 then begin
                 prepxdata;
                 for c2:=1 to NumEdg-1 do EnvLine (points^[1].EnvCos.X,
                                                   data[c2],data[c2+1],c2,NumEdg);
                 EnvLine (points^[1].EnvCos.x,data[NUmEdg],data[1],NumEdg,NumEdg);
                 if twocol then if odd(c) then ColorAdd:=128 else ColorAdd:=0 else ColorAdd:=0;
                 {$IFDEF fill}
                 shadedxlines;
                 {$ELSE}
                 if miny<0 then miny:=0;if maxy>199 then maxy:=199;
                 for c2:=miny to maxy do begin
                     mem[vseg:c2*320+X_Data[c2].X1]:=127;
                     mem[vseg:c2*320+X_Data[c2].X2]:=127;
                 end;
                 {$ENDIF}
              end;
          end;
     end;
end;
{----------------------------------------------------------------------------}
begin
  setoffsets(t);
  Pics:=0;
  setup;
  {$IFDEF NEW}
  if cube then MakeCube(t) else readobj(t,name);
  {$ELSE}
  if cube then MakeCube(t) else readobj(t,name,mul);
  {$ENDIF}
  coloradd:=0;
  GetTime (H, M, S, Hun);
  repeat
         cls(VSeg,0);
         cls(ZSeg, 127);
         ANgleX:= (ANgleX+AddX) and 511;
         SetMatrix ( AngleX, (AngleX+AngleX) and 511,-AngleX );
         rotatedraw(t);
         if Dub then begin
            SetMatrix ( -(AngleX+AngleX) and 511, AngleX, ((AngleX+AngleX) and 511));
            rotatedraw(t);
         end;
         switch(VSeg,$a000);
         Inc (Pics);
  until port[$60]=1;
  shutdown;
end.
