.386
jumps
; (c) 1996 by Daniel Vollmer...

Data Segment Word Use16
Extrn RotMatrix: DWord: 9
Extrn SinT,CosT: DWord: 1023
Data EndS

Code Segment DWord Use16

Assume CS: Code, DS: Data

Public LMul, LDiv, LAdd, LSub, LSqrt, LQuad, LTrunc
Public SetMatrix, RotierePunkte, TransPunkte, CalcEnvCos

LMul Proc Pascal Near
Arg A: DWord, B: DWord
    Mov EAX, A
    IMul B
    Shr EAX, 16
    Ret
EndP

LDiv Proc Pascal Near
Arg A: DWord, B: DWord
    Mov EAX, A
    Cdq
    Shld EDX, EAX, 16
    Shl EAX, 16
    IDiv B
    Shld EDX, EAX, 16
    Ret
EndP

LAdd Proc Pascal Near
Arg A: DWord, B: DWord
    Mov EAX, A
    Add EAX, B
    Shld EDX, EAX, 16
    Ret
EndP

LSub Proc Pascal Near
Arg A: DWord, B: DWord
    Mov EAX, A
    Sub EAX, B
    Shld EDX, EAX, 16
    Ret
EndP

LSqrt Proc Pascal Near
Arg A: DWord
    Mov EAX, A
    Or  EAX, EAX
    Jz  Sqrt_Exit
    Mov EBX, 8
    Mov ECX, EAX
    Mov EDI, EAX
Sqrt_Loop:
    Mov EAX, ECX
    Sub EDX, EDX
    Shld EDX, EAX, 16
    Shl EAX, 16
    IDiv EDI
    Cmp EAX, EDI
    Je Sqrt_Exit
    Add EAX, EDI
    Shr EAX, 1
    Mov EDI, EAX
    Dec EBX
    Jz Sqrt_Exit
    Jmp Sqrt_Loop
Sqrt_Exit:
    Shld EDX, EAX, 16
    Ret
EndP

LQuad PRoc Pascal Near
Arg A: DWord
    Mov EAX, A
    IMul EAX
    Shr EAX, 16
    Ret
EndP

LTrunc Proc PAscal Near
Arg A: DWord
    Mov AX, Word Ptr A+2
    Ret
EndP

SetMatrix Proc Pascal Near
Arg A:Word, B:Word, C:Word
Local SB:DWord, SC:DWord
Local CB:DWord, CC:DWord
Local SBCC:DWord, SBSC:DWord
   mov   cx,511
   mov   bx,A
   add   bx,cx
   shl   bx,2
   mov   eax,[offset SinT+bx]
   mov   edi,eax               ; SA=edi
   mov   eax,[offset CosT+bx]
   mov   esi,eax               ; CA=esi

   mov   bx,C
   add   bx,cx
   shl   bx,2
   mov   eax,[offset SinT+bx]
   mov   SC,eax
   mov   eax,[offset CosT+bx]
   mov   CC,eax

   mov   bx,B
   add   bx,cx
   shl   bx,2
   mov   eax,[offset CosT+bx]
   mov   CB,eax
   mov   eax,[offset SinT+bx]

   mov   SB,eax
   lea   bx,RotMatrix
   push  eax

   push  eax
   neg   eax
   mov   [bx+24],eax                ;    RotMatrix [3,1]:=-SB;
   pop   eax

   imul  CC
   shrd  eax,edx,16                 ;    SBCC:=LMul(SB,CC);
   mov   SBCC,eax
   pop   eax

   imul  SC
   shrd  eax,edx,16                 ;    SBSC:=LMul(SB,SC);
   mov   SBSC,eax

   mov   eax,CB
   imul  CC
   shrd  eax,edx,16
   mov   [bx],eax                   ;    RotMatrix [1,1]:=LMul(CB,CC);

   mov   eax,edi
   imul  SBCC
   shrd  eax,edx,16
   push  eax
   mov   eax,esi
   imul  SC
   shrd  eax,edx,16
   pop   ecx
   sub   ecx,eax
   mov   [bx+4],ecx                 ;    RotMatrix [1,2]:=LSub(LMul(SA,SBCC),LMul(CA,SC));

   mov   eax,esi
   imul  SBCC
   shrd  eax,edx,16
   push  eax
   mov   eax,edi
   imul  SC
   shrd  eax,edx,16
   pop   ecx
   add   ecx,eax
   mov   [bx+8],ecx                 ;    RotMatrix [1,3]:=LAdd(LMul(CA,SBCC),LMul(SA,SC));

   mov   eax,CB
   imul  SC
   shrd  eax,edx,16
   mov   [bx+12],eax                ;    RotMatrix [2,1]:=LMul(CB,SC);

   mov   eax,edi
   imul  SBSC
   shrd  eax,edx,16
   push  eax
   mov   eax,esi
   imul  CC
   shrd  eax,edx,16
   pop   ecx
   add   ecx,eax
   mov   [bx+16],ecx                ;    RotMatrix [2,2]:=LAdd(LMul(SA,SBSC),LMul(CA,CC));

   mov   eax,esi
   imul  SBSC
   shrd  eax,edx,16
   push  eax
   mov   eax,edi
   imul  CC
   shrd  eax,edx,16
   pop   ecx
   sub   ecx,eax
   mov   [bx+20],ecx                ;    RotMatrix [2,3]:=LSub(LMul(CA,SBSC),LMul(SA,CC));

   mov   eax,edi
   imul  CB
   shrd  eax,edx,16
   mov   [bx+28],eax                ;    RotMatrix [3,2]:=LMul(SA,CB);

   mov   eax,esi
   imul  CB
   shrd  eax,edx,16
   mov   [bx+32],eax                ;    RotMatrix [3,3]:=LMul(CA,CB);
   ret
SetMatrix endp

RotierePunkte Proc Pascal Near
Arg RP_X: DWord,TR_X:DWord,Count:Word,ArrSize:Word
Local RP_X2: DWord, RP_Y2: DWord, RP_Z2: DWord
    Les BX, RP_X
    Lfs SI, TR_X
    Mov di, Count
@doitall:
    Mov EAX, ES:[BX]
    Mov ECX, EAX
    IMul DWord Ptr RotMatrix
    Shrd EAX, EDX, 16
    Mov RP_X2, EAX

    Mov EAX, ECX
    IMul DWord Ptr RotMatrix+12
    Shrd EAX, EDX, 16
    Mov RP_Y2, EAX

    Mov EAX, ECX
    IMul DWord Ptr RotMatrix+24
    Shrd EAX, EDX, 16
    Mov RP_Z2, EAX

    Mov EAX, ES:[BX+4]
    Mov ECX, EAX
    IMul DWord Ptr RotMatrix+4
    Shrd EAX, EDX, 16
    Add RP_X2, EAX

    Mov EAX, ECX
    IMul DWord Ptr RotMatrix+16
    Shrd EAX, EDX, 16
    Add RP_Y2, EAX

    Mov EAX, ECX
    IMul DWord Ptr RotMatrix+28
    Shrd EAX, EDX, 16
    Add RP_Z2, EAX

    Mov EAX, ES:[BX+8]
    Mov ECX, EAX
    IMul DWord Ptr RotMatrix+8
    Shrd EAX, EDX, 16
    Add EAX, RP_X2
    Mov ES:[SI], EAX

    Mov EAX, ECX
    IMul DWord Ptr RotMatrix+20
    Shrd EAX, EDX, 16
    Add EAX, RP_Y2
    Mov ES:[SI+4], EAX

    Mov EAX, ECX
    IMul DWord Ptr RotMatrix+32
    Shrd EAX, EDX, 16
    Add EAX, RP_Z2
    Mov ES:[SI+8], EAX

    Add BX,ArrSize
    Add SI,ArrSize
    Dec DI
    Jnz @doitall
    Ret

RotierePunkte EndP

TransPunkte Proc Pascal Near
Arg Obj:DWord, Count:Word
Local XOffs:Word, YOffs:Word, XOffs3D:DWord, YOffs3D:DWord, ZOffs:DWord, Dist:DWord
;    for c1 := 1 to GeoMaxP do begin
;        te1 := LAdd(Temp[c1].z,ZOffs);
;        Coords[c1].X := ltrunc(Ldiv(Temp[c1].x shl 7,te1))+XOffs;
;        Coords[c1].Y := ltrunc(LDiv(Temp[c1].y shl 7,te1))+YOffs;
;    end;
     Les        bx,Obj
     mov        ax,es:[bx+13]
     mov        XOffs,ax
     mov        ax,es:[bx+15]
     mov        YOffs,ax
     mov        eax,es:[bx+17]
     mov        XOffs3D,eax
     mov        eax,es:[bx+21]
     mov        YOffs3D,eax
     mov        eax,es:[bx+25]
     mov        ZOffs,eax
     mov        eax,es:[bx+29]
     mov        Dist,eax
     Les        bx,es:[bx+4]
     add        bx,12
     Mov        cx,Count
@transthem:
     mov        edi,es:[bx+8]
     add        edi,ZOffs
     mov        eax,es:[bx]
     add        eax,XOffs3D
     cdq
     imul       eax,dist
     idiv       edi
     add        ax,XOffs
     mov        es:[bx+40],ax
     mov        eax,es:[bx+4]
     add        eax,YOffs3D
     cdq
     imul       eax,dist
     idiv       edi
     add        ax,YOffs
     mov        es:[bx+42],ax
     mov        eax,es:[bx+8]
     shr        eax,6
     mov        es:[bx+44],ax
     add        bx,64
     dec        cx
     jnz        @transthem
     ret

TransPunkte endp

CalcEnvCos Proc Pascal Near
Arg PointN:DWord,Count:Word
;     for c:=1 to GeoMaxP do begin
;         EnvCos [c].X:=(PointNormals [c].X *63)+4194303;
;         EnvCos [c].Y:=(PointNormals [c].Y *63)+4194303;
;     end;
    les  bx,PointN
    mov  cx,count
@loopit:
    mov  eax,es:[bx]
    add  eax,65535
    shr  eax,2
    mov  es:[bx+12],ax
    mov  eax,es:[bx+4]
    add  eax,65535
    shr  eax,2
    mov  es:[bx+14],ax
    add  bx,64
    dec  cx
    jnz  @loopit
    ret
CalcEnvCos endp
Code EndS

End

