{$M 4096,0,0}
program menu; {(c) 1996 Daniel Vollmer}
uses crt,dos;
const NumEntries=256;
      StringLength=79;
      XSize=80;
      YSize=24;
      TextSeg=$b800;
      TextSeg2=$b800+((XSize*(YSize+1)*2) div 16);
      Fill=$5d20;
var
   list  : array[1..NumEntries,1..2] of string[StringLength];
   NumEnt: integer;
   Actual: integer;
   Line  : integer;
   t     : boolean;
   Num   : string[3];
   NumPos: byte;
   Status: string[XSize-1];
   Saver : string[StringLength];
   Ticks : LongInt;
   SaveTime : LongInt;
   f:text;

procedure copybuffer(var source,destinat);assembler;
asm
   push     ds
   lds      si,source
   les      di,destinat
   mov      cx,XSize*(YSize+1)
   rep      movsw
   pop      ds
end;

function FileExists(dname : string) : boolean;
var dumf : file;
begin;
  {$I-}
  FileExists:=false;
  assign(dumf,dname);
  reset(dumf,1);
  if IOResult = 0 then begin
    if FileSize(dumf)>0 then FileExists:=true;
    close(dumf);
  end;
end;

procedure error(s:string);
begin
     writeln(#13+#10+#13+#10+s);
     halt(1);
end;

procedure rline(var s:string);
var
   b:byte;
   s2:string;
begin
     repeat
           if eof(f) then begin
              close(f);
              error('Menu Error: Corrupt Menu-File (line missing)!');
           end;
           readln(f,s);
           s2:=s;
           b:=1;
           while s2[b]=#32 do delete(s2,b,1);
     until (s2[1]<>';') and (s2<>''); { comment or blank }
end;

function rnum:integer;
var I, Code: Integer;
    s:string;
begin
     rline(s);
     val(s, I, Code);
     if code <> 0 then begin
        close(f);
        error('Menu Error: Corrupt Menu-File (number expected)!');
     end;
     rnum:=i;
end;

procedure ww(s:integer);
begin
     case s of
     1..9:writeln('  ',s,'. '+list[s,1]);
     10..99:writeln(' ',s,'. '+list[s,1]);
     100..NumEntries:writeln(s,'. '+list[s,1]);
     end;
end;

procedure screen(start:integer);
var c:integer;
begin
     clrscr;
     if (NumEnt-start)>=YSize-1 then begin
        for c:=0 to YSize-2 do ww(start+c);
        if start+YSize-1<100 then write(' ',start+YSize-1,'. ',list[start+YSize-1,1])
        else write(start+YSize-1,'. ',list[start+YSize-1,1]);
     end else begin
         for c:=0 to NumEnt-2 do ww(start+c);

         if NumEnt>9 then write(' ',NumEnt,'. ',list[NumEnt,1])
         else write('  ',NumEnt,'. ',list[NumEnt,1]);
     end;
     gotoxy(1,YSize+1);
     textcolor(LightMagenta);TextBackground(Magenta);
     write(Status);
     memw[TextSeg:24*160+158]:=fill;
     TextColor(LightCyan);
     TextBackground(Blue);
     copybuffer(mem[TextSeg:0],mem[TextSeg2:0]);
end;

procedure highline(offst:word;line,x:byte);assembler;
asm
   xor  dh,dh
   xor  bh,bh
   push TextSeg2
   pop  es
   xor  di,di
   mov  al,XSize*2
   mul  byte ptr line
   inc  ax
   add  ax,offst
   add  di,ax
   mov  dl,x
   dec  dl
@loop:
   mov  bx,dx
   add  bx,bx
   mov  al,es:[di+bx]
   not  al
   and  al,01111111b
   or   al,00001000b
   mov  es:[di+bx],al
   dec  dl
   jns  @loop
end;

function up:boolean;
begin
     up:=false;
     if (Actual=1) and (Line+Actual>1) then begin
        dec(Line);
        highline(0,Actual-1,XSize);
        up:=true;
     end else if Actual>1 then begin
         highline(0,Actual-1,XSize);
         dec(Actual);
     end else highline(0,Actual-1,XSize);
end;

function down:boolean;
begin
     down:=false;
     if (Actual=YSize) and (Line+Actual<NumEnt) then begin
        inc(Line);
        highline(0,Actual-1,XSize);
        down:=true;
     end else if Actual+Line<NumEnt then begin
         highline(0,Actual-1,XSize);
         inc(Actual);
     end else highline(0,Actual-1,XSize);
end;

procedure myexec(s:string);
var
   x,x2:String;
   dir:string;
   P: PathStr;
   D: DirStr;
   N: NameStr;
   E: ExtStr;
   c:byte;
begin
     x:=s;
     x2:='';
     if pos(' ',x)<>0 then begin {params trennen}
        x2:=copy(x,pos(' ',x),(length(x)-pos(' ',x))+1);
        while (x2[1]=' ') do delete(x2,1,1);
        delete(x,pos(' ',x),(length(x)-pos(' ',x))+1);
     end;
     FSplit(x, D, N, E);
     getdir(0,Dir); {save dir}
     if not fileexists(D+N+E) then error('Menu Error: File '+D+N+E+' not found!');
     if d[length(d)]='\' then delete(D,Length(d),1);
     chdir(d);
     t:=true;
     for c:=1 to length(e) do e[c]:=upcase(e[c]);
     Textcolor(lightgray);textbackground(black);
     clrscr;
     SwapVectors;
     if e<>'.BAT' then exec(N+E,x2) else exec('c:\dos\command.com','/C '+N+E+' '+x2);
     SwapVectors;
{     writeln(DosError);readkey;}
     TextColor(LightCyan);TextBackground(Blue);
     chdir(Dir); {change back}
     Ticks:=meml[$40:$6C];
end;

procedure ReadMenu(N:Byte);
var c:integer;
begin
     assign(f,paramstr(N));
     reset(f);
     rline(Status);
     while length(Status)<sizeof(Status)-1 do insert(' ',Status,length(Status)+1);
     NumEnt:=rnum;
     if NumEnt>NumEntries then begin
        close(f);
        error('Menu Error: Too many entries in Menu-File!');
     end;
     rline(Saver);
     SaveTime:=rnum;
     SaveTime:=SaveTime*18;
     for c:=1 to NumEnt do begin
         rline(list[c,1]);
         rline(list[c,2]);
     end;
     close(f);
     Num:='   ';
     NumPos:=1;
     Actual:=1;
     Line:=0;
     t:=true;
end;

var
   c     : integer;
   err   : integer;
   ch    : char;
   ActualMenu:byte;
begin
     if paramcount<1 then error('Menu Error: Name of the Menu-File required!');
     for c:=1 to paramcount do if not fileexists(paramstr(c)) then error('Menu Error: Menu-File '+paramstr(c)+' not found!');
     ActualMenu:=1;
     readmenu(ActualMenu);
     TextColor(LightCyan);
     TextBackground(Blue);
     Ticks:=meml[$40:$6C];
     repeat
           if t then begin
              screen(Line+1);
              t:=false;
           end;
           highline(0,Actual-1,XSize);
           copybuffer(mem[TextSeg2:0],mem[TextSeg:0]);
           mem[TextSeg:77*2]:=ord(Num[1]);
           mem[TextSeg:78*2]:=ord(Num[2]);
           mem[TextSeg:79*2]:=ord(Num[3]);
           repeat
                 if meml[$40:$6C]-Ticks>=SaveTime then begin
                    myexec(Saver);
                    Ticks:=meml[$40:$6C];
                    while keypressed do readkey;
                    screen(Line+1);
                    highline(0,Actual-1,XSize);
                    copybuffer(mem[TextSeg2:0],mem[TextSeg:0]);
                    mem[TextSeg:77*2]:=ord(Num[1]);
                    mem[TextSeg:78*2]:=ord(Num[2]);
                    mem[TextSeg:79*2]:=ord(Num[3]);
                    t:=false;
                 end;
           until keypressed;
           Ticks:=meml[$40:$6C];
           ch:=readkey;
           case ch of
           #0:begin
                  ch:=readkey;
                  case ch of
                  #80:if down then t:=true;
                  #71:begin
                           for c:=2 to (Line+Actual) do up;
                           t:=true
                      end;
                  #72:if up then t:=true;
                  #73:begin
                           t:=true;
                           if Actual>1 then for c:=2 to Actual do up
                           else if Line>0 then if Line>YSize-2 then dec(Line,YSize-1)
                           else Line:=0;
                      end;
                  #75:if ActualMenu>1 then begin
                         dec(ActualMenu);
                         t:=true;
                         readmenu(ActualMenu);
                      end else highline(0,Actual-1,XSize);
                  #77:if ActualMenu<paramcount then begin
                         inc(ActualMenu);
                         t:=true;
                         readmenu(ActualMenu);
                      end else highline(0,Actual-1,XSize);
                  #79:begin
                           for c:=(Line+Actual) to NumEnt-1 do down;
                           t:=true;
                      end;
                  #81:begin
                           if Actual<YSize then for c:=Actual to YSize-1 do down
                           else if NumEnt-(Line+Actual)>=YSize-1 then inc(Line,YSize-1)
                           else Line:=NumEnt-YSize;
                           t:=true;
                      end;
                  else highline(0,Actual-1,XSize);
                  end;
              end;
           #13,#32:begin
                    if NumPos>1 then begin
                       highline(0,Actual-1,XSize);
                       while Pos(' ',Num) > 0 do delete(Num,Pos(' ',Num),1);
                       val(Num,c,err);
                       Num:='   ';
                       NumPos:=1;
                       if err=0 then begin
                          if (c>0) and (c<=NumEnt) then
                          if (Line+YSize>=c) and (Line<c) then Actual:=c-Line
                          else if (Line>=c) then begin
                             Line:=c-1;
                             Actual:=1;
                             t:=true;
                          end else if (Line+YSize<c) then begin
                             Line:=c-YSize;
                             Actual:=YSize;
                             t:=true;
                          end;
                       end;
                    end else myexec(list[Line+Actual,2]);
               end;
           #8:begin
                   highline(0,Actual-1,XSize);
                   if NumPos>1 then begin
                      Num[NumPos-1]:=' ';
                      dec(NumPos);
                   end;
              end;
           '0'..'9':begin
                         highline(0,Actual-1,XSize);
                         if NumPos<=3 then begin
                            insert(ch,Num,NumPos);
                            inc(NumPos);
                         end;
                    end;
           else begin
                highline(0,Actual-1,XSize);
                NumPos:=1;
                Num:='   ';
           end;
           end;
     until (ch=#27);
     TextColor(LightGray);TextBackground(Black);
     clrscr;
end.
