// Copyright (C) 1995 Christian Worm
//
// Bemrk: Dette program er udviklet til og compileret med BC++ 4.0
// Dette program bruges til at samle de forskellige assembler
// filer til 3 forskellige assembler filer. Disse 3 kan compileres
// og herefter bruges sammen med Pascal interfacet.
// Filerne fr flgende navne:

#define PACK_FILE_NAME   "PASENCOD.ASM"
#define UNPACK_FILE_NAME "PASDECOD.ASM"
#define SHARED_FILE_NAME "PASCOMN.ASM"

#include <process.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>

//----------------------------------------------------------------------------
// Flgende klasse bruges til at lse filer i et direcrory inklusiv
// subdirectories.

class readdirs {
  public:
  void start_read(char* basedir);
  // Denne start lsningen af dir og subdirectorues og giver dem alle til:

  virtual void putfile(char* filename)=0;
  // Kaldes for alle filer
};

void readdirs::start_read(char* basedir) {
  char dirname[128];
  strcpy(dirname,basedir);
  if(dirname[strlen(dirname)-1]!='\\') strcat(dirname,"\\");
  // dirname indeholder nu directory navn + \\
  char* cur_entry=dirname+strlen(dirname);
  // cur_entry indeholder pointer til frste char efter \\

  strcpy(cur_entry,"*.*"); // dirname indholder dirnavn + \\*.*
  find_t curdir;
  int done=_dos_findfirst(dirname,_A_SUBDIR,&curdir);
  while(!done) {
    if(curdir.name[0]!='.') {
      // Hvis vi ikke er i et af de trivielle subdirs
      strcpy(cur_entry,curdir.name); // sr dirname til vrdi
      if(curdir.attrib & _A_SUBDIR)
        // Hvis vi er i et almindeligt subdir, s process det:
        start_read(dirname);
      else
        // Tjek for om den fil vi har fundet er en af de filer vi er ved
        // at skrive. Rent logisk burde tjekke ikke vre i denne
        // gennrelle klasse, men det er det nemmeste :)
        if((strcmp(curdir.name,PACK_FILE_NAME)) &&
           (strcmp(curdir.name,UNPACK_FILE_NAME)) &&
           (strcmp(curdir.name,SHARED_FILE_NAME)))
          // S vis  filen til brugeren
          putfile(dirname);
    }
    done=_dos_findnext(&curdir);
  }
  return;
}

//----------------------------------------------------------------------------
// Den flgende klasser bruger ovenstende klasse til at lse alle
// filer som skal processes. Den filtrer alle ikke-ASM filer fra
// og identificerer endvidere hvad der hrrer til pakkeren, hvad
// der hrer til udpakkeren og hvad der hrer til begge dele.
// De enkelte kendes ved at de har en linie med flgende udseende:

#define PACK_FILE   "include ctrl\\packint.ah\n"
#define UNPACK_FILE "include ctrl\\unpkint.ah\n"
#define SHARED_FILE "include ctrl\\packgen.ah\n"

class find_asms:readdirs {
  virtual void putfile(char* filename);

  public:
  readdirs::start_read; // Public funktion fra readdirs som stter det hele igang

  virtual void put_asm_file(char* asm_file, int file_type)=0;
  // Sender en fil og angiver typen. 0=Pakker fil, 1=Udpakker fil, 2=Flles fil
};

void find_asms::putfile(char* filename) {
  if(strcmp(filename+strlen(filename)-3,"ASM")) return; // Ignorer alle ikke ASM filer

  printf("\nCoppying %s\n",filename);

  // ben filen og sg efter kendetegn:
  FILE* f=fopen(filename,"rt");
  char curline[161];
  int type=-1;
  while(fgets(curline,161,f)) {
    // curline indholder en linie fra filen:
    if(!strcmp(curline,PACK_FILE))   { type=0; break; }
    if(!strcmp(curline,UNPACK_FILE)) { type=1; break; }
    if(!strcmp(curline,SHARED_FILE)) { type=2; break; }
  }
  fclose(f);

  if(type==-1) {
    // Filens tilhrs forhold blev ikke fundet:
    printf("The file is not identified and is ignored\n");
    return;
  }

  // Ellers vis fil til bruger:
  put_asm_file(filename,type);
}

//----------------------------------------------------------------------------
// Flgende klasse reprsnetere en destinations fil - d.v.s. en af de 3

class dest_file {
  char include[25][40];
  // Liste over alle inklude filer. Vi skal sikre at den samme fil
  // ikke inkluder den samme fil to gange.

  int includes;
  // Antal inklude filer indtil videre

  FILE* d;
  // Den fil vi kopierer til.

  public:
  dest_file(char* dest_filename);
  // Initerer klassen med det givne destinations navn

  ~dest_file();

  void copy_file(char*);
  // Denne kopierer en given assembler fil til denne destinations fil.
};

dest_file::dest_file(char* name) {
  includes=0;
  d=fopen(name,"wt");
}

dest_file::~dest_file() {
  // Angiv at filen slutter og luk den:
  fprintf(d,"\nend");
  fclose(d);
}

void dest_file::copy_file(char* name) {
  // Skriv frst til at vores destinations fil at her starter en ny fil:
  fprintf(d,"\n\n;-------------------%s-------------------\n\n",name);

  // Og start s kopiering
  FILE* s=fopen(name,"rt");
  char curline[160];
  while(fgets(curline,160,s)!=NULL) { // G alle linier igennem
    if(!memicmp(curline,"include ",8)) { // Hvis vi har en include linie
      // Se efter om den pgldende fil allerede er included:
      for(int a=0; a<includes; a++)
        if(!stricmp(curline+8,include[a])) break;
      if(a!=includes) continue; // Hvis filen er includeded s fortst
      // Tilfj filen til vores liste:
      if(strlen(curline+8)>40) {
        printf("Warning: Include line too long\n");
        continue;
      }
      if(includes==25) {
        printf("Warning: Too many include files\n");
        continue;
      }
      strcpy(include[includes++],curline+8);
    } else if((!stricmp(curline,"end\n")) || (!stricmp(curline,"end")))
      // Hvis vi har net slutningen
      break;

    fputs(curline,d);
  }
  fclose(s);
}

//----------------------------------------------------------------------------
// Flgende klasse bruger ovenstende klasser til at skrive de 3 assembler
// filer.

class write_result:find_asms {
  dest_file packf;
  dest_file unpckf;
  dest_file shrdf;

  public:
  find_asms::start_read; // Denne starter det hele

  write_result();

  virtual void put_asm_file(char* asm_file, int file_type);
};

write_result::write_result() :
  packf(PACK_FILE_NAME),
  unpckf(UNPACK_FILE_NAME),
  shrdf(SHARED_FILE_NAME) {}

void write_result::put_asm_file(char* asm_file, int file_type) {
  // Kopier den givne fil til den nskede fil:
  switch(file_type) {
    case 0: packf.copy_file(asm_file); break;
    case 1: unpckf.copy_file(asm_file); break;
    case 2: shrdf.copy_file(asm_file); break;
  }
}

//----------------------------------------------------------------------------

main(int argc, char* argv[]) {
  if(argc!=2) {
    printf("PASCOMP. Copytight (C) 1995 Christian Worm\n\n");
    printf("Syntax: PASCOMP dirname\n\n");
    printf("This program copy all the assembler files in dirname and its subdirectories\n");
    printf("to 3 different assembler files. These files can be assembled to the Pascal\n");
    printf("interface for suppack.\n");
    return 1;
  }

  // Opret ikke objketet her p stakken da det er ret stort:
  write_result* wr=new write_result;
  if(wr==NULL) abort();

  // G i gang:
  wr->start_read(argv[1]);

  delete wr;

  return 0;
}
