; (c) 1996 by daniel vollmer
.model tiny
codeseg
.386
org 100h
MaxStack equ 32
MaxInp equ 34
MaxProgram equ 128
MaxRealStack equ 20             ; 20 words of stack in the int...
;-----------------------------C-O-D-E-------------------------------------------

Dos macro Func
  mov	 ah,Func
  int	 21h
endm

getchar macro
  mov	 ah,10h
  int	 16h			; getchar in al
endm

upcase macro			; char in al -> uppercase
local end
  cmp	 al,'a'
  jb	 end
  cmp	 al,'z'
  ja	 end
  sub	 al,32
end:
endm

; install timer-handler, int 16 handler, keyboard-handler, and int 2f-handler
start:
  jmp	 @CalcInstall
;------------------------------------D-A-T-A------------------------------------
OrgSS dw ?
OrgSO dw ?
Active db 0
Exit db 0
VidSeg dw 0b800h
Base   db 10
Ident  db 'd'
Mode   db 0
ErrorCode db 0
MyStackPtr dw 0
include imag.asm
MenuLookUp dw 1071h,1177h,1265h,1e61h,1f73h,2064h
           dw 1051h,1157h,1245h,1e41h,1f53h,2044h
           dw 1011h,1117h,1205h,1e01h,1f13h,2004h
           dw 1000h,1100h,1200h,1e00h,1f00h,2000h
IRow1   db "DUP",0
        dw OpDup
        db "SWAP",0
        dw OpSwap
        db "Exit",0
        dw OpExit
        db "DROP",0
        dw OpDrop
        db "CLR",0
        dw OpClr
        db "Enter",0
        dw OpEnter
IRow2   db "X",0
        dw OpSqu
        db "ABS",0
        dw OpAbs
        db "MOD",0
        dw OpMod
        db "X",0
        dw OpSqr
        db "NEG",0
        dw OpNeg
        db "?",0
        dw OpNop
IRow3   db "SHL",0
        dw OpShl
        db "SHR",0
        dw OpShr
        db "NOT",0
        dw OpNot
        db "AND",0
        dw OpAnd
        db "OR",0
        dw OpOr
        db "XOR",0
        dw OpXor
IRow4   db "?",0
        dw OpNop
        db "?",0
        dw OpNop
        db "?",0
        dw OpNop
        db "?",0
        dw OpNop
        db "?",0
        dw OpNop
        db "?",0
        dw OpNop
IMenu	dw IRow1,IRow2,Irow3,Irow4
Menues	dw IMenu,IMenu,IMenu		; 0 integer, 2 comma, 4 float
KeyNum equ 10
KeyTab  dw 0372ah,OpMul
        dw 04e2bh,OpAdd
        dw 04a2dh,OpSub
        dw 0e02fh,OpDiv
        dw 03b00h,OpBin
        dw 03c00h,OpOct
        dw 03d00h,OpDec
        dw 03e00h,OpInt
        dw 03f00h,OpHex
        dw 0e00dh,OpDup
InpBuffer db MaxInp dup (?) ; maximum number of bytes needed in binary mode
Buff dw CalcImag_Width*CalcImag_Depth dup (?)
MyStack dd MaxStack dup (?)
ProgramBuffer db MaxProgram dup (?)
LocalStack dw MaxRealStack dup (?)
EndStack Label word
;-------------------------------------------------------------------------------
Int09Handler proc far
  push	 ax
  in	 al,60h
  cmp	 al,53			; my hotkey? ("/")
  jne	 @no
  cmp    cs:[Active],1
  jne    @cont
  mov    cs:[Exit],1
  jmp    @no
@cont:
  push   es
  push	 040h
  pop	 es
  mov    al,es:[017h]
  pop	 es
  test   al,00000100b           ; ctrl pressed ?
  jz	 @no

  push   es
  push   040h
  pop    es
  mov    al,es:[49h]
  pop    es
  cmp    al,3
  ja     i9@notgo

  cmp    cs:[Active],1
  je     i9@notgo
  mov	 cs:[Active],1
  mov    cs:[Exit],0

  in     al,61h                                 ; get control-reg
  or	 al,82h 				; set-bits to reset key-flip-flop
  out	 61h,al 				; sent...
  and	 al,7fh 				; mask off high-bit
  out	 61h,al 				; complete reset...
  mov	 al,20h
  out	 20h,al 				; reset PIC

  mov    cs:[OrgSS],ss
  mov    cs:[OrgSO],sp
  push   cs
  pop    ss
  mov    sp,offset EndStack-2

  push   ax
  mov    al, 20h         ; end-of-interrupt command
  out    20h, al         ; issue command to controller
  pop    ax

  pushad
  push	 ds
  push	 es

  mov    ah,12h
  mov    bl,32h
  mov    al,0
  int    10h

  sti

  mov    ax,0b800h
  push	 040h
  pop	 es
  movzx  bx,byte ptr es:[062h]	; pagenum...
  mov	 dx,es:[04ch]		; pagesize in byte
  shr	 dx,4			; convert to segment...
  cmp	 bx,0
  jz	 i@gotaddress
i@incloop:
  add	 ax,dx			; add pagesize
  dec	 bx
  jnz	 i@incloop
i@gotaddress:
  mov	 VidSeg,ax

  cld
  push   cs
  pop    es

  mov    ds,VidSeg

  mov	 si,21*2
  lea    di,Buff
  mov	 dx,CalcImag_Depth
i@saveloop:
  mov	 cx,CalcImag_Width
  rep	 movsw
  add	 si,(80-CalcImag_Width)*2
  dec	 dx
  jnz	 i@saveloop

  push	 cs			; set segments...
  pop	 ds
  mov	 es,VidSeg

  movzx  si,Mode
  call   drawmenu
;-------------------------------------------------------------------------------
  call   MainLoop
;-------------------------------------------------------------------------------
i9@exit:
  push   cs
  pop    ds
  mov	 es,VidSeg

  cld
  mov    di,21*2
  lea    si,Buff
  mov	 dx,CalcImag_Depth
saveloop:
  mov	 cx,CalcImag_Width
  rep	 movsw
  add	 di,(80-CalcImag_Width)*2
  dec	 dx
  jnz	 saveloop

  pop	 es
  pop	 ds
  popad
  mov	 cs:[Active],0

  cli
  mov    ss,cs:[OrgSS]
  mov    sp,cs:[OrgSO]
  sti
i9@notgo:
  pop    ax
  iret
@no:
  pop	 ax
  db	 0eah
  Old09  dw ?,?
Int09Handler endp
;-------------------------------------------------------------------------------
MainLoop proc near
  call   updatedisp
main@keyloop:
  cmp    cs:[Exit],1
  je     main@exit
  mov    ah,11h
  int	 16h
  jz	 main@keyloop
  upcase
  cmp    al,27
  je	 main@exit
  cmp    Ident,'i'
  jne    main@nominus
  cmp    al,'-'
  je     main@num
main@nominus:
  cmp    al,'A'
  jb	 main@nohex
  sub	 al,7
main@nohex:
  sub	 al,48
  cmp	 al,Base
  jb	 main@num
  getchar
  push   cs
  pop    es
  lea    di,KeyTab
  mov    cx,KeyNum
main@lookkeytable:
  scasw
  jne    main@nextkey
  clc
  call   [di]
  jmp    main@update
main@nextkey:
  add    di,2                   ; skip key-code...
  dec    cx
  jnz    main@lookkeytable

  mov    cx,4                   ; 4 rows...
  lea    di,MenuLookUp
  movzx  si,Mode
  mov    bx,[offset Menues+si]
main@menurowloop:
  mov    si,word ptr [bx]       ; now pts to row1
  mov    dx,6                   ; 6 fields...
main@fieldloop:
  cmp    [si],byte ptr 0
  je     main@nextfield
  inc    si
  jmp    main@fieldloop
main@nextfield:
  inc    si                     ; si now pts to the procedure
  cmp    ax,[di]                ; compare to hardcoded keycode...
  jne    main@nothisone
  clc
  call   [si]
  jmp    main@update
main@nothisone:
  add    si,2
  add    di,2
  dec    dx
  jnz    main@fieldloop
  add    bx,2
  dec    cx
  jnz    main@menurowloop
  jmp    main@keyloop

main@num:
  call	 ReadNumber
  jc     main@keyloop
  call	 mypush
  jc	 main@exit
main@update:
  call   updatedisp
  jmp	 main@keyloop
main@exit:
  mov    ah,11h
  int    16h
  jz     main@bye
  getchar                        ; remove the char...
main@bye:
  ret
MainLoop endp
;-------------------------------------------------------------------------------
MakeNumber proc near
; prints Number depending on State
; input:    eax=number
; output:   cx=num-chars
; destroys: cx
  push	 eax
  push	 ebx
  push	 edx
  push	 si
  push	 di

  push	 ds
  push	 es

  push	 cs
  pop	 es

  lea	 di,InpBuffer
  xor	 cx,cx
  movzx  ebx,Base
  push	 word ptr Ident 	; put on stack (last char)
  cmp	 Ident,'i'
  jne	 p@makeloop
  cmp	 eax,0
  jge	 p@makeloop
  neg	 eax
  mov	 ch,1			;ch=negative-flag
p@makeloop:
  xor	 edx,edx
  div	 ebx
  push	 dx			; save modulo
  inc	 cl
  mov	 si,cx
  or	 eax,eax		; done?
  jnz	 p@makeloop
  cmp	 ch,1			; was it negative?
  jne	 p@nominus
  mov	 al,'-'                 ; 1st sign=minus
  stosb 			; write
p@nominus:
  pop	 ax
  cmp	 al,9
  jbe	 p@nothex
  add	 al,7
p@nothex:
  add	 al,48
  stosb
  dec	 cl
  jnz	 p@nominus
  pop	 ax			; info-char (b/o/d/i/h)
  stosb
  mov	 cx,si
  add	 cl,ch
  inc	 cl
  xor	 ch,ch

  pop	 es
  pop	 ds
  pop	 di
  pop	 si
  pop	 edx
  pop	 ebx
  pop	 eax
  ret
MakeNumber endp
;-------------------------------------------------------------------------------
ReadNumber proc near
; reads Number depending on State-byte
; input:    none
; output:   eax=number cf=read_error
; destroys: eax
Local NegF:byte
  push	 ebx
  push	 ecx
  push	 edx
  push	 esi
  push	 edi

  mov	 NegF,0 		 ; false
  xor	 ebx,ebx
  xor	 al,al
  mov	 dx,0b17h
  call	 cs:calcoffset
  push	 VidSeg
  pop	 es
r@readloop:
  cmp    bx,0
  jz     r@dont_print
  cmp	 al,Base
  ja	 r@dont_print
  cmp	 al,9
  jbe	 r@nothex
  add	 al,7
r@nothex:
  add	 al,48
  mov    es:[edi+ebx*2],al
r@dont_print:
  getchar
  upcase
  cmp	 al,13
  je	 r@endread
  cmp	 al,27
  je	 r@cancel
  cmp    al,46
  jne    r@nobackspace
  cmp    bx,0
  jnz    r@backspace
  cmp    NegF,1
  jne    r@backspace
  mov    NegF,0
  mov    byte ptr es:[edi+ebx*2],32
  sub    di,2
  jmp    r@nobackspace
r@backspace:
  mov    byte ptr es:[edi+ebx*2],32
  dec	 bx			; set offset one back...
r@nobackspace:
  cmp	 Ident,'i'
  jne	 r@not_neg
  cmp	 al,'-'
  jne	 r@not_neg
  cmp    bx,0                   ; just 1st char possible (0 as offset)
  ja	 r@not_neg
  mov	 NegF,1 		; set negative flag
  add    di,2
  mov    es:[edi+ebx*2],al
  jmp    r@dont_print
r@not_neg:
  cmp	 al,'A'
  jb	 r@nohex
  sub	 al,7
r@nohex:
  sub	 al,48
  cmp	 al,Base		; invalid ?
  jae	 r@readloop		; try again...
  mov	 cs:[offset InpBuffer+bx],al
  inc	 bx
  cmp	 bx,MaxInp
  jb	 r@readloop
r@endread:
  or	 bx,bx
  jz	 r@cancel
  movzx  ecx,Base
  mov	 edi,ecx			      ; edi=base, ecx=actual base
  xor	 esi,esi			      ; result-number
  dec	 bx
  movzx  si,cs:[offset InpBuffer+bx]	      ; last digit
  or	 bx,bx				      ; just one digit ->
  je	 r@conv_end			      ; done...
  dec	 bx				      ; move pointer in buffer
  xor	 edx,edx
r@convloop:
  movzx  eax,byte ptr cs:[offset InpBuffer+bx]
  mul	 ecx
  or	 edx,edx
  ja	 r@cancel
  add	 esi,eax			      ; result to number
  mov	 eax,ecx
  mul	 edi
  mov	 ecx,eax			      ; update actual base
  dec	 bx
  jns	 r@convloop
r@conv_end:
  cmp	 NegF,1
  jne	 r@positive
  neg	 esi
r@positive:
  xor	 dh,dh
  call	 cs:clearinpline
  mov	 eax,esi
  pop	 edi
  pop	 esi
  pop	 edx
  pop	 ecx
  pop	 ebx
  clc
  ret
r@cancel:
  xor	 dh,dh
  call	 cs:clearinpline
  pop	 edi
  pop	 esi
  pop	 edx
  pop	 ecx
  pop	 ebx
  stc
  ret
ReadNumber endp
;-------------------------------------------------------------------------------
mypush proc near
; pushes eax on dword-stack
; input:    eax=number
; output:   none
; destroys:
  push	 ebp
  movzx  ebp,MyStackPtr
  cmp	 bp,MaxStack
  jae	 pu@error
  mov	 cs:[offset MyStack+ebp*4],eax
  inc	 MyStackPtr
  clc
  pop	 ebp
  ret
pu@error:
  stc
  pop	 ebp
  ret
mypush endp
;-------------------------------------------------------------------------------
mypop proc near
; pops from dword-stack to eax
; input:    none
; output:   eax=number
; destroys: eax
  push	 ebp
  movzx  ebp,MyStackPtr
  or	 ebp,ebp
  jz	 po@error
  dec	 ebp
  mov	 eax,cs:[offset MyStack+ebp*4]
  mov	 MyStackPtr,bp
  clc
  pop	 ebp
  ret
po@error:
  stc
  pop	 ebp
  ret
mypop endp
;-------------------------------------------------------------------------------
calcoffset proc near
; calculates video-offset
; input:    dl=x dh=y
; output:   edi=offset
; destroys: edi
  push	 bp
  movzx  bp,dh
  movzx  edi,bp
  shl	 bp,7		; *128
  shl	 di,5		; *32
  add	 di,bp
  movzx  bp,dl
  add	 di,bp
  add	 di,bp
  movzx  edi,di
  pop	 bp
  ret
calcoffset endp
;-------------------------------------------------------------------------------
printstring proc near
; prints string to es:[di]
; input:    cl=numchar dl=x dh=y
; output:   none
; destroys: ax ebx di ds es
  pushad
  push	 es
  push	 ds

  push	 VidSeg
  pop	 es
  push	 cs
  pop	 ds
  lea	 si,InpBuffer
  call	 cs:calcoffset
pr@loop:
  lodsb
  cmp	 al,13		; return
  jne	 pr@nonewline
  inc	 dh
  xor	 dl,dl
  call	 cs:calcoffset
  jmp	 pr@loop
pr@nonewline:
  inc	 dl		; x
  stosb 		; write
  inc	 di		; skip attribute
  dec	 cl
  jnz	 pr@loop
pr@done:
  pop	 ds
  pop	 es
  popad
  ret
printstring endp
;-------------------------------------------------------------------------------
clearinpline proc near
; clears display-line (34 chars)
; input:    dh=numline (0-9 (0=commline))
; output:   none
; destroys: none
  pushad
  push	 es
  mov	 al,11
  sub	 al,dh
  mov	 dh,al
  mov	 dl,24
  call	 cs:calcoffset

  mov	 cx,34
  push	 VidSeg
  pop	 es
  mov	 al,32		; space
c@skip:
  stosb
  inc	 di
  dec	 cx
  jnz	 c@skip
  pop	 es
  popad
  ret
clearinpline endp
;-------------------------------------------------------------------------------
UpdateDisp proc near
; updates the display
; input:    none
; output:   none
; destroys: none
  pushad

  mov	 dh,9
up@clear:
  call	 clearinpline
  dec	 dh
  jnz	 up@clear

  movzx  ebx,MyStackPtr
  or	 ebx,ebx
  jz	 up@exit

  mov	 cl,bl
  dec	 ebx			; points now to the last number on the stack...
  cmp	 cl,9
  jbe	 no@sub
  mov	 cl,9
no@sub:
  mov	 ch,8
  sub	 ch,cl
up@loop:
  mov	 dh,2
  add	 dh,cl
  add	 dh,ch
  mov	 eax,cs:[MyStack+ebx*4]
  push	 cx
  call	 MakeNumber
  mov    dl,58
  sub    dl,cl
  call   PrintString
  pop	 cx
  dec	 ebx
  dec	 cl
  jnz	 up@loop

up@exit:
  mov    al,Ident
  push   es
  mov    es,VidSeg
  mov    es:[11*160+22*2],al
  pop    es
  popad
  ret
UpdateDisp endp
;-------------------------------------------------------------------------------
drawmenu proc near
; draws menu-keys
; input:    si=menunum (0=int,2=comma,4=float,...)
; output:   none
; destroys: none
Local Odd:byte
  pushad
  push	 es

  push	 si
  push	 VidSeg
  pop	 es
  mov	 di,80-CalcImag_Width
  lea	 si,CalcImag
  mov	 cx,CalcImag_Length
  call	 cs:uncrunch

  pop	 si
  mov	 di,13*160+23*2
  mov	 si,word ptr [offset Menues+si]
  mov	 dh,4			      ; 4 sub-menues...
dr@do_all_rows:
  push	 si
  mov	 si,word ptr [si]	      ; in si is now offset to row1
  mov	 ah,3bh
  mov	 ch,2			      ; 2 rows in 1 sub-menue
dr@next3fields:
  mov	 dl,3			      ; 3 fields
dr@draw_row:
  mov	 Odd,0
  xor	 cl,cl
dr@one_count:
  lodsb
  cmp	 al,0
  jz	 dr@done_count
  inc	 cl			      ; numchars...
  jmp	 dr@one_count
dr@done_count:
  mov	 bx,10
  sub	 bl,cl
  test	 bl,00000001b
  setnz  Odd
  and	 bl,11111110b
  push	 bx
  add	 di,bx
  movzx  bx,cl
  sub	 si,bx
  dec	 si
  xor	 cl,cl
dr@one_field:
  lodsb
  cmp	 al,0
  jz	 dr@done_field
  stosw
  inc	 cl			      ; numchars...
  jmp	 dr@one_field
dr@done_field:
  add    si,2
  pop	 bx
  add	 di,bx
  add	 di,2*2
  cmp	 Odd,1
  jne	 dr@noinc
  add	 di,2
dr@noinc:
  dec	 dl
  jnz	 dr@draw_row
  add	 di,160-36*2
  dec	 ch
  jnz	 dr@next3fields
  add	 di,160
  pop	 si
  add	 si,2
  dec	 dh
  jnz	 dr@do_all_rows

  pop	 es
  popad
  ret
drawmenu endp

include ops.asm
include uncrunch.asm
;***********************I*N*T*S*************************************************
Int2FKennung equ 0f5h

Int2FHandler proc far
  cmp	 ah, Int2FKennung
  je	 @forme
  db	 0eah
  Old2F  dw ?,? 		; old int...
@forme:
  cmp	 al,1			; function: return codeseg
  je	 @GetSegm
  mov	 al,ah
  ror	 al,2			; inverse kennung...
  iret
@GetSegm:
  push	 cs
  pop	 es
  iret
Int2FHandler endp


Transient Label Word

; from here to the "Comment |" is beta-code for the compiler of the programming
; language... the call to the int 1c haendler works, because i commented the
; iret and similar interrupt-specific things... in the "Comment |" section
; is the code that installs * deinstalls the TSR...
; HAVE FUN!

Compiler Proc Near
  movzx  bx,byte ptr cs:[80h]  ; length of command-line...
  jz     skipcompile
  dec    bx                    ; don't count the space...
  jz     skipcompile
  mov    cs:[82h+bx],byte ptr 0; pad with a zero at the end of command-line
  push   cs
  pop    ds
  mov    dx,82h                ; address of command-line...
  xor    al,al                 ; just reading
  Dos    3dh                   ; open the file...
  jc     FileError
  mov    bx,ax                 ; handle -> bx
  lea    edx,FileBuff
wait4char:
  mov    cx,1                  ; read 1 byte
  Dos    3fh                   ; read file....
  jc     waitcharerr
  cmp    FileBuff,byte ptr 32
  jbe    wait4char
  cmp    FileBuff,byte ptr '{' ; open comment????
  jne    nocomment
wait4comment:
  Dos    3fh
  jc     waitcommerr
  cmp    FileBuff,byte ptr '}' ; closed comment????
  jne    wait4comment          ; keep on waiting...
  jmp    wait4char
nocomment:
  inc    dx                    ; leave the char...
  mov    cx,2
  Dos    3fh                   ; read the 2 missing ones...
  jc     expect2err
  dec    dx
  mov    cx,3
upcaseloop:
  mov    al,ds:[edx]
  upcase
  mov    ds:[edx],al
  inc    dx
  dec    cx
  jnz    upcaseloop
  mov    ds:[edx],byte ptr 0   ; add a zero
  sub    dx,4
  mov    eax,ds:[edx]          ; eax=the token we read...
  shr    eax,8
;  shl    eax,8
  mov    edi,-1
compareloop:
  inc    edi
  cmp    edi,255
  ja     compareend
  cmp    [offset ConvTab+edi*4],eax
  jne    compareloop
compareend:
;  cmp    edi,255
;  ja     unknowntoken
unknowntoken:
closequit:
  Dos    3eh
skipcompile:
quit:
  jmp    comp@end
FileError:
  push   cs
  pop    ds
  lea    dx,FileErrMsg
  Dos    9h
  jmp    comp@end
WaitCharErr:
  push   cs
  pop    ds
  lea    dx,WaitCharErrMsg
  Dos    9h
  jmp    comp@end
WaitCommErr:
  push   cs
  pop    ds
  lea    dx,WaitCommErrMsg
  Dos    9h
  jmp    comp@end
Expect2Err:
  push   cs
  pop    ds
  lea    dx,Expect2ErrMsg
  Dos    9h
comp@end:
  ret
Compiler endp

@CalcInstall:
  mov	 ah,Int2fKennung
  xor	 al,al
  push	 ax
  int    2fh                   ; already installed?
  pop	 bx
  ror	 bh,2
  or	 al,al
  jz	 @install
  cmp	 bh,al
  je	 @already
  mov	 ah,9
  lea	 dx,BelegtMsg
  jmp	 @@quit
@already:
  mov	 al,1
  int	 2fh
  mov	 si,es

  mov	 al,09h
  Dos	 35h
  mov	 bx,es
  cmp	 bx,si
  jne	 @noway

  mov	 al,2fh
  Dos	 35h
  mov	 bx,es
  cmp	 bx,si
  jne	 @noway
                        ; check int-segments....
  mov	 es,si

  mov	 al,09h
  mov	 dx,es:[Old09]
  mov	 ds,es:[Old09+2]
  Dos	 25h

  mov	 al,2fh
  mov	 dx,es:[Old2f]
  mov	 ds,es:[Old2f+2]
  Dos	 25h
                                ; set back ints...
  Dos	 49h			; free mem...
  push	 cs
  pop	 ds
  lea	 dx, FreeMsg
  Dos	 9
@@quit:
  xor	 al,al
  Dos	 4ch
@noway:
  lea	 dx,NoRemoveMsg
  Dos	 9
  jmp	 @@quit
@install:
  mov	 al,09h
  Dos	 35h
  mov	 [Old09],bx
  mov	 [Old09+2],es
  lea	 dx, Int09Handler
  Dos	 25h

  mov	 al,2fh
  Dos	 35h
  mov	 [Old2f],bx
  mov	 [Old2f+2],es
  lea	 dx, Int2fHandler
  Dos	 25h

  mov	 es,cs:[2ch]
  Dos	 49h

  lea	 dx,InstallMsg
  Dos	 09h

  call   Compiler

  lea    dx,Transient
  shr	 dx,4
  inc	 dx
  Dos    31h

BelegtMsg db "ID already used by another program...",13,10,36
NoRemoveMsg db "RESCalc cannot be removed...",13,10,36
InstallMsg db "RESCalc installed...",13,10,36
FreeMsg db "RESCalc deinstalled...",13,10,36
FileErrMsg db "Error while opening input file...",13,10,36
WaitCharErrMsg db "File error while waiting for char...",13,10,36
WaitCommErrMsg db "File error while waiting for closing comment...",13,10,36
Expect2ErrMsg db "File error while expecting 2 more chars to complete one token...",13,10,36
FileBuff db 4 dup (?)
EndCmd equ 255
NumEntries equ 13
ConvTab db "PSH",0,"PSH",0,"PSH",0,"RRE",0,"RST",0,"LBL",0,"JMP",0,"JMZ",0,"JNZ",0,"MUL",0,"ADD",0,"SUB",0,"DIV",0
;          byte   word    dword   regread regstor label
end start
