program ball; {(c) 1996 by Daniel Vollmer}
uses dos;
const
MaxLines=1024;
NumLines:word=1023;
XOffs:word=159;
YOffs:word=99;
ZOffs:LongInt=30 shl 16;
DIst:LongInt=1;
rad:byte=1;
type
   screen=array[1..65535] of byte;
   Matrix   = array [1..3, 1..3] of LongInt;
   Punkt    = record
                    x,y,z     : LongInt;
              end;
   Pointype = record
                    OrgPoint     : Punkt;           {12}
                    Temp         : Punkt;           {12}
                    Coords       : record
                                         x,y       : integer;
                                   end;             { 4}
              end;                                  {->64}
   PointsType=array[0..MaxLines*2-1] of Pointype;
var
   sint,cost                  : array[-511..511] of LongInt;
   Drehmatrix                 : Matrix;
   VScreen                    : ^Screen;
   vseg                       : word;
   Pics                       : LongInt;
   H,M,S,Hun                  : Word;
   X_Data                     : Array [0..199] Of Record
                                      X1,Count:integer;
                                end;
   MinY,MaxY                  : integer;
   Lines                      : ^PointsType;
   AngleX                     : word;
   c,c2                       : word;
   Paint                      : Word;
   ch:char;quit:boolean;counter:longint;
{----------------------------------------------------------------------------}
Function LSqrt (A: LongInt): LongInt; External;
Function LAdd (A, B: LongInt): LongInt; External;
Function LSub (A, B: LongInt): LongInt; External;
Function LDiv (A, B: LongInt): LongInt; External;
Function LMul (A, B: LongInt): LongInt; External;
Function LQuad (A: LongInt): LongInt; External;
procedure RotierePunkte (var X1, X2: LongInt;Count,ArrSize:Word); External;
procedure TransPunkte (var Point:LongInt;Count:Word); external;
{$L math.obj}
{----------------------------------------------------------------------------}
function readkey : char; assembler;
asm
  mov ah, $07
  int $21
end;

function keypressed : boolean; assembler;
asm
  mov ah,$B
  int $21
  and al,$FE
end;

procedure switch(source:word;dest:word);assembler;
asm
   push ds
   mov  es,dest
   mov  ds,source
   db $66; xor  si,si
   db $66; xor  di,di
   mov  cx,16000
   db $66; rep  movsw
   pop  ds
end;

procedure cls(dest:word);assembler;
asm
   mov  es,dest
   db $66; xor  di,di
   mov  cx,16000
   db $66; xor  ax,ax
   db $66; rep  stosw
end;

procedure dopal(c,r,g,b:byte);assembler;
asm
    mov dx,3c8h
    mov al,[c]
    out dx,al
    inc dx
    mov al,[r]
    out dx,al
    mov al,[g]
    out dx,al
    mov al,[b]
    out dx,al
end;

procedure retrace;assembler;
asm
  mov dx,3dah
@vert1:
  in al,dx
  test al,8
  jz @vert1
end;

procedure setup;
var c:word;c2:integer;den:LongInt;
begin
     randomize;
     getmem(VScreen,sizeof(Screen));
     vseg:=seg(VScreen^);
     getmem(Lines,sizeof(PointsType));
     for c:=0 to NumLines do begin
         with Lines^[c*2] do begin
              OrgPoint.x:=Random(65535); OrgPoint.x:=(OrgPoint.x*12)-(6*65535);
              OrgPoint.y:=Random(65535); OrgPoint.y:=(OrgPoint.y*12)-(6*65535);
              OrgPoint.z:=Random(65535); OrgPoint.z:=(OrgPoint.z*12)-(6*65535);
              den:=Round((LSqrt (LAdd(LAdd(LQuad(OrgPoint.x),LQuad(OrgPoint.y)),LQuad(OrgPoint.z)))) * 1.5);
              if den<>0 then begin
                 Lines^[c*2+1].OrgPoint.x:=LDiv (OrgPoint.x,den);
                 Lines^[c*2+1].OrgPoint.y:=LDiv (OrgPoint.y,den);
                 Lines^[c*2+1].OrgPoint.z:=LDiv (OrgPoint.z,den);
              end else begin
                  Lines^[c*2+1].OrgPoint.x:=0;
                  Lines^[c*2+1].OrgPoint.y:=0;
                  Lines^[c*2+1].OrgPoint.z:=0;
              end;
              den:=(LSqrt (LAdd(LAdd(LQuad(OrgPoint.x),LQuad(OrgPoint.y)),LQuad(OrgPoint.z))));
              if den<>0 then begin
                 OrgPoint.x:=LDiv (OrgPoint.x,den);
                 OrgPoint.y:=LDiv (OrgPoint.y,den);
                 OrgPoint.z:=LDiv (OrgPoint.z,den);
              end else begin
                  OrgPoint.x:=0;
                  OrgPoint.y:=0;
                  OrgPoint.z:=0;
              end;
         end;
     end;
     Pics:=0;
     Paint:=63;
     counter:=0;
     quit:=false;
     for c2 := -511 to 511 do begin
         sint[c2] := round(65535*sin(c2 * pi / 256));
         cost[c2] := round(65535*cos(c2 * pi / 256));
     end;
    asm
        mov ax,13h
        int 10h
     end;
     dopal(1,20,40,35);{1=ball,2=strich,3=strich hinter ball,4=anti-alias,5=anti-strich}
     dopal(2,40,0,40);
     dopal(3,30,45,45);
     for c:=4 to 30 do dopal(c,40,0,40);
     dopal(5,40,55,55);
     dopal(31,10,20,20);
     for c:=32 to 63 do dopal(c,35,22,43);
end;

procedure MyExit;
var H2, M2, S2, Hun2: Word;
    Seks: Real;
begin
    GetTime (H2, M2, S2, Hun2);
    asm
       mov  ax,3
       int  10h
    end;
    Seks:=60*(M2-Integer(M))+S2-Integer(S)+((Hun2-Integer(Hun))/100);
    Writeln;
    WriteLn( Pics, ' Pics Painted...');
    if seks >0 then WriteLn ((Pics/Seks):4:1, ' Frames per second with ',Paint,' Lines!');
    writeln('Made by Daniel Vollmer!');
    writeln('Thanks to the great Kefrens [Watch Desert Dreams!!!!].');
    writeln('Try "-", "+", ",", and "."-Keys!');
    freemem(VScreen,sizeof(Screen));
    freemem(Lines,sizeof(PointsType));
end;

Procedure DrawCircle(X, Y, Radius:Word);
Var
   Xs, Ys    : Integer;
   Da, Db, S : Integer;
   SqrRadius : Integer;
begin
     Xs := 0;
     Ys := Radius;
     MinY:= (Y-Radius)+1;
     MaxY:= (Y+Radius)-1;
     SqrRadius := Sqr(Radius);
     Repeat
           Da := Sqr(Xs+1) + Sqr(Ys) - SqrRadius;
           Db := Sqr(Xs+1) + Sqr(Ys - 1) - SqrRadius;
           S  := Da + Db;
           inc(Xs);
           if (S > 0) then dec(Ys);
           X_Data[Y-Ys+1].X1:=X-Xs+1;
           X_Data[Y+Ys-1].X1:=X-Xs+1;
           X_Data[Y-Xs+1].X1:=X-Ys+1;
           X_Data[Y+Xs-1].X1:=X-Ys+1;
           X_Data[Y-Ys+1].Count:=((X+Xs-1)-(X_Data[Y-Ys+1].X1))+1;
           X_Data[Y-Xs+1].Count:=((X+Ys-1)-(X_Data[Y-Xs+1].X1))+1;
           X_Data[Y+Ys-1].Count:=((X+Xs-1)-(X_Data[Y+Ys-1].X1))+1;
           X_Data[Y+Xs-1].Count:=((X+Ys-1)-(X_Data[Y+Xs-1].X1))+1;
     Until (Xs >= Ys);
end;

procedure fillcircle;assembler;
asm
   mov   es,vseg
   mov   bx,offset X_Data
   mov   si,MinY
   mov   ax,320
   mul   si
   mov   di,ax
   push  si
   shl   si,2
   add   bx,si
   pop   si
   mov   al,1
   mov   ah,al
@yloop:
   push  di
   add   di,ds:[bx]
   mov   cx,ds:[bx+2]
   mov   byte ptr es:[di-1],31
   shr   cx,1
   rep   stosw
   mov   byte ptr es:[di],31
   pop   di
   add   di,320
   add   bx,4
   inc   si
   cmp   si,MaxY
   jle   @yloop
end;

procedure IncLine(x1, y1, x2, y2 : integer);
var i, deltax, deltay, numpixels,
    d, dinc1, dinc2,
    x, xinc1, xinc2,
    y, yinc1, yinc2 : integer;
    screen : word;
    screeninc1, screeninc2 : integer;
begin
  deltax := abs(x2 - x1);
  deltay := abs(y2 - y1);
  if deltax >= deltay then begin
      numpixels := deltax + 1;
      d := (deltay+deltay) - deltax;
      dinc1 := deltay+deltay;
      dinc2 := (deltay - deltax) shl 1;
      xinc1 := 1;
      xinc2 := 1;
      yinc1 := 0;
      yinc2 := 1;
  end else begin
      numpixels := deltay + 1;
      d := (deltax+deltax) - deltay;
      dinc1 := deltax+deltax;
      dinc2 := (deltax - deltay) shl 1;
      xinc1 := 0;
      xinc2 := 1;
      yinc1 := 1;
      yinc2 := 1;
  end;
  if x1 > x2 then begin
      xinc1 := - xinc1;
      xinc2 := - xinc2;
  end;
  if y1 > y2 then begin
      yinc1 := - yinc1;
      yinc2 := - yinc2;
  end;
  screen := word(y1) * 320 + x1;
  screeninc1 := yinc1 * 320 + xinc1;
  screeninc2 := yinc2 * 320 + xinc2;
  asm
    mov es,vseg
    mov di, screen
    mov dx, d
    mov cx, numpixels
    mov bx, dinc1
    mov si, screeninc1
@bres1:
    add byte ptr es:[di],2
    or  dx,dx
    jnl @bres2
    add dx, bx
    add di, si
    jmp @bres3
@bres2:
    add dx, dinc2
    add di, screeninc2
@bres3:
    dec cx
    jnz @bres1
  end;
end;

procedure Line(x1, y1, x2, y2 : integer);
var i, deltax, deltay, numpixels,
    d, dinc1, dinc2,
    x, xinc1, xinc2,
    y, yinc1, yinc2 : integer;
    screen : word;
    screeninc1, screeninc2 : integer;
begin
  deltax := abs(x2 - x1);
  deltay := abs(y2 - y1);
  if deltax >= deltay then begin
      numpixels := deltax + 1;
      d := (deltay+deltay) - deltax;
      dinc1 := deltay+deltay;
      dinc2 := (deltay - deltax) shl 1;
      xinc1 := 1;
      xinc2 := 1;
      yinc1 := 0;
      yinc2 := 1;
  end else begin
      numpixels := deltay + 1;
      d := (deltax+deltax) - deltay;
      dinc1 := deltax+deltax;
      dinc2 := (deltax - deltay) shl 1;
      xinc1 := 0;
      xinc2 := 1;
      yinc1 := 1;
      yinc2 := 1;
  end;
  if x1 > x2 then begin
      xinc1 := - xinc1;
      xinc2 := - xinc2;
  end;
  if y1 > y2 then begin
      yinc1 := - yinc1;
      yinc2 := - yinc2;
  end;
  screen := word(y1) * 320 + x1;
  screeninc1 := yinc1 * 320 + xinc1;
  screeninc2 := yinc2 * 320 + xinc2;
  asm
    mov es,vseg
    mov di, screen
    mov dx, d
    mov cx, numpixels
    mov bx, dinc1
    mov si, screeninc1
@bres1:
    mov byte ptr es:[di], 2
    cmp dx, 0
    jnl @bres2
    add dx, bx
    add di, si
    jmp @bres3
@bres2:
    add dx, dinc2
    add di, screeninc2
@bres3:
    dec cx
    jnz @bres1
  end;
end;

procedure SetzeMatrix (A, B, C: Integer);
  Var SA, SB, SC: LongInt;
      CA, CB, CC: LongInt;
      SBCC, SBSC: LongInt;
  Begin
    SA:=SinT[A];
    SB:=SinT[B];
    SC:=SinT[C];
    CA:=CosT[A];
    CB:=CosT[B];
    CC:=CosT[C];
    SBCC:=LMul(SB,CC);
    SBSC:=LMul(SB,SC);
    Drehmatrix [1,1]:=LMul(CB,CC);
    Drehmatrix [1,2]:=LSub(LMul(SA,SBCC),LMul(CA,SC));
    Drehmatrix [1,3]:=LAdd(LMul(CA,SBCC),LMul(SA,SC));
    Drehmatrix [2,1]:=LMul(CB,SC);
    Drehmatrix [2,2]:=LAdd(LMul(SA,SBSC),LMul(CA,CC));
    Drehmatrix [2,3]:=LSub(LMul(CA,SBSC),LMul(SA,CC));
    Drehmatrix [3,1]:=-SB;
    Drehmatrix [3,2]:=LMul(SA,CB);
    Drehmatrix [3,3]:=LMul(CA,CB);
End;

procedure draw;
begin
           cls(vseg);
           SetzeMatrix(AngleX,AngleX,AngleX);
           RotierePunkte(Lines^[0].OrgPoint.x,Lines^[0].Temp.x,(Paint+1)*2,sizeof(PointYpe));
           TransPunkte(Lines^[0].Temp.X,(Paint+1)*2);
           drawcircle(160,100,rad);
           if rad>1 then fillcircle else mem[vseg:31839]:=1;
           for c:=0 to Paint do begin
               c2:=c+c;
               if (Lines^[c2].Temp.Z>0) then
               IncLine(Lines^[c2].Coords.X,Lines^[c2].Coords.Y,Lines^[c2+1].Coords.X,Lines^[c2+1].Coords.Y)
               else Line(Lines^[c2].Coords.X,Lines^[c2].Coords.Y,Lines^[c2+1].Coords.X,Lines^[c2+1].Coords.Y);
           end;
           retrace;
           switch(vseg,$a000);
           AngleX:=(AngleX+1) mod 511;
end;

begin
     setup;
     GetTime (H, M, S, Hun);
     for Pics:=0 to 378 do begin
           draw;
           if dist<2950 then inc(Dist,8);
           if pics mod 7=0 then if rad<54 then inc(rad);
     end;
     repeat
           draw;
           inc(pics);
           if keypressed then begin
              ch:=readkey;
              case ch of
                   '+':if Paint<MaxLines-1 then inc(Paint);
                   '-':if Paint>=1 then dec(Paint);
                   ',':begin
                            inc(counter);
                            if dist>8 then dec(dist,8);
                            if pics mod 7=0 then if rad>1 then dec(rad);
                       end;
                   '.':begin
                            inc(counter);
                            if dist<2950 then inc(Dist,8);
                            if counter mod 7=0 then if rad<54 then inc(rad);
                       end;
                   #27:quit:=true;
              end;
           end;
     until quit;
     myexit;
end.