{Bitmap editor 0.5 2/12/96}

{$X+}
uses crt,gfx3;

VAR f : text;                          
    data : array[1..50] of string;
    filename : string;
    bitmap : ARRAY [1..1024] of INTEGER;      {each pixel in bitmap 32 by 32}
    bitmap_ed : ARRAY [1..1024] of STRING[3];
    ch : char;
    colour : integer;

PROCEDURE setup_bitmap;                {sets up a new blank bitmap}
var loop : integer;
begin
  for loop := 1 to 1024 do bitmap[loop] := 0;
end;

PROCEDURE grid_bitmap;                  {displays the bitmap}
var loop1,loop2,loop3 : integer;
    x,y : integer;
BEGIN
  x := 127;
  y := 7;
  for loop1 := 1 to 1024 do begin
    for loop2 := 0 to 4 do
      for loop3 := 0 to 4 do
        putpixel (x+loop2,y+loop3,bitmap[loop1],vga);
    inc (x,6);
    if x >= 319 then begin
      x := 127;
      y := y + 6;
    end;
  end;
end;

PROCEDURE scale;                         {draws actual size bitmap}
var loop,x,y : integer;
BEGIN
  x := 5;
  y := 5;
  for loop := 1 to 1024 do begin
    putpixel (x,y,bitmap[loop],vga);
    inc (x);
    if x = 37 then begin
      x := 5;
    inc (y);
    end;
  end;
end;

PROCEDURE grid;                              {draws the grid}
var x1,y1 : integer;
BEGIN
  x1 := 126;
  y1 := 6;
  repeat
    line (x1,6,x1,197,15,vga);
    inc (x1,6);
  until x1 >= 319;
  repeat
    line (126,y1,318,y1,15,vga);
    inc (y1,6);
  until y1 >= 199;
end;

procedure curs (x,y : integer);                  {draws the cursor}
begin
  putpixel(x,y,7,vga);
  putpixel(x+4,y,7,vga);
  putpixel(x+1,y+1,7,vga);
  putpixel(x+3,y+1,7,vga);
  putpixel(x+2,y+2,7,vga);
  putpixel(x+1,y+3,7,vga);
  putpixel(x+3,y+3,7,vga);
  putpixel(x,y+4,7,vga);
  putpixel(x+4,y+4,7,vga);
end;

procedure pal_curs (x,y : integer);                 {palette cursor}
begin
  putpixel (x,y,0,vga);
  putpixel (x+1,y,0,vga);
  putpixel (x+2,y,0,vga);
  putpixel (x+3,y,0,vga);
  putpixel (x+4,y,0,vga);
  putpixel (x,y+1,0,vga);
  putpixel (x,y+2,0,vga);
  putpixel (x,y+3,0,vga);
  putpixel (x+4,y+1,0,vga);
  putpixel (x+4,y+2,0,vga);
  putpixel (x+4,y+3,0,vga);
  putpixel (x,y+4,0,vga);
  putpixel (x+1,y+4,0,vga);
  putpixel (x+2,y+4,0,vga);
  putpixel (x+3,y+4,0,vga);
  putpixel (x+4,y+4,0,vga);
end;

PROCEDURE palette;                         {draws the palette}
var loop1,loop2,loop3,x,y : integer;
BEGIN
  x := 0;
  y := 50;
  for loop1 := 1 to 256 do begin
    for loop2 := 1 to 5 do
      for loop3 := 1 to 5 do
        putpixel (x+loop2,y+loop3,loop1,vga);
    inc (x,5);
    if x = 120 then begin
      x := 0;
      inc (y,5);
    end;
  end;
end;

PROCEDURE col_box;        {box contain current colour}
BEGIN
  drawpoly (60,20,120,20,120,40,60,40,colour,vga);
end;

Procedure filehandling;
VAR loop,loop1 : INTEGER;
    abc : string;
    c : string[1];
    row : integer;
BEGIN
  row := 0;
  gotoxy (1,24);
  write ('Save file as : ');
  readln (filename);
  c := ',';
  for loop := 1 to 1024 do str(bitmap[loop],bitmap_ed[loop]);
  loop1 := 0;
  assign(f, filename);
  rewrite(f);
  for loop := 1 to 50 do begin;
    loop1 := (loop-6) * 32;
    if loop = 1 then data[loop] := 'USES crt,gfx3;';
    if loop = 2 then data[loop] := ' ';
    if loop = 3 then data[loop] := '{You''ll need Denthors gfx3 unit to run this code}';
    if loop = 4 then data[loop] := 'PROCEDURE draw_sprite;';
    if loop = 5 then data[loop] := 'CONST sprite : ARRAY [1..32,1..32] OF BYTE =';
    if loop = 6 then data[loop] := '      ((' + bitmap_ed[1+loop1] + c + bitmap_ed[2+loop1] + c + bitmap_ed[3+loop1] + c +
      bitmap_ed[4+loop1] + c + bitmap_ed[5+loop1] + c + bitmap_ed[6+loop1] + c +
        bitmap_ed[7+loop1] + c + bitmap_ed[8+loop1] + c + bitmap_ed[9+loop1] + c +
          bitmap_ed[10+loop1] + c + bitmap_ed[11+loop1] + c + bitmap_ed[12+loop1] + c +
            bitmap_ed[13+loop1] + c + bitmap_ed[14+loop1] + c + bitmap_ed[15+loop1] + c +
              bitmap_ed[16+loop1] + c + bitmap_ed[17+loop1] + c + bitmap_ed[18+loop1] + c +
                bitmap_ed[19+loop1] + c + bitmap_ed[20+loop1] + c + bitmap_ed[21+loop1] + c +
                  bitmap_ed[22+loop1] + c + bitmap_ed[23+loop1] + c + bitmap_ed[24+loop1] + c +
                    bitmap_ed[25+loop1] + c + bitmap_ed[26+loop1] + c + bitmap_ed[27+loop1] + c +
                      bitmap_ed[28+loop1] + c + bitmap_ed[29+loop1] + c + bitmap_ed[30+loop1] + c +
                        bitmap_ed[31+loop1] + c + bitmap_ed[32+loop1] + ')' + c;
    if (loop > 6) AND (loop < 37) then data[loop] := '       (' +
      bitmap_ed[1+loop1] + c + bitmap_ed[2+loop1] + c + bitmap_ed[3+loop1] + c +
        bitmap_ed[4+loop1] + c + bitmap_ed[5+loop1] + c + bitmap_ed[6+loop1] + c +
          bitmap_ed[7+loop1] + c + bitmap_ed[8+loop1] + c + bitmap_ed[9+loop1] + c +
            bitmap_ed[10+loop1] + c + bitmap_ed[11+loop1] + c + bitmap_ed[12+loop1] + c +
              bitmap_ed[13+loop1] + c + bitmap_ed[14+loop1] + c + bitmap_ed[15+loop1] + c +
                bitmap_ed[16+loop1] + c + bitmap_ed[17+loop1] + c + bitmap_ed[18+loop1] + c +
                  bitmap_ed[19+loop1] + c + bitmap_ed[20+loop1] + c + bitmap_ed[21+loop1] + c +
                    bitmap_ed[22+loop1] + c + bitmap_ed[23+loop1] + c + bitmap_ed[24+loop1] + c +
                      bitmap_ed[25+loop1] + c + bitmap_ed[26+loop1] + c + bitmap_ed[27+loop1] + c +
                        bitmap_ed[28+loop1] + c + bitmap_ed[29+loop1] + c + bitmap_ed[30+loop1] + c +
                          bitmap_ed[31+loop1] + c + bitmap_ed[32+loop1] + ')' + c;
    if loop = 37 then data[loop] := '       (' + bitmap_ed[1+loop1] + c + bitmap_ed[2+loop1] + c + bitmap_ed[3+loop1] + c +
      bitmap_ed[4+loop1] + c + bitmap_ed[5+loop1] + c + bitmap_ed[6+loop1] + c +
        bitmap_ed[7+loop1] + c + bitmap_ed[8+loop1] + c + bitmap_ed[9+loop1] + c +
          bitmap_ed[10+loop1] + c + bitmap_ed[11+loop1] + c + bitmap_ed[12+loop1] + c +
            bitmap_ed[13+loop1] + c + bitmap_ed[14+loop1] + c + bitmap_ed[15+loop1] + c +
              bitmap_ed[16+loop1] + c + bitmap_ed[17+loop1] + c + bitmap_ed[18+loop1] + c +
                bitmap_ed[19+loop1] + c + bitmap_ed[20+loop1] + c + bitmap_ed[21+loop1] + c +
                  bitmap_ed[22+loop1] + c + bitmap_ed[23+loop1] + c + bitmap_ed[24+loop1] + c +
                    bitmap_ed[25+loop1] + c + bitmap_ed[26+loop1] + c + bitmap_ed[27+loop1] + c +
                      bitmap_ed[28+loop1] + c + bitmap_ed[29+loop1] + c + bitmap_ed[30+loop1] + c +
                        bitmap_ed[31+loop1] + c + bitmap_ed[32+loop1] + '));';
    if loop = 38 then data[loop] := '  VAR loop1,loop2 : INTEGER;';
    if loop = 39 then data[loop] := 'BEGIN';
    if loop = 40 then data[loop] := '  FOR loop1 := 1 to 32 do';
    if loop = 41 then data[loop] := '    FOR loop2 := 1 to 32 do';
    if loop = 42 then data[loop] := '      putpixel (loop1,loop2,sprite[loop2,loop1],vga);';
    if loop = 43 then data[loop] := 'END;';
    if loop = 44 then data[loop] := ' ';
    if loop = 45 then data[loop] := 'BEGIN';
    if loop = 46 then data[loop] := '  setmcga;';
    if loop = 47 then data[loop] := '  draw_sprite;';
    if loop = 48 then data[loop] := '  readln;';
    if loop = 49 then data[loop] := '  settext;';
    if loop = 50 then data[loop] := 'END.';
    Writeln(f, data[loop]);
  end;
  close(f);
END;

procedure prog;                                       {the main code hub}
var lives,x,y,pos,a,b : integer;
    r,g,bl : byte;
begin
  pos := 1;
  lives := 1;
  a := 1;
  b := 51;
  x := 127;
  y := 7;
  ch:=#0;
  curs(x,y);
  pal_curs(a,b);
  grid;
  col_box;
  gotoxy (1,24); write (pos,'      ');
  repeat
    IF KEYPRESSED THEN BEGIN
      ch:=READKEY;
      if (ch='f') then filehandling;
      if (ch=chr(77)) and (x <= 307) then begin
        x := x + 6;
        pos := pos + 1;
      end;
      if (ch=chr(75)) and (x >= 133) then begin
        x := x - 6;
        pos := pos - 1;
      end;
      if (ch=chr(80)) and (y <= 187) then begin
        y := y + 6;
        pos := pos + 32;
      end;
      if (ch=chr(72)) and (y >= 13) then begin
        y := y - 6;
        pos := pos - 32;
      end;
      if (ch=',') and (colour > 1) then begin
        a := a - 5;
        if a < 1 then begin
          b := b - 5;
          a := 116;
        end;
        colour := colour - 1;
      end;
      if (ch='.') and (colour < 256) then begin
        a := a + 5;
        if 1 = a div 120 then begin
          b := b + 5;
          a := 1;
        end;
        colour := colour + 1;
      end;
      if (ch='z') then bitmap[pos] := colour;
      if (ch='x') then bitmap[pos] := 0;
      if (ch=chr(27)) then lives := 0;
      scale;
      grid_bitmap;
      palette;
      curs(x,y);
      pal_curs(a,b);
      col_box;
    end;
  UNTIL lives = 0;
end;

PROCEDURE intro;
BEGIN
  clrscr;
  WRITELN ('Beta Version 0.5 of Sprite Editor');
  WRITELN ('By Tim Jewell');
  WRITELN;
  WRITELN ('The on-screen display is not yet complete so here are the');
  WRITELN ('commands you can use.');
  WRITELN;
  WRITELN ('F       = Generate pascal source for the sprite');
  WRITELN ('CURSORS = Move around sprite grid');
  WRITELN (',       = Move colour cursor left');
  WRITELN ('.       = Move colour cursor right');
  WRITELN ('z       = Fill element in current colour');
  WRITELN ('x       = Clear element');
  WRITELN ('ESC     = Exit the program');
  WRITELN;
  WRITELN ('Press any key to continue...');
  readkey;
end;

begin                              {main program}
  intro;
  directvideo := false;
  colour := 1;
  setmcga;
  cls (vga,150);
  palette;
  setup_bitmap;
  grid_bitmap;
  scale;
  prog;
  settext;
end.
