#include <conio.h>
#include <stdio.h>
#include <alloc.h>
#include <stdlib.h>


void     DecodePcx(unsigned char *buffer,int length,FILE *fp)
{
    unsigned data,num,loop;

    for(loop=0;loop<length;){
         data=fgetc(fp);
         if(data>=0xc0) {
              num=data&0x3f;
              data=fgetc(fp);
              while(num--) buffer[loop++]=data;
         }
         else buffer[loop++]=data;
    }
}


struct {
    unsigned char sign,version,code,bpp;
    unsigned x1,y1,x2,y2,hres,vres;
    unsigned char index[48],vmode,vplanes;
    unsigned bpl,palinfo,shres,svres;
    unsigned char dumy[54];
} header;


int xs,ys;


char     *loadpcx(char *filename)
{
    char *buffer;
    int  loop;
    FILE *fp;

    fp=fopen(filename,"rb");
    if(fp==NULL) return NULL;
    fread(&header,128,1,fp);

    xs=header.x2-header.x1+1;
    ys=header.y2-header.y1+1;

    buffer=malloc(xs*ys);

    for(loop=0;loop<ys;loop++) {
         DecodePcx(buffer+loop*xs,header.bpl,fp);
    }

    fclose(fp);

    return (char *) buffer ;
}


#define  SKIP      255


struct {
    int   skipbytes;
    int   putbytes;
} Pattern ;


void     EncodeSpr0(unsigned char *image,unsigned length,FILE *fp)
{
    int  loop,index,table;
    int  pattern[256];

    for(loop=0,table=0;loop<length;) {

         // skip bytes
         for(index=0;image[loop]==SKIP && loop<length;index++,loop++) ;
         if(loop>=length) break;
         pattern[table++]=index;

         for(index=0;image[loop]!=SKIP && loop<length;index++,loop++) ;
         pattern[table++]=index;

    }

    // Total line patterns
    fputc(table/2,fp);

    // Put Pattern
    for(loop=0;loop<table;) {
         Pattern.skipbytes=pattern[loop++];
         Pattern.putbytes =pattern[loop++];

         fwrite(&Pattern,4,1,fp);
         if(Pattern.putbytes!=0) {
              fwrite(image+Pattern.skipbytes,Pattern.putbytes,1,fp);
         }

         image+=Pattern.skipbytes+Pattern.putbytes;
    }
}


void     main(int argc,char *argv[])
{
    char *picture;
    int  loop;

    FILE *fp;

    puts(" [ Format Converter ] : PCX To Zero-Skippin'-Sprite");

    if(argc!=3) {
         puts("\n.Usage : PCX2SPR0 <pcx-filename> <output-filename>");
         return;
    }

    picture=loadpcx(argv[1]);

    if(picture == NULL) {
         puts("File error.");
         return;
    }

    fp=fopen(argv[2],"wb");
    if(fp==NULL) {
         puts("File error.");
         fclose(fp);
         return;
    }

    fwrite(&ys,2,1,fp);
    for(loop=0;loop<ys;loop++) {
         EncodeSpr0(picture+loop*xs,xs,fp);
    }

    fclose(fp);
}


// NOERROR / GARGOYLE
