// Transparent texture warping
// Rex Deathstar May 1995

// Released to the public during late-October 1995...
// (needs original PURENESS demo files to run)

// Almost 4 months have passed since the release of Pureness.
// The response that we at WaterLogic receive from all over Internet has been
// -very- encouraging. Especially the fact that the demo authority of
// the HORNET archive has requested that Pureness be allowed to be included
// in the 'Freedom' CD-ROM, which we agreed with honour. I have thus received
// a 'Freedom' collector's CD as a gift from the only 100 given away, the rest
// are sold as normal CD-ROMs. This CD contains all the best demos, entire
// source code/music/graphics collection of the HORNET archive at
// FTP.CDROM.COM, and I'll be trying to distribute the contents of this CD
// to various boards for your benefit.

// As I move on to try to achieve better quality code, these Realmode codes
// that were used in Pureness slowly becomes another item of history in my
// harddisk. And as I've always said, it's better to share it with my peers
// than to let it wither away and become useless with time.
// And so, here're the codes to the Transparent Plasma and Transparent Image
// Warp as seen in Pureness.

// The code of honor for programmers is to give proper credits to whoever
// deserves it. If you choose not to follow this code of behaviour, for
// whatever reasons you might have, then you are just the equivalent of
// the shameless thieves in the real-life society. You shall then be tortured
// by your conscience and not able to live nor die in peace. I'm just speaking
// out for all the coders in the world, not just for myself. So, give it some
// thought if you're tempted by the devil.

// Ok, I know the following sources are not worth all these boring talk and
// babble, but those were just my views and I'd appreciate it if you will take
// the time to read them. You did download this file out of interest right? ;)

//;WaterLogic productions to date
//;==============================
//;1.  REXINTRO.ZIP....debut selftro, very poorly done.
//;2.  ASYLUM!.ZIP ....Advert for Asylum BBS (closed down now :( )
//;3.  ICHIBAN!.ZIP....Advert for IchiBan BBS
//;4.  ANARCHY!.ZIP....Advert for Anarchy Online BBS
//;5.  ICHIBAN2.ZIP....2nd Advert for IchiBan BBS
//;6.  COROM.ZIP   ....Advert for COROM PRODUCTIONS BBS
//;7.  _FACES.ZIP  ....Slideshow demo featuring realtime crossfading
//;8.  TINIFIRE.ZIP....76 byte fire routine, real small huh? (Full sources)
//;9.  TINYSTAR.ZIP....123 byte 3D starfield, another small one. (Full sources)
//;10. DELAYDOT.ZIP....3D object morph with delaydots. (Full sources)
//;11. PARTICLE.ZIP....3D Lissajous figures morph. (Full sources)
//;12. PURENESS.ZIP....1st place megademo during 'The Scene 95' demo party at
//;                    Seaview Hotel/Singapore on 2nd July 1995.
//;13. COROMSRC.ZIP....Source codes to a BBS advert
//;14. WATERFAL.ZIP....Source codes to a waterfall effect
//;15. PLASWARP.ZIP....Source codes to the plasma and image warp effect as
//;					   seen in Pureness (needs PURENESS.DAT to run)
//;16. ????????.ZIP....A brand-new 3D engine in VirtualColor is in the making!

//;Any comments and enquiries, write to Rex Jordan in any of the following BBSs:
//;
//;Developer's Site BBS
//;065-561-0237
//;
//;Meteoroid BBS
//;065-567-1510
//;
//;Andromeda BBS
//;065-744-9049
//;
//;or Email <deathstr@singnet.com.sg>

#pragma inline
asm .486

#include <conio.h>
#include <stdio.h>
#include <math.h>
#include <dos.h>
#include <process.h>
#include <string.h>
#include "fader.h"

#define INIT13h

// LOADER
#define MAINDATAfilename "PURENESS.DAT"

#define MAXDATS 50

typedef struct {
	char filename[16];
	long filesize,position;
} DATINFO;

	DATINFO DATs[MAXDATS];

	char	MAINDATAfile[20];
// --------

#define		rad 0.01745329
#define		FRAMES 1200

	char 	pal[256][3];
unsigned int 	texture,backdrop,mbuffer1,mbuffer2,vram;
	long 	warpS[512],warpC[512],xoffset,yoffset;
	long  	tmpx[320],tmpy[200],deg,deltax,deltay,adx,ady;
	int	a,n,x,y,sx,sy;
	long 	warpxscale,warpyscale;
	long 	ystart,xstart,dx,dy,nframes=FRAMES;
	long	texturefile,backdropfile;

void graphics();
void text();
void load_texture();
void warp_it();
void load_backdrop();
void make_warptable();
void build_tmpxy();
void animate_values();
void capture_first_frame();
void floater();
void initialize_loader();
long search(char *filename);
void text();

void main()
{

	if(allocmem(4096,&texture)!=-1) exit(1);
	if(allocmem(4096,&backdrop)!=-1) exit(1);

	if(allocmem(4000,&mbuffer1)!=-1) exit(1);
	if(allocmem(4000,&mbuffer2)!=-1) exit(1);
	vram=mbuffer1;

	initialize_loader();
	graphics();
	load_texture();
	load_backdrop();
	make_warptable();

	capture_first_frame();
	floater();

// MAIN LOOP
while(!kbhit() && nframes--)
{
	animate_values();
	build_tmpxy();
	warp_it();
}

	if(kbhit()) getch();
	text();
	puts("Transparent Image Warping - Rex Deathstar/WaterLogic <deathstr@singnet.com.sg>");


}
//-----------------------------------
void warp_it()
{
  asm mov es,[vram]
  asm xor di,di
  asm mov gs,[texture]
  asm mov fs,[backdrop]

  xstart=xoffset;
  ystart=yoffset;

  asm mov dx,0x3da
  vr1:
  asm in al,dx
  asm test al,8
  asm jnz vr1
  vr2:
  asm in al,dx
  asm test al,8
  asm jz vr2


  asm mov bp,[ady]
  asm mov eax,dword ptr [xstart]
  asm mov edx,dword ptr [ystart]


	asm mov si,200*4

	yloop:
	asm push si
	asm push eax
	asm push edx
	asm shr eax,8
	asm shr edx,8


	asm lea si,[tmpx]
	xloop:
	asm mov	bx,dx
	asm mov	bl,ah
	asm add dx,bp
	asm add ax,[si]
	asm mov	cl,gs:[bx]

	asm mov	bx,dx
	asm mov	bl,ah
	asm add dx,bp
	asm add ax,[si+4]
	asm mov	ch,gs:[bx]

	asm add cx,fs:[di]
	asm mov	es:[di],cx

	asm mov	bx,dx
	asm mov	bl,ah
	asm add dx,bp
	asm add ax,[si+8]
	asm mov	cl,gs:[bx]

	asm mov	bx,dx
	asm mov	bl,ah
	asm add dx,bp
	asm add ax,[si+12]
	asm mov	ch,gs:[bx]

	asm add cx,fs:[di+2]
	asm mov	es:[di+2],cx

	asm add di,4
	asm add si,16
	asm cmp si,offset [tmpx]+320*4
	asm jl  xloop


	asm pop edx
	asm pop eax
	asm pop si
	asm add edx,dword ptr tmpy[si]
	asm add eax,dword ptr [deltax]

	asm sub si,4
	asm jnz yloop
}
//--------------------
void build_tmpxy()
{
	/*for(x=0;x<320;x++)
	{
	sx=(warpxscale*x)>>16;
	tmpx[x]=adx+warpS[sx&511];
	}*/
	asm xor ecx,ecx
	asm lea di,[tmpx]
	asm lea si,[warpS]
	asm mov edx,dword ptr [warpxscale]
	build_tmpx:
	asm mov ebx,ecx
	asm imul ebx,edx
	asm shr ebx,16

	asm and bx,511
	asm shl bx,2
	asm mov eax,[si+bx]
	asm add eax,dword ptr [adx]
	asm mov [di],eax

	asm add di,4
	asm inc cx
	asm cmp cx,320
	asm jl  build_tmpx


	/*for(y=0;y<200;y++)
	{
	sy=(warpyscale*y)>>16;
	tmpy[y]=deltay+ady+warpC[sy&511];
	}*/
	asm xor ecx,ecx
	asm lea di,[tmpy]
	asm lea si,[warpC]
	asm mov edx,dword ptr [warpyscale]
	asm mov ebp,dword ptr [ady]
	asm add ebp,dword ptr [deltay]
	build_tmpy:
	asm mov ebx,ecx
	asm imul ebx,edx
	asm shr ebx,16

	asm and bx,511
	asm shl bx,2
	asm mov eax,[si+bx]
	asm add eax,ebp
	asm mov [di],eax

	asm add di,4
	asm inc cx
	asm cmp cx,200
	asm jl  build_tmpy
}
//--------------------
void animate_values()
{
	dy=sin(deg*rad)*(160000.0*sin(deg*rad/10));
	dx=cos(deg*rad)*(160000.0*sin(deg*rad/12));
	warpxscale=(sin(deg*rad/7)*2)*65535;
	warpyscale=(sin(deg*rad/7)*3)*65535;

	deltax=dx; deltay=dy;
	adx=-dy; ady=dx;

	adx>>=8; ady>>=8;

	deg+=1;
	xoffset+=32776<<16;
	yoffset+=32774<<16;
}
//--------------------
void graphics()
{

	FILE *f;

	f=fopen(MAINDATAfile,"rb");
	fseek(f,search("WARP.PAL"),SEEK_SET);
	fread(pal,768,1,f);
	fclose(f);

	#ifdef INIT13h
	asm mov	ax,0x13
	asm int	0x10
	#endif

	VGADAC(&pal[0][0]);
}
//------------------------

void text()
{
asm mov	ax,0x03
asm int	0x10
}


//-----------------
void load_texture()
{
asm mov ax,0x3d00
asm lea dx,[MAINDATAfile]
asm int 0x21
asm mov bp,ax

	asm mov bx,bp
	asm mov ax,0x4200
	asm mov cx,word ptr [texturefile+2]
	asm mov dx,word ptr [texturefile]
	asm int 0x21

asm mov bx,bp
asm mov ax,0x3f00
asm xor dx,dx
asm mov cx,32768
asm push ds
asm mov ds,[texture]
asm int 0x21
asm pop ds

asm mov bx,bp
asm mov ax,0x3f00
asm mov dx,32768
asm mov cx,32768
asm push ds
asm mov ds,[texture]
asm int 0x21
asm pop ds

asm mov bx,bp
asm mov ax,0x3e00
asm int 0x21


	asm mov es,[texture]
	asm mov bx,2
	ntimes:
	asm xor di,di
	asm xor dx,dx
	post_process2:
	asm xor ax,ax
	asm mov dl,es:[di+1]
	asm add ax,dx
	asm mov dl,es:[di-1]
	asm add ax,dx
	asm mov dl,es:[di+256]
	asm add ax,dx
	asm mov dl,es:[di-256]
	asm add ax,dx

	asm mov dl,es:[di-257]
	asm add ax,dx
	asm mov dl,es:[di-255]
	asm add ax,dx
	asm mov dl,es:[di+257]
	asm add ax,dx
	asm mov dl,es:[di+255]
	asm add ax,dx

	asm shr ax,3
	asm mov es:[di],al
	asm inc di
	asm jnz post_process2

	asm dec bx
	asm jnz ntimes
}
//----------------------------------------------------------------------
void	load_backdrop()
{
	asm	mov	ax,3d00h
	asm	lea	dx,[MAINDATAfile]
	asm	int	21h
	asm	mov	bp,ax

	asm mov bx,bp
	asm mov ax,0x4200
	asm add dword ptr [backdropfile],1078
	asm mov cx,word ptr [backdropfile+2]
	asm mov dx,word ptr [backdropfile]
	asm int 0x21

	asm	mov	bx,bp
	asm	mov	cx,64000
	asm	mov	ah,3fh
	asm	push	ds
	asm	mov	ds,[backdrop]
	asm	xor	dx,dx
	asm	int	21h
	asm	pop	ds


	asm	mov	bx,bp
	asm	mov	ah,3eh
	asm	int	21h

}
//----------------
void make_warptable()
{
	for( deg=0 ; deg <512; deg++ )
	{
	warpS[deg]=pow(sin(360.0*deg/512*rad),1)*600;
	warpC[deg]=pow(cos(360.0*deg/512*rad),1)*600;
	}
}
//-----------------------
void capture_first_frame()
{
	animate_values();
	build_tmpxy();
	warp_it();

	vram=0xa000;
}
//-----------------------
void floater()
{
asm mov es,[mbuffer2]
asm push ds
asm mov ds,[backdrop]
asm xor di,di
asm xor si,si
asm mov cx,64000/4
asm rep movsd
asm pop ds

asm mov es,[vram]
asm mov fs,[mbuffer1]	// modified backdrop: target
asm mov gs,[mbuffer2]	// original backdrop: source

asm mov cx,64
outer_loop:
	//VRETRACE
	asm	mov	dx,0x3da
	vr1:
	asm	in	al,dx
	asm	test	al,8
	asm	jz	vr1
	vr2:
	asm	in	al,dx
	asm	test	al,8
	asm	jnz	vr2
	//-----------------
asm xor di,di
float_it:
asm mov al,fs:[di]	//target
asm mov ah,gs:[di]	//source
asm cmp ah,al
asm je  done
asm inc ah
done:
asm mov es:[di],ah
asm mov gs:[di],ah
asm inc di
asm cmp di,64000
asm jb  float_it

asm dec cx
asm jnz outer_loop
}
//---------------
void initialize_loader()
{
	FILE *f;
	long size;

	sprintf(MAINDATAfile,MAINDATAfilename+NULL);


	if((f=fopen(MAINDATAfile,"rb"))==NULL)
	{
	text();
	printf("Cannot open %s!",MAINDATAfile);
	exit(1);
	}

	size=sizeof(DATINFO)*MAXDATS;

	fseek(f,-size,SEEK_END);
	fread(DATs,1,size,f);
	fclose(f);

	texturefile=search("COLOR.DAT");
	backdropfile=search("WARP.BMP");

	/*for(a=0; a<MAXDATS; a++)
	printf("Entry #%2d : NAME: %12s, SIZE: %6ld, POSITION: %8ld\n"
	,a,DATs[a].filename,DATs[a].filesize,DATs[a].position);

	getch();*/
}
//---------------
long search(char *filename)
{
	// search thru list for program
	for(n=0; n<MAXDATS; n++)
	if(strcmp(DATs[n].filename,filename)==NULL)
	break; //if found, get out of loop!

	// program not in list if loop terminates
	if(n==MAXDATS)
	{
	text();
	puts("Error searching PURENESS.DAT!");
	exit(1);
	}

	return(DATs[n].position);
}

