;-----------------------------------------------------------------------;
; Lens effect								;
; Code by Nagy Daniel							;
;									;
; On my VGA it's absolute flicker free! (Hope on yours too...)		;
; It's a bit lame, so simplify it if you can.				;
;									;
; If you want to resize the lens, just calculate another transfrm.dat,	;
; and correct xsize							;
;									;
; Compile: TASM /m9							;
; Link:    TLINK /3							;
;									;
;	Send ideas, comments to: rocker@hal2000.hal.vein.hu		;
;-----------------------------------------------------------------------;


DOSSEG
.MODEL SMALL
.STACK 200h
.CODE
.386

ASSUME CS:@CODE, DS:@CODE

xsize	equ	52		;lens diameter
xsize2	equ	xsize*xsize


start:	push	cs
	pop	ds
	cld

;--------------------- CPU check -----------------------
	xor	ax,ax
	push	ax
	popf
	pushf
	pop	ax
	and	ax,0f000h
	cmp	ax,0f000h
	je	no386
	mov	ax,07000h
	push	ax
	popf
	pushf
	pop	ax
	and	ax,07000h
	jne	vgachk
no386:	mov	ah,9
	lea	dx,_386err
	int	21h
	jmp	errend

;---------------------- VGA check ---------------------
vgachk:	mov	ax,1a00h
	int	10h
	and	al,8
	jnz	mouchk
	mov	ah,9
	lea	dx,vgaerr
	int	21h
	jmp	errend

;--------------------- Mouse check --------------------
mouchk:	mov	ax,0
	int	33h
	or	ax,ax
	jnz	memchk
	mov	ah,9
	lea	dx,mouserr
	int	21h
	jmp	errend

;--------------------- Memory check --------------------
memchk:	mov	ebx,0a000h
	mov	ax,ss
	add	ax,32
	sub	bx,ax
	shl	ebx,4
	cmp	ebx,64000
	ja	ok2run
	mov	ah,9
	lea	dx,memerr
	int	21h
	jmp	errend

;==================== Everything seems OK, let's start ====================
ok2run:	mov	ax,0013h
	int	10h		;320x200x256 VGA mode

	mov	ax,7
	xor	cx,cx
	mov	dx,320-xsize
	int	33h		;define horizontal mouse range
	inc	ax
	mov	dx,200-xsize
	int	33h		;define vertical mouse range
	
	mov	[inpseg],0a000h
	call	loadtga		;import picture to screen
	cmp	ah,1		;error check
	jnz	goon1
	mov	ax,0003h
	int	10h
	mov	ah,9
	lea	dx,filerr
	int	21h
	jmp	errend

goon1:	mov	ax,ss
	add	ax,32
	mov	[inpseg],ax
	call	loadtga		;import picture to memory
	cmp	ah,1		;error check
	jnz	goon2
	mov	ax,0003h
	int	10h
	mov	ah,9
	lea	dx,filerr
	int	21h
	jmp	errend

goon2:	mov	ax,4
	mov	cx,150
	mov	dx,80
	int	33h		;center mouse cursor
	mov	ax,3
	int	33h		;get mouse position and button status
	mov	bx,dx
	mov	ax,320
	mul	bx
	add	ax,cx		;calculate cursor address
	mov	[maddr],ax	;and store mouse cursor address
	mov	[mnewaddr],ax	;and store mouse cursor address


	call	getorig		;get original picture
	call	transf		;make transformation
	call	or2te		;copy it to 'temp' buffer
	lea	si,cs:dest	;ds:si = stored original picture address
	call	putimg		;display transformed picture

;================================ Main loop ==================================
again:	mov	ax,000bh
	int	33h		;examine mouse movement
	or	cx,cx
	jnz	newpic		;horizontal movement -> new picture
	or	dx,dx
	jnz	newpic		;vertical movement -> new picture
	mov	ax,3
	int	33h		;read mouse button status
	and	bx,1
	jnz	finish		;quit if button pressed
	mov	ah,1
	int	16h		;quit if key pressed
	jnz	finis	
	jmp	again		;jump back

;====================== Draw new picture if mouse moved ======================
newpic:	mov	ax,3
	int	33h		;get new mouse position
	mov	bx,dx
	mov	ax,320
	mul	bx
	add	ax,cx		;calculate cursor address
	mov	cs:[mnewaddr],ax;and store mouse cursor address

	call	getorig		;get original picture
	call	transf		;make transformation
	call	vrtchk		;VRT check
	lea	si,cs:temp
	call	putimg		;display original picture from 'temp'
	push	[cs:mnewaddr]
	pop	[cs:maddr]
	lea	si,cs:dest	;ds:si = stored original picture address
	call	putimg		;display transformed picture
	call	or2te		;copy 'orig' to 'temp'

	jmp	again		;jump back

;============================== Quit program =================================
finis:	xor	ah,ah
	int	16h
finish:	mov	ax,0
	int	33h
	mov	ax,0003h
	int	10h

errend:	mov	ax,4c00h
	int	21h


;=============================================================================
;=============================   Subroutines   ===============================
;=============================================================================

;=============== Get original picture ============
getorig	proc	near

	mov	si,cs:[mnewaddr];ds:si = mouse position address
	push	[inpseg]	;which is the upper-left corner
	pop	ds		;of the transformation area
	push	cs
	pop	es
	lea	di,cs:orig
	mov	cx,xsize	;rows

ujra:	push	cx
	mov	cx,xsize/4	;columns
	rep	movsd		;store a row
	pop	cx
	add	si,320-xsize	;jump to next row
	loop	ujra		;store all rows
	ret

	endp	getorig

;==================== Orig to Temp =====================
or2te	proc	near

	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	lea	si,orig
	lea	di,temp
	mov	cx,676
	rep	movsd
	ret

	endp	or2te

;======================= Put image ==========================
;si = buffer address to display
putimg	proc	near

	push	cs
	pop	ds
	push	0a000h
	pop	es
	mov	di,[maddr]	;es:di = address to put picture
	mov	cx,xsize	;rows

kovsr:	push	cx
	mov	cx,xsize/4	;columns
	rep	movsd		;display a row
	pop	cx
	add	di,320-xsize	;go to next row
	loop	kovsr		;display all rows
	ret

	endp	putimg

;====================== Transformation =======================
transf	proc	near

	push	cs
	pop	ds
	lea	bx,trans	;bx = transformation array address
	lea	bp,orig		;bp = stored original picture address
	lea	di,dest		;di = transformed picture address
	mov	cx,xsize2	;transform all points

newpix:	mov	si,[bx]		;si = pointer to needed pixel
	add	si,bp
	dec	si
	movsb
	inc	bx
	inc	bx		;next pixel
	loop	newpix		;transform all 961 pixels
	ret

	endp	transf

;========================= VRT Check =======================
vrtchk	proc	near

	mov	dx,3dah
z1:	in	al,dx		;Is it Vertical Retrace?
	test	al,8
	jnz	z1		;If yes, wait

z2:	in	al,dx		;Is it Vertical Retrace?
	test	al,8
	jz	z2		;If no, wait
	ret

	endp	vrtchk

;======================== Load TGA pix =========================
loadtga	proc	near

	push	ds
	push	cs
	pop	ds
	mov	ax,3D00h
	lea	dx,TGA_filename
	int 21h				;open file
	jc	errfil
	mov	[TGA_handle],ax

	mov	ah,3Fh
	mov	bx,[TGA_handle]
	mov	cx,18			;read crap
	lea	dx,ReadBuffer
	int	21h
	jc	errfil
        
	mov	ah,3Fh
	mov	bx,[TGA_handle]
	mov	cx,768			;read palette
	lea	dx,ReadBuffer
	int	21h
	jc	errfil

	mov	cx,256
	push	cs
	pop	es
	lea	si,ReadBuffer
	lea	di,ReadBuffer

palfix:	lodsb
	shr	al,2
	mov	ah,al
	lodsb
	shr	al,2
	mov	bh,al
	lodsb
	shr	al,2
	stosb
	mov	al,bh
	stosb
	mov	al,ah
	stosb
	dec	cx
	jnz	palfix

	mov	ax,1012h
	xor	bx,bx
	mov	cx,256
	push	cs
	pop	es
        lea	dx,ReadBuffer
	int	10h			;set all palette

	mov	ah,3Fh
	mov	bx,[TGA_handle]
	mov	cx,64000
	push	[inpseg]
	pop	ds
	xor	dx,dx
	int	21h			;load picture
	jc	errfil

	mov	ah,3Eh
	mov	bx,[TGA_handle]
	int	21h			;close file
	xor	ah,ah
	jmp	fileok

errfil:	mov	ah,01h
fileok:	pop	ds
	ret

	endp	loadtga

;=============================================================================
;========================	  Data area	    ==========================
;=============================================================================

mouserr	db	'Mouse driver not found','$'
memerr	db	'Not enough memory','$'
vgaerr	db	'VGA card not found','$'
filerr	db	'File error','$'
_386err	db	'386 or better required','$'

orig	db	xsize2 dup (0)
dest	db	xsize2 dup (0)
temp	db	xsize2 dup (0)

trans	label
include transfrm.dat

inpseg		dw	0
maddr		dw	0
mnewaddr	dw	0
TGA_filename	db	'lens.tga',0
TGA_handle	dw	0
ReadBuffer	db	768 dup (0)

	ends
	end	start
