Program Glass; Uses CRT;
----------------------------------------------------------
-- Hi! K!O speaks. Here is another funny demo effect    --
-- called by me (it looks like) "bumped glass".         --
-- In fact, it's the same idea I used in "water effect" --
-- but...little simplier. Yes! Because you haven't to   -- 
-- change mask in "real time" :-), procedure is much    --
-- faster, too.                                         --
--                                                      --
-- Copyrights:                                          --
-- Of course, you can use this idea and procedure in    --
-- your own productions, but please credit me, if you   --
-- do.                                                  --
-- Have you any questions? Here is my e-mail. Feel free --
-- and send message to: kolejnik@ck-sg.p.lodz.pl        --
--                                                      --
-- 22/10/1997                       Konrad Olejnik/K!O  --
----------------------------------------------------------
var
          GlassBuf : array[ 0..64320 ] of Integer;  -- "bumped glass" mask
            ZapBuf,
    DatBuf, BufScr : array[ 0..64000 ] of byte;     
            paleta : array[ 1..768 ] of byte;
    t2, t1, ZapAdr,
          GlassAdr,
    VirScr, DatAdr : Dword;
    frame, m, i, j : word;
                ch : char;
            dr, li : ShortInt;
              plik : file; 
             timer : dword absolute $0046C;
const
             sfont : array[ 0..1519 ] of byte =  
 ---------------------------------------------
 -- bold font. Sorry for this BIG shit, but --
 -- I want to keep all in one file          --
 ---------------------------------------------         
( $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1C,$1C,$1C,
  $1C,$1C,$1C,$1C,$1C,$00,$00,$1C,$1C,$00,$00,$00,$00,$E7,$E7,$66,$24,$00,$00,
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$E7,$E7,$E7,$FF,$FF,$66,$66,$FF,$FF,
  $E7,$E7,$E7,$00,$00,$00,$00,$00,$0C,$7F,$CC,$CC,$CC,$7E,$33,$33,$33,$FE,$30,
  $00,$00,$00,$00,$60,$F1,$F3,$67,$0E,$1C,$38,$70,$E6,$CF,$8F,$06,$00,$00,$00,
  $00,$00,$70,$D8,$D8,$D8,$70,$70,$D9,$CF,$C6,$6F,$39,$00,$00,$00,$00,$1C,$1C,
  $1C,$38,$30,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1E,$3C,$78,$F0,$E0,
  $E0,$E0,$E0,$F0,$78,$3C,$1E,$00,$00,$00,$00,$78,$3C,$1E,$0F,$07,$07,$07,$07,
  $0F,$1E,$3C,$78,$00,$00,$00,$00,$00,$00,$BA,$FE,$7C,$FE,$FE,$7C,$FE,$BA,$00,
  $00,$00,$00,$00,$00,$00,$00,$1C,$1C,$1C,$7F,$7F,$1C,$1C,$1C,$00,$00,$00,$00,
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1C,$1C,$1C,$38,$30,$00,$00,$00,
  $00,$00,$00,$00,$7F,$7F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
  $00,$00,$00,$00,$00,$1C,$1C,$1C,$00,$00,$00,$00,$00,$01,$03,$07,$0E,$1C,$38,
  $70,$E0,$C0,$80,$00,$00,$00,$00,$00,$3C,$7E,$E7,$E7,$E7,$EF,$FF,$F7,$E7,$E7,
  $7E,$3C,$00,$00,$00,$00,$1C,$3C,$7C,$1C,$1C,$1C,$1C,$1C,$1C,$7F,$7F,$7F,$00,
  $00,$00,$00,$FE,$FF,$07,$07,$07,$7F,$FE,$E0,$E0,$E0,$FF,$7F,$00,$00,$00,$00,
  $FE,$FF,$07,$07,$07,$7F,$7F,$07,$07,$07,$FF,$FE,$00,$00,$00,$00,$07,$0E,$1C,
  $38,$70,$E7,$E7,$FF,$FF,$07,$07,$07,$00,$00,$00,$00,$7F,$FF,$E0,$E0,$E0,$FE,
  $7F,$07,$07,$07,$FF,$FE,$00,$00,$00,$00,$7E,$FE,$E0,$E0,$FE,$FF,$E7,$E7,$E7,
  $E7,$FF,$7E,$00,$00,$00,$00,$FE,$FF,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,
  $00,$00,$00,$00,$7E,$FF,$E7,$E7,$E7,$FF,$FF,$E7,$E7,$E7,$FF,$7E,$00,$00,$00,
  $00,$7E,$FF,$E7,$E7,$E7,$FF,$7F,$07,$07,$07,$07,$07,$00,$00,$00,$00,$00,$00,
  $00,$00,$1C,$1C,$1C,$00,$00,$1C,$1C,$1C,$00,$00,$00,$00,$00,$00,$00,$00,$1C,
  $1C,$1C,$00,$00,$1C,$1C,$1C,$38,$30,$00,$00,$07,$0E,$1C,$38,$70,$E0,$E0,$70,
  $38,$1C,$0E,$07,$00,$00,$00,$00,$00,$00,$00,$FE,$FE,$00,$00,$FE,$FE,$00,$00,
  $00,$00,$00,$00,$00,$E0,$70,$38,$1C,$0E,$07,$07,$0E,$1C,$38,$70,$E0,$00,$00,
  $00,$00,$7E,$FF,$E7,$07,$07,$0E,$1C,$1C,$00,$00,$1C,$1C,$00,$00,$00,$00,$3E,
  $7E,$E7,$E7,$E7,$EF,$EF,$EF,$E0,$E0,$7F,$3F,$00,$00,$00,$00,$3C,$7E,$E7,$E7,
  $E7,$FF,$FF,$E7,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$FE,$FF,$E7,$E7,$EF,$FE,$FF,
  $E7,$E7,$E7,$FF,$FE,$00,$00,$00,$00,$3C,$7E,$E7,$E7,$E0,$E0,$E0,$E0,$E7,$E7,
  $7E,$3C,$00,$00,$00,$00,$FC,$FE,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$FE,$FC,$00,
  $00,$00,$00,$FF,$FF,$E0,$E0,$E0,$FC,$FC,$E0,$E0,$E0,$FF,$FF,$00,$00,$00,$00,
  $FF,$FF,$E0,$E0,$E0,$FC,$FC,$E0,$E0,$E0,$E0,$E0,$00,$00,$00,$00,$3C,$7E,$E7,
  $E7,$E0,$EF,$EF,$E7,$E7,$E7,$7E,$3C,$00,$00,$00,$00,$E7,$E7,$E7,$E7,$E7,$FF,
  $FF,$E7,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$3E,$3E,$1C,$1C,$1C,$1C,$1C,$1C,$1C,
  $1C,$3E,$3E,$00,$00,$00,$00,$0F,$0F,$07,$07,$07,$07,$07,$07,$E7,$E7,$7E,$3C,
  $00,$00,$00,$00,$E7,$E7,$EE,$FC,$F8,$F0,$F8,$FC,$FE,$EF,$E7,$E7,$00,$00,$00,
  $00,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$FF,$FF,$00,$00,$00,$00,$C3,$E7,
  $FF,$FF,$FF,$FF,$E7,$E7,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$C7,$E7,$F7,$FF,$FF,
  $EF,$E7,$E7,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$3C,$7E,$E7,$E7,$E7,$E7,$E7,$E7,
  $E7,$E7,$7E,$3C,$00,$00,$00,$00,$FE,$FF,$E7,$E7,$E7,$FF,$FE,$E0,$E0,$E0,$E0,
  $E0,$00,$00,$00,$00,$3C,$7E,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$7E,$3F,$07,$03,
  $00,$00,$FE,$FF,$E7,$E7,$E7,$FE,$FE,$EF,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$7E,
  $FF,$E7,$E7,$E0,$FE,$7F,$07,$E7,$E7,$FF,$7E,$00,$00,$00,$00,$FE,$FE,$38,$38,
  $38,$38,$38,$38,$38,$38,$38,$38,$00,$00,$00,$00,$E7,$E7,$E7,$E7,$E7,$E7,$E7,
  $E7,$E7,$E7,$FF,$7E,$00,$00,$00,$00,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$7E,
  $3C,$18,$00,$00,$00,$00,$E7,$E7,$E7,$E7,$E7,$E7,$FF,$FF,$FF,$FF,$66,$66,$00,
  $00,$00,$00,$E7,$E7,$E7,$E7,$7E,$3C,$3C,$7E,$E7,$E7,$E7,$E7,$00,$00,$00,$00,
  $EE,$EE,$EE,$EE,$FE,$FE,$7C,$38,$38,$38,$38,$38,$00,$00,$00,$00,$FF,$FF,$07,
  $07,$0E,$1C,$38,$70,$E0,$E0,$FF,$FF,$00,$00,$00,$00,$7E,$7E,$70,$70,$70,$70,
  $70,$70,$70,$70,$7E,$7E,$00,$00,$00,$00,$00,$80,$C0,$E0,$70,$38,$1C,$0E,$07,
  $03,$01,$00,$00,$00,$00,$00,$7E,$7E,$0E,$0E,$0E,$0E,$0E,$0E,$0E,$0E,$7E,$7E,
  $00,$00,$00,$00,$18,$3C,$7E,$E7,$C3,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$FF,$00,$00,$00,$00,$38,$38,
  $38,$1C,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7C,
  $7E,$0E,$7E,$FE,$EE,$FF,$7F,$00,$00,$00,$00,$E0,$E0,$E0,$E0,$FE,$FF,$E7,$E7,
  $E7,$E7,$FF,$FE,$00,$00,$00,$00,$00,$00,$00,$00,$3E,$7F,$E7,$E0,$E0,$E7,$7F,
  $3E,$00,$00,$00,$00,$07,$07,$07,$07,$7F,$FF,$E7,$E7,$E7,$E7,$FF,$7F,$00,$00,
  $00,$00,$00,$00,$00,$00,$3C,$7E,$E7,$FF,$FF,$E0,$7E,$3E,$00,$00,$00,$00,$3E,
  $7F,$77,$70,$FE,$FE,$70,$70,$70,$70,$70,$70,$00,$00,$00,$00,$00,$00,$00,$00,
  $3C,$7E,$E7,$E7,$E7,$7F,$3F,$07,$7E,$7C,$00,$00,$E0,$E0,$E0,$E0,$FE,$FF,$E7,
  $E7,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$00,$38,$38,$00,$78,$78,$38,$38,$38,$38,
  $7C,$7C,$00,$00,$00,$00,$00,$07,$07,$00,$0F,$0F,$07,$07,$07,$07,$07,$E7,$FF,
  $7E,$00,$00,$E0,$E0,$E0,$E3,$E7,$EF,$FE,$FC,$EE,$E7,$E7,$E7,$00,$00,$00,$00,
  $78,$78,$38,$38,$38,$38,$38,$38,$38,$38,$7C,$7C,$00,$00,$00,$00,$00,$00,$00,
  $00,$EE,$FF,$FF,$DB,$DB,$DB,$DB,$DB,$00,$00,$00,$00,$00,$00,$00,$00,$FC,$FE,
  $E7,$E7,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$00,$00,$00,$00,$3C,$7E,$E7,$E7,$E7,
  $E7,$7E,$3C,$00,$00,$00,$00,$00,$00,$00,$00,$FC,$FE,$E7,$E7,$E7,$FE,$FC,$E0,
  $E0,$E0,$00,$00,$00,$00,$00,$00,$3F,$7F,$E7,$E7,$E7,$7F,$3F,$07,$07,$07,$00,
  $00,$00,$00,$00,$00,$FE,$FF,$E7,$E0,$E0,$E0,$E0,$E0,$00,$00,$00,$00,$00,$00,
  $00,$00,$7F,$FF,$E0,$FE,$7F,$07,$FF,$FE,$00,$00,$00,$00,$00,$38,$38,$38,$FE,
  $FE,$38,$38,$38,$38,$3F,$1F,$00,$00,$00,$00,$00,$00,$00,$00,$E7,$E7,$E7,$E7,
  $E7,$E7,$7F,$3F,$00,$00,$00,$00,$00,$00,$00,$00,$E7,$E7,$E7,$E7,$E7,$7E,$3C,
  $18,$00,$00,$00,$00,$00,$00,$00,$00,$C3,$C3,$DB,$DB,$FF,$FF,$E7,$C3,$00,$00,
  $00,$00,$00,$00,$00,$00,$C3,$E7,$7E,$3C,$3C,$7E,$E7,$C3,$00,$00,$00,$00,$00,
  $00,$00,$00,$E7,$E7,$E7,$E7,$E7,$FF,$7F,$07,$7F,$7E,$00,$00,$00,$00,$00,$00,
  $FF,$FF,$0E,$1C,$38,$70,$FF,$FF,$00,$00,$00,$00,$1C,$3C,$30,$70,$70,$E0,$E0,
  $70,$70,$30,$3C,$1C,$00,$00,$00,$00,$00,$1C,$1C,$1C,$1C,$00,$00,$1C,$1C,$1C,
  $1C,$00,$00,$00,$00,$00,$38,$3C,$0C,$0E,$0E,$07,$07,$0E,$0E,$0C,$3C,$38,$00,
  $00,$00,$00,$70,$F9,$FF,$9F,$0E,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 );

procedure TextXY( where : dword; x, y : word; tekst : string; size, clr : byte );
var
  a, b, c, d, znak, zn : byte;
                   adr : dword;
begin
  znak:=1;
  repeat
    a:=0;
    zn:=Ord( tekst[ znak ] )-32;       
    repeat
      b:=0;
      repeat                              -- prepare text start & end x, y
        adr:=( y+a*size )*320+b*size+x+where;
        if (( sfont[ ( zn SHL 4 )+a ] SHL b ) AND $80 ) = $80
          then for c:=0 to size-1 do 
                 for d:=0 to size-1 do
                   mem[ adr+c*320+d ]:=clr;
        inc( b );
      until b = 8;
      inc( a );
    until a = 16;
    inc( x, 9*( size-1 ));
    inc( znak );
  until znak = Ord( tekst[ 0 ] ) + 1;
end;

procedure SetMode( tryb : word ); assembler;
asm
  mov  AX, [tryb]
  int  $10
end;

procedure MoveD( src, dest, size : Dword ); assembler;
asm
  cld
  mov  ESI, [src]
  mov  EDI, [dest]
  mov  ECX, [size]
  rep  movsd
end;

procedure FlipScreen( adres : dword ); assembler;
asm
    mov  DX, $3DA     -- port $3DA - 4 bit:
@l1:                  -- 0 - display mode, 1 - vertical retrace
     in  AL, DX
    and  AL, $08
    jnz  @l1
@l2: 
     in  AL, DX
    and  AL, $08
     jz  @l2
    mov  ESI, [adres]
    mov  EDI, $A0000
    mov  ECX, 16000
    rep  movsd
end;

procedure FillDWord( src, size, what : Dword ); assembler;
asm
  mov  EDI, [src]
  mov  ECX, [size]
  mov  EAX, [what]
  rep  stosd
end;


procedure FuzzyScreen2( adres : dword; ilePix : word ); assembler;
 -- for k:=0 to ilePix do
 --   mem[ adres+k ]:=( mem[ adres+k+1 ]+mem[ adres+k-1 ]+
 --                   ( mem[ adres+k+320 ]+mem[ adres+k-320 ] ) SHR 2;
asm
       mov  CX, [ilePix]
       mov  EBX, [adres]
       add  EBX, 320
 @ll2:
       xor  AX, AX
       xor  DX, DX
       mov  AL, [EBX+320]
       mov  DL, [EBX-320]
       add  AX, DX
       xor  DX, DX
       mov  DL, [EBX+1]
       add  AX, DX
       xor  DX, DX
       mov  DL, [EBX-1]
       add  AX, DX
       shr  AX, 2
       mov  [EBX], AL
       inc  EBX
       dec  CX
       cmp  CX, 320
       jae  @ll2
end;

procedure LoadBMP( BMPName : string );
var
      n, i : byte;
     Fsize : Dword;

begin
  assign( plik, BMPName );
  {$I-}
  reset( plik, 1 );
  {$I+}
  if IOResult <> 0
    then begin
           SetMode( $0003 );
           writeLn('No Pictures found.');
           halt( 1 );
         end;
  Fsize:=FileSize( plik );
  seek( plik, 54 );
  BlockRead( plik, DatBuf, 1024 );
  for i:=0 to 255 do                      -- prepare palette
    begin
      paleta[ i*3+3 ]:=DatBuf[ i*4+0 ] SHR 2;
      paleta[ i*3+2 ]:=DatBuf[ i*4+1 ] SHR 2;
      paleta[ i*3+1 ]:=DatBuf[ i*4+2 ] SHR 2;
    end;
  seek( plik, 1078 );
  BlockRead( plik, DatBuf, Fsize-1078 );
  for i:=0 to 199 do
    moveD( DatAdr+320*i, VirScr+( 199-i )*320, 80 );
  close( plik );
end;

procedure SetPal; assembler;
asm
  xor  AL, AL
  mov  DX, $3C8
  out  DX, AL
  mov  ESI, offset paleta
  mov  CX, 768
  mov  DX, $3C9
  rep  outsb
end;

procedure ShowGlass; assembler;
-------------- All, what this procedure does, is here ----------------
-- Picture "under glass" is in "DatAdr",  "VirScr" - screen buffer  --
-- mask with bumped glass is under "GlassAdr" offset                --
----------------------------------------------------------------------
--  i:=0;
--  repeat
--    inc( i );
--    j:=0;
--    wn:=( i SHL 6 )+( i SHL 8 );
--    repeat
--      inc( j );
--      inc( wn );
--      dx:=GlassBuf[ wn ]-GlassBuf[ wn+320 ];
--      dy:=GlassBuf[ wn ]-GlassBuf[ wn+1 ];
--      ofsx:=( dx SHR 3 ) + j;
--      ofsy:=( dy SHR 3 ) + i;
--      bajt:=DatBuf[ ofsx+( ofsy SHL 6 )+( ofsy SHL 8 ) ];
--      BufScr[ wn ]:=bajt;
--    until j = width-1;
--  until i = height-1;
-----------------------------------------------------------------
asm
 --------------------------------
 -- Painting glass starts here --
 --------------------------------
           push  BP
            xor  BP, BP            -- i = Y counter
            mov  EDI, [GlassAdr]   -- buffer with map of glass
            mov  ESI, [VirScr]
            xor  EBX, EBX          -- start offset of screen (0)
            xor  CX, CX
    @lloop:                        -- main loop starts here !!!
            inc  CX
            xor  EBX, EBX
            add  EDI, 2            -- use integers, so all *2
            mov  BX, [EDI+2]       -- BX:=GlassBuf[ i*320+j ]
            sub  BX, [EDI]
            mov  DX, [EDI+640]     -- DX:=GlassBuf[ i*320+j+1 ]
            sub  DX, [EDI]
            sar  DX, 3
            sar  BX, 3            
            add  DX, CX            -- DX: ofsx = ( wdx SHR 3 ) + CX(X)
            add  BX, BP            -- BX: ofsy = ( wdy SHR 3 ) + BP (Y)
            shl  BX, 6
            mov  AX, BX
            shl  BX, 2
            add  BX, AX            -- BX:= ofsy*320
            add  BX, DX            -- BX = ofsx+ofsy*320
            add  EBX, [DatAdr]
            mov  AL, [EBX]         -- AL:=mem[ DatAdr+BX ]
            inc  ESI
            mov  [ESI], AL         -- mem[ VirScr+i*320+j ]:=AL
            cmp  CX, 320           -- X size of screen: 320
            jne  @lloop
            xor  CX, CX
            inc  BP
            cmp  BP, 200
            jne  @lloop            -- end of "paint water"
            pop  BP
end; { of procedure "ShowWater" }

BEGIN                                   -- main program starts here
  SetMode( $13 );
  VirScr:=Ofs( BufScr );
  DatAdr:=Ofs( DatBuf );
GlassAdr:=Ofs( GlassBuf );              -- offset for bumped glass mask
  ZapAdr:=Ofs( ZapBuf );
  FillDWord( GlassAdr, 64000, 0 );      -- clear mask buffer
  FillDWord( DatAdr, 16000, 0 );
  -----------------------
  -- Prepare bump mask --
  -----------------------
  TextXY( ZapAdr, 15, 40, 'B u m p  G l a s s  E f f e c t', 2, 129 );
  TextXY( ZapAdr, 120, 80, 'I N', 3, 129 );  
  TextXY( ZapAdr, 70, 130, 'T M T  P A S C A L', 2, 129 );
  FuzzyScreen2( ZapAdr, 64000 );        -- just for more realistic look
  i:=0;
  repeat
    if mem[ ZapAdr+i ] > 128 then GlassBuf[ i ]:=2*mem[ ZapAdr+i ]
                             else GlassBuf[ i ]:=-2*mem[ ZapAdr+i ];
    inc( i );
  until i = 64000;
  LoadBMP( 'dolphin.bmp' );
  moveD( VirScr, ZapAdr, 16000 );
  SetPal;
  -----------------
  -- Well, done. --
  -----------------
  dr:=1;
  li:=1;
  frame:=0;  t1:=timer;
  repeat
    if ( dr > 80 ) OR ( dr < -90 ) then li:=-li;
    inc( dr, li );
    FillDWord( DatAdr, 16000, 0 );
    if dr >=0 then moveD( ZapAdr, DatAdr+dr*320, 16000-dr*80 )
              else moveD( ZapAdr-( dr*320 ), DatAdr, 16000+dr*80 ); 
    ------------------------------------------------
    --- code for move of background picture is above
    --- please try to optimize this part  
    ------------------------------------------------
    ShowGlass;                             -- Just do it.
    FlipScreen( VirScr );                  -- show the buffer on the screen
    inc( frame );
  until KeyPressed;
  t2:=timer-t1;
  SetMode( $03 );
  writeLn((( frame*18.2 )/t2 ):6:2,' frames per second.');
-- and this is the
END.
-- my friend.   :-)
