
#include <io.h>
#include <stdio.h>
#include <dos.h>             /* has MK_FP macroo in it */
#include <stdlib.h>     // for malloc. This must be here or malloc will
                        // FAIL, if d==NULL will not catch it!! so always include this!

#define NOT_FOUND -1
#define debug 1                  /* debugging on/off */

/* this is the pic size structure for display info only*/
struct pic_size
{
int width;
int height;
};

typedef struct pic_size SIZE_INFO;



struct head                  /* pcx header */
{
 char manufacturer,          /* always 10 */
      version,               /* always 5 */
      encoding,              /* 1 = run length encoding */
      bits_per_pixel;        /* always 8 */
 int  xmin,                  /* x,y min/max of the pic */
      ymin,
      xmax,
      ymax,
      hres,
      vres;
 char colormap[48],          /* for ega, we dont use it */
      reserved,
      nplanes;              /* better be 1 */
 int  bytes_per_line,
      pal_type;             /* 1 for color b/w , 2= greyscale */
 char filler[58];
 };

 typedef struct head PCX_HEADER;
 



/* Palette control */
void G_SetColor(unsigned char index,char r,char g,char b);
void G_GetColor(char index,char *r,char *g,char *b);
void G_SetPal(char *pal,int start,int numcols);
void G_GetPal(char *pal,int start,int numcols);
void G_FadeInPal(char *npal,int speed);
void G_FadeOutPal(char *npal,int speed); 
int  G_FindColor(char r,char g,char b);
void G_DisplayPal(); 





/* From SCR.C */

void Int13_mode();
void Text_mode();
void G_plot_pixel(int x,int y,unsigned char color, char far *back);
void G_Centered_vertical_line(int height,unsigned char color,int column,char far *back);
void G_Set_column_color(int column,unsigned char color,char far *back); 
void G_Set_scanline_color(int line,unsigned char color,char far *back);
void G_Set_screen_color(unsigned char color,char far *back);

//int  GL_GetPixel(int x,int y);
//void GL_FillBox(int x1,int y1,int x2,int y2,char color);
//void GL_FilledBox(int x1,int y1,int w,int h,char color);
//void GL_Rectangle(int x1,int y1,int x2,int y2,char color);
//void GL_Line(int x1,int y1,int x2,int y2,char color);
//void GL_Circle(int x,int y,int radius);

//void GL_SetDrawingBuffer(char *buffer);
//unsigned char *GL_MakeDrawingBuffer(void);
//void GL_FreeDrawingBuffer(unsigned char *buffer);
//void GL_UpdateScreen(unsigned char *buffer);

void G_WaitRetrace();  
//void GL_PutImage(int x,int y,struct image_s *image);
//void GL_GetImage(int x,int y,struct image_s *image);
//void GL_PutSprite(int x,int y,int sx,int sy,unsigned char *image);


//void GL_Putc( int c );
//void GL_Puts( char *str);
//int GL_TextXSize(char *str);
//int GL_LoadFont( char* font );
//void GL_ItalicsOn(void);
//void GL_ItalicsOff(void);
//void GL_GotoXY( int x, int y );
//int GL_GetX(void);
//int GL_GetY(void);
//void GL_BoldOff(void);
//void GL_BoldOn(void);
//void GL_PutText(int x,int y,char *str);
//void GL_TextColor(char color);
//void GL_TextShadow(char color,int offsetx,int offsety);
//void GL_TextUnderline(char color,int offsety);
//void GL_TextBold(int thickness);










//void GL_PutText(int x,int y,char *str);
//void GL_TextColor(char color);
//void GL_TextShadow(char color,int offsetx,int offsety);
//void GL_TextUnderline(char color,int offsety);
//void GL_TextBold(int thickness);
//int  GL_TextXSize(char *str);
//int  GL_TextYSize(char *str);
//int  GL_LoadFontFile(char *fname);
//void GL_UseFont(int fontID);

/* ACTIVE FOR MODE X ONLY (no effect in Mode 13H): */
//void GL_SetVisualPage(int page);
//void GL_SetActivePage(int page);
//int  GL_GetVisualPage(void);
//int  GL_GetActivePage(void);


/* image.c */
char *G_load_pcx(char *filename, int load_palette,SIZE_INFO *size); 
char *pcx_decode(FILE *handle, int load_palette,SIZE_INFO *size);

//int GL_Gif( char* file, char * buffer, char * pal, int* width, int* height );


/* glkey.c */
//void GL_AddKey(int down,int up);
//void GL_TrapKeys(void);
//void GL_ReleaseKeys(void);

//struct GL_KEYMAP                        /* This holds a list of key scan   */
//{                                       /* codes that we want to trap.     */
//   unsigned char downcode;              /* Code when key is pressed        */
//   unsigned char upcode;                /* Code when key is released       */
//};

//extern unsigned char *ScrBuffer;
//extern struct GL_KEYMAP GL_Keys[32];
//extern char   GL_NumKeys;
//extern char   GL_KeyStat[32];           /* You can test if a given key is   */

//#define random(num)(int)(((long)rand()*(num))/(RAND_MAX+1))
//#define randomize()     srand((unsigned)time(NULL))

              /*
void disable();
void enable();
                */

#pragma aux disable =  "cli"
#pragma aux enable =   "sti"




