//ks_sp.cpp

//texture mapping onto a sphere by Keith/Pixel Magic

//.raw format is first 2 words width/height then byte data.

//Comments/suggestions welcome : ks2@st-and.ac.uk

//Also uploaded to x2ftp with binaries and raws

//If you use it, please credit me

#include <conio.h>
#include <math.h>
#include <dos.h>
#include <stdio.h>

#pragma inline

int R;		//Radius of sphere
int D;		//Diameter of sphere
int C;		//Circum of sphere
int* Rh;	//Rad at height

char far* bm;
int W;		//Width of bm
int H;		//Height of bm

int** TRF;	//Horizontal transformations
int* TRFV;	//Vertical (scan line) transformations

//Externals which I have not included
struct pal;
extern char far* LoadRAW(char*,int&,int&);
extern pal*	 LoadPal(char*);
extern void*	 SetPal(pal* p);

main(int argc,char** argv)
{
 char buf[15];

 if(argc!=2) return(0);

 sprintf(buf,"%s.raw",argv[1]);

 bm=LoadRAW(buf,W,H);

 sprintf(buf,"%s.pal",argv[1]);

 pal* p=LoadPal(buf);

 if(bm==NULL || p==NULL) return(0);

 C=W;
 D=(float)C/M_PI;
 R=(float)(C)/(M_PI*2.0);

 register int i,j;

 Rh=new int[D];
 for(i=0;i<D;i++) Rh[i]=sqrt(R*R-(R-i)*(R-i));

 TRF=new int*[D];
 for(i=0;i<D;i++) TRF[i]=new int[Rh[i]];

 for(i=0;i<D;i++)
	for(j=0;j<Rh[i];j++) {
		double theta=asin((float)j/(float)Rh[i]);
		float arc=(float)C/4.0;
		float fractional=theta/(M_PI/2.0);
		int offset=fractional*arc;
		TRF[i][j]=offset; }

 TRFV=new int[D];

 for(i=0;i<D;i++) {
	float dh=(float)H/(float)D;
	int line=(float)i*dh;
	TRFV[i]=W*line; }

 int x=160;

 _AH=0;		//Set 13h
 _AL=0x13;
 asm int 0x10

 SetPal(p);

 char far* vga=(char far*)MK_FP(0xA000,0);

 int rot=0;

 char k=0;

 while(k!=27) {
	if(kbhit()) k=getch();
	rot++;
	rot%=W;
	for(i=0;i<D;i++) {
		char far* loc=bm+TRFV[i]+rot;
		int i320=i*320;
		for(j=0;j<Rh[i];j++) {
			int h_offset=TRF[i][j];
			char c1=*(loc+h_offset);
			char c2=*(loc-h_offset);
			vga[x+j+i320]=c1;
			vga[x-j+i320]=c2; }
		}
	}

 _AH=0;
 _AL=0x03;
 asm int 0x10

 printf("Texture map: Keith\\Pixel Magic\n");

 return(0);
}
