;-----------------------------------------------------------------------------
; /* XtaC */
;
; MCGA.ASM
;
; These are a bunch of assembler routines for programming the vga
; They are beeing used to link with C code
;
; DISCLAIMER
; You can use this code in any way you want, as long as you greet me in your
; work. If you want to contact me, e-mail me at milton_moura@hotmail.com
;-----------------------------------------------------------------------------

;.model flat,c

.code

public tweakvga
public waitretrace
public waithretrace
public setmcga
public settext

;----------------------------
; tweak the vga to 80x50
;----------------------------
tweakvga proc C
        mov  ax,13h
        int  10h
        cli
        mov  dx,3C4h
        mov  ax,604h
        out  dx,ax
        mov  ax,0F02h
        out  dx,ax
        mov  dx,3D4h
        mov  ax,14h
        out  dx,ax
        mov  ax,0E317h
        out  dx,ax
        mov  al,9
        out  dx,al
        inc  dx
        in   al,dx
        and  al,0E0h
        add  al,7
        out  dx,al
        sti
        ret
tweakvga endp

;-------------------------------
; waits for a vertical retrace
;-------------------------------
waitretrace proc C
        mov dx,3dah

@loop1: in al,dx
        and al,08h
        jnz @loop1

@loop2: in al,dx
        and al,08
        jz @loop2

        ret
waitretrace endp

waithretrace proc C
        mov dx, 03dah

@l1:    in al, dx
        test al, 1
        jnz @l1

@l2:    in al, dx
        test al, 1
        jz @l2

        ret
waithretrace endp

setmcga proc C
        mov ax,13h
        int 10h

        ret
setmcga endp

settext proc C
        mov ax,3h
        int 10h

        ret
settext endp

end
