{$G+}
{ In Procdures FADEIN & FADEOUT, the (X) is the delay between
  screen darkenings. }

Unit FadeUNT;
 Interface

   Uses Crt;

   Const
     PelAddrRgR  = $3C7;
     PelAddrRgW  = $3C8;
     PelDataReg  = $3C9;

   Type
     RGB = Record
             R,G,B : Byte;
           End;
     Colortype = Array [0..255] Of RGB;

   Var
     Col : Colortype;
     Pal1, PAL2 	: Colortype;


   Procedure GetCol(C : Byte; Var R, G, B : Byte);
   Procedure SetCol(C, R, G, B : Byte);
   Procedure SetInten(B : Byte);
   Procedure FadeIn (X:Integer);
   Procedure FadeOut (X:Integer);
   Procedure FadeOut1 (X:Integer);
   Procedure Fadeout2(Stage:Integer);
 Implementation



Procedure GetCol(C : Byte; Var R, G, B : Byte);
Begin
  Port[PelAddrRgR] := C;
  R := Port[PelDataReg];
  G := Port[PelDataReg];
  B := Port[PelDataReg];
End;

Procedure SetPal(Var Palette : COLorType); Assembler;
Asm
	push	ds
	lds   si, Palette
	mov   dx, 3c8h
	mov   al, 0
	out   dx, al
	inc   dx
	mov   cx, 768
	rep   outsb
	pop   ds
End;

Procedure SetCol(C, R, G, B : Byte);
Begin
  Port[PelAddrRgW] := C;
  Port[PelDataReg] := R;
  Port[PelDataReg] := G;
  Port[PelDataReg] := B;
End;

Procedure SetInten(b : Byte);
 Var
   I : Integer;
   FR, FG, FB : Byte;
 Begin
   For I:=0 To 255 Do
   Begin
     FR:=Col[I].R*B Div 255;
     FG:=Col[I].G*B Div 255;
     FB:=Col[I].B*B Div 255;
     SetCol(I, FR, FG, FB);
   End;
 End;

Procedure SetInten1(b : Byte);
 Var
   I : Integer;
   FR, FG, FB : Byte;
 Begin
   For I:=0 To 63 Do
   Begin
     FR:=Col[I].R*B Div 63;
     FG:=Col[I].G*B Div 63;
     FB:=Col[I].B*B Div 63;
     SetCol(I, FR, FG, FB);
   End;
 End;

Procedure FadeIn (X:Integer);
 Var
   Y:Integer;           (* Y is the LCV *)
 Begin
   For Y:=0 To 255 Do
     Begin
       SetInten(Y);
       Delay(X);
     End;
 End;

Procedure FadeOut (X:Integer);
 Var
   Y:Integer;    (* Y is the LCV *)
 Begin
   For Y:=0 To 255 Do
     GetCol(Y, Col[Y].R, Col[Y].G, Col[Y].B);
   For Y:=255 DownTo 0 Do
     Begin
       SetInten(Y);
       Delay(X);
     End;
 End;

Procedure FadeOut1 (X:Integer);
 Var
   Y:Integer;    (* Y is the LCV *)
 Begin
   For Y:=0 To 63 Do
     GetCol(Y, Col[Y].R, Col[Y].G, Col[Y].B);
   For Y:=63 DownTo 0 Do
     Begin
       SetInten1(Y);
       Delay(X);
     End;
 End;

Procedure Fadeout2(stage:Integer);
Var
	i 	: Byte;
	Tmp : RGB;
Begin
	Move(Pal1,Tmp,3);
	Move(Pal1[1],Pal1[0],765);
	Move(Tmp,Pal1[255],3);

	For i:=0 to 255 do
	Begin
		Pal2[i].R := Integer(Pal1[i].R * stage div 64);
		Pal2[i].G := Integer(Pal1[i].G * stage div 64);
		Pal2[i].B := Integer(Pal1[i].B * stage div 64);
	End;

	SetPal(Pal2);
End;

End.

