;; Matrix Rotations
;; Phred/OTM     aka Alex Chalfin
;; achalfin@uceng.uc.edu

.Model Large,Pascal

Jumps   ; Have TASM resolve any out of range jumps
.386    ; Enable 386 code

.Code 

Include sincos.dd   ; 512 degree 12 place fixed point sin/cos tables

 Cos_X dd ?
 Cos_Y dd ?
 Cos_Z dd ?
 Sin_X dd ?
 Sin_Y dd ?
 Sin_Z dd ?

 Matrix dd ?,?,?,?,?,?,?,?,?

Public InitRotationMatrix

Proc InitRotationMatrix Uses eax,Xan:Word,Yan:Word,Zan:Word

;  Matrix[0] := ((cz * cy) + ((sx * sz) Sar 12) * sy) Sar 12;
;  Matrix[1] := ((cy * -sz) + ((cz * sx) Sar 12) * sy) Sar 12;
;  Matrix[2] := (cx * sy) Sar 12;
;  Matrix[3] := (sz * cx) Sar 12;
;  Matrix[4] := (cz * cx) Sar 12;
;  Matrix[5] := (-sx);
;  Matrix[6] := ((-sy * cz) + ((sz * sx) Sar 12) * cy) Sar 12;
;  Matrix[7] := ((-sz * -sy) + ((cz * sx) Sar 12) * cy) Sar 12;
;  Matrix[8] := (cx * cy) Sar 12;

  Mov   bx,Xan  ; Set up XAngle variables
  Add   bx,bx
  Movsx eax,[CoSine + bx]
  Mov   Cos_X,eax
  Movsx eax,[Sine + bx]
  Mov   Sin_X,eax

  Mov   bx,Yan  ; Set up YAngle variables
  Add   bx,bx
  Movsx eax,[CoSine + bx]
  Mov   Cos_Y,eax
  Movsx eax,[Sine + bx]
  Mov   Sin_Y,eax

  Mov   bx,Zan ; Set up ZAngle variables
  Add   bx,bx
  Movsx eax,[CoSine + bx]
  Mov   Cos_Z,eax
  Movsx eax,[Sine + bx]
  Mov   Sin_Z,eax

; Calculate first index, Matrix[0]
  Mov  eax,Cos_Z
  Imul [Cos_Y]
  Mov  ebx,eax
  Mov  eax,Sin_X
  Imul [Sin_Z]
  Sar  eax,12
  Imul [Sin_Y]
  Add  eax,ebx
  Sar  eax,12
  Mov  [Matrix+0],eax

; Second index, Matrix[1]

  Mov  eax,Cos_Y
  Neg  eax
  Imul [Sin_Z]
  Mov  ebx,eax
  Mov  eax,Cos_Z
  Imul [Sin_X]
  Sar  eax,12
  Imul [Sin_Y]
  Add  eax,ebx
  Sar  eax,12
  Mov  [Matrix+4],eax

; Third index, Matrix[2]

  Mov  eax,Cos_X
  Imul [Sin_Y]
  Sar  eax,12
  Mov  [Matrix+8],eax

; fourth index, Matrix[3]

  Mov  eax,Sin_Z
  Imul [Cos_X]
  Sar  eax,12
  Mov  [Matrix+12],eax

; Matrix[4]

  Mov  eax,Cos_Z
  Imul [Cos_X]
  Sar  eax,12
  Mov  [Matrix+16],eax

; Matrix[5]

  Mov  eax,Sin_X
  Neg  eax
  Mov  [Matrix+20],eax

; Matrix[6]

  Mov  eax,Sin_Y
  Neg  eax
  Imul [Cos_Z]
  Mov  ebx,eax
  Mov  eax,Sin_Z
  Imul [Sin_X]
  Sar  eax,12
  Imul [Cos_Y]
  Add  eax,ebx
  Sar  eax,12
  Mov  [Matrix+24],eax

; Matrix[7]

  Mov  eax,Sin_Z
  Imul Sin_Y
  Mov  ebx,eax
  Mov  eax,Cos_Z
  Imul [Sin_X]
  Sar  eax,12
  Imul [Cos_Y]
  Add  eax,ebx
  Sar  eax,12
  Mov  [Matrix+28],eax

; Matrix[8]

  Mov  eax,Cos_X
  Imul [Cos_Y]
  Sar  eax,12
  Mov  [Matrix+32],eax
  Ret
EndP InitRotationMatrix

CalcX Macro
  Mov  ebx,fs:[si+0]
  Imul ebx,[Matrix+0]
  Mov  eax,fs:[si+4]
  Imul [Matrix+4]
  Add  ebx,eax
  Mov  eax,fs:[si+8]
  Imul [Matrix+8]
  Add  ebx,eax
  Sar  ebx,12
  Mov  es:[di],ebx
EndM

CalcY Macro
  Mov  ebx,fs:[si+0]
  Imul ebx,[Matrix+12]
  Mov  eax,fs:[si+4]
  Imul [Matrix+16]
  Add  ebx,eax
  Mov  eax,fs:[si+8]
  Imul [Matrix+20]
  Add  ebx,eax
  Sar  ebx,12
  Mov  es:[di+4],ebx
EndM

CalcZ Macro
  Mov  ebx,fs:[si+0]
  Imul ebx,[Matrix+24]
  Mov  eax,fs:[si+4]
  Imul [Matrix+28]
  Add  ebx,eax
  Mov  eax,fs:[si+8]
  Imul [Matrix+32]
  Add  ebx,eax
  Sar  ebx,12
  Mov  es:[di+8],ebx
EndM


;      WorldVert^[Count].x := (LocalVert^[Count].x * Matrix[0] +
;                              LocalVert^[Count].y * Matrix[3] +
;                              LocalVert^[Count].z * Matrix[6]) Sar 12;
;      WorldVert^[Count].y := (LocalVert^[Count].x * Matrix[1] +
;                              LocalVert^[Count].y * Matrix[4] +
;                              LocalVert^[Count].z * Matrix[7]) Sar 12;
;      WorldVert^[Count].z := (LocalVert^[Count].x * Matrix[2] +
;                              LocalVert^[Count].y * Matrix[5] +
;                              LocalVert^[Count].z * Matrix[8]) Sar 12;

Public Rotate

Proc Rotate Uses es fs si di,LocalCoords:DWord,WorldCoords:DWord,Num:Word,XT:DWord,YT:DWord,ZT:DWord
  Lfs  si,LocalCoords
  Les  di,WorldCoords
  Mov  cx,Num
  Jcxz @Exit
 @TransformLooper:
  CALCX    ; Calculate the x transformation
  CALCY    ; Calculate the y transformation
  CALCZ    ; Calculate the z transformation
  Mov  edx,XT
  Add  es:[di],edx
  Mov  edx,YT
  Add  es:[di+4],edx
  Mov  edx,ZT
  Add  es:[di+8],edx
  Add  si,12
  Add  di,12
  Inc  bx
  Dec  cx
  Jnz @TransformLooper
 @Exit:
  Ret
EndP Rotate
End
