;----------------------------------------------------------------------------
; TEDIUM.ASM - copyright (c) Scott McNab 94/95 (a.k.a jedi / oxygen)
;----------------------------------------------------------------------------
; This source is the code for the Tedium intro by Oxygen.
; The code not at all optimised but is useful as an example of programming a
; simple game which uses mode-x (320*240*256) graphics in pure 32-bit
; protected mode assembly.
; Some of the code is borrowed form various places which I can't remember
; since this was written almost a year ago now...
; This code requires pmode.obj (and file.obj) which is part of the PMODE
; header by Thomas Pytel (a.k.a Tran).
; The game data (fonts etc) is found in the tedium.dat file.
; You are free to use this code for whatever you want, just give me a word in
; the credits or greets :-)                          jedi@tartarus.uwa.edu.au
;----------------------------------------------------------------------------

		.386p
		jumps
		locals

;----------------------------------------------------------------------------
; Place all 16-bit code here

code16          segment para public use16
		assume cs:code16, ds:code16

code16          ends

;----------------------------------------------------------------------------
code32          segment para public use32
		assume cs:code32, ds:code32

		include pmode.inc
		include file.inc

		public _main

SETRASTERON     macro
		push ax dx
		mov dx,03c8h            ;raster trick on
		mov al,0
		out dx,al
		inc dx
		mov al,16
		out dx,al
		mov al,0
		out dx,al
		out dx,al
		pop dx ax
endm

SETRASTEROFF    macro
		push ax dx
		mov dx,03c8h            ;raster trick off
		mov al,0
		out dx,al
		inc dx
		out dx,al
		out dx,al
		out dx,al
		pop dx ax
endm

;----------------------------------------------------------------------------
; DATA
;----------------------------------------------------------------------------

pal_buffer      label byte
 DB 0,0,0,24,24,36,0,0,16,44,44,52,60,60,60,0,0,0,20,20,28,60,24,24,3,3,15,15
 DB 15,27,12,12,24,24,24,40,3,3,3,15,15,15,0,0,0,0,0,0,0,0,0,4,4,0,8,8,0,12,12
 DB 0,16,16,0,20,20,0,24,20,0,28,24,0,32,28,0,36,32,0,40,36,0,44,40,4,48,44,12
 DB 52,48,20,56,56,28,60,60,36,17,0,0,29,0,0,46,0,0,63,0,0,0,17,0,0,29,0,0,46
 DB 0,0,63,0,0,0,17,0,0,29,0,0,46,0,0,63,17,17,0,29,29,0,46,46,0,63,63,0,17,0
 DB 17,29,0,29,46,0,46,63,0,63,17,17,17,29,29,29,46,46,46,63,63,63,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DB 0,0,0

XMODE_STAT      label  word             ;320*200*256
	db      0e7h    ; dot clock
	db      02      ; Number of CRTC Registers to update
	dw      00014h  ; turn off dword mode
	dw      0e317h  ; turn on byte mode
	dw      320     ; width
	dw      200     ; height

SCREEN_HEIGHT   EQU     200
SCREEN_WIDTH    EQU     320

;Graphics adaptor port equates
MISC_OUTPUT     equ     03c2h   ;Miscellaneous Output register
SC_INDEX        equ     03c4h   ;Sequence Controller Index
CRTC_INDEX      equ     03d4h   ;CRT Controller Index
CRTC_OFFSET     equ     13h     ; CRTC offset register index
MAP_MASK        equ     02

filename        db      'tedium.dat',0

bitmap_buffer   dd      ?
title_buffer    dd      ?
current_frame   db      ?
anim_pause      db      1
catoffset       dd      ?
FontBuffer      dd      ?

asciitbl        db      10 DUP(0)       ;bin 2 dec conversion room
		db      255     ;end of ascii

;Random number values
Rand_k1         dw      9821
Rand_k2         dw      1
Rand_seed       dw      ?

SpeedVal        dw      ?

TopLeftX        dw      ?
TopLeftY        dw      ?
BaseColour      dw      ?

CATSPEED        equ     8

TETRIS_WIDTH    equ     10
TETRIS_HEIGHT   equ     25
CLEARSPEED      equ     4
SetCountY       dw      0       ;initial values
GapCount        db      1
TetrisMode      db      0
DrawScreenX     dw      0       ;prepare screen counters
DrawScreenY     dw      0

BOOSTWAIT       equ     10      ;number of rows before speed boost
STARTSPEED      equ     36      ;slowest
ENDSPEED        equ     1       ;fastest
GameSpeed       dw      STARTSPEED ;speed of game in FPS
GameCount       dw      STARTSPEED ;counter for current game
CurrentTile     dw      255     ;current tile type
CurrentAngle    dw      0       ;current tile rotation
NextTile        dw      255     ;next tile type

CurrentXPos     dw      0       ;X-pos in field
CurrentYPos     dw      0       ;Y-pos in field

LEFT            equ     1
RIGHT           equ     2
ROTATE          equ     4
Direction       db      0       ;movement direction

Xcount          db      ?
Ycount          db      ?
colour          db      ?
LineCounter     db      ?

GameMap         dd      ?       ;buffer for game map
BackMap         dd      ?       ;buffer for back map

BIGSTARTY       equ     3
BigBoxPtr       dd      offset BigBoxText
SkipCount       dw      ?
BigBoxX         dw      0
BigBoxY         dw      BIGSTARTY

CurrentScore    dd      ?       ;current game score
CurrentRows     dw      ?       ;number of completed rows
BoostCount      db      ?       ;wait until next speed boost in rows
TopScore        dd      ?       ;highest game score
TopRows         dw      ?       ;highest number of completed rows
AddValue        dd      ?       ;value to add for extra scores
ScoreFlag       db      ?       ;update flag
EndCounter      dw      ?       ;count for pause at end

FadeCounter     db      255     ;count for fade out at end of game

;block data:
Block0a         db      3,2     ;angle 0
		db      0,1,0
		db      1,1,1
Block0b         db      2,3     ;angle 1
		db      1,0
		db      1,1
		db      1,0
Block0c         db      3,2     ;angle 2
		db      1,1,1
		db      0,1,0
Block0d         db      2,3     ;angle 3
		db      0,1
		db      1,1
		db      0,1

Block1a         db      2,2     ;angle 0
		db      2,2
		db      2,2
Block1b         db      2,2     ;angle 1
		db      2,2
		db      2,2
Block1c         db      2,2     ;angle 2
		db      2,2
		db      2,2
Block1d         db      2,2     ;angle 3
		db      2,2
		db      2,2

Block2a         db      4,1     ;angle 0
		db      3,3,3,3
Block2b         db      1,4     ;angle 1
		db      3,3,3,3
Block2c         db      4,1     ;angle 2
		db      3,3,3,3
Block2d         db      1,4     ;angle 3
		db      3,3,3,3

Block3a         db      3,2     ;angle 0
		db      4,0,0
		db      4,4,4
Block3b         db      2,3     ;angle 1
		db      4,4
		db      4,0
		db      4,0
Block3c         db      3,2     ;angle 2
		db      4,4,4
		db      0,0,4
Block3d         db      2,3     ;angle 3
		db      0,4
		db      0,4
		db      4,4

Block4a         db      3,2     ;angle 0
		db      0,0,4
		db      4,4,4
Block4b         db      2,3     ;angle 1
		db      4,0
		db      4,0
		db      4,4
Block4c         db      3,2     ;angle 2
		db      4,4,4
		db      4,0,0
Block4d         db      2,3     ;angle 3
		db      4,4
		db      0,4
		db      0,4
Block5a         db      3,2   ;angle 0
		db      5,5,0
		db      0,5,5
Block5b         db      2,3   ;angle 1
		db      0,5
		db      5,5
		db      5,0
Block5c         db      3,2   ;angle 2
		db      5,5,0
		db      0,5,5
Block5d         db      2,3   ;angle 3
		db      0,5
		db      5,5
		db      5,0
Block6a         db      3,2   ;angle 0
		db      0,5,5
		db      5,5,0
Block6b         db      2,3   ;angle 1
		db      5,0
		db      5,5
		db      0,5
Block6c         db      3,2   ;angle 2
		db      0,5,5
		db      5,5,0
Block6d         db      2,3   ;angle 3
		db      5,0
		db      5,5
		db      0,5

BlockTable      dd      offset Block0a
		dd      offset Block0b
		dd      offset Block0c
		dd      offset Block0d
		dd      offset Block1a
		dd      offset Block1b
		dd      offset Block1c
		dd      offset Block1d
		dd      offset Block2a
		dd      offset Block2b
		dd      offset Block2c
		dd      offset Block2d
		dd      offset Block4a
		dd      offset Block4b
		dd      offset Block4c
		dd      offset Block4d
		dd      offset Block3a
		dd      offset Block3b
		dd      offset Block3c
		dd      offset Block3d
		dd      offset Block5a
		dd      offset Block5b
		dd      offset Block5c
		dd      offset Block5d
		dd      offset Block6a
		dd      offset Block6b
		dd      offset Block6c
		dd      offset Block6d

FilledTable     db      TETRIS_HEIGHT dup(?)

YourScoreT      db      254,24,14,20,17,254,18,2,14,17,4,254,36,255
FilledRowsT     db      5,8,11,11,4,3,254,17,14,22,18,254,36,255
TopScoreT       db      254,254,19,14,15,254,18,2,14,17,4,254,36,255
TopRowsT        db      254,254,254,12,0,23,254,17,14,22,18,254,36,255

BigBoxText      label byte
 DB 36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36
 DB 36,36,36,36,36,36,36,254,254,254,254,254,254,19,254,4,254,3,254,8,254,20
 DB 254,12,254,254,254,254,254,254,36,36,36,36,36,36,36,36,36,36,36,36,36,36
 DB 36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,254,0,13,254
 DB 14,23,24,6,4,13,254,19,7,0,13,6,254,8,13,254,34,29,254,36,36,36,36,36,36
 DB 36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36
 DB 36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36
 DB 36,36,36,36,36,254,254,254,254,254,254,254,254,254,254,254,18,20,12,12,0
 DB 17,24,254,254,254,254,254,254,254,254,254,254,254,36,36,36,36,36,36,36,36
 DB 36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,254,254,254
 DB 19,7,8,18,254,8,13,19,17,14,254,8,18,254,0,1,14,20,19,254,0,11,11,254,254
 DB 254,254,254,19,7,8,13,6,18,254,19,4,3,8,20,18,254,0,13,3,254,1,14,17,8,13
 DB 6,254,36,254,254,4,21,4,17,24,254,4,11,4,12,4,13,19,254,14,5,254,19,7,8,18
 DB 254,8,13,19,17,14,254,254,254,22,0,18,254,2,7,14,18,4,13,254,1,4,2,0,20,18
 DB 4,254,14,5,254,8,19,18,254,254,15,17,14,21,4,13,254,1,14,17,4,3,14,12,254
 DB 14,17,254,8,17,17,8,19,0,19,8,14,13,254,254,5,0,2,19,14,17,254,36,254,5,17
 DB 14,12,254,19,7,4,254,12,20,18,8,2,254,19,14,254,254,19,7,8,18,254,19,4,23
 DB 19,254,0,13,3,254,19,7,4,254,6,0,12,4,254,8,19,18,4,11,5,254,254,8,13,18
 DB 15,8,17,0,19,8,14,13,254,5,14,17,254,19,7,8,18,254,8,13,19,17,14,254,2,0
 DB 12,4,254,5,17,14,12,254,0,254,28,254,3,0,24,254,14,23,24,6,4,13,254,12,4
 DB 4,19,18,19,0,17,19,8,13,6,254,19,7,4,254,27,33,19,7,254,14,5,254,13,14,21
 DB 4,12,1,4,17,26,34,34,29,254,36,254,18,7,14,17,19,11,24,254,0,5,19,4,17,254
 DB 4,21,4,17,24,14,13,4,254,254,254,7,0,3,254,5,8,13,8,18,7,4,3,254,19,7,4,8
 DB 17,254,4,23,0,12,18,254,254,19,7,4,254,12,4,4,19,254,22,0,18,254,7,4,11,3
 DB 254,0,19,254,10,8,19,18,20,13,4,18,254,254,254,7,14,20,18,4,254,22,8,19,7
 DB 254,19,7,4,254,14,17,8,6,8,13,0,11,254,254,254,254,254,8,13,19,4,13,19,8
 DB 14,13,254,14,5,254,2,14,12,15,11,4,19,8,13,6,254,0,254,254,18,7,14,17,19
 DB 254,23,12,0,18,254,8,13,19,17,14,254,0,13,3,254,18,19,0,17,19,8,13,6,254
 DB 254,254,14,13,254,14,20,17,254,13,4,23,19,254,12,0,9,14,17,254,3,4,12,14
 DB 254,254,254,254,7,14,22,4,21,4,17,254,8,13,19,4,13,19,8,14,13,18,254,22,4
 DB 17,4,254,18,14,14,13,254,254,254,254,5,14,17,6,14,19,19,4,13,254,0,18,254
 DB 9,4,3,8,254,18,15,4,13,19,254,254,254,7,8,18,254,19,8,12,4,254,19,17,24,8
 DB 13,6,254,19,14,254,4,17,0,3,8,2,0,19,4,254,254,0,254,21,8,17,20,18,254,5
 DB 17,14,12,254,7,8,18,254,7,0,17,3,254,3,17,8,21,4,254,254,254,22,7,8,11,4
 DB 254,19,7,4,254,17,4,18,19,254,15,11,0,24,4,3,254,14,12,5,254,254,254,0,11
 DB 11,254,22,0,18,254,13,14,19,254,11,14,18,19,254,7,14,22,4,21,4,17,254,0,18
 DB 254,254,0,11,11,254,12,4,12,1,4,17,18,254,12,0,13,0,6,4,3,254,19,14,254,6
 DB 4,19,254,254,254,254,254,254,254,2,14,10,4,254,8,13,3,20,2,4,3,254,2,0,5
 DB 5,8,13,4,254,254,254,254,254,0,3,3,8,2,19,8,14,13,254,5,17,14,12,254,27,31
 DB 254,11,8,19,17,4,18,254,14,5,254,254,254,254,254,254,254,254,254,254,18,14
 DB 5,19,254,3,17,8,13,10,254,254,254,254,254,254,254,254,254,254,14,20,17,254
 DB 0,8,12,254,22,8,19,7,254,19,7,8,18,254,8,13,19,17,14,254,8,18,254,19,14,254
 DB 18,7,0,17,4,254,22,8,19,7,254,14,19,7,4,17,254,15,4,14,15,11,4,254,14,20
 DB 17,254,4,23,15,4,17,8,4,13,2,4,18,254,3,20,17,8,13,6,254,19,7,8,18,254,19
 DB 8,12,4,254,254,254,1,24,254,2,17,4,0,19,8,13,6,254,0,13,254,8,13,19,17,14
 DB 254,22,7,8,2,7,254,254,254,254,254,17,4,5,11,4,2,19,18,254,8,19,254,15,4
 DB 17,5,4,2,19,11,24,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,8,254,19,7,8,13,10,254,22
 DB 4,254,7,0,21,4,254,18,20,2,2,4,4,3,4,3,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,2,17,4,3,8,19
 DB 25,254,5,14,17,254,19,7,8,18,254,8,13,19,17,14,254,36,254,254,254,36,36,36
 DB 36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36
 DB 36,254,254,254,254,0,11,11,254,2,14,3,8,13,6,254,1,24,254,36,36,254,9,4,3
 DB 8,254,254,254,254,254,12,20,18,8,2,254,0,13,3,254,6,5,23,254,1,24,254,36
 DB 36,254,10,8,19,18,20,13,4,254,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36
 DB 36,36,36,36,36,36,36,36,36,36,36,36,36,36,19,7,8,18,254,19,4,23,19,254,22
 DB 0,18,254,22,17,8,19,19,4,13,254,1,24,254,9,4,3,8,254,254,1,4,2,0,20,18,4
 DB 254,18,19,0,19,8,23,254,2,14,20,11,3,13,19,254,1,4,254,254,254,254,254,1
 DB 14,19,7,4,17,4,3,254,22,17,8,19,8,13,6,254,14,13,4,254,0,13,3,254,254,254
 DB 254,10,8,19,18,20,13,4,18,254,22,0,18,254,19,14,14,254,4,23,2,8,19,8,13,6
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,8,5,254,24,14,20,254
 DB 13,4,4,3,254,8,13,18,19,17,20,2,19,8,14,13,18,254,14,13,254,254,7,14,22,254
 DB 19,14,254,15,11,0,24,254,19,7,4,254,6,0,12,4,254,14,13,254,19,7,4,254,17
 DB 8,6,7,19,254,19,7,4,13,254,24,14,20,254,18,7,14,20,11,3,254,1,4,254,18,7
 DB 14,19,254,36,254,8,5,254,24,14,20,254,3,14,13,19,254,10,13,14,22,254,19,7
 DB 4,254,10,4,24,18,254,254,254,254,254,254,254,19,7,4,13,254,22,14,17,10,254
 DB 19,7,4,12,254,14,20,19,254,254,36,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,11,14,14,10,18,254,11,8,10,4,254,19,7,8,13,6,18,254,0,17,4,254,6
 DB 4,19,19,8,13,6,19,14,14,254,4,23,2,8,19,8,13,6,254,36,254,22,4,254,7,0,3
 DB 254,1,4,19,19,4,17,254,254,254,254,2,20,19,254,19,14,254,19,7,4,254,6,17
 DB 4,4,19,25,254,19,7,4,13,254,36,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,9,4,3,8,254,6,17,4,4,19,18,254,36,254,2,24,6,13,4,19,254,12,0,3,10
 DB 0,15,254,254,254,19,7,4,254,3,20,3,4,254,5,14,17,2,4,254,5,14,17,12,0,19
 DB 254,19,17,20,6,254,254,254,254,18,19,0,17,18,2,17,4,0,12,254,0,13,3,254,14
 DB 19,7,4,17,254,8,17,2,254,254,254,0,3,3,8,2,19,18,254,36,254,22,4,18,19,254
 DB 14,25,254,3,20,3,4,18,254,0,13,3,254,254,254,254,0,11,11,254,15,20,17,4,254
 DB 0,18,18,4,12,1,11,24,254,2,14,3,4,17,18,254,254,6,17,4,4,19,18,254,5,17,14
 DB 12,254,18,19,0,19,8,23,254,19,14,254,36,254,5,14,17,2,4,5,14,17,12,0,19,254
 DB 12,0,4,11,2,20,12,254,2,7,20,2,10,254,1,8,18,2,20,8,19,18,254,254,254,1,11
 DB 0,2,10,254,0,17,19,8,18,19,254,14,19,19,14,254,2,7,17,14,13,18,254,254,13
 DB 4,2,17,14,18,254,0,13,3,254,9,20,18,18,8,254,11,0,7,3,4,13,13,8,4,12,8,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,10,8,19,18,20,13,4,254,6,17,4
 DB 4,19,18,254,36,254,15,18,24,2,7,4,254,19,7,4,254,254,3,20,3,4,254,23,36,2
 DB 4,11,11,254,36,254,0,11,11,254,15,4,17,19,7,13,4,19,254,254,3,20,3,4,18,254
 DB 36,254,3,24,13,0,12,8,10,254,7,20,19,2,7,14,254,1,4,13,254,3,254,254,254
 DB 0,13,3,254,0,11,11,254,0,12,1,8,4,13,19,254,12,20,18,8,2,8,0,13,18,254,254
 DB 36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36
 DB 36,36,36,36,19,7,8,18,254,8,13,19,17,14,254,22,0,18,254,2,14,3,4,3,254,8
 DB 13,254,0,1,14,20,19,254,27,254,3,0,24,18,254,18,19,17,4,19,2,7,4,3,254,14
 DB 20,19,254,14,21,4,17,254,27,254,254,254,22,4,4,10,18,254,2,14,20,17,19,4
 DB 18,24,254,14,5,254,12,24,254,13,4,22,254,254,254,254,254,8,13,19,4,17,13
 DB 4,19,254,0,2,2,14,20,13,19,254,0,13,3,254,4,21,4,13,254,254,254,254,254,254
 DB 254,13,4,22,4,17,254,27,33,10,33,254,5,0,23,12,14,3,4,12,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,11,14,14,10,254,14,20,19
 DB 254,5,14,17,254,5,20,19,20,17,4,254,14,23,24,6,4,13,254,254,254,254,17,4
 DB 11,4,0,18,4,18,254,22,7,4,13,4,21,4,17,254,14,20,17,254,8,17,2,254,254,254
 DB 254,254,254,254,254,254,2,11,8,4,13,19,254,8,18,254,3,14,22,13,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,20,13,19
 DB 8,11,254,19,7,4,13,254,12,0,10,4,254,19,7,4,254,12,14,18,19,254,14,5,254
 DB 254,24,14,20,17,254,1,14,17,4,3,14,12,254,0,13,3,254,17,4,12,4,12,1,4,17
 DB 254,36,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,19,7,4,254,19,4,3,8,20
 DB 18,254,19,7,8,13,6,18,254,8,13,254,11,8,5,4,254,0,17,4,254,254,254,254,254
 DB 254,254,254,14,5,19,4,13,254,19,7,4,254,1,4,18,19,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
 DB 254,254,254,254,254,254,254,254,254,254,254,254,254,255

EndText         label byte
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,'',15,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,'',15,'',15,0,0
	DB      0,0,'',15,'',15,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,'',15,'',15,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,'',15,'',15,'',15,0,0
	DB      '',15,'',15,'',15,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      '',15,'',15,'',15,'',15,'',15,0,0,0,0,'',15
	DB      '',15,'',15,'',15,'',15,'',15,'',15,0,0,'',15
	DB      '',15,'',15,'',15,'',15,'',15,'',15,'',15,0,0
	DB      '',15,'',15,'',15,0,0,'',15,'',15,'',15,0,0
	DB      0,0,'',15,'',15,'',15,0,0,'',15,'',15,'',15
	DB      '',15,'',15,'',15,'',15,'',15,'',15,'',15,'',15
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,'',1
	DB      '',1,'',1,'',1,'',1,'',1,'',1,'',1,0,0,'',15
	DB      '',15,'',15,0,0,0,0,0,0,0,0,'',15,'',15
	DB      '',15,'',15,'',15,'',15,'',15,0,0,'',15,'',15
	DB      '',15,0,0,0,0,'',15,'',15,'',15,0,0,'',15
	DB      '',15,'',15,0,0,'',15,'',15,'',15,0,0,0,0
	DB      '',15,'',15,'',15,0,0,'',15,'',15,'',15,0,0
	DB      0,0,'',15,'',15,0,0,0,0,'',15,'',15,0,0
	DB      '',1,'',1,'',1,'',1,'',1,'',1,'',1,'',1,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,'',4,'',4,0,0,'',15,'',15,''
	DB      15,0,0,0,0,'',15,0,0,'',15,'',15,'',15,0
	DB      0,0,0,'',15,'',15,0,0,'',15,'',15,'',15,0
	DB      0,0,0,'',15,'',15,'',15,0,0,'',15,'',15,''
	DB      15,0,0,'',15,'',15,'',15,0,0,0,0,'',15,''
	DB      15,'',15,0,0,'',15,'',15,'',15,0,0,0,0,''
	DB      15,'',15,0,0,0,0,'',15,'',15,0,0,'',4,''
	DB      4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,'',15,''
	DB      15,'',15,'',15,'',15,0,0,0,0,'',15,'',15,''
	DB      15,'',15,'',15,'',15,0,0,0,0,'',15,'',15,''
	DB      15,'',15,'',15,'',15,'',15,0,0,'',15,'',15,''
	DB      15,0,0,0,0,'',15,'',15,'',15,'',15,'',15,''
	DB      15,'',15,0,0,'',15,'',15,'',15,0,0,0,0,''
	DB      15,'',15,0,0,0,0,'',15,'',15,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,'',7,'',7,'-'
	DB      7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,''
	DB      7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,''
	DB      7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,''
	DB      7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,''
	DB      7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,''
	DB      7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,''
	DB      7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,''
	DB      7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,''
	DB      7,'',7,'-',7,'-',7,'',7,'',7,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,'a',7,0,0,'w',7,'e',7,'e',7,'k',7,'e',7,'n',7,'d'
	DB      7,0,0,'i',7,'n',7,'t',7,'r',7,'o',7,0,0,'a',7,'b'
	DB      7,'o',7,'u',7,'t',7,0,0,'b',7,'o',7,'r',7,'e',7,'d'
	DB      7,'o',7,'m',7,0,0,'b',7,'y',7,0,0,'o',7,'x',7,'y'
	DB      7,'g',7,'e',7,'n',7,'.',7,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,'-',4,'-',4,'=',4,0,0,'h',12,'o'
	DB      12,'w',12,0,0,'t',12,'o',12,0,0,'c',12,'o',12,'n'
	DB      12,'t',12,'a',12,'c',12,'t',12,0,0,'u',12,'s',12,0
	DB      0,'=',4,'-',4,'-',4,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      'i',14,'f',14,0,0,'y',14,'o',14,'u',14,0,0,'h',14
	DB      'a',14,'v',14,'e',14,0,0,'i',14,'n',14,'t',14,'e',14
	DB      'r',14,'n',14,'e',14,'t',14,0,0,'a',14,'c',14,'c',14
	DB      'e',14,'s',14,'s',14,',',14,0,0,'m',14,'a',14,'i',14
	DB      'l',14,0,0,'u',14,'s',14,0,0,'a',14,'t',14,':',14
	DB      0,0,0,0,0,0,0,0,0,0,0,0,'c',14,'a',14
	DB      'l',14,'l',14,0,0,'o',14,'u',14,'r',14,0,0,'W',14
	DB      'H',14,'Q',14,',',14,0,0,'A',14,'b',14,'s',14,'o',14
	DB      'l',14,'u',14,'t',14,'e',14,0,0,'Z',14,'e',14,'r',14
	DB      'o',14,0,0,'B',14,'B',14,'S',14,':',14,0,0,0,0
	DB      0,0,0,0,0,0,0,0,'j',9,'e',9,'d',9,'i',9,':'
	DB      9,0,0,'j',10,'e',10,'d',10,'i',10,'@',10,'o',10,'m'
	DB      10,'e',10,'n',10,'.',10,'c',10,'o',10,'m',10,'.',10,'a'
	DB      10,'u',10,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,'+',10,'6',10,'1',10,'-',10,'9'
	DB      10,'-',10,'2',10,'4',10,'6',10,'-',10,'1',10,'1',10,'0'
	DB      10,'7',10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,'s'
	DB      9,'t',9,'a',9,'t',9,'i',9,'x',9,':',9,0,0,'k',10,'i'
	DB      10,'m',10,'b',10,'a',10,'@',10,'i',10,'t',10,'.',10,'c'
	DB      10,'o',10,'m',10,'.',10,'a',10,'u',10,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,'-',9,'O',9,'R',9,'-',9
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,'m',9,'a',9,'n',9,'t',9,'i',9,'s',9,'s',9,'a'
	DB      9,':',9,0,0,'s',10,'j',10,'m',10,'@',10,'i',10,'t'
	DB      10,'.',10,'c',10,'o',10,'m',10,'.',10,'a',10,'u',10,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,'y',14,'o'
	DB      14,'u',14,0,0,'c',14,'a',14,'n',14,0,0,'f',14,'i'
	DB      14,'n',14,'d',14,0,0,'s',14,'n',14,'a',14,'i',14,'l'
	DB      14,'m',14,'a',14,'i',14,'l',14,0,0,'a',14,'d',14,'d'
	DB      14,'r',14,'e',14,'s',14,'s',14,'e',14,'s',14,0,0,0
	DB      0,0,0,0,0,0,0,'t',9,'r',9,'a',9,'s',9,'h',9
	DB      ':',9,0,0,'j',10,'l',10,'c',10,'h',10,'o',10,'n',10
	DB      'g',10,'@',10,'t',10,'a',10,'r',10,'t',10,'a',10,'r',10
	DB      'u',10,'s',10,'.',10,'u',10,'w',10,'a',10,'.',10,'e',10
	DB      'd',10,'u',10,'.',10,'a',10,'u',10,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,'a',14,'n',14
	DB      'd',14,0,0,'m',14,'o',14,'r',14,'e',14,0,0,'i',14
	DB      'n',14,'f',14,'o',14,0,0,'i',14,'n',14,0,0,'t',14
	DB      'h',14,'e',14,0,0,'f',14,'i',14,'l',14,'e',14,':',14
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,'k',9,'i',9,'t',9,'s',9,'u',9,'n',9,'e',9,':',9
	DB      0,0,'u',10,'a',10,'.',10,'g',10,'r',10,'o',10,'.',10
	DB      'y',10,'g',10,'o',10,'l',10,'o',10,'h',10,'c',10,'y',10
	DB      's',10,'p',10,'.',10,'e',10,'s',10,'r',10,'e',10,'v',10
	DB      'e',10,'r',10,'@',10,'e',10,'n',10,'u',10,'s',10,'t',10
	DB      'i',10,'k',10,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,'t',10,'e',10
	DB      'd',10,'i',10,'u',10,'m',10,'.',10,'d',10,'o',10,'c',10
	DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB      0,0,0,0,0,0,0,0,0,0,0,0,'',7,'',7
	DB      '-',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7
	DB      '',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7
	DB      '',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7
	DB      '',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7
	DB      '',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7
	DB      '',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7
	DB      '',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7
	DB      '',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7,'',7
	DB      '',7,'',7,'-',7,'',7,'',7,'',7

;----------------------------------------------------------------------------
; CODE
;----------------------------------------------------------------------------
_main:          sti

		mov ax,_filebuflen              ;First allocate file buffer
		movsx eax,ax
		call _getlomem
		jnc initfine
		jmp _exit
initfine:       mov [_filebufloc],eax

		call Seed_Random

		call SetGFXMode

		call LoadBitmap
		call _closefile

		call MainRoutine

		mov [v86r_ax],3                 ;reset textmode
		mov al,10h
		int 33h

		@rlp edi,0b8000h                ;draw text screen at end
		mov esi,offset EndText
		mov ecx,80*18/2
		rep movsd
		mov [v86r_ax],0200h             ;Set cursor pos
		mov [v86r_dx],1200h
		mov [v86r_bx],0
		mov al,10h
		int 33h
		jmp _exit

;----------------------------------------------------------------------------
MainRoutine     proc near               ;do it...
		call VWait
		mov esi,offset pal_buffer ;set palette
		xor ah,ah
		call SetPalette

		call StartBit

		mov [anim_pause],1
		mov [catoffset],64*SCREEN_WIDTH/4

@@loopagain2:   mov ebp,[bitmap_buffer] ;animation loop
@@loopagain:    call VWait
		;SETRASTERON

		cmp [catoffset],0
		jz @@okey
		call PasteBitmap        ;update video routines
		sub [catoffset],SCREEN_WIDTH/4
@@okey:         dec [anim_pause]
		jnz @@nopaste

		mov [anim_pause],CATSPEED
		cmp [catoffset],0
		jnz @@noputit
		call PasteBitmap        ;update video routines
@@noputit:      add ebp,76*64
		inc [current_frame]
		cmp [current_frame],12
		jb @@nopaste
		mov [current_frame],0
		mov ebp,[bitmap_buffer]

@@nopaste:      call CreateScreen
		call HandleTetris
		call UpdateTexts
		call ShowScores
		;SETRASTEROFF

		cmp [FadeCounter],255   ;handle fading stuff
		jz @notending
		dec [FadeCounter]
		jz @leavehere
		mov ah,128
		sub ah,[FadeCounter]
		shr ah,1
		mov esi,offset pal_buffer
		call SetPalette         ;fade screen

@notending:     call ChekForKey         ;other routines
		jnc @@loopagain

		mov [v86r_ax],0         ;process keypress
		mov ax,16h
		int 33h
		mov ax,[v86r_ax]
		cmp al,27               ;check for ESC
		jz @@donehere

		cmp ah,50h              ;al,'2'
		jnz @notspace
		mov [GameCount],1
@notspace:      cmp ah,4bh              ;al,'4'
		jnz @notleft
		or [Direction],LEFT
@notleft:       cmp ah,4dh              ;al,'6'
		jnz @notright
		or [Direction],RIGHT
@notright:      cmp ah,4ch              ;al,'5'
		jnz @chekentr
		or [Direction],ROTATE

@chekentr:      cmp ah,48h
		jnz @@loopagain
		or [Direction],ROTATE

		jmp @@loopagain
@@donehere:     cmp [FadeCounter],255
		jnz @@loopagain
		mov [FadeCounter],128
		jmp @@loopagain
@leavehere:     ret
MainRoutine     endp

;----------------------------------------------------------------------------
ShowScores      proc near       ;display scores
		cmp [TetrisMode],3
		ja @abortit
		cmp [TetrisMode],2
		jnb @goahead
@abortit:       ret
@goahead:       cmp [ScoreFlag],0
		jz @abortit

		mov [ScoreFlag],0
		mov eax,[CurrentScore]          ;show current score
		call Bin2Dec
		mov esi,offset asciitbl
		mov byte ptr [esi+8],255
		inc esi
		mov dx,136
		mov cx,168+8
		call DrawDigits

		xor eax,eax                     ;current row number
		mov ax,[CurrentRows]
		call Bin2Dec
		mov esi,offset asciitbl
		mov byte ptr [esi+8],255
		inc esi
		mov dx,136+16
		mov cx,168+8
		call DrawDigits

		mov eax,[TopScore]              ;show highest score
		cmp [CurrentScore],eax
		jb @scorelower
		mov eax,[CurrentScore]
		mov [TopScore],eax
@scorelower:    call Bin2Dec
		mov esi,offset asciitbl
		mov byte ptr [esi+8],255
		inc esi
		mov dx,136+16*2
		mov cx,168+8
		call DrawDigits

		xor eax,eax                     ;top row number
		mov ax,[TopRows]
		cmp [CurrentRows],ax
		jb @rowslower
		mov ax,[CurrentRows]
		mov [TopRows],ax
@rowslower:     call Bin2Dec
		mov esi,offset asciitbl
		mov byte ptr [esi+8],255
		inc esi
		mov dx,136+16*3
		mov cx,168+8
		call DrawDigits

		ret
ShowScores      endp

;----------------------------------------------------------------------------
DrawDigits      proc near       ;draw 8 digits in asciitbl
@nextdigit:     xor eax,eax
		mov al,[esi]
		inc esi
		cmp al,255
		jz @shownscore
		cmp al,'0'
		jnz @notzero
		mov al,'9'+1
		jmp short @notspce2
@notzero:       cmp al,' '
		jnz @notspce
		mov al,'9'+1         ;38-(26-'1')
		jmp short @notspce2
@notspce:       cmp al,0
		jnz @notspce2
		mov al,38
@notspce2:      add ax,26-'1'
		add eax,eax
		push esi cx dx
		call DrawLetter ;dx=y pos, cx=x pos, eax=char
		pop dx cx esi
		add cx,8
		jmp @nextdigit
@shownscore:    ret
DrawDigits      endp

;----------------------------------------------------------------------------
UpdateTexts     proc near       ;handle all texts
		cmp [SkipCount],0
		jz @processit
		dec [SkipCount]
		ret
@processit:     mov [SkipCount],1
		xor eax,eax
@tryitagain:    mov esi,[BigBoxPtr]
		mov al,[esi]
		inc [BigBoxPtr]
		cmp al,255
		jnz @nofixtxt
		mov [BigBoxPtr],offset BigBoxText
		jmp @tryitagain
@nofixtxt:
		;dx=y pos, cx=x pos, eax=char
		cmp al,254
		jnz @nospace
		mov al,38
@nospace:       add eax,eax
		mov dx,[BigBoxY]
		shl dx,4
		sub dx,4
		mov cx,[BigBoxX]
		shl cx,3
		call DrawLetter
		inc [BigBoxX]
		cmp [BigBoxX],29
		jb @finexcoords
		mov [BigBoxX],0
		inc [BigBoxY]
@finexcoords:   cmp [BigBoxY],BIGSTARTY+5
		jb @finished
		mov [BigBoxY],BIGSTARTY
		mov [BigBoxX],0
		mov [SkipCount],72*6
@finished:      ret
UpdateTexts     endp

;----------------------------------------------------------------------------
HandleTetris    proc near
		cmp [TetrisMode],0
		jnz @@checkmode1

		dec [GapCount]
		jnz @@checkmode1
		mov [GapCount],CLEARSPEED
		mov ax,TETRIS_WIDTH             ;mode 1 = fill game
		mov dx,5
		mov bx,[SetCountY]
		mov cx,40-TETRIS_WIDTH
@@setloop:      push ax bx cx dx
		call PutBlock
		pop dx cx bx ax
		inc cx
		dec ax
		jnz @@setloop
		inc [SetCountY]
		cmp [SetCountY],TETRIS_HEIGHT
		jb @@checkmode1
		mov [TetrisMode],1
		mov [SetCountY],0

@@checkmode1:   cmp [TetrisMode],1
		jnz @@checkmode2
		dec [GapCount]
		jnz @@checkmode2
		mov [GapCount],CLEARSPEED
		mov ax,TETRIS_WIDTH             ;mode 2 = clear game
		xor dx,dx
		mov bx,[SetCountY]
		mov cx,40-TETRIS_WIDTH
@@setloop1:     push ax bx cx dx
		call ClearBlock
		pop dx cx bx ax
		inc cx
		dec ax
		jnz @@setloop1
		inc [SetCountY]
		cmp [SetCountY],TETRIS_HEIGHT
		jb @@checkmode2
		mov [TetrisMode],2
		mov [SetCountY],0

		call DrawScoreTxt

		mov [CurrentScore],0            ;set up game vars
		mov [CurrentRows],0
		mov [BoostCount],BOOSTWAIT
		mov [GameSpeed],STARTSPEED
		mov [ScoreFlag],1

		call FindNextTile
		mov ax,[NextTile]
		mov [CurrentTile],ax
		mov [CurrentXPos],TETRIS_WIDTH/2-1
		mov [CurrentYPos],0
		mov [CurrentAngle],0
		call FindNextTile

	;--------------------------------------
@@checkmode2:   cmp [TetrisMode],2      ;actual game code is here
		jnz @@checkmode3
		call ShowNextTile
		cmp [Direction],0
		jz @move

		test [Direction],ROTATE
		jz @chekleft
		and [Direction],not ROTATE
		push [CurrentAngle]
		inc [CurrentAngle]
		cmp [CurrentAngle],4
		jb @nooverflo
		mov [CurrentAngle],0
@nooverflo:     call CheckValidPos
		pop ax
		jnc @tisok1
		mov [CurrentAngle],ax
@tisok1:        call PlotNewPos

@chekleft:      test [Direction],LEFT
		jz @chekright
		and [Direction],not LEFT
		push [CurrentXPos]
		dec [CurrentXPos]
		call CheckValidPos
		pop ax
		jnc @tisok2
		mov [CurrentXPos],ax
@tisok2:        call PlotNewPos

@chekright:     test [Direction],RIGHT
		jz @move
		and [Direction],not RIGHT
		push [CurrentXPos]
		inc [CurrentXPos]
		call CheckValidPos
		pop ax
		jnc @tisok3
		mov [CurrentXPos],ax
@tisok3:        call PlotNewPos

@move:          mov [Direction],0
		dec [GameCount]
		jnz @@finmove
		mov ax,[GameSpeed]
		mov [GameCount],ax
		call SlideBlocks
		call UpdateMap
		call CheckForEnd
@@finmove:
	;--------------------------------------
@@checkmode3:   cmp [TetrisMode],3      ;code for lines completed
		jnz @@checkmode4
		call HandleFullLines
@@checkmode4:   cmp [TetrisMode],4      ;end of game code
		jnz @@checkmode5
		dec [EndCounter]
		jnz @@checkmode5
		mov [TetrisMode],0
		mov edi,[BackMap]
		mov ecx,TETRIS_WIDTH*TETRIS_HEIGHT
		mov al,0
		rep stosb

		;blank scorebox
		mov dx,SC_INDEX
		mov ax,0f02h
		out dx,ax
		@rlp edi,0a0000h+(136*(SCREEN_WIDTH/4))+76/4+1
		mov al,10
		mov bx,64
@clritlp:       mov ecx,38
		rep stosb
		add edi,(SCREEN_WIDTH/4)-38
		dec bx
		jnz @clritlp

@@checkmode5:   ret
HandleTetris    endp

;----------------------------------------------------------------------------
CheckForEnd     proc near       ;see if game is to end
		mov esi,[BackMap]
		mov cx,TETRIS_WIDTH
@nextblk:       cmp byte ptr [esi],0
		jnz @endgame
		inc esi
		dec cx
		jnz @nextblk
		ret
		;found the end of the game
@endgame:       mov [TetrisMode],4
		mov esi,[BackMap]
		mov cx,TETRIS_WIDTH*TETRIS_HEIGHT

@noew:          cmp byte ptr [esi],0
		jz @ablank
		mov byte ptr [esi],6
@ablank:        inc esi
		dec cx
		jnz @noew
		mov esi,[BackMap]               ;make blocks grey
		mov edi,[GameMap]
		mov ecx,TETRIS_HEIGHT*TETRIS_WIDTH
		rep movsb
		call UpdateMap
		mov [EndCounter],72*4
		ret
CheckForEnd     endp

;----------------------------------------------------------------------------
DrawScoreTxt    proc near       ;draw the score texts
		mov esi,offset YourScoreT
		mov dx,136
		mov cx,80
		call DrawALine
		mov esi,offset FilledRowsT
		mov dx,136+16
		mov cx,80
		call DrawALine
		mov esi,offset TopScoreT
		mov dx,136+16*2
		mov cx,80
		call DrawALine
		mov esi,offset TopRowsT
		mov dx,136+16*3
		mov cx,80
		call DrawALine
		ret
DrawScoreTxt    endp

;----------------------------------------------------------------------------
DrawALine       proc near
@nextone:       xor eax,eax
		mov al,[esi]
		inc esi
		cmp al,255
		jz @gonehere
		cmp al,254
		jnz @notaspce
		mov al,38
@notaspce:      add eax,eax
		push esi cx dx
		call DrawLetter
		pop dx cx esi
		add cx,8
		jmp @nextone
@gonehere:      ret
DrawALine       endp

;----------------------------------------------------------------------------
HandleFullLines proc near
		cmp [LineCounter],0
		jz @fillines
		cmp [LineCounter],72
		jz @clearlines
		inc [LineCounter]
		ret

@fillines:      ;make line grey
		mov esi,offset FilledTable
		mov bx,TETRIS_HEIGHT
		mov edi,[BackMap]
@fillloop:      cmp byte ptr [esi],0    ;make line filled
		jz @incloop1
		mov ecx,TETRIS_WIDTH

		mov ax,TETRIS_HEIGHT
		sub ax,bx
		mul cx

		movzx eax,ax
		add edi,eax
		mov al,6
		rep stosb
		mov edi,[BackMap]
@incloop1:      inc esi
		dec bx
		jnz @fillloop
		inc [LineCounter]

		mov esi,[BackMap]
		mov edi,[GameMap]
		mov ecx,TETRIS_HEIGHT*TETRIS_WIDTH
		rep movsb
		call UpdateMap
		ret

@clearlines:    ;clear line - shift blocks down to cover spaces
		mov [TetrisMode],2

		mov [AddValue],10

		mov esi,(offset FilledTable)+TETRIS_HEIGHT-1
		mov bx,TETRIS_HEIGHT
@yewnow:        cmp byte ptr [esi],0
		jz @nowaye
		mov ecx,[AddValue]

		add [CurrentScore],ecx          ;fix scores and inc
		shl [AddValue],1
		inc [ScoreFlag]

		inc [CurrentRows]               ;  speed if needed
		dec [BoostCount]
		jnz @noincspd
		mov [BoostCount],BOOSTWAIT
		dec [GameSpeed]
		jnz @noincspd
		inc [GameSpeed]
@noincspd:      call ShiftRows
		;shift table
		push esi
@@slidetab:     mov al,[esi-1]
		mov [esi],al
		dec esi
		cmp esi,offset FilledTable
		ja @@slidetab
		pop esi
		jmp @yewnow
@nowaye:        dec esi
		dec bx
		jnz @yewnow

		mov esi,[BackMap]
		mov edi,[GameMap]
		mov ecx,TETRIS_HEIGHT*TETRIS_WIDTH
		rep movsb
		call UpdateMap
		ret
HandleFullLines endp

;----------------------------------------------------------------------------
ShiftRows       proc near       ;shift all rows up to BX
		push bx
		dec bx
		mov edi,[BackMap]
		mov eax,TETRIS_WIDTH
		mul bx
		add eax,TETRIS_WIDTH-1
		add edi,eax
		mov cx,ax
		sub cx,TETRIS_WIDTH
@shft:          mov al,[edi-TETRIS_WIDTH]
		mov [edi],al
		dec edi
		dec cx
		jnz @shft
		pop bx
		ret
ShiftRows       endp

;----------------------------------------------------------------------------
CheckValidPos   proc near       ;determine if current pos is clear for block
				;CF=set if invalid
		mov edi,[BackMap]
		movzx eax,[CurrentTile]         ;calc block ptr
		cmp al,255
		je @@abort3
		shl eax,2
		add ax,[CurrentAngle]
		mov esi,[BlockTable+eax*4]
		xor ax,ax
		mov al,[esi]
		mov [Xcount],al
		inc esi
		mov al,[esi]
		mov [Ycount],al         ;esi=ptr to start of block defn
		inc esi

		mov bx,TETRIS_WIDTH     ;calc map offset
		mov ax,[CurrentYPos]
		sub al,[Ycount]
		inc al
		mul bx
		add ax,[CurrentXPos]
		xor cx,cx              ;check for region
		mov cl,[Xcount]
		cmp [CurrentXPos],0
		jl @@abort3
		add cx,[CurrentXPos]
		cmp cx,TETRIS_WIDTH
		ja @@abort3
		movzx eax,ax
		add edi,eax

		mov dl,[Xcount]
		mov cl,[Ycount]

@hereitis3:     mov al,[esi]
		or al,al
		jz @yeah3
		cmp byte ptr [edi],0
		jz @yeah3
		jmp @@abort3
@yeah3:         inc edi
		inc esi
		dec dl
		jnz @hereitis3
		mov dl,[Xcount]
		mov al,TETRIS_WIDTH
		sub al,dl
		movzx eax,ax
		add edi,eax
		dec cl
		jnz @hereitis3
		clc
		ret
@@abort3:       stc
		ret
CheckValidPos   endp

;----------------------------------------------------------------------------
PlotNewPos      proc near       ;draw tile on map
		mov esi,[BackMap]
		mov edi,[GameMap]
		mov ecx,TETRIS_HEIGHT*TETRIS_WIDTH
		rep movsb

		mov edi,[GameMap]
@pastehere:     movzx eax,[CurrentTile]         ;calc block ptr
		cmp al,255
		je @@abort2
		shl eax,2
		add ax,[CurrentAngle]
		mov esi,[BlockTable+eax*4]
		xor ax,ax
		mov al,[esi]
		mov [Xcount],al
		inc esi
		mov al,[esi]
		mov [Ycount],al         ;esi=ptr to start of block defn
		inc esi

		mov bx,TETRIS_WIDTH     ;calc map offset
		mov ax,[CurrentYPos]
		sub al,[Ycount]
		inc al
		mul bx
		add ax,[CurrentXPos]
		movzx eax,ax
		add edi,eax

		mov dl,[Xcount]
		mov cl,[Ycount]

@hereitis2:     mov al,[esi]
		or al,al
		jz @yeah2
		mov [edi],al
@yeah2:         inc edi
		inc esi
		dec dl
		jnz @hereitis2
		mov dl,[Xcount]
		mov al,TETRIS_WIDTH
		sub al,dl
		movzx eax,ax
		add edi,eax
		dec cl
		jnz @hereitis2

		call UpdateMap
@@abort2:       ret
PlotNewPos      endp

MakePermanent   proc near       ;make block permanent on back map
		mov edi,[BackMap]
		call @pastehere
		ret
MakePermanent   endp

;----------------------------------------------------------------------------
SlideBlocks     proc near       ;slide current block down
		push [CurrentYPos]
		inc [CurrentYPos]
		call CheckValidPos
		pop ax
		jnc @fine
		mov [CurrentYPos],ax
		call MakePermanent

		inc [CurrentScore]
		inc [ScoreFlag]

		mov ax,[NextTile]
		mov [CurrentTile],ax
		mov [CurrentXPos],TETRIS_WIDTH/2-1
		mov [CurrentAngle],0

		movzx eax,ax
		mov esi,[BlockTable+eax*4]     ;set ptr to block data
		xor eax,eax
		mov al,[esi+1]
		dec ax
		mov [CurrentYPos],ax

		call FindNextTile
		call CheckValidPos
		jnc @fine
		jmp @endgame

@fine:          call CheckForRows
		call PlotNewPos
		ret
SlideBlocks     endp

;----------------------------------------------------------------------------
CheckForRows    proc near               ;check for filled rows
		mov edi,offset FilledTable      ;clear table first
		mov ecx,TETRIS_HEIGHT
		mov al,0
		rep stosb

		mov esi,[BackMap]
		mov bx,TETRIS_HEIGHT
		xor eax,eax
		mov ecx,eax
@trynow2:       mov cx,TETRIS_WIDTH
		mov al,0
@addloop:       cmp byte ptr [esi],0
		jz @nope
		inc esi
		dec cx
		jnz @addloop
		;found a full line
		mov ax,TETRIS_HEIGHT
		sub ax,bx
		mov [FilledTable+eax],1
		mov [TetrisMode],3
		mov [LineCounter],0
@nope:          add esi,ecx
		dec bx
		jnz @trynow2
		ret
CheckForRows    endp

;----------------------------------------------------------------------------
ShowNextTile    proc near               ;display the next tile
		mov ax,[NextTile]
		cmp al,6
		jbe @notnone
		ret
@notnone:       call ClrTileBox
		mov ax,[NextTile]
		cmp al,0                ;type 1
		jnz @check1

		mov dx,0
		mov cx,(40-TETRIS_WIDTH-4)*2+1
		mov bx,3
		push bx cx dx
		call PutBlock2
		pop dx cx bx
		sub cx,2
		add bx,2
		push bx cx dx
		call PutBlock2
		pop dx cx bx
		add cx,2
		push bx cx dx
		call PutBlock2
		pop dx cx bx
		add cx,2
		call PutBlock2
		jmp @none

@check1:        cmp al,1                ;type 2
		jnz @check2
		mov dx,1
		mov cx,(40-TETRIS_WIDTH-4)*2
		mov bx,3
		push bx cx dx
		call PutBlock2
		pop dx cx bx
		add cx,2
		push bx cx dx
		call PutBlock2
		pop dx cx bx
		add bx,2
		push bx cx dx
		call PutBlock2
		pop dx cx bx
		sub cx,2
		call PutBlock2
		jmp @none

@check2:        cmp al,2                ;type 3
		jnz @check3
		mov dx,2
		mov cx,(40-TETRIS_WIDTH-5)*2
		mov bx,4
		push bx cx dx
		call PutBlock2
		pop dx cx bx
		add cx,2
		push bx cx dx
		call PutBlock2
		pop dx cx bx
		add cx,2
		push bx cx dx
		call PutBlock2
		pop dx cx bx
		add cx,2
		call PutBlock2
		jmp @none

@check3:        cmp al,3                ;type 4
		jnz @check4
		mov dx,3
		mov cx,(40-TETRIS_WIDTH-5)*2+1
		mov bx,5
		push bx cx dx
		call PutBlock2
		pop dx cx bx
		add cx,2
		push bx cx dx
		call PutBlock2
		pop dx cx bx
		add cx,2
		push bx cx dx
		call PutBlock2
		pop dx cx bx
		sub bx,2
		call PutBlock2
		jmp @none

@check4:        cmp al,4                ;type 5
		jnz @check5
		mov dx,3
		mov cx,(40-TETRIS_WIDTH-5)*2+1
		mov bx,3
		call PutBlock2
		mov dx,3
		mov cx,(40-TETRIS_WIDTH-5)*2+1+2
		mov bx,3
		call PutBlock2
		mov dx,3
		mov cx,(40-TETRIS_WIDTH-5)*2+1+4
		mov bx,3
		call PutBlock2
		mov dx,3
		mov cx,(40-TETRIS_WIDTH-5)*2+1+4
		mov bx,5
		call PutBlock2
		jmp @none

@check5:        cmp al,5                ;type 6
		jnz @check6
		mov dx,4
		mov cx,(40-TETRIS_WIDTH-5)*2+1
		mov bx,3
		call PutBlock2
		mov dx,4
		mov cx,(40-TETRIS_WIDTH-5)*2+1+2
		mov bx,3
		call PutBlock2
		mov dx,4
		mov cx,(40-TETRIS_WIDTH-5)*2+1+2
		mov bx,5
		call PutBlock2
		mov dx,4
		mov cx,(40-TETRIS_WIDTH-5)*2+1+4
		mov bx,5
		call PutBlock2
		jmp @none
@check6:        cmp al,6                ;type 7
		jnz @none
		mov dx,4
		mov cx,(40-TETRIS_WIDTH-5)*2+1
		mov bx,5
		call PutBlock2
		mov dx,4
		mov cx,(40-TETRIS_WIDTH-5)*2+1+2
		mov bx,5
		call PutBlock2
		mov dx,4
		mov cx,(40-TETRIS_WIDTH-5)*2+1+2
		mov bx,3
		call PutBlock2
		mov dx,4
		mov cx,(40-TETRIS_WIDTH-5)*2+1+4
		mov bx,3
		call PutBlock2
@none:          ret

ClrTileBox:     mov ax,12               ;clear tile box
		mov bx,1
		mov cx,40-TETRIS_WIDTH-5
@clrlp:         push ax bx cx
		mov dl,0
		call ClearBlock
		pop cx bx ax
		dec ax
		jz @fin
		inc cx
		cmp cx,40-TETRIS_WIDTH-1
		jb @clrlp
		mov cx,40-TETRIS_WIDTH-5
		inc bx
		jmp @clrlp
@fin:           ret
ShowNextTile    endp

;----------------------------------------------------------------------------
FindNextTile    proc near               ;get random tile
@gtlp:          call Get_Random
		shr ax,13
		cmp al,6
		ja @gtlp
		mov ah,0
		mov [NextTile],ax
		ret
FindNextTile    endp

;----------------------------------------------------------------------------
UpdateMap       proc near       ;update tetris screen
		mov esi,[GameMap]
		mov bx,0                ;Y
		mov cx,40-TETRIS_WIDTH  ;X
		mov ax,TETRIS_WIDTH*TETRIS_HEIGHT

		;looppoint
@looppt:        push ax bx cx
		mov dl,[esi]
		dec dl
		cmp dl,5
		ja @blank
		call PutBlock
		jmp short @count
@blank:         mov dl,0
		call ClearBlock
@count:         pop cx bx ax
		inc esi
		dec ax
		jz @@done
		inc cx
		cmp cx,40
		jb @looppt
		inc bx
		mov cx,40-TETRIS_WIDTH
		jmp @looppt
@@done:         ret
UpdateMap       endp

;----------------------------------------------------------------------------
CreateScreen    proc near       ;draw screen in background
		cmp [DrawScreenX],40-TETRIS_WIDTH-1
		jae @tryY
		mov dx,5
		mov cx,[DrawScreenX]
		mov bx,4
		call PutBlock
		mov dx,5
		mov cx,[DrawScreenX]
		mov bx,16
		call PutBlock

		cmp [DrawScreenX],40-TETRIS_WIDTH-1-5
		jb @donex
		mov dx,5
		mov cx,[DrawScreenX]
		mov bx,0
		call PutBlock
		cmp [DrawScreenX],40-TETRIS_WIDTH-1-5
		jbe @donex
		mov dx,0
		mov cx,[DrawScreenX]
		mov bx,1
		call ClearBlock
		mov dx,0
		mov cx,[DrawScreenX]
		mov bx,2
		call ClearBlock
		mov dx,0
		mov cx,[DrawScreenX]
		mov bx,3
		call ClearBlock

@donex:         inc [DrawScreenX]
@tryY:          cmp [DrawScreenY],TETRIS_HEIGHT
		jae @done
		mov dx,5
		mov cx,40-TETRIS_WIDTH-1
		mov bx,[DrawScreenY]
		call PutBlock

		cmp [DrawScreenY],4
		ja @doney
		mov dx,5
		mov cx,40-TETRIS_WIDTH-1-5
		mov bx,[DrawScreenY]
		call PutBlock

@doney:         inc [DrawScreenY]
@done:          ret
CreateScreen    endp

;----------------------------------------------------------------------------
ClearBlock      proc near       ;clear block at CX,BX (*4) to colour DX
		shl bx,3        ;calc offset (Y=Y*8)
		mov ax,bx
		shl ax,6
		shl bx,4
		add bx,ax
		add bx,cx       ;   offset = BX
		add bx,cx
		@rlp edi,0a0000h
		movzx ebx,bx
		add edi,ebx     ;edi=pos on screen to start drawing
		mov bx,dx               ;clear the block
		mov dx,SC_INDEX
		mov ax,0f02h
		out dx,ax
		mov bh,bl
		mov [edi],bx
		mov [edi+80],bx
		mov [edi+80*2],bx
		mov [edi+80*3],bx
		mov [edi+80*4],bx
		mov [edi+80*5],bx
		mov [edi+80*6],bx
		mov [edi+80*7],bx
		ret
ClearBlock      endp

;----------------------------------------------------------------------------
PutBlock        proc near       ;put block colour# DX at CX,BX (*4)
		shl dx,2        ;convert colour
		add dx,32

		shl bx,3        ;calc offset (Y=Y*8)
		mov ax,bx
		shl ax,6
		shl bx,4
		add bx,ax
		add bx,cx       ;   offset = BX
		add bx,cx
		@rlp edi,0a0000h
		movzx ebx,bx
		add edi,ebx     ;edi=pos on screen to start drawing

		;draw the block, CX=base colour
@@pasteblock:   mov cx,dx
		mov dx,SC_INDEX
		mov ax,0f02h
		out dx,ax
		inc dx
		mov ch,cl               ;draw the box
		mov [edi],cx            ;  (top + bottom lines)
		mov [edi+80*7],cx
		mov al,01h              ;  (left side and middle right)
		out dx,al
		inc ch
		mov [edi+80],cx
		mov [edi+80*6],cx
		inc ch
		mov [edi+80*2],cx
		mov [edi+80*5],cx
		inc ch
		mov [edi+80*3],cx
		mov [edi+80*4],cx
		xchg ch,cl              ;  (right side and middle left
		mov al,08h
		out dx,al
		mov [edi+80*3],cx
		mov [edi+80*4],cx
		dec cl
		mov [edi+80*2],cx
		mov [edi+80*5],cx
		dec cl
		mov [edi+80],cx
		mov [edi+80*6],cx
		mov al,04h              ;  (2nd right and 2nd middle left)
		out dx,al
		inc ch
		mov [edi+80],cx
		mov [edi+80*6],cx
		inc cl
		mov [edi+80*2],cx
		mov [edi+80*5],cx
		mov [edi+80*3],cx
		mov [edi+80*4],cx
		xchg ch,cl              ;last bit
		mov al,02h
		out dx,al
		mov [edi+80*2],cx
		mov [edi+80*5],cx
		mov [edi+80*3],cx
		mov [edi+80*4],cx
		dec ch
		mov [edi+80],cx
		mov [edi+80*6],cx
		ret

PutBlock2:      ;put block colour# DX at CX,BX (*2)
		shl dx,2        ;convert colour
		add dx,32

		shl bx,2        ;calc offset (Y=Y*4)
		mov ax,bx
		shl ax,6
		shl bx,4
		add bx,ax
		add bx,cx       ;   offset = BX
		@rlp edi,0a0000h
		movzx ebx,bx
		add edi,ebx     ;edi=pos on screen to start drawing
		jmp @@pasteblock

PutBlock        endp

;----------------------------------------------------------------------------
StartBit        proc near
		mov dx,SC_INDEX
		mov ax,0f02h
		out dx,ax

		;line on screen
		@rlp edi,0a0000h+(SCREEN_WIDTH/4)*SCREEN_HEIGHT
		mov bx,200
@@clr:          call VWait
		mov eax,0a0a0a0ah
		mov ecx,SCREEN_WIDTH/4/4
		rep stosd
		sub edi,(SCREEN_WIDTH)/2
		dec bx
		jnz @@clr

		@rlp edi,0a0000h                ;clear all
		mov ecx,(SCREEN_WIDTH*SCREEN_HEIGHT/4)
		mov eax,0a0a0a0ah
		rep stosd

		mov [TopLeftX],0
		mov [TopLeftY],200
		call SetScrollRegs

		mov [SpeedVal],60
		call PasteTitle
		mov bx,200*2                 ;slide on title split screen
@@slideonloop:  call VWait
		call SplitScreen
		dec [SpeedVal]
		jnz @@fine
		inc [SpeedVal]
@@fine:         mov ax,[SpeedVal]
		cmp ax,32
		jbe @@ok
		mov ax,32
@@ok:           shr ax,2
		inc ax
		sub bx,ax
		jge @@slideonloop

		mov [TopLeftX],0
		mov [TopLeftY],0
		call SetScrollRegs
		mov bx,200*2
		call SplitScreen
		ret
StartBit        endp

;----------------------------------------------------------------------------
PasteTitle      proc near               ;paste "TEDIUM" title on screen
		mov esi,[title_buffer]
		mov dx,SC_INDEX
		mov ax,0102h
		out dx,ax
		call copyloop2
		mov ax,0202h
		out dx,ax
		call copyloop2
		mov ax,0402h
		out dx,ax
		call copyloop2
		mov ax,0802h
		out dx,ax
		call copyloop2
		ret
copyloop2:      @rlp edi,0a0000h+160+4 ;(10)     ;+20
		mov bx,28
@@lp1:          mov ecx,156/4
		rep movsb
		add edi,(320/4)-(156/4)
		dec bx
		jnz @@lp1
		ret
PasteTitle      endp

;----------------------------------------------------------------------------
PasteBitmap     proc near               ;paste a bitmap
		mov esi,ebp
		mov dx,SC_INDEX
		mov ax,0102h
		out dx,ax
		call copyloop
		mov ax,0202h
		out dx,ax
		call copyloop
		mov ax,0402h
		out dx,ax
		call copyloop
		mov ax,0802h
		out dx,ax
		call copyloop
		ret
copyloop:       @rlp edi,0a0000h+320/4*136
		add edi,[catoffset]
		mov bx,64
@@lp1:          mov ecx,76/4
		rep movsb
		add edi,(320/4)-(76/4)
		dec bx
		jnz @@lp1
		ret
PasteBitmap     endp

;----------------------------------------------------------------------------
DrawLetter      proc near               ;paste a character
		mov esi,[FontBuffer]   ;dx=y pos, cx=x pos, eax=char
		@rlp edi,0a0000h
		add esi,eax
		xor ebx,ebx

		mov ax,dx               ;calc scrn offset
		shl ax,6
		shl dx,4
		add ax,dx
		mov bx,cx
		shr bx,2
		add bx,ax
		add edi,ebx             ;edi=offset to start writing

		and cl,3                ;calc planes and write to video
		mov ax,0102h
		shl ah,cl
		mov dx,SC_INDEX
		out dx,ax

		push ax edi                 ;move plane 1 data
		mov cl,16
@@p1:           mov ax,[esi]
		mov [edi],ax
		add edi,SCREEN_WIDTH/4
		add esi,320/4
		dec cl
		jnz @@p1
		pop edi ax

		add ah,ah
		cmp ah,8
		jbe @@fine2
		mov ah,1
		inc edi
@@fine2:        out dx,ax

		push ax edi                 ;move plane 2 data
		mov cl,16
@@p2:           mov ax,[esi]
		mov [edi],ax
		add edi,SCREEN_WIDTH/4
		add esi,320/4
		dec cl
		jnz @@p2
		pop edi ax

		add ah,ah
		cmp ah,8
		jbe @@fine3
		mov ah,1
		inc edi
@@fine3:        out dx,ax

		push ax edi                 ;move plane 3 data
		mov cl,16
@@p3:           mov ax,[esi]
		mov [edi],ax
		add edi,SCREEN_WIDTH/4
		add esi,320/4
		dec cl
		jnz @@p3
		pop edi ax

		add ah,ah
		cmp ah,8
		jbe @@fine4
		mov ah,1
		inc edi
@@fine4:        out dx,ax

		mov cl,16                   ;move plane 4 data
@@p4:           mov ax,[esi]
		mov [edi],ax
		add edi,SCREEN_WIDTH/4
		add esi,320/4
		dec cl
		jnz @@p4
		ret
DrawLetter      endp

;----------------------------------------------------------------------------
LoadBitmap      proc near               ;load bitmap data
		mov eax,76*64*12        ;allocate bitmaps buffer
		call _getmem
		mov [bitmap_buffer],eax
		mov edx,offset filename ;load anim data
		call _openfile
		jnc @finehere
		jmp _exit

@finehere:      mov edx,[bitmap_buffer]
		mov ecx,76*64*12
		call _readfile

		mov eax,156*28          ;allocate bitmaps buffer
		call _getmem
		mov [title_buffer],eax
		mov edx,[title_buffer]
		mov ecx,156*28
		call _readfile

		mov eax,320*16          ;read font data
		call _getmem
		mov [FontBuffer],eax
		mov edx,eax
		mov ecx,320*16
		call _readfile

		mov esi,[FontBuffer]    ;convert font
		mov cx,320*16
		call @@hereitis2

		mov esi,[bitmap_buffer] ;convert bitmaps
		mov cx,76*64*12
		call @@hereitis
		mov esi,[title_buffer]
		mov cx,156*28
		call @@hereitis

		mov eax,TETRIS_WIDTH*TETRIS_HEIGHT ;alloc ram for game map
		call _getmem
		mov [GameMap],eax
		mov edi,eax
		mov ecx,TETRIS_WIDTH*TETRIS_HEIGHT
		xor ax,ax
		rep stosb

		mov eax,TETRIS_WIDTH*(TETRIS_HEIGHT+1) ;alloc ram for top map
		call _getmem
		mov [BackMap],eax
		mov edi,eax
		mov ecx,TETRIS_WIDTH*TETRIS_HEIGHT
		xor ax,ax
		rep stosb
		mov ecx,TETRIS_WIDTH
		mov al,255
		rep stosb
		ret

@@hereitis:     cmp byte ptr [esi],0    ;convert loop
		jnz @incit
		mov byte ptr [esi],10
@incit:         inc esi
		dec cx
		jnz @@hereitis
		ret

@@hereitis2:    cmp byte ptr [esi],0    ;convert font loop
		jnz @incit2
		mov byte ptr [esi],10
		jmp short @donefix
@incit2:        mov byte ptr [esi],4
@donefix:       inc esi
		dec cx
		jnz @@hereitis2
		ret
LoadBitmap      endp

;----------------------------------------------------------------------------
SetGFXMode      proc near
		mov [v86r_ax],013h            ;Set videomode
		mov al,10h
		int 33h

		mov cx,256*3            ;First blank palette
		mov dx,03c8h
		xor al,al
		out dx,al
		inc dx
@clr1:          out dx,al
		dec cx
		jnz @clr1

		mov dx,SC_INDEX
		mov ax,0604h
		out dx,ax                 ; disable chain4 mode
		mov ax,0100h
		out dx,ax                 ; synchronous reset while setting Misc
		mov esi,offset XMODE_STAT
		lodsb
		mov dx,MISC_OUTPUT
		out dx,al               ; select the dot clock and Horiz
		mov dx,SC_INDEX
		mov ax,0300h
		out dx,ax               ; undo reset (restart sequencer)
		mov dx,CRTC_INDEX       ; reprogram the CRT Controller
		mov al,11h              ; VSync End reg contains register write
		out dx,al               ; protect bit
		inc dx                  ; CRT Controller Data register
		in al,dx               ; get current VSync End register setting
		and al,07fh             ; remove write protect on various
		out dx,al               ; CRTC registers
		dec dx                  ; CRT Controller Index
		xor ecx,ecx
		lodsb
		mov cl,al
@@SetCRTParmsLoop: lodsw                ; get the next CRT Index/Data pair
		out dx,ax               ; set the next CRT Index/Data pair
		loop @@SetCRTParmsLoop
		mov dx,SC_INDEX
		mov ax,0f02h
		out dx,ax               ; enable writes to all four planes
		@rlp edi,0a0000h        ; now clear all display memory, 8 pixels
		xor eax,eax             ; clear to zero-value pixels
		mov ecx,4000h           ; # of words in display memory
		rep stosd               ; clear all of display memory
		mov dx,CRTC_INDEX
		mov al,CRTC_OFFSET
		out dx,al
		inc dx
		mov ax,SCREEN_WIDTH/8   ; no - set logical width = physical
		out dx,al
		ret
SetGFXMode      endp

;----------------------------------------------------------------------------
SetPalette      proc near               ;Initialise palette to esi
		mov cx,256*3
		mov dx,03c8h
		mov al,0
		out dx,al
		inc dx
@here:          mov al,[esi]
		sub al,ah
		jge @@fine
		mov al,0
@@fine:         out dx,al
		inc esi
		dec cx
		jnz @here
		ret
SetPalette      endp

;----------------------------------------------------------------------------
VWait           proc near       ;Wait for vertical retrace
		mov dx,3dah
VRT:            in al,dx
		test al,8
		jnz VRT         ;wait until Verticle Retrace starts
NoVRT:          in al,dx
		test al,8
		jz NoVRT        ;wait until Verticle Retrace Ends
		ret
VWait           endp

;----------------------------------------------------------------------------
ChekForKey      proc near       ;Check for a keypress (dont null it)
		mov ax,gs:[41ah]
		cmp ax,gs:[41ch]
		je @nokey
		stc
		ret
@nokey:         clc
		ret
ChekForKey      endp

;----------------------------------------------------------------------------
SetScrollRegs   proc near               ;Set screen window slide offsets
					;(Includes wait for retrace)
		mov ax,[TopLeftY]
		mov bx,ax
		shl ax,7
		shl bx,5
		add bx,ax
		mov ax,[TopLeftX]
		shr ax,2
		add bx,ax

		mov dx,03dah
@SW_WAIT0:      in al,dx                ;Wait for vertical trace
		and al,08h
		jnz @SW_WAIT0

		mov dx,03d4h            ;Set screen offset
		mov al,0dh
		mov ah,bl
		out dx,ax
		mov al,0ch
		mov ah,bh
		out dx,ax

		mov dx,03dah            ;Wait for horiz trace
@DP_WAIT1:      in al,dx
		and al,08h
		jz @DP_WAIT1

		mov dx,03c0h            ;Set fine slide
		mov al,33h
		out dx,al
		mov ax,[TopLeftX]
		and al,3
		add al,al
		out dx,al
		ret
SetScrollRegs   endp

;----------------------------------------------------------------------------
SplitScreen     proc near               ;Set splitscreen AX lines from top
		mov dx,03dah
		in al,dx
		mov al,10h+20h          ; Bit 5 set to prevent screen blanking
		mov dx,03c0h            ; Point AC to Index/Data register
		out dx,al
		inc dx                  ; Point to AC Data reg (for reads only)
		in al,dx                ; Get the current AC Mode Control reg
		or al,20h               ; Enable split scrn Pel panning suppress.
		dec dx                  ; Point to AC Index/Data reg (for writes only)
		out dx,al               ; Write the new AC Mode Control setting
		cli                     ; Dont allow register setting to be interrupted
		mov dx,CRTC_INDEX
		mov ah,bl
		mov al,18h
		out dx,ax               ; Bits 7-0 of the split screen scan line
		mov ah,bh
		and ah,1
		shl ah,4
		mov al,07h              ; Bit 4 of overflow register = Bit 8 of split
		out dx,al               ; screen scan line,
		inc dx                  ; So using readability of VGA registers
		in al,dx                ; Read the OVERFLOW register, and set the
		and al, not 10h         ; bit corresponding to Bit 8 (above)
		or al,ah
		out dx,al
		dec dx
		mov ah,bh
		and al,2
		ror ah,3
		mov al,09h              ; Bit 6 of max scan line register =
		out dx,al               ; Bit 9 of split screen scan line
		inc dx                  ; As we did before, update the apropriate
		in al,dx                ; bit without disturbing the rest
		and al, not 40h
		or al,ah
		out dx,al
		sti                     ; Registers are set, so interrupts are safe
		ret
SplitScreen     endp

;----------------------------------------------------------------------------
Get_Random      proc            ; returns a 16 bit semi-poor quality pseudo-random number in AX.
		push dx
		mov ax,[Rand_seed]
		imul [Rand_k1]
		add ax,[Rand_k2]
		mov [Rand_seed],ax
		ror al,1
		rol ah,1
		pop dx
		ret
Get_Random      endp

Seed_Random     proc            ; Seeds rand from the DOS clock.
		mov [v86r_ah],2ch
		mov al,21h
		int 33h
		mov ax,[v86r_dx]
		mov [Rand_seed],ax
		ret
Seed_Random     endp

;----------------------------------------------------------------------------
Bin2Dec         proc near               ;Convert EAX to decimal
		pushad
		mov edi,offset asciitbl ;first blank buffer
		push eax
		xor eax,eax
		mov [edi],eax
		mov [edi+4],eax
		mov [edi+8],ax
		pop eax
		xor edx,edx
		mov ebx,edi
		add edi,8
		mov byte ptr ds:[edi],0
		dec edi
ssss:           mov ecx,10
		div ecx
		add dl,30h
sssss:          mov ds:[edi],dl
		dec edi
		xor edx,edx
		or eax,eax
		jne ssss
		mov dl,' '
		cmp ebx,edi
		jbe sssss
		popad
		ret
Bin2Dec         endp

;----------------------------------------------------------------------------
code32          ends
		end
