		.386
		.387
		Ideal
		Jumps
		Model	Tiny,C
		CodeSeg

		Include 'settings.inc'
		Include 'vesa.inc'
		Include	'render2.inc'
		Include 'color.inc'
		Include 'ray.inc'
		Include 'gfx.inc'

Public		RenderScene
Proc		RenderScene	uses eax ebx cx dx si di es
		arg	myScene:ptr Scene
		local	tempa1:dword
		local	angley:dword,anglex:dword

		mov	si,[myScene]

		lea	di,[si+Scene.CameraTarget]
		lea	bx,[si+Scene.CameraPos]

		call	VectorCopy	C,bx,offset rsCamPos

		; Get viewer vector
		call	VectorSub	C,di,bx,offset rsViewer

		; Get rotation around y axis
		; angley = atan(X/Z)
		fld	[rsViewer.X]
		fld	[rsViewer.Z]
		fpatan
		fchs
		fstp	[angley]

		; anglex = atan(y/sqrt(x^2+z^2)
		fld	[rsViewer.X]
		fld	st(0)
		fmulp
		fld	[rsViewer.Z]
		fld	st(0)
		fmulp
		faddp
		fsqrt
		fld	[rsViewer.Y]
		fxch	st(1)
		fpatan
		fchs
		fstp	[anglex]

		; Calculate delta values for viewing plane vector movement
		fld	[rsSScreenWidth]
		fild	[si + Scene.ScreenWidth]
		fdivp
		fstp	[rsDeltaX]
		fld	[rsSScreenHeight]
		fild	[si + Scene.ScreenHeight]
		fdivp
		fstp	[rsDeltaY]

		; Calculate vector to viewing plane
		;call	VectorAdd	C,bx,offset rsSCamDistVec,offset rsView2
		call	VectorCopy	C,offset rsSCamDistVec,offset rsView2

		fld	[rsView2.X]
		fld	[rsSScreenWidth2]
		fsubp
		fst	[rsView2.X]
		fstp	[rsViewX]

		fld	[rsView2.Y]
		fld	[rsSScreenHeight2]
		fsubp
		fstp	[rsView2.Y]

		; The render loop
		mov	cx,[si + Scene.ScreenHeight]

		cmp	[si+Scene.RenderToVidmem],1
		je	SHORT @@VidmemRender
		mov	dx,[si+Scene.ScreenSeg]
		mov	es,dx
		mov	di,[si+Scene.ScreenOfs]		; Probably zero
		jmp	SHORT @@BufferRender
@@VidmemRender:
		push	VIDMEM
		pop	es
		mov	edx,[si + Scene.VidmemStart]	; Get start of vidmem
		mov	di,dx				; Memory offset
		shr	edx,16				; Get bank
IFDEF VESA
		call	VesaSetBank	C,dx		; Set bank
ENDIF
@@BufferRender:
@@RenderLoopY:
		push	cx
		mov	cx,[si + Scene.ScreenWidth]
		push	[dword rsView2.X]			; Save X
@@RenderLoopX:
		call	RotatePlaneVec	C,[anglex],[angley],offset rsView2,offset rsView3
		call	VectorAdd	C,offset rsCamPos,offset rsView3,offset rsView4
		;call	VectorAdd	C,offset rsCamPos,offset rsView2,offset rsView4
		lea	ax,[si + Scene.LightPos]
		;jmp	@@Skip
		xor	bx,bx
		call	RayGetColor C,offset rsCamPos,offset rsView4,[si + Scene.ObjectList],[si + Scene.NumObjects],-1,ITERATIONS,ax,offset rsColorVec
@@Skip:
		test	ax,ax
		jz	SHORT @@NoColor
		call	ColorFloat2RGB	C,offset rsColorVec,offset rsColor
		mov	ah,[rsColor.B]
		shr	ax,3+8
		mov	bh,[rsColor.G]
		and	bh,11111100b
		shr	bx,5
		or	ax,bx
		mov	bh,[rsColor.R]
		and	bh,11111000b
		or	ax,bx
@@NoColor:
		cmp	[si + Scene.RenderToVidmem],1
		je	SHORT @@VidMemRender2
		mov	[es:di],ax
		add	di,2
		jmp	SHORT @@BufferRender2
@@VidMemRender2:
		mov	[es:di],ax
		mov	[es:di+2],ax
		add	di,4
		test	di,di
		jnz	SHORT @@NoBankSwitch
		inc	dx
		call	VesaSetBank	C,dx
@@NoBankSwitch:
@@BufferRender2:
		fld	[rsView2.X]
		fld	[rsDeltaX]
		faddp
		fstp 	[rsView2.X]
		dec	cx
		jnz	@@RenderLoopX
		pop	[dword rsView2.X]
		pop	cx
		fld	[rsView2.Y]
		fld	[rsDeltaY]
		faddp
		fstp	[rsView2.Y]
		cmp	[si + Scene.RenderToVidmem],1
		jne	@@BufferRender3
		mov	ax,[VesaModeWidthInBytes]
		sub	ax,320*2*2
		add	di,ax
		jnc	@@NoOverflow
		inc	dx
		call	VesaSetBank	C,dx
@@NoOverflow:

@@BufferRender3:
		dec	cx
		jnz	@@RenderLoopY

		ret
EndP		RenderScene

Proc		RotatePlaneVec	uses eax si di
		arg	anglex:dword,angley:dword,A:ptr Vector,O:ptr Vector
		local	cosx:dword,sinx:dword,cosy:dword,siny:dword
		local	ztemp:dword

		mov	si,[A]
		mov	di,[O]


		; Calculate cos(anglex),sin(anglex), cos(angley),sin(angley)
		fld	[anglex]
		fsincos
		fstp	[cosx]
		fstp	[sinx]

		fld	[angley]
		fsincos
		fstp	[cosy]
		fstp	[siny]

		; Y' = -Z*sinx+Y*cosx
		fld	[sinx]
		fld	[si+Vector.Z]
		fmulp
		fchs
		fld	[cosx]
		fld	[si+Vector.Y]
		fmulp
		faddp
		fstp	[di+Vector.Y]

		; ZTemp = Z*cosx+Y*sinx
		fld	[cosx]
		fld	[si+Vector.Z]
		fmulp
		fld	[sinx]
		fld	[si+Vector.Y]
		fmulp
		faddp
		fld	st(0)			; Duplicate

		; X' = - siny*ztemp + X*cosy
		fchs
		fld	[siny]			; siny*ztemp
		fmulp
		fld	[cosy]
		fld	[si+Vector.X]
		fmulp
		faddp
		fstp	[di+Vector.X]

		; Z' = cosy*ztemp + X*siny
		fld	[cosy]			; cosy*ztemp
		fmulp
		fld	[siny]
		fld	[si+Vector.X]
		fmulp
		faddp
		fstp	[di+Vector.Z]

		ret
EndP		RotatePlaneVec

		DataSeg
		Align	4

rsViewer	Vector < >
rsTempViewer	Vector < >

rsSScreenWidth	dd	320.0		; Standard screen width
rsSScreenWidth2 dd	159.501		; Standard screen width/2 - 0.5
rsSScreenHeight	dd	200.0		; Standard screen height
rsSScreenHeight2 dd	 99.501		; Standard screen height/2 -0.5

rsSCamDist	dd	400.0		; Distance from camera to viewing plane
rsSCamDistVec	Vector	< 0.0, 0.0, 400.0 > ; Same as above as a vector

rsCamPos	Vector	< >		; Camera position
rsObjList	dw	0

rsView2		Vector	< >		; Temp vector for campos->plane
rsView3		Vector	< >		; Rotated vector for campos->plane
rsView4		Vector	< >		; rsView3 + camera pos
rsViewX		dd	0.0
rsDeltaX	dd	0.0
rsDeltaY	dd	0.0

rsColorVec	Vector	< >
rsColor		RGBA	< >

		End
