		.486
		.487
		Ideal
		Jumps
		Model	Tiny,C
		Stack	200h

		Include 'settings.inc'
		Include	'vector.inc'
		Include 'vesa.inc'
		Include	'ray.inc'
		Include 'genmath.inc'
		Include	'gfx.inc'
		Include 'keyboard.inc'
		Include 'color.inc'
		Include 'render.inc'
		Include 'xms.inc'
		Include 'playback.inc'
		Include 'text.inc'
		Include 'errors.inc'

Struc		PackedObject
Position	dw	0,0,0
Radius		dw	0
Material	db	0
Ends		PackedObject

		CodeSeg
		mov	ax,@data
		mov	ds,ax

		finit

		call	TextInit

		call	XMSInit
		test	ax,ax
		jz	XMSError

		call	VesaInit C,VESA_12
		test	ax,ax
		jz	VesaError
		call	VesaSetMode C,VESA_MODE_640x480x64k
		test	ax,ax
		jz	VesaError

		xor	eax,eax
		mov	ax,[VesaModeWidthInBytes]
		mov	ebx,20
		mul	ebx
		mov	[vmstart],eax

		call	BuildObjectList
		call	GfxStretchScreen2
		call	GfxCLS
		call	RenderStill1
		;call	VesaSetBank		C,1
		; x = 75
		; y = 40
		xor	eax,eax
		mov	ax,[VesaModeWidthInBytes]
		mov	ebx,20
		mul	ebx
		add	eax,75*2
		shl	eax,1

		call	TextWriteString		C,offset raystring,eax

		call	RenderAnimation1
		call	GfxCLS
		call	GfxStretchScreen4

		call	PlaybackStart	C,0,19,-1
		call	RenderAnimation2
		call	PlaybackStop

		call	PlaybackStart	C,30,30+40-1,15
Wait1:
		cmp	[cbActive],0
		jne	Wait1
		call	PlaybackStop

		call	GfxCLS
		call	GfxStretchScreen2
		call	RenderStill2
Tjohei:
		; x = 50
		; y = 40
		xor	eax,eax
		mov	ax,[VesaModeWidthInBytes]
		mov	ebx,20
		mul	ebx
		add	eax,50*2
		shl	eax,1

		call	TextWriteString		C,offset creditstring,eax
AlmostExit:
		WaitKey
		SetGFXMode < 03h >
Exit:
		call	XMSFree
		mov	ah,4Ch
		int	21h

XMSError:
		call	ErrorXMS
		jmp	SHORT Exit
VesaError:
		call	ErrorVesa
		jmp	SHORT Exit

Proc		RenderStill1
		call	BuildScene	C,offset still1_objects,5,offset still1_camlight,1,320,200
		call	RenderScene	C,offset tempScene
		ret
EndP		RenderStill1

Proc		RenderStill2
		call	BuildScene	C,offset still2_objects,5,offset still2_camlight,1,320,200
		call	RenderScene	C,offset tempScene
		ret
EndP		RenderStill2

Proc		RenderAnimation1
		call	BuildScene	C,offset animation1_objects,5,offset animation1_camlight,0,160,100
		mov	cx,20		; Frames
		xor	ax,ax
@@Loop1:
		push	ax cx
		call	RenderScene	C,offset tempScene
		call	XMSSetFrame	C,ax,seg buf,offset buf

; Load the counter
		mov	si,offset tempObjects

; Object 1 should have x,y as -cos,sin
; Object 2 should have x,y as cos,-sin
; Object 3 should have z,x as -cos,sin
; Object 4 should have z,x as cos,-sin

		fld	[animation1_counter]
		fadd	[animation1_step]
		fst	[animation1_counter]
		fsincos
		fld	[animation1_rotateradius]
		fmul
; COS
; Object 2.X
		fst	[dword si + 0 + 2*(SIZE Object)]
; Object 4.Z
		fst	[dword si + 8 + 4*(SIZE Object)]
		fchs
; -COS
; Object 1.X
		fst	[dword si + 0 + 1*(SIZE Object)]
; Object 3.Z
		fstp    [dword si + 8 + 3*(SIZE Object)]
		fld	[animation1_rotateradius]
		fmul
; SIN
; Object 1.Y
		fst	[dword si + 4 + 1*(SIZE Object)]
; Object 3.Z
		fst	[dword si + 0 + 3*(SIZE Object)]
		fchs
; -SIN
; Object 2.Y
		fst	[dword si + 4 + 2*(SIZE Object)]
; Object 4.X
		fstp    [dword si + 0 + 4*(SIZE Object)]

		pop	cx ax
		inc	ax
		loop	@@Loop1

		ret
EndP		RenderAnimation1

Proc		RenderAnimation2
		call	BuildScene	C,offset still1_objects,5,offset animation2_camlight,0,160,100
		mov	cx,40
		mov	ax,30
@@Loop1:
		push	ax cx
		call	RenderScene	C,offset tempScene
		call	XMSSetFrame	C,ax,seg buf,offset buf

; Load the counter
		mov	si,offset tempScene

; Object 1 should have x,y as -cos,sin
; Object 2 should have x,y as cos,-sin
; Object 3 should have z,x as -cos,sin
; Object 4 should have z,x as cos,-sin

		fld	[animation2_counter]
		fadd	[animation2_step]
		fst	[animation2_counter]
		fsincos
		fld	[animation2_rotateradius]
		fmul
; cos
		fstp	[dword si + 0]
		fld	[animation2_rotateradius]
		fmul

; SIN
		fstp	[dword si + 8]

		pop	cx ax
		inc	ax
		loop	@@Loop1
		ret
EndP		RenderAnimation2

;******************************************************************************
;*
;* void BuildScene(PacketObject *objptr,word num,void *camlightptr,bool vidmem,word scrw,word scrh)
;*
;* Purpose:
;*	Builds a scene from the information in objptr and camlightptr
;*
;* Arguments:
;*	objptr - pointer to a list of packet objects
;*	num - number of objects
;*	camlightptr - pointer to 3*3 words with camera position,target and light
;*	vidmem - true if we should write to video memory
;*	scrw - width of screen
;*	scrh - height of screen
;*
;******************************************************************************
Proc		BuildScene	uses es
		arg	objptr:word,num:word,camlightptr:word,vidmem:word,scrw:word,scrh:word

		mov	ax,ds
		mov	es,ax
		mov	di,offset tempObjects
		mov	si,[objptr]
		mov	cx,[num]
@@ObjectLoop1:
		push	cx si
		mov	cx,4
		push	si di
@@PosRadiusLoop1:
		fild	[word si]
		fstp	[dword di]
		add	si,2
		add	di,4
		loop	@@PosRadiusLoop1
		pop	di si

		xor	bx,bx
		mov	bl,[si+PackedObject.Material]
		mov	ax,70
		mul	bx
		add	ax,offset MaterialTable
		mov	si,ax
		mov	cx,70/2
		lea	di,[di+Object.Class]	; Get start of class in object
		rep movsw				; di points to next tempobject
		pop	si cx
		add	si,SIZE PackedObject
		loop	@@ObjectLoop1

		mov	ax,[num]
		mov	[numObjects],ax

		mov	ax,[vidmem]
		mov	[VidmemRender],ax		; Render to vidmem?

		mov	cx,3*3
		mov	si,[camlightptr]
		mov	di,offset CamPos
@@CamlightLoop1:
		fild	[word si]
		fstp	[dword di]
		add	si,2
		add	di,4
		loop	@@CamlightLoop1

		mov	ax,[scrw]
		mov	[ScreenWidth],ax
		mov	ax,[scrh]
		mov	[ScreenHeight],ax

		ret
EndP		BuildScene

;******************************************************************************
;*
;* void BuildObjectList()
;*
;* Purpose:
;*	Builds a list of pointers to the objects in tempObjects
;*
;******************************************************************************
Proc		BuildObjectList
		mov	si,offset tempObjects
		mov	di,offset tempObjList
		mov	cx,MAX_OBJECTS
@@Loop1:
		mov	[di],si
		add	di,2
		add	si,SIZE Object
		loop	@@Loop1
		ret
EndP		BuildObjectList

		DataSeg
		Align	2

label MaterialTable
PO_RED		=	0		; GREEN! :)
		dd	OBJECT_SPHERE			; 4
 		Vector	< 0.0, 0.2, 0.0 >		; ambient 3*4
		Vector	< 0.0, 0.6, 0.0 >               ; diffuse 3*4
		Vector < 0.7, 1.0, 0.7 >		; specular 3*4
		dd	0.7				; shininess 4
		dd	0.0				; reflection 4
		dd	1,2				; Width/height of texture 4*2
		dd	3,4				; 4*2
		dd	5				; 4
		dw	0				; 2 = 70

PO_BLUE 	=	1
		dd	OBJECT_SPHERE			; 4
 		Vector	< 0.0, 0.0, 0.2 >		; ambient
		Vector	< 0.0, 0.0, 0.6 >               ; diffuse
		Vector < 0.7, 0.7, 1.0 >		; specular
		dd	0.7				; shininess
		dd	0.0				; reflection
		dd	0,0				; Width/height of texture
		dd	0,0
		dd	0
		dw	0

PO_CHECKEREDGROUND = 2
		dd	OBJECT_GROUND
 		Vector	< 0.2, 0.2, 0.2 >		; ambient
		Vector	< 0.5, 0.5, 0.5 >               ; diffuse
		Vector < 0.2, 0.2, 0.2 >		; specular
		dd	0.2				; shininess
		dd	0.5				; reflection
		dd	1,1				; Width/height of texture
		dd	1,1				; Width/height mask
		dd	7				; Scalefactor (2^factor)
		dw	GroundTexture

PO_GLASS 	=	3
		dd	OBJECT_SPHERE			; 4
 		Vector	< 0.05, 0.05, 0.05 >		; ambient
		Vector	< 0.1, 0.1, 0.1 >               ; diffuse
		Vector < 1.0, 1.0, 1.0 >		; specular
		dd	0.9				; shininess
		dd	1.0				; reflection
		dd	0,0				; Width/height of texture
		dd	0,0
		dd	0
		dw	0

; Scene info for still1

label still1_objects
		dw	-100,0,500		; Position
		dw	100		; Radius
		db	PO_BLUE	; Type

		dw	-300,0,400		; Position
		dw	100		; Radius
		db	PO_RED	; Type

		dw	50,50,200		; Position
		dw	50		; Radius
		db	PO_RED		; Type


		dw	150,-50,600  	; Position
		dw	100		; Radius
		db	PO_GLASS	; Type


		dw	0,100,0  	; Position
		dw	0		; Radius
		db	PO_CHECKEREDGROUND

label still1_camlight
		dw	200,-250,-500  	; Camera
		dw	0,0,400		; Camera target
		dw	-100,-300,-300	; Light

label still2_objects
		dw	-100,0,500		; Position
		dw	100		; Radius
       		db	PO_BLUE	; Type

		dw	-300,0,400		; Position
		dw	100		; Radius
		db	PO_RED	; Type

		dw	150,-50,250		; Position
		dw	50		; Radius
		db	PO_GLASS		; Type

		dw	150,-50,600  	; Position
		dw	100		; Radius
		db	PO_GLASS	; Type

		dw	0,100,0  	; Position
		dw	0		; Radius
		db	PO_CHECKEREDGROUND

label still2_camlight
		dw	-200,-250,-500  	; Camera
		dw	0,0,400		; Camera target
		dw	700,-300,0	; Light

; Scene info for animation1

animation1_rotateradius dd	300.0
animation1_step	dd	0.157079632	; pi/20 (antall frames)
animation1_counter	dd	0.0

label animation1_objects
; Big glass sphere
		dw	0,0,0
		dw	200
		db	PO_GLASS
; Four small spheres
		dw	-300,0,0
		dw	50		; ?
		db	PO_BLUE

		dw	300,0,0
		dw	50		; ?
		db	PO_BLUE

		dw	0,0,-300
		dw	50		; ?
		db	PO_RED

		dw	0,0,300
		dw	50		; ?
		db	PO_RED

label animation1_camlight
		dw	600,-450,-600	; Camera position
		dw	100,0,0		; Camera target
		dw	1000,-300,0	; Light

animation2_rotateradius dd	1000.0
animation2_step	dd	0.157079632	; pi/20 (antall frames)
animation2_counter	dd	0.0
label animation2_camlight
		dw	1000,-250,0  	; Camera
		dw	0,0,400	; Camera target
		dw	-100,-300,-300	; Light



label tempScene
CamPos		Vector	<  >
CamTarget	Vector	<  >
Light		Vector	< >
NumObjects	dw	0
ObjListPtr	dw	tempObjList
VidmemRender	dw	0
VmStart		dd	0
ScreenWidth	dw	0
ScreenHeight	dw	0
BufSeg		dw	seg Buf
BufOFs		dw	offset Buf

tempObjList	dw	MAX_OBJECTS dup(0)

label tempObjects
REPT	MAX_OBJECTS 			; MAX 20 objects
		Object	< >
ENDM

GroundTexture	RGBA	< 0,255,255,255>
		RGBA	< 0,255,  0,  0 >
		RGBA	< 0,255,  0,  0 >
		RGBA	< 0,255,255,255 >

raystring	db	'Recursive',10
		db	'raytracing',10
		db	'  in 4k!',0
creditstring	db	'  Coding by',10
		db	'Neon/Spetsnaz',0

Segment		ARGH	Para Private Use16 'BUF'
Buf		DB	FRAME_SIZE dup(0)
Ends		ARGH

		end
