// math.inc

void rotate( point *src, point *dest ); //, point *rot);
void CalcCentAndNormal( side *calc );
void sort( render *src );
int random_number( void );
void scale( point *dest, point *off );
void prime_rotation( point *rot );
void move( render * );

long m[3][3];

void prime_rotation( point *rot )
{
	m[0][0] = ( sn[rot->y+64]*sn[rot->z+64] )>>8;
	m[0][1] = ( sn[rot->x]*sn[rot->y] )>>8;
	m[0][1] = (m[0][1] * sn[rot->z+64] )>>8;
	m[0][1] += (sn[rot->x+64]*sn[rot->z])>>8;
	m[0][1] = -m[0][1];
	m[0][2] = (sn[rot->x+64]*sn[rot->y])>>8;
	m[0][2] = (m[0][2] * sn[rot->z+64])>>8;
	m[0][2] = -m[0][2];
	m[0][2] += (sn[rot->x]*sn[rot->z])>>8;

	m[1][0] = ( sn[rot->y+64] * sn[rot->z] )>>8;
	m[1][1] = ( sn[rot->x]*sn[rot->y] )>>8;
	m[1][1] = ( m[1][1] * sn[rot->z] )>>8;
	m[1][1] = -m[1][1];
	m[1][1] += ( sn[rot->x+64]*sn[rot->z+64] )>>8;
	m[1][2] = ( sn[rot->x+64]*sn[rot->y] )>>8;
	m[1][2] = ( m[1][2] * sn[rot->z] )>>8;
	m[1][2] += ( sn[rot->x]*sn[rot->z+64] )>>8;
	m[1][2] = -m[1][2];
	
	m[2][0] = sn[rot->y];
	m[2][1] = (sn[rot->x]*sn[rot->y+64])>>8;
	m[2][2] = (sn[rot->x+64]*sn[rot->y+64])>>8;
}
	
void rotate( point *src, point *dest ) //, point *rot)
{
	dest->x = ( (src->x)*m[0][0] )>>8;
	dest->x += ( (src->y)*m[0][1] )>>8;
	dest->x += ( (src->z)*m[0][2] )>>8;
	
	dest->y = ( (src->x)*m[1][0] )>>8;
	dest->y += ( (src->y)*m[1][1] )>>8;
	dest->y += ( (src->z)*m[1][2] )>>8;

	dest->z = ( (src->x)*m[2][0] )>>8;
	dest->z += ( (src->y)*m[2][1] )>>8;
	dest->z += ( (src->z)*m[2][2] )>>8;
}

void scale( point *dest, point *off )
{
	(*dest).x = (((*dest).x+(*off).x)*1024)/((*dest).z + (*off).z + 1024);
	(*dest).y = (((*dest).y+(*off).y)*1024)/((*dest).z + (*off).z + 1024);
}


void CalcCentAndNormal( side *calc )
{
	point *v1, *v2, *v3;

	v1 = (*calc).p1;
	v2 = (*calc).p2;
	v3 = (*calc).p3;

	(*calc).centerz = (*v1).z+(*v2).z+(*v3).z;

	(*calc).norz = 
	    (
	      (( (*v1).x - (*v2).x) * ((*v1).y - (*v3).y)) -
	      (( (*v1).y - (*v2).y) * ((*v1).x - (*v3).x))
	    )>>9;

	//(*calc).norz /= (*calc).normalize;

	if( (*calc).norz > 0 )
	  calc->norz = -calc->norz;

	if( (*calc).norz < -63 )
	  (*calc).norz = -63;
}

void sort( render *src )
{
	int sort_flag = 1;
	int x;
	side *tempside;

	while( sort_flag )
	{
	  sort_flag = 0;
	  for( x = 0; x < (*src).sides-1; x++ )
	  {
	    if( (signed long) (*(*src).render_sort[x]).centerz <
		(signed long) (*(*src).render_sort[x+1]).centerz )
	    {
	      tempside = (*src).render_sort[x];
	      (*src).render_sort[x] = (*src).render_sort[x+1];
	      (*src).render_sort[x+1] = tempside;
	      sort_flag = 1;
	    }
	  }
	}
}

int random_number( void )
{
	static int rand = 0x348b;
	static int rand2 = 0x7f34;
	int r;

	asm  {
	  mov     ax, rand
	  mov     bx, rand2
	  add     ax, 0a137h
	  add     bx, 63f7h
	  rol     ax, 2
	  mov     word ptr rand, ax
	  add     bx, ax
	  ror     bx, 1
	  mov     word ptr rand2, bx
	  add     ax, bx
	  mov     r, ax  }

	  return r;
}

void move( render *src )
{
	int x;

	x = (*src).local_rotation.x-128;
	x/= (*src).frames;
	(*src).local_rotation.x -= x;

	x = (*src).local_rotation.y;
	x/= (*src).frames;
	(*src).local_rotation.y -= x;

	x = (*src).local_rotation.z;
	x/= (*src).frames;
	(*src).local_rotation.z -= x;

	x = (*src).local_position.x - (*src).final_position.x;
	x/= (*src).frames;
	(*src).local_position.x -= x;

	x = (*src).local_position.y - (*src).final_position.y;
	x/= (*src).frames;
	(*src).local_position.y -= x;

	x = (*src).local_position.z - (*src).final_position.z;
	x/= (*src).frames;
	(*src).local_position.z -= x;
}
