void wait_retrace( void );
void change_pal( int col_num, char, char, char );
void putpixel( int x, char y, int color );
int getpixel( int x, char y );
void trifiller( int x1, int y1, int x2, int y2, int x3, int y3, int color );
void virt_screen2( void );
void clr_virt2( void );
void clr2( void );
void flip_virt2_real2( void );
void flip_virt2_real( void );
void FlatTriFill( int x1, int y1, int x2, int y2, int x3, int y3,
		  int basecolor );

long int upx, upy, downx, downy, midx, midy;
long int difx1i, xinc1i, difx2i, xinc2i;

#include "sn_table.dat"

void wait_retrace( void )
{
      // straight from Denthor's tutorials  Thanks!

      asm  {
	mov  dx,0x3da  }
   l1:
      asm  {
	in  al,dx
	test al, 8
	jnz l1  }
   l2:
      asm  {
	in  al,dx
	test al, 8
	jz  l2  }
}

void change_pal( int col_num, char blue, char green, char red )
{
	asm  {
	  mov  dx, 0x3c8
	  mov  ax, col_num
	  out  dx, al
	  inc  dx
	  mov  al, red
	  out  dx, al
	  mov  al, green
	  out  dx, al
	  mov  al, blue
	  out  dx, al  }
}

void putpixel( int x, char y, int color )
{
	asm  {
	  mov  ax, scrnptr
	  mov  es, ax
	  xor  bx, bx
	  mov  bh, y
	  shr  bx, 2
	  add  bh, y
	  add  bx, x
	  mov  ax, color
	  add   bx, 4
	  mov  es:[bx], al
	}
}

int getpixel( int x, char y )
{
	int r;
	asm  {
	  mov  ax, scrnptr
	  mov  es, ax
	  xor  bx, bx
	  mov  bh, y
	  shr  bx, 2
	  add  bh, y
	  add  bx, x
	  add   bx, 4
	  mov  al, es:[bx]
	  xor  ah, ah
	  mov  r, ax
	}

	return r;
}


void virt_screen2( void )
{
// sets the pointer to the second virtual screen
	int x;
	x = (long)buffer2>>16;
  asm  {
    mov  ax, x
    mov  es, ax  }
}

void clr_virt2( void )
{
// clears the memory required for the second virtual screen

	int x, y;
	x = (long)buffer1>>16;
	y = (long)buffer2>>16;
  asm  {
    mov  ax, x
    mov  es, ax
    mov  cx, 32000
    mov di, 4
    xor  ax, ax
    rep  stosw
    mov  ax, y
    mov  es, ax
    mov  cx, 32000
    mov di, 4
    xor  ax, ax
    rep  stosw
    }
}

void clr2( void )
{
// clears the memory required for the second virtual screen

	int x, y;
	x = (long)buffer1>>16;
asm  {
    mov  ax, x
    mov  es, ax
    mov  cx, 22880
    mov di, 18244
    xor  ax, ax
    rep  stosw
    les  di, buffer2
    mov  cx, 32000
    xor  ax, ax
    rep  stosw
    }
}

void flip_virt2_real2( void )
{
//  flips the contents of the second virtual screen to the real screen

	int x, y;
	x = (long)buffer1>>16;
	y = (long)buffer2>>16;
  asm  {
    push ds
    push es
  mov  ax, y
  mov  es, ax           //
  mov  ax, x
  mov  ds, ax
  mov   si, 4
  mov   di, 4
  mov  cx, 32000        // clear screen
  rep  movsw            //
  pop  es               //
  pop  ds  }            //
}

void flip_virt2_real( void )
{
//  flips the contents of the second virtual screen to the real screen

	int x, y;
	x = (long)buffer1>>16;
	y = (long)buffer2>>16;
  asm  {
    push ds
    push es
    mov  ax, 0xa000
    mov  es, ax
    lds  si, buffer2
    xor di, di
    mov  cx, 32000  }
flip_lp:
  asm  {
  rep  movsw

  mov  ax, y
  mov  es, ax           //
  mov  ax, x
  mov  ds, ax
  mov   si, 4
  mov   di, 4
  mov  cx, 32000        // clear screen
  rep  movsw            //
  pop  es               //
  pop  ds  }            //
}

void FlatTriFill( int x1, int y1, int x2, int y2, int x3, int y3,
		  int basecolor )
{
	int linebds[200][2];
	
	long x, y;
	long dx1, dx2;
	long xinc1, xinc2;
	long put1, put2;
	long upx, upy, midx, midy, downx, downy;
	long xlength, color;

	if( (x1<0) && (x2<0) && (x3<0) )
	  return;

	if( (x1>319) && (x2>319) && (x3>319) )
	  return;
	
	if( y1<=y2 )
	  if( y1 <= y3 )
	  {
	    upx = x1;
	    upy = y1;
	    if( y2<=y3 )
	    {
	      midx = x2;
	      midy = y2;
	      downx = x3;
	      downy = y3;
	    }
	    else
	    {
	      midx = x3;
	      midy = y3;
	      downx = x2;
	      downy = y2;
	    }
	    goto Gfound;
	  }

	if( y2<=y3 )
	{
	  upx = x2;
	  upy = y2;
	    if( y1<=y3 )
	    {
	      midx = x1;
	      midy = y1;
	      downx = x3;
	      downy = y3;
	    }
	    else
	    {
	      midx = x3;
	      midy = y3;
	      downx = x1;
	      downy = y1;
	    }
	}
	else
	{
	  upx = x3;
	  upy = y3;
	    if( y1<=y2 )
	    {
	      midx = x1;
	      midy = y1;
	      downx = x2;
	      downy = y2;
	    }
	    else
	    {
	      midx = x2;
	      midy = y2;
	      downx = x1;
	      downy = y1;
	    }
	}
Gfound:
	if( downy<0 )
	  return;
	if( upy>200 )
	  return;
	
	dx1 = (midx - upx)<<12;
	if( upy != midy )
	  dx1 /= (midy-upy);

	dx2 = (downx - upx)<<12;
	if( upy != downy )
	  dx2 /= (downy - upy);

	put1 = upx;
	put2 = upx;

	xinc1 = 0;
	xinc2 = 0;

	y = upy;

	while( y < 0 )
	{
	  xinc1 += dx1;
	  xinc2 += dx2;

	  y++;
	}

	for( ; (y<midy) && (y<200); y++ )
	{
	  linebds[y][0]=put1+(xinc1>>12);
	  linebds[y][1]=put2+(xinc2>>12);

	  xinc1 += dx1;
	  xinc2 += dx2;
	}

	dx1 = (downx-midx)<<12;
	if( midy!=downy )
	  dx1 /= (downy-midy);

	put1 = midx;
	xinc1 = 0;

	for( ; (y<=downy) && (y<200); y++ )
	{
	  linebds[y][0] = put1+(xinc1>>12);
	  linebds[y][1] = put2+(xinc2>>12);
	  
	  xinc1 += dx1;
	  xinc2 += dx2;
	}

	if( upy < 0 )
	  upy = 0;

	if( downy > 199 )
	  downy = 199;

	for( y=upy; y<=downy; y++ )
	{
	  if( linebds[y][0] < 0 )
	    linebds[y][0] = 0;
	  if( linebds[y][1] < 0 )
	    linebds[y][1] = 0;
	  if( linebds[y][0] > 319 )
	    linebds[y][0] = 319;
	  if( linebds[y][1] >319 )
	    linebds[y][1] = 319;
	}

	asm  {
	  mov  ax, scrnptr
	  mov  es, ax  }

	for( y = upy; y <= downy; y++ )
	{
	  dx1 = linebds[y][0];
	  dx2 = linebds[y][1];
	  xlength = dx1 - dx2;
	  if( xlength < 0 )
	  {
	    
	    xlength = -xlength;

	      asm  {
		mov     ax, basecolor
		xor     bx, bx
		mov     bh, byte ptr y
		shr     bx, 2
		add     bh, byte ptr y
		add     bx, word ptr dx1
		mov     di, bx
		mov     cx, word ptr xlength
		add     di, 4
		mov     ah, al
		inc     cx  
		shr     cx, 1
		jnc     duo
		stosb  }
	      duo:
	      asm  {
		rep  stosw  }
	  }
	  else
	  {
	      asm  {
		mov     ax, basecolor
		xor     bx, bx
		mov     bh, byte ptr y
		shr     bx, 2
		add     bh, byte ptr y
		add     bx, word ptr dx2
		mov     di, bx
		mov     cx, word ptr xlength
		add     di, 4
		mov     ah, al
		inc     cx
		shr     cx, 1
		jnc     duod
		stosb  }
	      duod:
	      asm  {
		rep  stosw  }
	  }
	}
}
