//  freedom.cpp
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <alloc.h>

int scrnptr;
char *buffer1, *buffer2;
char *font;

#include "graphics.inc"
#include "font.inc"
#include "bccdvt.cpp"
#include "math.inc"
#include "data.inc"

render *text[10];
int text_begin = 0;
long int total_frames = 0;
int text_end = 0;
int kb_flag = 0;
long counter = 0;
long frame_dec = 0;
long previous_cnt = 0;
long temp_cnt = 0;
char music = 0;

#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif

void interrupt ( *old_kb_handler)(__CPPARGS);
void interrupt new_kb_handler(__CPPARGS);

int display( render * );
void fill( side *src );
void water( char * );
void clear();
void clear2();
void allocs();
void funky_first_put();
void funky_get_rid();

#include "text.inc"

void main( void )
{
	char flag;
	int x;
	int y = 0, z = 0;
	int max = 10;
	int clearflag = 0;
	int doneflag = 0;
	int dontz[10];
	int exitflag = 0;
	int cmflag = 0;
	point location;
	point fnt;

	old_kb_handler = getvect(9);
	setvect(9, new_kb_handler);

       music = VT_Init();
       if( music==1 )
	 counter = VT_Timer();
	
	for( x = 0; x < 6*9; x++ )
	  for( y = 0; y < 21; y++ )
	    message[(x*21)+y] = message1[x][y];

	message[(6*9*21)+1] = 'A';

	for( x = 0; x<10; x++ )
	  dontz[x] = 1;

	y = 0;

	allocs();

	location.x = -6000;
	location.y = -1000;
	location.z = 4096*10;

	for( x = 0; x < 10; x++ )
	{
	  while( message[y] == ' ' )
	  {
	    location.x+=600;
	    if( location.x>6000)
	    {
	      location.x = -6000;
	      location.y+= 800;
	      if( location.y>3000 )
		location.y = -1000;
	    }
	    y++;
	  }

	  LoadRender( text[x], &alpha[(int)message[y]-'A'], location, message[y]-'A' );
	  y++;
	  location.x+=600;
	    if( location.x>6000)
	    {
	      location.x = -6000;
	      location.y+= 800;
	      if( location.y>3000 )
		location.y = -1000;
	    }
	 // normalize(text[x]);
	}

	text[9]->frames = 243;
	text[8]->frames = 230;
	text[7]->frames = 218;
	text[6]->frames = 205;
	text[5]->frames = 192;
	text[4]->frames = 179;
	text[3]->frames = 166;
	text[2]->frames = 154;
	text[1]->frames = 141;
	text[0]->frames = 128;

	asm  {
	  mov  ax, 0x0013
	  int  0x10  }
	
	virt_screen2();
	clr_virt2();
	
	funky_first_put();
	
	for( x = 1; x < 32; x++ )
	  change_pal( x, x<<1, x>>1, x>>1 );

	for( ; x < 64; x++ )
	  change_pal( x, 63, x>>1, x>>1 );

	//printf( "%ld", counter );
	
       clr2();
       flip_virt2_real2();


       scrnptr = (long)buffer2>>16;
       flip_virt2_real();

       previous_cnt = counter;
       
	max = 10;
	while( 1 )
	{
	  if( music==1 )
	  {
	    temp_cnt = VT_Timer();
	    frame_dec = temp_cnt-previous_cnt;
	    previous_cnt = temp_cnt;
	  }
	  else
	  {
	    frame_dec = 1;
	  }

	  for( z = 0; z < 10; z++ )
	  {
	   if( dontz[z] )
	   {
	    scrnptr = (long)buffer2>>16;
	    if( display(text[z]) )
	    {
	      putfont( text[z] );

	      while( message[y] == ' ' )
	      {
		location.x+=600;
		if( location.x>6000)
		{
		  location.x = -6000;
		  location.y+= 800;
		  if( location.y>3000 )
		  {
		    location.y = -1000;
		    clearflag = 1;
		  }
	       }
	       y++;
		if( y >= 1134 )
		{
		  doneflag = 1;
		  y = 0;
		}
	      }

	      LoadRender( text[z], &alpha[message[y]-'A'], location, message[y]-'A' );
	      y++;
	      location.x+=600;
	      if( location.x>6000)
	      {
		location.x = -6000;
		location.y+= 800;
		if( location.y>3000 )
		{
		  location.y = -1000;
		  clearflag = 1;
		}
	      }
	    
	      if( y >= 1134 )
	      {
		doneflag = 1;
		y = 0;
	      }

	      if( clearflag )
		dontz[z] = 0;
	      
	     // normalize(text[z]);
	    }
	   }
	  }

	  if( kb_flag == 1 )
	  {
	    clearflag = 1;
	    exitflag = 1;
	  }
	  total_frames++;

	  flip_virt2_real();

	  max = 0;
	  for( x = 0; x < 10; x++ )
	  {
	    if( dontz[x] )
	      max++;
	  }

	  if( max == 0 )
	  {
	    if( music )
	      counter = VT_Timer();

	    //printf( "%ld %ld\n", counter, total_frames );
	    flip_virt2_real();
	    if( cmflag == 0 )
	      clear();
	    else
	      clear2();

	    cmflag ^=1;

	    flip_virt2_real();
	    for( x = 0; x < 10; x++ )
	      dontz[x] = 1;
	    clearflag = 0;

	    text[9]->frames = 243+98;
	    text[8]->frames = 230+98;
	    text[7]->frames = 218+98;
	    text[6]->frames = 205+98;
	    text[5]->frames = 192+98;
	    text[4]->frames = 179+98;
	    text[3]->frames = 166+98;
	    text[2]->frames = 154+98;
	    text[1]->frames = 141+98;
	    text[0]->frames = 128+98;

	    if( exitflag )
	    {
	      setvect( 9, old_kb_handler );
	      asm  {
		mov  ax, 0x0003
		int  0x10  }

	      if( music )
		VT_Abort();
	      goto dne2;
	    }

	    if(doneflag)
	      goto dne;
	      
	  }
	}
       dne:
	 funky_get_rid();

	for( x = 0; x < 256; x++ )
	  change_pal( x, 0, 0, 0 );
	  
	 setvect(9, old_kb_handler);

	dne2:
}

void interrupt new_kb_handler(__CPPARGS)
{
	asm  {
	  pushf
	  push ax
	  in   al, 60h
	  cmp  al, 1
	  jne  kb_ignore  }
	kb_flag = 1;
	kb_ignore:
	asm  {
	  mov  al, 20h
	  out  20h, al
	  pop  ax
	  popf
	}
}

int display( render *src )
{
	int x, y;
	int flag = 0;

	(*src).frames = (*src).frames - frame_dec;
	if( (*src).frames <= 0 )
	{
	  flag = 1;
	  (*src).frames=1;
	}
	  
	move( src );

	prime_rotation( &(*src).local_rotation );

	for( x = 0; x < (*src).vertices; x++ )
	  rotate( &(*src).render_point[x], &(*src).rotated_point[x] );//, &(*src).local_rotation );

	for( x = 0; x < (*src).sides; x++ )
	  CalcCentAndNormal( &(*src).render_side[x] );
	
	for( x = 0; x < (*src).vertices; x++ )
	  scale( &(*src).rotated_point[x], &(*src).local_position );
	
	sort( src );

	for( x = 0; x < (*src).sides; x++ )
	  if( (*(*src).render_sort[x]).norz < 0 )
	    fill( (*src).render_sort[x] );

	return flag;
}

void fill( side *src )
{
	FlatTriFill( (*(*src).p1).x+160,
		     (*(*src).p1).y+100,
		     (*(*src).p2).x+160,
		     (*(*src).p2).y+100,
		     (*(*src).p3).x+160,
		     (*(*src).p3).y+100,
				    
		     -(*src).norz );

}

void clear()
{
	unsigned int d, u, v, w, x, y;
	signed int color, color2, z;
	unsigned int zq = 0;
	int snsn[320];
	int sncos[320];

	scrnptr = 0xa000;
	for( y = 57; y < 200; y++ )
	  for( x = 0;x < 320; x++ )
	  {
	    z = getpixel( x, y );
	    if( z == 0x5e )
	      z = 0;

	    while( z > 63 )
	      z-= 63;
	    putpixel( x, y, z );
	  }

	for( x = 0; x < 320; x++ )
	{
	  snsn[x] = sne[sne[x]];
	  sncos[x] = sne[cosine[x]];
	}

	z = -100;
	asm  {
	  mov  ax, 0xa000
	  mov  es, ax  }

      while(z < 50)
      {
		wait_retrace();
	z+=2;

	asm  {
	  mov  di, 18244  }

	for( y = 56 ,u = 0; y < 200; y+=2, u+=3 )
	{
	  w = sne[(y-z)&255];
	  v = cosine[(35+u-z)&127];

	  for( x = 0, zq = z; x < 320; x+=2, zq +=3  )
	  {
	    color2 = w + sncos[(x+z)&255];
	    color =  snsn[(zq)&255] + v;
	    if( color > color2 )
	      color -= color2-5;
	    else
	      color = color2 - (color)+5;

		    color += -x-y+z;

	  asm  {
	      mov  ax, color                    // takes up half the time
	      shr  ax, 1
	      mov  ah, al
	      mov  bx, ax
	      and  ax, es:[di]
	      mov  es:[di], ax
	      and  bx, es:[di+320]
	      mov  es:[di+320], bx
	      add       di, 2
	    }
	  }
	  asm  {
	    add  di, 320  }
	}
      }
	clr2();
	flip_virt2_real2();
}

void clear2()
{
	int x, y, z;
	
	asm  {
	  mov  ax, 0xa000
	  mov  es, ax  }
	for( z = 0; z < 144; z++ )
	{
	  asm  {
	    mov  di, 18240
	    mov  dx, 142  }
	  c2_yloop:
	  asm  {
	    mov  cx, 160  }
	  c2_xloop:
	  asm  {
	    mov  ax, es:[di+320]
	    mov  es:[di], ax
	    add  di, 2
	    dec  cx
	    jnz  c2_xloop  
	    dec  dx
	    jnz  c2_yloop }

	  wait_retrace();
	}
	
	clr2();
	flip_virt2_real2();
}


void water( char *scrn )
{
	int x;
	x = ((long)scrn)>>16;
	asm  {
	  push es
	  mov es, x
	  pop  es  }
}


void allocs()
{
	int x;

	for( x = 0; x < 10; x++ )
	  text[x] = (render*) malloc( sizeof(render) );

	buffer1 = (char*)malloc( 64000 );
	buffer2 = (char*)malloc( 64000 );

	font = (char*)malloc( 640*20 );
	
	if( (text[9] == NULL) || (buffer1 == NULL) || (buffer2 == NULL) )
	{
	  asm  {
	    mov  ax, 0003h
	    int  0x10  }
	  printf( "memory allocation error: buffers\n" );
	  setvect(9, old_kb_handler);
	  VT_Abort();
	  exit (0);
	}

	if( (font==NULL) )
	{
	  asm  {
	    mov  ax, 0003h
	    int  0x10  }
	  printf( "memory allocation error: font\n" );
	  setvect(9, old_kb_handler);
	  VT_Abort();
	  exit (0);
	}

}

void funky_first_put()
{
	int x, y, temp;
	FILE* fp;
	char *tmp;

	tmp = font;

	flip_virt2_real();

	scrnptr = (long)buffer1>>16;

	if( music==1 )
	{
	  VT_AutoOff();
	  VT_Poll();
	  
	  fp = fopen( "freedom.003", "rb" );
	    for( y = 0; y < 57; y++ )
	    {
	      if( music ) 
		VT_Poll();
	      for( x = 0; x < 320; x++ )
		putpixel( x, y, fgetc(fp) );
	    }

	    for( x = 0; x < 256; x++ )
	      change_pal( x, fgetc(fp)/4, fgetc(fp)/4, fgetc(fp)/4 );
	    if( music ) 
	      VT_Poll();
	    for( x = 0; x < 640; x++ )
	      for( y = 0; y < 20; y++ )
	      {
		*tmp = fgetc(fp);
		tmp++;
	      }
	    if( music ) 
	      VT_Poll();
	    
	  fclose( fp );
	  
	  VT_Poll();
	  VT_AutoOn();
	}
	else
	{
	  fp = fopen( "freedom.003", "rb" );
	    for( y = 0; y < 57; y++ )
	     for( x = 0; x < 320; x++ )
		putpixel( x, y, fgetc(fp) );
	    
	    for( x = 0; x < 256; x++ )
	      change_pal( x, fgetc(fp)/4, fgetc(fp)/4, fgetc(fp)/4 );
	    for( x = 0; x < 640; x++ )
	      for( y = 0; y < 20; y++ )
	      {
		*tmp = fgetc(fp);
		tmp++;
	      }
	  fclose( fp );
	}


	for( y = 0; y < 57; y+=4 )
	  for( x = 0; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 1; y < 57; y+=4 )
	  for( x = 0; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 2; y < 57; y+=4 )
	  for( x = 0; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 3; y < 57; y+=4 )
	  for( x = 0; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 3; y < 57; y+=4 )
	  for( x = 1; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }
       
	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 3; y < 57; y+=4 )
	  for( x = 2; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 3; y < 57; y+=4 )
	  for( x = 3; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 2; y < 57; y+=4 )
	  for( x = 3; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 1; y < 57; y+=4 )
	  for( x = 3; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 0; y < 57; y+=4 )
	  for( x = 3; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();
	
	for( y = 0; y < 57; y+=4 )
	  for( x = 2; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 0; y < 57; y+=4 )
	  for( x = 1; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 1; y < 57; y+=4 )
	  for( x = 1; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 2; y < 57; y+=4 )
	  for( x = 1; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 2; y < 57; y+=4 )
	  for( x = 2; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 1; y < 57; y+=4 )
	  for( x = 2; x < 320; x+=4 )
	  {
	    temp = getpixel( x, y );
	    scrnptr = 0xa000;
	    putpixel( x-4, y, temp );
	    scrnptr = (long)buffer1>>16;
	  }

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();
}

void funky_get_rid()
{
	int x, y; 
	int temp = 0;

	scrnptr = 0xa000;
	
	for( y = 0; y < 57; y+=4 )
	  for( x = 0; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 1; y < 57; y+=4 )
	  for( x = 0; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 2; y < 57; y+=4 )
	  for( x = 0; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 3; y < 57; y+=4 )
	  for( x = 0; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 3; y < 57; y+=4 )
	  for( x = 1; x < 320; x+=4 )
	    putpixel( x-4, y, temp );
       
	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 3; y < 57; y+=4 )
	  for( x = 2; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 3; y < 57; y+=4 )
	  for( x = 3; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 2; y < 57; y+=4 )
	  for( x = 3; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 1; y < 57; y+=4 )
	  for( x = 3; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 0; y < 57; y+=4 )
	  for( x = 3; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();
	
	for( y = 0; y < 57; y+=4 )
	  for( x = 2; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 0; y < 57; y+=4 )
	  for( x = 1; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 1; y < 57; y+=4 )
	  for( x = 1; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 2; y < 57; y+=4 )
	  for( x = 1; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 2; y < 57; y+=4 )
	  for( x = 2; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();

	for( y = 1; y < 57; y+=4 )
	  for( x = 2; x < 320; x+=4 )
	    putpixel( x-4, y, temp );

	wait_retrace();
	wait_retrace();
	wait_retrace();
	wait_retrace();
}

