int font_begins[50] = { 
298,  // a
311,
325,
338,
351,  // e
364,
377,
390,
403,  // i
411,
424,
436,
449,
465,
478,  // o
491,
505,
517,
530,
543,
556,  // u
570,
582,
599,
612,
625,  // z
38,   // -
261,  // !
272,  // ?
55,   // .
29,   // ,
211,  // :
89,   // 1
98,
111,
125,
138,
261,
164,
76,
193,
76,    // 0
261

};

int font_ends[50]   = { 
311,  // a
323,
336,
349,
362,  // e
375,
388,
401,
408,  // i
421,
434,
446,
462,
475,
489,
501,
514,
527,
541,
553,
566,
579,
596,
609,
622,
636,  // z
47,   // -
266,  // !
283,  // ?
60,   // .
33,   // ,
215,  // :
97,   // 1
110,
122,
136,
149,
266,
179,
88,
205,
88,    // 0
266
};


void putfont( render *src )
{
	int letter = (*src).letter;
	int x, y;
	int begin, length;
	point loc;
	
	loc.x = 0;
	loc.y = 0;
	loc.z = 0;

	scale( &loc, &(*src).local_position );
	y = loc.y+90;
	
	begin = font_begins[letter];
	length = font_ends[letter]-begin;

	x = loc.x-(length>>1);
	x+=160;

	asm  {
	  push  es
	  push  ds
	  xor  bx, bx
	  mov  bh, byte ptr y
	  shr  bx, 2
	  add  bh, byte ptr y
	  add  bx, x
	  mov  ax, length
	  mov  dx, begin
	  les  di, buffer1
	  add  di, bx
	  lds  si, font
	  add  si, dx
	  sub  di, 320
	  add  di, ax
	  sub  si, 640
	  add  si, ax
	  mov  dx, 20
	  }
	next_line:
	asm  {
	  add  di, 320
	  sub  di, ax
	  add  si, 640
	  sub  si, ax
	    mov  cx, ax
	    rep  movsb
	    dec  dx
	    jnz  next_line
	    pop  ds
	    pop  es
	    }
}
